/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGameSessionPlacementResponse extends GameLiftResponse implements
        ToCopyableBuilder<DescribeGameSessionPlacementResponse.Builder, DescribeGameSessionPlacementResponse> {
    private static final SdkField<GameSessionPlacement> GAME_SESSION_PLACEMENT_FIELD = SdkField
            .<GameSessionPlacement> builder(MarshallingType.SDK_POJO).memberName("GameSessionPlacement")
            .getter(getter(DescribeGameSessionPlacementResponse::gameSessionPlacement))
            .setter(setter(Builder::gameSessionPlacement)).constructor(GameSessionPlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionPlacement").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GAME_SESSION_PLACEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final GameSessionPlacement gameSessionPlacement;

    private DescribeGameSessionPlacementResponse(BuilderImpl builder) {
        super(builder);
        this.gameSessionPlacement = builder.gameSessionPlacement;
    }

    /**
     * <p>
     * Object that describes the requested game session placement.
     * </p>
     * 
     * @return Object that describes the requested game session placement.
     */
    public final GameSessionPlacement gameSessionPlacement() {
        return gameSessionPlacement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionPlacement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGameSessionPlacementResponse)) {
            return false;
        }
        DescribeGameSessionPlacementResponse other = (DescribeGameSessionPlacementResponse) obj;
        return Objects.equals(gameSessionPlacement(), other.gameSessionPlacement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGameSessionPlacementResponse").add("GameSessionPlacement", gameSessionPlacement())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GameSessionPlacement":
            return Optional.ofNullable(clazz.cast(gameSessionPlacement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GameSessionPlacement", GAME_SESSION_PLACEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGameSessionPlacementResponse, T> g) {
        return obj -> g.apply((DescribeGameSessionPlacementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeGameSessionPlacementResponse> {
        /**
         * <p>
         * Object that describes the requested game session placement.
         * </p>
         * 
         * @param gameSessionPlacement
         *        Object that describes the requested game session placement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionPlacement(GameSessionPlacement gameSessionPlacement);

        /**
         * <p>
         * Object that describes the requested game session placement.
         * </p>
         * This is a convenience method that creates an instance of the {@link GameSessionPlacement.Builder} avoiding
         * the need to create one manually via {@link GameSessionPlacement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GameSessionPlacement.Builder#build()} is called immediately and
         * its result is passed to {@link #gameSessionPlacement(GameSessionPlacement)}.
         * 
         * @param gameSessionPlacement
         *        a consumer that will call methods on {@link GameSessionPlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameSessionPlacement(GameSessionPlacement)
         */
        default Builder gameSessionPlacement(Consumer<GameSessionPlacement.Builder> gameSessionPlacement) {
            return gameSessionPlacement(GameSessionPlacement.builder().applyMutation(gameSessionPlacement).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private GameSessionPlacement gameSessionPlacement;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGameSessionPlacementResponse model) {
            super(model);
            gameSessionPlacement(model.gameSessionPlacement);
        }

        public final GameSessionPlacement.Builder getGameSessionPlacement() {
            return gameSessionPlacement != null ? gameSessionPlacement.toBuilder() : null;
        }

        public final void setGameSessionPlacement(GameSessionPlacement.BuilderImpl gameSessionPlacement) {
            this.gameSessionPlacement = gameSessionPlacement != null ? gameSessionPlacement.build() : null;
        }

        @Override
        public final Builder gameSessionPlacement(GameSessionPlacement gameSessionPlacement) {
            this.gameSessionPlacement = gameSessionPlacement;
            return this;
        }

        @Override
        public DescribeGameSessionPlacementResponse build() {
            return new DescribeGameSessionPlacementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
