/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGameSessionRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateGameSessionRequest.Builder, CreateGameSessionRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(CreateGameSessionRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasId").getter(getter(CreateGameSessionRequest::aliasId)).setter(setter(Builder::aliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasId").build()).build();

    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumPlayerSessionCount")
            .getter(getter(CreateGameSessionRequest::maximumPlayerSessionCount))
            .setter(setter(Builder::maximumPlayerSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateGameSessionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField
            .<List<GameProperty>> builder(MarshallingType.LIST)
            .memberName("GameProperties")
            .getter(getter(CreateGameSessionRequest::gameProperties))
            .setter(setter(Builder::gameProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GameProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(GameProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorId").getter(getter(CreateGameSessionRequest::creatorId)).setter(setter(Builder::creatorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorId").build()).build();

    private static final SdkField<String> GAME_SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionId").getter(getter(CreateGameSessionRequest::gameSessionId))
            .setter(setter(Builder::gameSessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionId").build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken").getter(getter(CreateGameSessionRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final SdkField<String> GAME_SESSION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionData").getter(getter(CreateGameSessionRequest::gameSessionData))
            .setter(setter(Builder::gameSessionData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionData").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(CreateGameSessionRequest::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD,
            ALIAS_ID_FIELD, MAXIMUM_PLAYER_SESSION_COUNT_FIELD, NAME_FIELD, GAME_PROPERTIES_FIELD, CREATOR_ID_FIELD,
            GAME_SESSION_ID_FIELD, IDEMPOTENCY_TOKEN_FIELD, GAME_SESSION_DATA_FIELD, LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fleetId;

    private final String aliasId;

    private final Integer maximumPlayerSessionCount;

    private final String name;

    private final List<GameProperty> gameProperties;

    private final String creatorId;

    private final String gameSessionId;

    private final String idempotencyToken;

    private final String gameSessionData;

    private final String location;

    private CreateGameSessionRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.aliasId = builder.aliasId;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.name = builder.name;
        this.gameProperties = builder.gameProperties;
        this.creatorId = builder.creatorId;
        this.gameSessionId = builder.gameSessionId;
        this.idempotencyToken = builder.idempotencyToken;
        this.gameSessionData = builder.gameSessionData;
        this.location = builder.location;
    }

    /**
     * <p>
     * A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN value. Each
     * request must reference either a fleet ID or alias ID, but not both.
     * </p>
     * 
     * @return A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN
     *         value. Each request must reference either a fleet ID or alias ID, but not both.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * A unique identifier for the alias associated with the fleet to create a game session in. You can use either the
     * alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.
     * </p>
     * 
     * @return A unique identifier for the alias associated with the fleet to create a game session in. You can use
     *         either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not
     *         both.
     */
    public final String aliasId() {
        return aliasId;
    }

    /**
     * <p>
     * The maximum number of players that can be connected simultaneously to the game session.
     * </p>
     * 
     * @return The maximum number of players that can be connected simultaneously to the game session.
     */
    public final Integer maximumPlayerSessionCount() {
        return maximumPlayerSessionCount;
    }

    /**
     * <p>
     * A descriptive label that is associated with a game session. Session names do not need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with a game session. Session names do not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the GameProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGameProperties() {
        return gameProperties != null && !(gameProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of key-value pairs that can store custom data in a game session. For example:
     * <code>{"Key": "difficulty", "Value": "novice"}</code>. For an example, see <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-create"
     * >Create a game session with custom properties</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGameProperties} method.
     * </p>
     * 
     * @return A set of key-value pairs that can store custom data in a game session. For example:
     *         <code>{"Key": "difficulty", "Value": "novice"}</code>. For an example, see <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-create"
     *         >Create a game session with custom properties</a>.
     */
    public final List<GameProperty> gameProperties() {
        return gameProperties;
    }

    /**
     * <p>
     * A unique identifier for a player or entity creating the game session.
     * </p>
     * <p>
     * If you add a resource creation limit policy to a fleet, the <code>CreateGameSession</code> operation requires a
     * <code>CreatorId</code>. Amazon GameLift limits the number of game session creation requests with the same
     * <code>CreatorId</code> in a specified time period.
     * </p>
     * <p>
     * If you your fleet doesn't have a resource creation limit policy and you provide a <code>CreatorId</code> in your
     * <code>CreateGameSession</code> requests, Amazon GameLift limits requests to one request per
     * <code>CreatorId</code> per second.
     * </p>
     * <p>
     * To not limit <code>CreateGameSession</code> requests with the same <code>CreatorId</code>, don't provide a
     * <code>CreatorId</code> in your <code>CreateGameSession</code> request.
     * </p>
     * 
     * @return A unique identifier for a player or entity creating the game session. </p>
     *         <p>
     *         If you add a resource creation limit policy to a fleet, the <code>CreateGameSession</code> operation
     *         requires a <code>CreatorId</code>. Amazon GameLift limits the number of game session creation requests
     *         with the same <code>CreatorId</code> in a specified time period.
     *         </p>
     *         <p>
     *         If you your fleet doesn't have a resource creation limit policy and you provide a <code>CreatorId</code>
     *         in your <code>CreateGameSession</code> requests, Amazon GameLift limits requests to one request per
     *         <code>CreatorId</code> per second.
     *         </p>
     *         <p>
     *         To not limit <code>CreateGameSession</code> requests with the same <code>CreatorId</code>, don't provide
     *         a <code>CreatorId</code> in your <code>CreateGameSession</code> request.
     */
    public final String creatorId() {
        return creatorId;
    }

    /**
     * <p>
     * <i>This parameter is deprecated. Use <code>IdempotencyToken</code> instead.</i>
     * </p>
     * <p>
     * Custom string that uniquely identifies a request for a new game session. Maximum token length is 48 characters.
     * If provided, this string is included in the new game session's ID.
     * </p>
     * 
     * @return <i>This parameter is deprecated. Use <code>IdempotencyToken</code> instead.</i> </p>
     *         <p>
     *         Custom string that uniquely identifies a request for a new game session. Maximum token length is 48
     *         characters. If provided, this string is included in the new game session's ID.
     */
    public final String gameSessionId() {
        return gameSessionId;
    }

    /**
     * <p>
     * Custom string that uniquely identifies the new game session request. This is useful for ensuring that game
     * session requests with the same idempotency token are processed only once. Subsequent requests with the same
     * string return the original <code>GameSession</code> object, with an updated status. Maximum token length is 48
     * characters. If provided, this string is included in the new game session's ID. A game session ARN has the
     * following format:
     * <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
     * . Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are retained
     * for this time period and then deleted.
     * </p>
     * 
     * @return Custom string that uniquely identifies the new game session request. This is useful for ensuring that
     *         game session requests with the same idempotency token are processed only once. Subsequent requests with
     *         the same string return the original <code>GameSession</code> object, with an updated status. Maximum
     *         token length is 48 characters. If provided, this string is included in the new game session's ID. A game
     *         session ARN has the following format:
     *         <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
     *         . Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are
     *         retained for this time period and then deleted.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    /**
     * <p>
     * A set of custom game session properties, formatted as a single string value. This data is passed to a game server
     * process with a request to start a new game session. For more information, see <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a game session</a>.
     * </p>
     * 
     * @return A set of custom game session properties, formatted as a single string value. This data is passed to a
     *         game server process with a request to start a new game session. For more information, see <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     *         >Start a game session</a>.
     */
    public final String gameSessionData() {
        return gameSessionData;
    }

    /**
     * <p>
     * A fleet's remote location to place the new game session in. If this parameter is not set, the new game session is
     * placed in the fleet's home Region. Specify a remote location with an Amazon Web Services Region code such as
     * <code>us-west-2</code>. When using an Anywhere fleet, this parameter is required and must be set to the Anywhere
     * fleet's custom location.
     * </p>
     * 
     * @return A fleet's remote location to place the new game session in. If this parameter is not set, the new game
     *         session is placed in the fleet's home Region. Specify a remote location with an Amazon Web Services
     *         Region code such as <code>us-west-2</code>. When using an Anywhere fleet, this parameter is required and
     *         must be set to the Anywhere fleet's custom location.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(aliasId());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasGameProperties() ? gameProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionData());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGameSessionRequest)) {
            return false;
        }
        CreateGameSessionRequest other = (CreateGameSessionRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(aliasId(), other.aliasId())
                && Objects.equals(maximumPlayerSessionCount(), other.maximumPlayerSessionCount())
                && Objects.equals(name(), other.name()) && hasGameProperties() == other.hasGameProperties()
                && Objects.equals(gameProperties(), other.gameProperties()) && Objects.equals(creatorId(), other.creatorId())
                && Objects.equals(gameSessionId(), other.gameSessionId())
                && Objects.equals(idempotencyToken(), other.idempotencyToken())
                && Objects.equals(gameSessionData(), other.gameSessionData()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGameSessionRequest").add("FleetId", fleetId()).add("AliasId", aliasId())
                .add("MaximumPlayerSessionCount", maximumPlayerSessionCount()).add("Name", name())
                .add("GameProperties", hasGameProperties() ? gameProperties() : null).add("CreatorId", creatorId())
                .add("GameSessionId", gameSessionId()).add("IdempotencyToken", idempotencyToken())
                .add("GameSessionData", gameSessionData()).add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "AliasId":
            return Optional.ofNullable(clazz.cast(aliasId()));
        case "MaximumPlayerSessionCount":
            return Optional.ofNullable(clazz.cast(maximumPlayerSessionCount()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "GameProperties":
            return Optional.ofNullable(clazz.cast(gameProperties()));
        case "CreatorId":
            return Optional.ofNullable(clazz.cast(creatorId()));
        case "GameSessionId":
            return Optional.ofNullable(clazz.cast(gameSessionId()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        case "GameSessionData":
            return Optional.ofNullable(clazz.cast(gameSessionData()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("AliasId", ALIAS_ID_FIELD);
        map.put("MaximumPlayerSessionCount", MAXIMUM_PLAYER_SESSION_COUNT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("GameProperties", GAME_PROPERTIES_FIELD);
        map.put("CreatorId", CREATOR_ID_FIELD);
        map.put("GameSessionId", GAME_SESSION_ID_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        map.put("GameSessionData", GAME_SESSION_DATA_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGameSessionRequest, T> g) {
        return obj -> g.apply((CreateGameSessionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGameSessionRequest> {
        /**
         * <p>
         * A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN value.
         * Each request must reference either a fleet ID or alias ID, but not both.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet to create a game session in. You can use either the fleet ID or ARN
         *        value. Each request must reference either a fleet ID or alias ID, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * A unique identifier for the alias associated with the fleet to create a game session in. You can use either
         * the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not both.
         * </p>
         * 
         * @param aliasId
         *        A unique identifier for the alias associated with the fleet to create a game session in. You can use
         *        either the alias ID or ARN value. Each request must reference either a fleet ID or alias ID, but not
         *        both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasId(String aliasId);

        /**
         * <p>
         * The maximum number of players that can be connected simultaneously to the game session.
         * </p>
         * 
         * @param maximumPlayerSessionCount
         *        The maximum number of players that can be connected simultaneously to the game session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount);

        /**
         * <p>
         * A descriptive label that is associated with a game session. Session names do not need to be unique.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with a game session. Session names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A set of key-value pairs that can store custom data in a game session. For example:
         * <code>{"Key": "difficulty", "Value": "novice"}</code>. For an example, see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-create"
         * >Create a game session with custom properties</a>.
         * </p>
         * 
         * @param gameProperties
         *        A set of key-value pairs that can store custom data in a game session. For example:
         *        <code>{"Key": "difficulty", "Value": "novice"}</code>. For an example, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-create"
         *        >Create a game session with custom properties</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameProperties(Collection<GameProperty> gameProperties);

        /**
         * <p>
         * A set of key-value pairs that can store custom data in a game session. For example:
         * <code>{"Key": "difficulty", "Value": "novice"}</code>. For an example, see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-create"
         * >Create a game session with custom properties</a>.
         * </p>
         * 
         * @param gameProperties
         *        A set of key-value pairs that can store custom data in a game session. For example:
         *        <code>{"Key": "difficulty", "Value": "novice"}</code>. For an example, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-create"
         *        >Create a game session with custom properties</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameProperties(GameProperty... gameProperties);

        /**
         * <p>
         * A set of key-value pairs that can store custom data in a game session. For example:
         * <code>{"Key": "difficulty", "Value": "novice"}</code>. For an example, see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#game-properties-create"
         * >Create a game session with custom properties</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.GameProperty.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.GameProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.GameProperty.Builder#build()} is called immediately and
         * its result is passed to {@link #gameProperties(List<GameProperty>)}.
         * 
         * @param gameProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.GameProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameProperties(java.util.Collection<GameProperty>)
         */
        Builder gameProperties(Consumer<GameProperty.Builder>... gameProperties);

        /**
         * <p>
         * A unique identifier for a player or entity creating the game session.
         * </p>
         * <p>
         * If you add a resource creation limit policy to a fleet, the <code>CreateGameSession</code> operation requires
         * a <code>CreatorId</code>. Amazon GameLift limits the number of game session creation requests with the same
         * <code>CreatorId</code> in a specified time period.
         * </p>
         * <p>
         * If you your fleet doesn't have a resource creation limit policy and you provide a <code>CreatorId</code> in
         * your <code>CreateGameSession</code> requests, Amazon GameLift limits requests to one request per
         * <code>CreatorId</code> per second.
         * </p>
         * <p>
         * To not limit <code>CreateGameSession</code> requests with the same <code>CreatorId</code>, don't provide a
         * <code>CreatorId</code> in your <code>CreateGameSession</code> request.
         * </p>
         * 
         * @param creatorId
         *        A unique identifier for a player or entity creating the game session. </p>
         *        <p>
         *        If you add a resource creation limit policy to a fleet, the <code>CreateGameSession</code> operation
         *        requires a <code>CreatorId</code>. Amazon GameLift limits the number of game session creation requests
         *        with the same <code>CreatorId</code> in a specified time period.
         *        </p>
         *        <p>
         *        If you your fleet doesn't have a resource creation limit policy and you provide a
         *        <code>CreatorId</code> in your <code>CreateGameSession</code> requests, Amazon GameLift limits
         *        requests to one request per <code>CreatorId</code> per second.
         *        </p>
         *        <p>
         *        To not limit <code>CreateGameSession</code> requests with the same <code>CreatorId</code>, don't
         *        provide a <code>CreatorId</code> in your <code>CreateGameSession</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorId(String creatorId);

        /**
         * <p>
         * <i>This parameter is deprecated. Use <code>IdempotencyToken</code> instead.</i>
         * </p>
         * <p>
         * Custom string that uniquely identifies a request for a new game session. Maximum token length is 48
         * characters. If provided, this string is included in the new game session's ID.
         * </p>
         * 
         * @param gameSessionId
         *        <i>This parameter is deprecated. Use <code>IdempotencyToken</code> instead.</i> </p>
         *        <p>
         *        Custom string that uniquely identifies a request for a new game session. Maximum token length is 48
         *        characters. If provided, this string is included in the new game session's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionId(String gameSessionId);

        /**
         * <p>
         * Custom string that uniquely identifies the new game session request. This is useful for ensuring that game
         * session requests with the same idempotency token are processed only once. Subsequent requests with the same
         * string return the original <code>GameSession</code> object, with an updated status. Maximum token length is
         * 48 characters. If provided, this string is included in the new game session's ID. A game session ARN has the
         * following format:
         * <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
         * . Idempotency tokens remain in use for 30 days after a game session has ended; game session objects are
         * retained for this time period and then deleted.
         * </p>
         * 
         * @param idempotencyToken
         *        Custom string that uniquely identifies the new game session request. This is useful for ensuring that
         *        game session requests with the same idempotency token are processed only once. Subsequent requests
         *        with the same string return the original <code>GameSession</code> object, with an updated status.
         *        Maximum token length is 48 characters. If provided, this string is included in the new game session's
         *        ID. A game session ARN has the following format:
         *        <code>arn:aws:gamelift:&lt;region&gt;::gamesession/&lt;fleet ID&gt;/&lt;custom ID string or idempotency token&gt;</code>
         *        . Idempotency tokens remain in use for 30 days after a game session has ended; game session objects
         *        are retained for this time period and then deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        /**
         * <p>
         * A set of custom game session properties, formatted as a single string value. This data is passed to a game
         * server process with a request to start a new game session. For more information, see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         * >Start a game session</a>.
         * </p>
         * 
         * @param gameSessionData
         *        A set of custom game session properties, formatted as a single string value. This data is passed to a
         *        game server process with a request to start a new game session. For more information, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         *        >Start a game session</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionData(String gameSessionData);

        /**
         * <p>
         * A fleet's remote location to place the new game session in. If this parameter is not set, the new game
         * session is placed in the fleet's home Region. Specify a remote location with an Amazon Web Services Region
         * code such as <code>us-west-2</code>. When using an Anywhere fleet, this parameter is required and must be set
         * to the Anywhere fleet's custom location.
         * </p>
         * 
         * @param location
         *        A fleet's remote location to place the new game session in. If this parameter is not set, the new game
         *        session is placed in the fleet's home Region. Specify a remote location with an Amazon Web Services
         *        Region code such as <code>us-west-2</code>. When using an Anywhere fleet, this parameter is required
         *        and must be set to the Anywhere fleet's custom location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String aliasId;

        private Integer maximumPlayerSessionCount;

        private String name;

        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();

        private String creatorId;

        private String gameSessionId;

        private String idempotencyToken;

        private String gameSessionData;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGameSessionRequest model) {
            super(model);
            fleetId(model.fleetId);
            aliasId(model.aliasId);
            maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            name(model.name);
            gameProperties(model.gameProperties);
            creatorId(model.creatorId);
            gameSessionId(model.gameSessionId);
            idempotencyToken(model.idempotencyToken);
            gameSessionData(model.gameSessionData);
            location(model.location);
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getAliasId() {
            return aliasId;
        }

        public final void setAliasId(String aliasId) {
            this.aliasId = aliasId;
        }

        @Override
        public final Builder aliasId(String aliasId) {
            this.aliasId = aliasId;
            return this;
        }

        public final Integer getMaximumPlayerSessionCount() {
            return maximumPlayerSessionCount;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<GameProperty.Builder> getGameProperties() {
            List<GameProperty.Builder> result = GamePropertyListCopier.copyToBuilder(this.gameProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty... gameProperties) {
            gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder>... gameProperties) {
            gameProperties(Stream.of(gameProperties).map(c -> GameProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCreatorId() {
            return creatorId;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final String getGameSessionId() {
            return gameSessionId;
        }

        public final void setGameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
        }

        @Override
        public final Builder gameSessionId(String gameSessionId) {
            this.gameSessionId = gameSessionId;
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final String getGameSessionData() {
            return gameSessionData;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGameSessionRequest build() {
            return new CreateGameSessionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
