/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateContainerFleetResponse extends GameLiftResponse implements
        ToCopyableBuilder<CreateContainerFleetResponse.Builder, CreateContainerFleetResponse> {
    private static final SdkField<ContainerFleet> CONTAINER_FLEET_FIELD = SdkField
            .<ContainerFleet> builder(MarshallingType.SDK_POJO).memberName("ContainerFleet")
            .getter(getter(CreateContainerFleetResponse::containerFleet)).setter(setter(Builder::containerFleet))
            .constructor(ContainerFleet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerFleet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FLEET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ContainerFleet containerFleet;

    private CreateContainerFleetResponse(BuilderImpl builder) {
        super(builder);
        this.containerFleet = builder.containerFleet;
    }

    /**
     * <p>
     * The properties for the new container fleet, including current status. All fleets are initially placed in
     * <code>PENDING</code> status.
     * </p>
     * 
     * @return The properties for the new container fleet, including current status. All fleets are initially placed in
     *         <code>PENDING</code> status.
     */
    public final ContainerFleet containerFleet() {
        return containerFleet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(containerFleet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateContainerFleetResponse)) {
            return false;
        }
        CreateContainerFleetResponse other = (CreateContainerFleetResponse) obj;
        return Objects.equals(containerFleet(), other.containerFleet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateContainerFleetResponse").add("ContainerFleet", containerFleet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerFleet":
            return Optional.ofNullable(clazz.cast(containerFleet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContainerFleet", CONTAINER_FLEET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateContainerFleetResponse, T> g) {
        return obj -> g.apply((CreateContainerFleetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateContainerFleetResponse> {
        /**
         * <p>
         * The properties for the new container fleet, including current status. All fleets are initially placed in
         * <code>PENDING</code> status.
         * </p>
         * 
         * @param containerFleet
         *        The properties for the new container fleet, including current status. All fleets are initially placed
         *        in <code>PENDING</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerFleet(ContainerFleet containerFleet);

        /**
         * <p>
         * The properties for the new container fleet, including current status. All fleets are initially placed in
         * <code>PENDING</code> status.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerFleet.Builder} avoiding the need
         * to create one manually via {@link ContainerFleet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerFleet.Builder#build()} is called immediately and its
         * result is passed to {@link #containerFleet(ContainerFleet)}.
         * 
         * @param containerFleet
         *        a consumer that will call methods on {@link ContainerFleet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerFleet(ContainerFleet)
         */
        default Builder containerFleet(Consumer<ContainerFleet.Builder> containerFleet) {
            return containerFleet(ContainerFleet.builder().applyMutation(containerFleet).build());
        }
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private ContainerFleet containerFleet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateContainerFleetResponse model) {
            super(model);
            containerFleet(model.containerFleet);
        }

        public final ContainerFleet.Builder getContainerFleet() {
            return containerFleet != null ? containerFleet.toBuilder() : null;
        }

        public final void setContainerFleet(ContainerFleet.BuilderImpl containerFleet) {
            this.containerFleet = containerFleet != null ? containerFleet.build() : null;
        }

        @Override
        public final Builder containerFleet(ContainerFleet containerFleet) {
            this.containerFleet = containerFleet;
            return this;
        }

        @Override
        public CreateContainerFleetResponse build() {
            return new CreateContainerFleetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
