/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A unique identifier for a container in a container fleet compute.
 * </p>
 * <p>
 * <b>Returned by:</b> <a
 * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute.html">DescribeCompute</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerAttribute implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerAttribute.Builder, ContainerAttribute> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerName").getter(getter(ContainerAttribute::containerName)).setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()).build();

    private static final SdkField<String> CONTAINER_RUNTIME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerRuntimeId").getter(getter(ContainerAttribute::containerRuntimeId))
            .setter(setter(Builder::containerRuntimeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerRuntimeId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD,
            CONTAINER_RUNTIME_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String containerName;

    private final String containerRuntimeId;

    private ContainerAttribute(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.containerRuntimeId = builder.containerRuntimeId;
    }

    /**
     * <p>
     * The identifier for a container that's running in a compute.
     * </p>
     * 
     * @return The identifier for a container that's running in a compute.
     */
    public final String containerName() {
        return containerName;
    }

    /**
     * <p>
     * The runtime ID for the container that's running in a compute. This value is unique within the compute.
     * </p>
     * 
     * @return The runtime ID for the container that's running in a compute. This value is unique within the compute.
     */
    public final String containerRuntimeId() {
        return containerRuntimeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        hashCode = 31 * hashCode + Objects.hashCode(containerRuntimeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerAttribute)) {
            return false;
        }
        ContainerAttribute other = (ContainerAttribute) obj;
        return Objects.equals(containerName(), other.containerName())
                && Objects.equals(containerRuntimeId(), other.containerRuntimeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerAttribute").add("ContainerName", containerName())
                .add("ContainerRuntimeId", containerRuntimeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        case "ContainerRuntimeId":
            return Optional.ofNullable(clazz.cast(containerRuntimeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContainerName", CONTAINER_NAME_FIELD);
        map.put("ContainerRuntimeId", CONTAINER_RUNTIME_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerAttribute, T> g) {
        return obj -> g.apply((ContainerAttribute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerAttribute> {
        /**
         * <p>
         * The identifier for a container that's running in a compute.
         * </p>
         * 
         * @param containerName
         *        The identifier for a container that's running in a compute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);

        /**
         * <p>
         * The runtime ID for the container that's running in a compute. This value is unique within the compute.
         * </p>
         * 
         * @param containerRuntimeId
         *        The runtime ID for the container that's running in a compute. This value is unique within the compute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRuntimeId(String containerRuntimeId);
    }

    static final class BuilderImpl implements Builder {
        private String containerName;

        private String containerRuntimeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerAttribute model) {
            containerName(model.containerName);
            containerRuntimeId(model.containerRuntimeId);
        }

        public final String getContainerName() {
            return containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final String getContainerRuntimeId() {
            return containerRuntimeId;
        }

        public final void setContainerRuntimeId(String containerRuntimeId) {
            this.containerRuntimeId = containerRuntimeId;
        }

        @Override
        public final Builder containerRuntimeId(String containerRuntimeId) {
            this.containerRuntimeId = containerRuntimeId;
            return this;
        }

        @Override
        public ContainerAttribute build() {
            return new ContainerAttribute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
