/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Amazon GameLift configuration options for your Anywhere fleets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnywhereConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AnywhereConfiguration.Builder, AnywhereConfiguration> {
    private static final SdkField<String> COST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cost")
            .getter(getter(AnywhereConfiguration::cost)).setter(setter(Builder::cost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cost").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cost;

    private AnywhereConfiguration(BuilderImpl builder) {
        this.cost = builder.cost;
    }

    /**
     * <p>
     * The cost to run your fleet per hour. Amazon GameLift uses the provided cost of your fleet to balance usage in
     * queues. For more information about queues, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html">Setting up queues</a> in the
     * <i>Amazon GameLift Developer Guide</i>.
     * </p>
     * 
     * @return The cost to run your fleet per hour. Amazon GameLift uses the provided cost of your fleet to balance
     *         usage in queues. For more information about queues, see <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html">Setting up queues</a>
     *         in the <i>Amazon GameLift Developer Guide</i>.
     */
    public final String cost() {
        return cost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cost());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnywhereConfiguration)) {
            return false;
        }
        AnywhereConfiguration other = (AnywhereConfiguration) obj;
        return Objects.equals(cost(), other.cost());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnywhereConfiguration").add("Cost", cost()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Cost":
            return Optional.ofNullable(clazz.cast(cost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Cost", COST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnywhereConfiguration, T> g) {
        return obj -> g.apply((AnywhereConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnywhereConfiguration> {
        /**
         * <p>
         * The cost to run your fleet per hour. Amazon GameLift uses the provided cost of your fleet to balance usage in
         * queues. For more information about queues, see <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html">Setting up queues</a> in
         * the <i>Amazon GameLift Developer Guide</i>.
         * </p>
         * 
         * @param cost
         *        The cost to run your fleet per hour. Amazon GameLift uses the provided cost of your fleet to balance
         *        usage in queues. For more information about queues, see <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-intro.html">Setting up
         *        queues</a> in the <i>Amazon GameLift Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cost(String cost);
    }

    static final class BuilderImpl implements Builder {
        private String cost;

        private BuilderImpl() {
        }

        private BuilderImpl(AnywhereConfiguration model) {
            cost(model.cost);
        }

        public final String getCost() {
            return cost;
        }

        public final void setCost(String cost) {
            this.cost = cost;
        }

        @Override
        public final Builder cost(String cost) {
            this.cost = cost;
            return this;
        }

        @Override
        public AnywhereConfiguration build() {
            return new AnywhereConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
