/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>This data type is used with the Amazon GameLift containers feature, which is currently in public preview.</b>
 * </p>
 * <p>
 * The properties of container groups that are running on a container fleet. Container group properties for a fleet
 * can't be changed.
 * </p>
 * <p>
 * <b>Returned by:</b> <a>DescribeFleetAttributes</a>, <a>CreateFleet</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerGroupsAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerGroupsAttributes.Builder, ContainerGroupsAttributes> {
    private static final SdkField<List<ContainerGroupDefinitionProperty>> CONTAINER_GROUP_DEFINITION_PROPERTIES_FIELD = SdkField
            .<List<ContainerGroupDefinitionProperty>> builder(MarshallingType.LIST)
            .memberName("ContainerGroupDefinitionProperties")
            .getter(getter(ContainerGroupsAttributes::containerGroupDefinitionProperties))
            .setter(setter(Builder::containerGroupDefinitionProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupDefinitionProperties")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerGroupDefinitionProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerGroupDefinitionProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ConnectionPortRange> CONNECTION_PORT_RANGE_FIELD = SdkField
            .<ConnectionPortRange> builder(MarshallingType.SDK_POJO).memberName("ConnectionPortRange")
            .getter(getter(ContainerGroupsAttributes::connectionPortRange)).setter(setter(Builder::connectionPortRange))
            .constructor(ConnectionPortRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionPortRange").build())
            .build();

    private static final SdkField<ContainerGroupsPerInstance> CONTAINER_GROUPS_PER_INSTANCE_FIELD = SdkField
            .<ContainerGroupsPerInstance> builder(MarshallingType.SDK_POJO)
            .memberName("ContainerGroupsPerInstance")
            .getter(getter(ContainerGroupsAttributes::containerGroupsPerInstance))
            .setter(setter(Builder::containerGroupsPerInstance))
            .constructor(ContainerGroupsPerInstance::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerGroupsPerInstance").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONTAINER_GROUP_DEFINITION_PROPERTIES_FIELD, CONNECTION_PORT_RANGE_FIELD, CONTAINER_GROUPS_PER_INSTANCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ContainerGroupDefinitionProperty> containerGroupDefinitionProperties;

    private final ConnectionPortRange connectionPortRange;

    private final ContainerGroupsPerInstance containerGroupsPerInstance;

    private ContainerGroupsAttributes(BuilderImpl builder) {
        this.containerGroupDefinitionProperties = builder.containerGroupDefinitionProperties;
        this.connectionPortRange = builder.connectionPortRange;
        this.containerGroupsPerInstance = builder.containerGroupsPerInstance;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerGroupDefinitionProperties
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasContainerGroupDefinitionProperties() {
        return containerGroupDefinitionProperties != null
                && !(containerGroupDefinitionProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection of properties that describe each container group in the fleet. A container fleet is deployed with
     * one or more <a>ContainerGroupDefinition</a> resources, which is where these properties are set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerGroupDefinitionProperties}
     * method.
     * </p>
     * 
     * @return A collection of properties that describe each container group in the fleet. A container fleet is deployed
     *         with one or more <a>ContainerGroupDefinition</a> resources, which is where these properties are set.
     */
    public final List<ContainerGroupDefinitionProperty> containerGroupDefinitionProperties() {
        return containerGroupDefinitionProperties;
    }

    /**
     * <p>
     * A set of ports that allow inbound traffic to connect to processes running in the fleet's container groups. Amazon
     * GameLift maps each connection port to a container port, which is assigned to a specific container process. A
     * fleet's connection port range can't be changed, but you can control access to connection ports by updating a
     * fleet's <code>EC2InboundPermissions</code> with <a>UpdateFleetPortSettings</a>.
     * </p>
     * 
     * @return A set of ports that allow inbound traffic to connect to processes running in the fleet's container
     *         groups. Amazon GameLift maps each connection port to a container port, which is assigned to a specific
     *         container process. A fleet's connection port range can't be changed, but you can control access to
     *         connection ports by updating a fleet's <code>EC2InboundPermissions</code> with
     *         <a>UpdateFleetPortSettings</a>.
     */
    public final ConnectionPortRange connectionPortRange() {
        return connectionPortRange;
    }

    /**
     * <p>
     * Details about the number of replica container groups that Amazon GameLift deploys to each instance in the
     * container fleet.
     * </p>
     * 
     * @return Details about the number of replica container groups that Amazon GameLift deploys to each instance in the
     *         container fleet.
     */
    public final ContainerGroupsPerInstance containerGroupsPerInstance() {
        return containerGroupsPerInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasContainerGroupDefinitionProperties() ? containerGroupDefinitionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionPortRange());
        hashCode = 31 * hashCode + Objects.hashCode(containerGroupsPerInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerGroupsAttributes)) {
            return false;
        }
        ContainerGroupsAttributes other = (ContainerGroupsAttributes) obj;
        return hasContainerGroupDefinitionProperties() == other.hasContainerGroupDefinitionProperties()
                && Objects.equals(containerGroupDefinitionProperties(), other.containerGroupDefinitionProperties())
                && Objects.equals(connectionPortRange(), other.connectionPortRange())
                && Objects.equals(containerGroupsPerInstance(), other.containerGroupsPerInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ContainerGroupsAttributes")
                .add("ContainerGroupDefinitionProperties",
                        hasContainerGroupDefinitionProperties() ? containerGroupDefinitionProperties() : null)
                .add("ConnectionPortRange", connectionPortRange())
                .add("ContainerGroupsPerInstance", containerGroupsPerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerGroupDefinitionProperties":
            return Optional.ofNullable(clazz.cast(containerGroupDefinitionProperties()));
        case "ConnectionPortRange":
            return Optional.ofNullable(clazz.cast(connectionPortRange()));
        case "ContainerGroupsPerInstance":
            return Optional.ofNullable(clazz.cast(containerGroupsPerInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerGroupsAttributes, T> g) {
        return obj -> g.apply((ContainerGroupsAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerGroupsAttributes> {
        /**
         * <p>
         * A collection of properties that describe each container group in the fleet. A container fleet is deployed
         * with one or more <a>ContainerGroupDefinition</a> resources, which is where these properties are set.
         * </p>
         * 
         * @param containerGroupDefinitionProperties
         *        A collection of properties that describe each container group in the fleet. A container fleet is
         *        deployed with one or more <a>ContainerGroupDefinition</a> resources, which is where these properties
         *        are set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerGroupDefinitionProperties(Collection<ContainerGroupDefinitionProperty> containerGroupDefinitionProperties);

        /**
         * <p>
         * A collection of properties that describe each container group in the fleet. A container fleet is deployed
         * with one or more <a>ContainerGroupDefinition</a> resources, which is where these properties are set.
         * </p>
         * 
         * @param containerGroupDefinitionProperties
         *        A collection of properties that describe each container group in the fleet. A container fleet is
         *        deployed with one or more <a>ContainerGroupDefinition</a> resources, which is where these properties
         *        are set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerGroupDefinitionProperties(ContainerGroupDefinitionProperty... containerGroupDefinitionProperties);

        /**
         * <p>
         * A collection of properties that describe each container group in the fleet. A container fleet is deployed
         * with one or more <a>ContainerGroupDefinition</a> resources, which is where these properties are set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinitionProperty.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinitionProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinitionProperty.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #containerGroupDefinitionProperties(List<ContainerGroupDefinitionProperty>)}.
         * 
         * @param containerGroupDefinitionProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.ContainerGroupDefinitionProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerGroupDefinitionProperties(java.util.Collection<ContainerGroupDefinitionProperty>)
         */
        Builder containerGroupDefinitionProperties(
                Consumer<ContainerGroupDefinitionProperty.Builder>... containerGroupDefinitionProperties);

        /**
         * <p>
         * A set of ports that allow inbound traffic to connect to processes running in the fleet's container groups.
         * Amazon GameLift maps each connection port to a container port, which is assigned to a specific container
         * process. A fleet's connection port range can't be changed, but you can control access to connection ports by
         * updating a fleet's <code>EC2InboundPermissions</code> with <a>UpdateFleetPortSettings</a>.
         * </p>
         * 
         * @param connectionPortRange
         *        A set of ports that allow inbound traffic to connect to processes running in the fleet's container
         *        groups. Amazon GameLift maps each connection port to a container port, which is assigned to a specific
         *        container process. A fleet's connection port range can't be changed, but you can control access to
         *        connection ports by updating a fleet's <code>EC2InboundPermissions</code> with
         *        <a>UpdateFleetPortSettings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionPortRange(ConnectionPortRange connectionPortRange);

        /**
         * <p>
         * A set of ports that allow inbound traffic to connect to processes running in the fleet's container groups.
         * Amazon GameLift maps each connection port to a container port, which is assigned to a specific container
         * process. A fleet's connection port range can't be changed, but you can control access to connection ports by
         * updating a fleet's <code>EC2InboundPermissions</code> with <a>UpdateFleetPortSettings</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectionPortRange.Builder} avoiding the
         * need to create one manually via {@link ConnectionPortRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectionPortRange.Builder#build()} is called immediately and
         * its result is passed to {@link #connectionPortRange(ConnectionPortRange)}.
         * 
         * @param connectionPortRange
         *        a consumer that will call methods on {@link ConnectionPortRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionPortRange(ConnectionPortRange)
         */
        default Builder connectionPortRange(Consumer<ConnectionPortRange.Builder> connectionPortRange) {
            return connectionPortRange(ConnectionPortRange.builder().applyMutation(connectionPortRange).build());
        }

        /**
         * <p>
         * Details about the number of replica container groups that Amazon GameLift deploys to each instance in the
         * container fleet.
         * </p>
         * 
         * @param containerGroupsPerInstance
         *        Details about the number of replica container groups that Amazon GameLift deploys to each instance in
         *        the container fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerGroupsPerInstance(ContainerGroupsPerInstance containerGroupsPerInstance);

        /**
         * <p>
         * Details about the number of replica container groups that Amazon GameLift deploys to each instance in the
         * container fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerGroupsPerInstance.Builder}
         * avoiding the need to create one manually via {@link ContainerGroupsPerInstance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerGroupsPerInstance.Builder#build()} is called immediately
         * and its result is passed to {@link #containerGroupsPerInstance(ContainerGroupsPerInstance)}.
         * 
         * @param containerGroupsPerInstance
         *        a consumer that will call methods on {@link ContainerGroupsPerInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerGroupsPerInstance(ContainerGroupsPerInstance)
         */
        default Builder containerGroupsPerInstance(Consumer<ContainerGroupsPerInstance.Builder> containerGroupsPerInstance) {
            return containerGroupsPerInstance(ContainerGroupsPerInstance.builder().applyMutation(containerGroupsPerInstance)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<ContainerGroupDefinitionProperty> containerGroupDefinitionProperties = DefaultSdkAutoConstructList
                .getInstance();

        private ConnectionPortRange connectionPortRange;

        private ContainerGroupsPerInstance containerGroupsPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerGroupsAttributes model) {
            containerGroupDefinitionProperties(model.containerGroupDefinitionProperties);
            connectionPortRange(model.connectionPortRange);
            containerGroupsPerInstance(model.containerGroupsPerInstance);
        }

        public final List<ContainerGroupDefinitionProperty.Builder> getContainerGroupDefinitionProperties() {
            List<ContainerGroupDefinitionProperty.Builder> result = ContainerGroupDefinitionPropertiesListCopier
                    .copyToBuilder(this.containerGroupDefinitionProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainerGroupDefinitionProperties(
                Collection<ContainerGroupDefinitionProperty.BuilderImpl> containerGroupDefinitionProperties) {
            this.containerGroupDefinitionProperties = ContainerGroupDefinitionPropertiesListCopier
                    .copyFromBuilder(containerGroupDefinitionProperties);
        }

        @Override
        public final Builder containerGroupDefinitionProperties(
                Collection<ContainerGroupDefinitionProperty> containerGroupDefinitionProperties) {
            this.containerGroupDefinitionProperties = ContainerGroupDefinitionPropertiesListCopier
                    .copy(containerGroupDefinitionProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerGroupDefinitionProperties(
                ContainerGroupDefinitionProperty... containerGroupDefinitionProperties) {
            containerGroupDefinitionProperties(Arrays.asList(containerGroupDefinitionProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerGroupDefinitionProperties(
                Consumer<ContainerGroupDefinitionProperty.Builder>... containerGroupDefinitionProperties) {
            containerGroupDefinitionProperties(Stream.of(containerGroupDefinitionProperties)
                    .map(c -> ContainerGroupDefinitionProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConnectionPortRange.Builder getConnectionPortRange() {
            return connectionPortRange != null ? connectionPortRange.toBuilder() : null;
        }

        public final void setConnectionPortRange(ConnectionPortRange.BuilderImpl connectionPortRange) {
            this.connectionPortRange = connectionPortRange != null ? connectionPortRange.build() : null;
        }

        @Override
        public final Builder connectionPortRange(ConnectionPortRange connectionPortRange) {
            this.connectionPortRange = connectionPortRange;
            return this;
        }

        public final ContainerGroupsPerInstance.Builder getContainerGroupsPerInstance() {
            return containerGroupsPerInstance != null ? containerGroupsPerInstance.toBuilder() : null;
        }

        public final void setContainerGroupsPerInstance(ContainerGroupsPerInstance.BuilderImpl containerGroupsPerInstance) {
            this.containerGroupsPerInstance = containerGroupsPerInstance != null ? containerGroupsPerInstance.build() : null;
        }

        @Override
        public final Builder containerGroupsPerInstance(ContainerGroupsPerInstance containerGroupsPerInstance) {
            this.containerGroupsPerInstance = containerGroupsPerInstance;
            return this;
        }

        @Override
        public ContainerGroupsAttributes build() {
            return new ContainerGroupsAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
