/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest;
import software.amazon.awssdk.services.gamelift.model.AcceptMatchResponse;
import software.amazon.awssdk.services.gamelift.model.ClaimGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.ClaimGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.CreateAliasRequest;
import software.amazon.awssdk.services.gamelift.model.CreateAliasResponse;
import software.amazon.awssdk.services.gamelift.model.CreateBuildRequest;
import software.amazon.awssdk.services.gamelift.model.CreateBuildResponse;
import software.amazon.awssdk.services.gamelift.model.CreateContainerGroupDefinitionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateContainerGroupDefinitionResponse;
import software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsRequest;
import software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsResponse;
import software.amazon.awssdk.services.gamelift.model.CreateFleetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateFleetResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.CreateLocationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateLocationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionResponse;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.CreateScriptRequest;
import software.amazon.awssdk.services.gamelift.model.CreateScriptResponse;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationResponse;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteAliasResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteBuildResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteContainerGroupDefinitionRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteContainerGroupDefinitionResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteFleetResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteLocationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteLocationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteScriptRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteScriptResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationResponse;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest;
import software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionResponse;
import software.amazon.awssdk.services.gamelift.model.DeregisterComputeRequest;
import software.amazon.awssdk.services.gamelift.model.DeregisterComputeResponse;
import software.amazon.awssdk.services.gamelift.model.DeregisterGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.DeregisterGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeAliasResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeBuildResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeComputeRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeComputeResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeContainerGroupDefinitionRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeContainerGroupDefinitionResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeScriptRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeScriptResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsResponse;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.gamelift.model.GetComputeAccessRequest;
import software.amazon.awssdk.services.gamelift.model.GetComputeAccessResponse;
import software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenRequest;
import software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenResponse;
import software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest;
import software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlResponse;
import software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest;
import software.amazon.awssdk.services.gamelift.model.GetInstanceAccessResponse;
import software.amazon.awssdk.services.gamelift.model.ListAliasesRequest;
import software.amazon.awssdk.services.gamelift.model.ListAliasesResponse;
import software.amazon.awssdk.services.gamelift.model.ListBuildsRequest;
import software.amazon.awssdk.services.gamelift.model.ListBuildsResponse;
import software.amazon.awssdk.services.gamelift.model.ListComputeRequest;
import software.amazon.awssdk.services.gamelift.model.ListComputeResponse;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsRequest;
import software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsResponse;
import software.amazon.awssdk.services.gamelift.model.ListFleetsRequest;
import software.amazon.awssdk.services.gamelift.model.ListFleetsResponse;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse;
import software.amazon.awssdk.services.gamelift.model.ListGameServersRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServersResponse;
import software.amazon.awssdk.services.gamelift.model.ListLocationsRequest;
import software.amazon.awssdk.services.gamelift.model.ListLocationsResponse;
import software.amazon.awssdk.services.gamelift.model.ListScriptsRequest;
import software.amazon.awssdk.services.gamelift.model.ListScriptsResponse;
import software.amazon.awssdk.services.gamelift.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.gamelift.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.gamelift.model.PutScalingPolicyResponse;
import software.amazon.awssdk.services.gamelift.model.RegisterComputeRequest;
import software.amazon.awssdk.services.gamelift.model.RegisterComputeResponse;
import software.amazon.awssdk.services.gamelift.model.RegisterGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.RegisterGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsRequest;
import software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsResponse;
import software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest;
import software.amazon.awssdk.services.gamelift.model.ResolveAliasResponse;
import software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsRequest;
import software.amazon.awssdk.services.gamelift.model.SearchGameSessionsResponse;
import software.amazon.awssdk.services.gamelift.model.StartFleetActionsRequest;
import software.amazon.awssdk.services.gamelift.model.StartFleetActionsResponse;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.StartGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillRequest;
import software.amazon.awssdk.services.gamelift.model.StartMatchBackfillResponse;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.StartMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.StopFleetActionsRequest;
import software.amazon.awssdk.services.gamelift.model.StopFleetActionsResponse;
import software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementRequest;
import software.amazon.awssdk.services.gamelift.model.StopGameSessionPlacementResponse;
import software.amazon.awssdk.services.gamelift.model.StopMatchmakingRequest;
import software.amazon.awssdk.services.gamelift.model.StopMatchmakingResponse;
import software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.SuspendGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.TagResourceRequest;
import software.amazon.awssdk.services.gamelift.model.TagResourceResponse;
import software.amazon.awssdk.services.gamelift.model.UntagResourceRequest;
import software.amazon.awssdk.services.gamelift.model.UntagResourceResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateAliasRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateAliasResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateBuildRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateBuildResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetAttributesResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateFleetPortSettingsResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerGroupResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameServerResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionQueueResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateGameSessionResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateMatchmakingConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateRuntimeConfigurationResponse;
import software.amazon.awssdk.services.gamelift.model.UpdateScriptRequest;
import software.amazon.awssdk.services.gamelift.model.UpdateScriptResponse;
import software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetRequest;
import software.amazon.awssdk.services.gamelift.model.ValidateMatchmakingRuleSetResponse;
import software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesPublisher;
import software.amazon.awssdk.services.gamelift.paginators.ListAliasesPublisher;
import software.amazon.awssdk.services.gamelift.paginators.ListBuildsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.ListComputePublisher;
import software.amazon.awssdk.services.gamelift.paginators.ListContainerGroupDefinitionsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.ListFleetsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.ListGameServersPublisher;
import software.amazon.awssdk.services.gamelift.paginators.ListLocationsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.ListScriptsPublisher;
import software.amazon.awssdk.services.gamelift.paginators.SearchGameSessionsPublisher;

/**
 * Service client for accessing Amazon GameLift asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon GameLift provides solutions for hosting session-based multiplayer game servers in the cloud, including tools
 * for deploying, operating, and scaling game servers. Built on Amazon Web Services global computing infrastructure,
 * GameLift helps you deliver high-performance, high-reliability, low-cost game servers while dynamically scaling your
 * resource usage to meet player demand.
 * </p>
 * <p>
 * <b>About Amazon GameLift solutions</b>
 * </p>
 * <p>
 * Get more information on these Amazon GameLift solutions in the <a
 * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/">Amazon GameLift Developer Guide</a>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Amazon GameLift managed hosting -- Amazon GameLift offers a fully managed service to set up and maintain computing
 * machines for hosting, manage game session and player session life cycle, and handle security, storage, and
 * performance tracking. You can use automatic scaling tools to balance player demand and hosting costs, configure your
 * game session management to minimize player latency, and add FlexMatch for matchmaking.
 * </p>
 * </li>
 * <li>
 * <p>
 * Managed hosting with Realtime Servers -- With Amazon GameLift Realtime Servers, you can quickly configure and set up
 * ready-to-go game servers for your game. Realtime Servers provides a game server framework with core Amazon GameLift
 * infrastructure already built in. Then use the full range of Amazon GameLift managed hosting features, including
 * FlexMatch, for your game.
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon GameLift FleetIQ -- Use Amazon GameLift FleetIQ as a standalone service while hosting your games using EC2
 * instances and Auto Scaling groups. Amazon GameLift FleetIQ provides optimizations for game hosting, including
 * boosting the viability of low-cost Spot Instances gaming. For a complete solution, pair the Amazon GameLift FleetIQ
 * and FlexMatch standalone services.
 * </p>
 * </li>
 * <li>
 * <p>
 * Amazon GameLift FlexMatch -- Add matchmaking to your game hosting solution. FlexMatch is a customizable matchmaking
 * service for multiplayer games. Use FlexMatch as integrated with Amazon GameLift managed hosting or incorporate
 * FlexMatch as a standalone service into your own hosting solution.
 * </p>
 * </li>
 * </ul>
 * <p>
 * <b>About this API Reference</b>
 * </p>
 * <p>
 * This reference guide describes the low-level service API for Amazon GameLift. With each topic in this guide, you can
 * find links to language-specific SDK guides and the Amazon Web Services CLI reference. Useful links:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html">Amazon GameLift API
 * operations listed by tasks</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-components.html"> Amazon GameLift tools
 * and resources</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GameLiftAsyncClient extends AwsClient {
    String SERVICE_NAME = "gamelift";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "gamelift";

    /**
     * <p>
     * Registers a player's acceptance or rejection of a proposed FlexMatch match. A matchmaking configuration may
     * require player acceptance; if so, then matches built with that configuration cannot be completed unless all
     * players accept the proposed match within a specified time limit.
     * </p>
     * <p>
     * When FlexMatch builds a match, all the matchmaking tickets involved in the proposed match are placed into status
     * <code>REQUIRES_ACCEPTANCE</code>. This is a trigger for your game to get acceptance from all players in each
     * ticket. Calls to this action are only valid for tickets that are in this status; calls for tickets not in this
     * status result in an error.
     * </p>
     * <p>
     * To register acceptance, specify the ticket ID, one or more players, and an acceptance response. When all players
     * have accepted, Amazon GameLift advances the matchmaking tickets to status <code>PLACING</code>, and attempts to
     * create a new game session for the match.
     * </p>
     * <p>
     * If any player rejects the match, or if acceptances are not received before a specified timeout, the proposed
     * match is dropped. Each matchmaking ticket in the failed match is handled as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the ticket has one or more players who rejected the match or failed to respond, the ticket status is set
     * <code>CANCELLED</code> and processing is terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * If all players in the ticket accepted the match, the ticket status is returned to <code>SEARCHING</code> to find
     * a new match.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html"> FlexMatch events</a>
     * (reference)
     * </p>
     *
     * @param acceptMatchRequest
     * @return A Java Future containing the result of the AcceptMatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.AcceptMatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AcceptMatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptMatchResponse> acceptMatch(AcceptMatchRequest acceptMatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a player's acceptance or rejection of a proposed FlexMatch match. A matchmaking configuration may
     * require player acceptance; if so, then matches built with that configuration cannot be completed unless all
     * players accept the proposed match within a specified time limit.
     * </p>
     * <p>
     * When FlexMatch builds a match, all the matchmaking tickets involved in the proposed match are placed into status
     * <code>REQUIRES_ACCEPTANCE</code>. This is a trigger for your game to get acceptance from all players in each
     * ticket. Calls to this action are only valid for tickets that are in this status; calls for tickets not in this
     * status result in an error.
     * </p>
     * <p>
     * To register acceptance, specify the ticket ID, one or more players, and an acceptance response. When all players
     * have accepted, Amazon GameLift advances the matchmaking tickets to status <code>PLACING</code>, and attempts to
     * create a new game session for the match.
     * </p>
     * <p>
     * If any player rejects the match, or if acceptances are not received before a specified timeout, the proposed
     * match is dropped. Each matchmaking ticket in the failed match is handled as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the ticket has one or more players who rejected the match or failed to respond, the ticket status is set
     * <code>CANCELLED</code> and processing is terminated.
     * </p>
     * </li>
     * <li>
     * <p>
     * If all players in the ticket accepted the match, the ticket status is returned to <code>SEARCHING</code> to find
     * a new match.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html"> FlexMatch events</a>
     * (reference)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptMatchRequest.Builder} avoiding the need to
     * create one manually via {@link AcceptMatchRequest#builder()}
     * </p>
     *
     * @param acceptMatchRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.AcceptMatchRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptMatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.AcceptMatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AcceptMatch" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptMatchResponse> acceptMatch(Consumer<AcceptMatchRequest.Builder> acceptMatchRequest) {
        return acceptMatch(AcceptMatchRequest.builder().applyMutation(acceptMatchRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Locates an available game server and temporarily reserves it to host gameplay and players. This operation is
     * called from a game client or client service (such as a matchmaker) to request hosting resources for a new game
     * session. In response, Amazon GameLift FleetIQ locates an available game server, places it in <code>CLAIMED</code>
     * status for 60 seconds, and returns connection information that players can use to connect to the game server.
     * </p>
     * <p>
     * To claim a game server, identify a game server group. You can also specify a game server ID, although this
     * approach bypasses Amazon GameLift FleetIQ placement optimization. Optionally, include game data to pass to the
     * game server at the start of a game session, such as a game map or player information. Add filter options to
     * further restrict how a game server is chosen, such as only allowing game servers on <code>ACTIVE</code> instances
     * to be claimed.
     * </p>
     * <p>
     * When a game server is successfully claimed, connection information is returned. A claimed game server's
     * utilization status remains <code>AVAILABLE</code> while the claim status is set to <code>CLAIMED</code> for up to
     * 60 seconds. This time period gives the game server time to update its status to <code>UTILIZED</code> after
     * players join. If the game server's status is not updated within 60 seconds, the game server reverts to unclaimed
     * status and is available to be claimed by another request. The claim time period is a fixed value and is not
     * configurable.
     * </p>
     * <p>
     * If you try to claim a specific game server, this request will fail in the following cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the game server utilization status is <code>UTILIZED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the game server claim status is <code>CLAIMED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the game server is running on an instance in <code>DRAINING</code> status and the provided filter option does
     * not allow placing on <code>DRAINING</code> instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param claimGameServerRequest
     * @return A Java Future containing the result of the ClaimGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>OutOfCapacityException The specified game server group has no available game servers to fulfill a
     *         <code>ClaimGameServer</code> request. Clients can retry such requests immediately or after a waiting
     *         period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ClaimGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ClaimGameServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ClaimGameServerResponse> claimGameServer(ClaimGameServerRequest claimGameServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Locates an available game server and temporarily reserves it to host gameplay and players. This operation is
     * called from a game client or client service (such as a matchmaker) to request hosting resources for a new game
     * session. In response, Amazon GameLift FleetIQ locates an available game server, places it in <code>CLAIMED</code>
     * status for 60 seconds, and returns connection information that players can use to connect to the game server.
     * </p>
     * <p>
     * To claim a game server, identify a game server group. You can also specify a game server ID, although this
     * approach bypasses Amazon GameLift FleetIQ placement optimization. Optionally, include game data to pass to the
     * game server at the start of a game session, such as a game map or player information. Add filter options to
     * further restrict how a game server is chosen, such as only allowing game servers on <code>ACTIVE</code> instances
     * to be claimed.
     * </p>
     * <p>
     * When a game server is successfully claimed, connection information is returned. A claimed game server's
     * utilization status remains <code>AVAILABLE</code> while the claim status is set to <code>CLAIMED</code> for up to
     * 60 seconds. This time period gives the game server time to update its status to <code>UTILIZED</code> after
     * players join. If the game server's status is not updated within 60 seconds, the game server reverts to unclaimed
     * status and is available to be claimed by another request. The claim time period is a fixed value and is not
     * configurable.
     * </p>
     * <p>
     * If you try to claim a specific game server, this request will fail in the following cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the game server utilization status is <code>UTILIZED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the game server claim status is <code>CLAIMED</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the game server is running on an instance in <code>DRAINING</code> status and the provided filter option does
     * not allow placing on <code>DRAINING</code> instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClaimGameServerRequest.Builder} avoiding the need
     * to create one manually via {@link ClaimGameServerRequest#builder()}
     * </p>
     *
     * @param claimGameServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ClaimGameServerRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ClaimGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>OutOfCapacityException The specified game server group has no available game servers to fulfill a
     *         <code>ClaimGameServer</code> request. Clients can retry such requests immediately or after a waiting
     *         period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ClaimGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ClaimGameServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ClaimGameServerResponse> claimGameServer(
            Consumer<ClaimGameServerRequest.Builder> claimGameServerRequest) {
        return claimGameServer(ClaimGameServerRequest.builder().applyMutation(claimGameServerRequest).build());
    }

    /**
     * <p>
     * Creates an alias for a fleet. In most situations, you can use an alias ID in place of a fleet ID. An alias
     * provides a level of abstraction for a fleet that is useful when redirecting player traffic from one fleet to
     * another, such as when updating your game build.
     * </p>
     * <p>
     * Amazon GameLift supports two types of routing strategies for aliases: simple and terminal. A simple alias points
     * to an active fleet. A terminal alias is used to display messaging or link to a URL instead of routing players to
     * an active fleet. For example, you might use a terminal alias when a game version is no longer supported and you
     * want to direct players to an upgrade site.
     * </p>
     * <p>
     * To create a fleet alias, specify an alias name, routing strategy, and optional description. Each simple alias can
     * point to only one fleet, but a fleet can have multiple aliases. If successful, a new alias record is returned,
     * including an alias ID and an ARN. You can reassign an alias to another fleet by calling <code>UpdateAlias</code>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createAliasRequest
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an alias for a fleet. In most situations, you can use an alias ID in place of a fleet ID. An alias
     * provides a level of abstraction for a fleet that is useful when redirecting player traffic from one fleet to
     * another, such as when updating your game build.
     * </p>
     * <p>
     * Amazon GameLift supports two types of routing strategies for aliases: simple and terminal. A simple alias points
     * to an active fleet. A terminal alias is used to display messaging or link to a URL instead of routing players to
     * an active fleet. For example, you might use a terminal alias when a game version is no longer supported and you
     * want to direct players to an upgrade site.
     * </p>
     * <p>
     * To create a fleet alias, specify an alias name, routing strategy, and optional description. Each simple alias can
     * point to only one fleet, but a fleet can have multiple aliases. If successful, a new alias record is returned,
     * including an alias ID and an ARN. You can reassign an alias to another fleet by calling <code>UpdateAlias</code>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAliasRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAliasRequest#builder()}
     * </p>
     *
     * @param createAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAliasResponse> createAlias(Consumer<CreateAliasRequest.Builder> createAliasRequest) {
        return createAlias(CreateAliasRequest.builder().applyMutation(createAliasRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon GameLift build resource for your game server binary files. Combine game server binaries into
     * a zip file for use with Amazon GameLift.
     * </p>
     * <important>
     * <p>
     * When setting up a new game build for Amazon GameLift, we recommend using the CLI command <b> <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html">upload-build</a> </b>. This
     * helper command combines two tasks: (1) it uploads your build files from a file directory to an Amazon GameLift
     * Amazon S3 location, and (2) it creates a new build resource.
     * </p>
     * </important>
     * <p>
     * You can use the <code>CreateBuild</code> operation in the following scenarios:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new game build with build files that are in an Amazon S3 location under an Amazon Web Services account
     * that you control. To use this option, you give Amazon GameLift access to the Amazon S3 bucket. With permissions
     * in place, specify a build name, operating system, and the Amazon S3 storage location of your game build.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload your build files to a Amazon GameLift Amazon S3 location. To use this option, specify a build name and
     * operating system. This operation creates a new build resource and also returns an Amazon S3 location with
     * temporary access credentials. Use the credentials to manually upload your build files to the specified Amazon S3
     * location. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html">Uploading Objects</a> in the
     * <i>Amazon S3 Developer Guide</i>. After you upload build files to the Amazon GameLift Amazon S3 location, you
     * can't update them.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new build resource with a unique build ID and places it in
     * <code>INITIALIZED</code> status. A build must be in <code>READY</code> status before you can create fleets with
     * it.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html">Uploading Your
     * Game</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"
     * > Create a Build with Files in Amazon S3</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createBuildRequest
     * @return A Java Future containing the result of the CreateBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBuildResponse> createBuild(CreateBuildRequest createBuildRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon GameLift build resource for your game server binary files. Combine game server binaries into
     * a zip file for use with Amazon GameLift.
     * </p>
     * <important>
     * <p>
     * When setting up a new game build for Amazon GameLift, we recommend using the CLI command <b> <a
     * href="https://docs.aws.amazon.com/cli/latest/reference/gamelift/upload-build.html">upload-build</a> </b>. This
     * helper command combines two tasks: (1) it uploads your build files from a file directory to an Amazon GameLift
     * Amazon S3 location, and (2) it creates a new build resource.
     * </p>
     * </important>
     * <p>
     * You can use the <code>CreateBuild</code> operation in the following scenarios:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Create a new game build with build files that are in an Amazon S3 location under an Amazon Web Services account
     * that you control. To use this option, you give Amazon GameLift access to the Amazon S3 bucket. With permissions
     * in place, specify a build name, operating system, and the Amazon S3 storage location of your game build.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload your build files to a Amazon GameLift Amazon S3 location. To use this option, specify a build name and
     * operating system. This operation creates a new build resource and also returns an Amazon S3 location with
     * temporary access credentials. Use the credentials to manually upload your build files to the specified Amazon S3
     * location. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UploadingObjects.html">Uploading Objects</a> in the
     * <i>Amazon S3 Developer Guide</i>. After you upload build files to the Amazon GameLift Amazon S3 location, you
     * can't update them.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new build resource with a unique build ID and places it in
     * <code>INITIALIZED</code> status. A build must be in <code>READY</code> status before you can create fleets with
     * it.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html">Uploading Your
     * Game</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"
     * > Create a Build with Files in Amazon S3</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBuildRequest.Builder} avoiding the need to
     * create one manually via {@link CreateBuildRequest#builder()}
     * </p>
     *
     * @param createBuildRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateBuildRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateBuildResponse> createBuild(Consumer<CreateBuildRequest.Builder> createBuildRequest) {
        return createBuild(CreateBuildRequest.builder().applyMutation(createBuildRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift containers feature, which is currently in public preview. </b>
     * </p>
     * <p>
     * Creates a <code>ContainerGroupDefinition</code> resource that describes a set of containers for hosting your game
     * server with Amazon GameLift managed EC2 hosting. An Amazon GameLift container group is similar to a container
     * "task" and "pod". Each container group can have one or more containers.
     * </p>
     * <p>
     * Use container group definitions when you create a container fleet. Container group definitions determine how
     * Amazon GameLift deploys your containers to each instance in a container fleet.
     * </p>
     * <p>
     * You can create two types of container groups, based on scheduling strategy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <b>replica container group</b> manages the containers that run your game server application and supporting
     * software. Replica container groups might be replicated multiple times on each fleet instance, depending on
     * instance resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <b>daemon container group</b> manages containers that run other software, such as background services, logging,
     * or test processes. You might use a daemon container group for processes that need to run only once per fleet
     * instance, or processes that need to persist independently of the replica container group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To create a container group definition, specify a group name, a list of container definitions, and maximum total
     * CPU and memory requirements for the container group. Specify an operating system and scheduling strategy or use
     * the default values. When using the Amazon Web Services CLI tool, you can pass in your container definitions as a
     * JSON file.
     * </p>
     * <note>
     * <p>
     * This operation requires Identity and Access Management (IAM) permissions to access container images in Amazon ECR
     * repositories. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-iam-policy-examples.html"> IAM
     * permissions for Amazon GameLift</a> for help setting the appropriate permissions.
     * </p>
     * </note>
     * <p>
     * If successful, this operation creates a new <code>ContainerGroupDefinition</code> resource with an ARN value
     * assigned. You can't change the properties of a container group definition. Instead, create a new one.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Create a
     * container group definition</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet.html">Container fleet
     * design guide</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-definitions.html#containers-definitions-create"
     * >Create a container definition as a JSON file</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createContainerGroupDefinitionRequest
     * @return A Java Future containing the result of the CreateContainerGroupDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateContainerGroupDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateContainerGroupDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContainerGroupDefinitionResponse> createContainerGroupDefinition(
            CreateContainerGroupDefinitionRequest createContainerGroupDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift containers feature, which is currently in public preview. </b>
     * </p>
     * <p>
     * Creates a <code>ContainerGroupDefinition</code> resource that describes a set of containers for hosting your game
     * server with Amazon GameLift managed EC2 hosting. An Amazon GameLift container group is similar to a container
     * "task" and "pod". Each container group can have one or more containers.
     * </p>
     * <p>
     * Use container group definitions when you create a container fleet. Container group definitions determine how
     * Amazon GameLift deploys your containers to each instance in a container fleet.
     * </p>
     * <p>
     * You can create two types of container groups, based on scheduling strategy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A <b>replica container group</b> manages the containers that run your game server application and supporting
     * software. Replica container groups might be replicated multiple times on each fleet instance, depending on
     * instance resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <b>daemon container group</b> manages containers that run other software, such as background services, logging,
     * or test processes. You might use a daemon container group for processes that need to run only once per fleet
     * instance, or processes that need to persist independently of the replica container group.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To create a container group definition, specify a group name, a list of container definitions, and maximum total
     * CPU and memory requirements for the container group. Specify an operating system and scheduling strategy or use
     * the default values. When using the Amazon Web Services CLI tool, you can pass in your container definitions as a
     * JSON file.
     * </p>
     * <note>
     * <p>
     * This operation requires Identity and Access Management (IAM) permissions to access container images in Amazon ECR
     * repositories. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-iam-policy-examples.html"> IAM
     * permissions for Amazon GameLift</a> for help setting the appropriate permissions.
     * </p>
     * </note>
     * <p>
     * If successful, this operation creates a new <code>ContainerGroupDefinition</code> resource with an ARN value
     * assigned. You can't change the properties of a container group definition. Instead, create a new one.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Create a
     * container group definition</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-design-fleet.html">Container fleet
     * design guide</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-definitions.html#containers-definitions-create"
     * >Create a container definition as a JSON file</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateContainerGroupDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateContainerGroupDefinitionRequest#builder()}
     * </p>
     *
     * @param createContainerGroupDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateContainerGroupDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateContainerGroupDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateContainerGroupDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateContainerGroupDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateContainerGroupDefinitionResponse> createContainerGroupDefinition(
            Consumer<CreateContainerGroupDefinitionRequest.Builder> createContainerGroupDefinitionRequest) {
        return createContainerGroupDefinition(CreateContainerGroupDefinitionRequest.builder()
                .applyMutation(createContainerGroupDefinitionRequest).build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Creates a fleet of compute resources to host your game servers. Use this operation to set up the following types
     * of fleets based on compute type:
     * </p>
     * <p>
     * <b>Managed EC2 fleet</b>
     * </p>
     * <p>
     * An EC2 fleet is a set of Amazon Elastic Compute Cloud (Amazon EC2) instances. Your game server build is deployed
     * to each fleet instance. Amazon GameLift manages the fleet's instances and controls the lifecycle of game server
     * processes, which host game sessions for players. EC2 fleets can have instances in multiple locations. Each
     * instance in the fleet is designated a <code>Compute</code>.
     * </p>
     * <p>
     * To create an EC2 fleet, provide these required parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Either <code>BuildId</code> or <code>ScriptId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ComputeType</code> set to <code>EC2</code> (the default value)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2InboundPermissions</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2InstanceType</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FleetType</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RuntimeConfiguration</code> with at least one <code>ServerProcesses</code> configuration
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new fleet resource and places it in <code>NEW</code> status while Amazon
     * GameLift initiates the <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow"
     * >fleet creation workflow</a>. To debug your fleet, fetch logs, view performance metrics or other actions on the
     * fleet, create a development fleet with port 22/3389 open. As a best practice, we recommend opening ports for
     * remote access only when you need them and closing them when you're finished.
     * </p>
     * <p>
     * When the fleet status is ACTIVE, you can adjust capacity settings and turn autoscaling on/off for each location.
     * </p>
     * <p>
     * <b>Managed container fleet</b>
     * </p>
     * <p>
     * A container fleet is a set of Amazon Elastic Compute Cloud (Amazon EC2) instances. Your container architecture is
     * deployed to each fleet instance based on the fleet configuration. Amazon GameLift manages the containers on each
     * fleet instance and controls the lifecycle of game server processes, which host game sessions for players.
     * Container fleets can have instances in multiple locations. Each container on an instance that runs game server
     * processes is registered as a <code>Compute</code>.
     * </p>
     * <p>
     * To create a container fleet, provide these required parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ComputeType</code> set to <code>CONTAINER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ContainerGroupsConfiguration</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2InboundPermissions</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2InstanceType</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FleetType</code> set to <code>ON_DEMAND</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RuntimeConfiguration</code> with at least one <code>ServerProcesses</code> configuration
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new fleet resource and places it in <code>NEW</code> status while Amazon
     * GameLift initiates the <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow"
     * >fleet creation workflow</a>.
     * </p>
     * <p>
     * When the fleet status is ACTIVE, you can adjust capacity settings and turn autoscaling on/off for each location.
     * </p>
     * <p>
     * <b>Anywhere fleet</b>
     * </p>
     * <p>
     * An Anywhere fleet represents compute resources that are not owned or managed by Amazon GameLift. You might create
     * an Anywhere fleet with your local machine for testing, or use one to host game servers with on-premises hardware
     * or other game hosting solutions.
     * </p>
     * <p>
     * To create an Anywhere fleet, provide these required parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ComputeType</code> set to <code>ANYWHERE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Locations</code> specifying a custom location
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new fleet resource and places it in <code>ACTIVE</code> status. You can
     * register computes with a fleet in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-build-fleet.html">Setting up a
     * container fleet</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation"
     * >Debug fleet creation issues</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Multi-location fleets</a>
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>NotReadyException The operation failed because Amazon GameLift has not yet finished validating this
     *         compute. We recommend attempting 8 to 10 retries over 3 to 5 minutes with <a href=
     *         "http://aws.amazon.com/blogs/https:/aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/"
     *         >exponential backoffs and jitter</a>.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Creates a fleet of compute resources to host your game servers. Use this operation to set up the following types
     * of fleets based on compute type:
     * </p>
     * <p>
     * <b>Managed EC2 fleet</b>
     * </p>
     * <p>
     * An EC2 fleet is a set of Amazon Elastic Compute Cloud (Amazon EC2) instances. Your game server build is deployed
     * to each fleet instance. Amazon GameLift manages the fleet's instances and controls the lifecycle of game server
     * processes, which host game sessions for players. EC2 fleets can have instances in multiple locations. Each
     * instance in the fleet is designated a <code>Compute</code>.
     * </p>
     * <p>
     * To create an EC2 fleet, provide these required parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Either <code>BuildId</code> or <code>ScriptId</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ComputeType</code> set to <code>EC2</code> (the default value)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2InboundPermissions</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2InstanceType</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FleetType</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RuntimeConfiguration</code> with at least one <code>ServerProcesses</code> configuration
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new fleet resource and places it in <code>NEW</code> status while Amazon
     * GameLift initiates the <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow"
     * >fleet creation workflow</a>. To debug your fleet, fetch logs, view performance metrics or other actions on the
     * fleet, create a development fleet with port 22/3389 open. As a best practice, we recommend opening ports for
     * remote access only when you need them and closing them when you're finished.
     * </p>
     * <p>
     * When the fleet status is ACTIVE, you can adjust capacity settings and turn autoscaling on/off for each location.
     * </p>
     * <p>
     * <b>Managed container fleet</b>
     * </p>
     * <p>
     * A container fleet is a set of Amazon Elastic Compute Cloud (Amazon EC2) instances. Your container architecture is
     * deployed to each fleet instance based on the fleet configuration. Amazon GameLift manages the containers on each
     * fleet instance and controls the lifecycle of game server processes, which host game sessions for players.
     * Container fleets can have instances in multiple locations. Each container on an instance that runs game server
     * processes is registered as a <code>Compute</code>.
     * </p>
     * <p>
     * To create a container fleet, provide these required parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ComputeType</code> set to <code>CONTAINER</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ContainerGroupsConfiguration</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2InboundPermissions</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2InstanceType</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FleetType</code> set to <code>ON_DEMAND</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RuntimeConfiguration</code> with at least one <code>ServerProcesses</code> configuration
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new fleet resource and places it in <code>NEW</code> status while Amazon
     * GameLift initiates the <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-all.html#fleets-creation-workflow"
     * >fleet creation workflow</a>.
     * </p>
     * <p>
     * When the fleet status is ACTIVE, you can adjust capacity settings and turn autoscaling on/off for each location.
     * </p>
     * <p>
     * <b>Anywhere fleet</b>
     * </p>
     * <p>
     * An Anywhere fleet represents compute resources that are not owned or managed by Amazon GameLift. You might create
     * an Anywhere fleet with your local machine for testing, or use one to host game servers with on-premises hardware
     * or other game hosting solutions.
     * </p>
     * <p>
     * To create an Anywhere fleet, provide these required parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ComputeType</code> set to <code>ANYWHERE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Locations</code> specifying a custom location
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Name</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, this operation creates a new fleet resource and places it in <code>ACTIVE</code> status. You can
     * register computes with a fleet in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-build-fleet.html">Setting up a
     * container fleet</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html#fleets-creating-debug-creation"
     * >Debug fleet creation issues</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Multi-location fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>NotReadyException The operation failed because Amazon GameLift has not yet finished validating this
     *         compute. We recommend attempting 8 to 10 retries over 3 to 5 minutes with <a href=
     *         "http://aws.amazon.com/blogs/https:/aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/"
     *         >exponential backoffs and jitter</a>.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFleetResponse> createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest) {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Adds remote locations to an EC2 or container fleet and begins populating the new locations with instances. The
     * new instances conform to the fleet's instance type, auto-scaling, and other configuration settings.
     * </p>
     * <note>
     * <p>
     * You can't add remote locations to a fleet that resides in an Amazon Web Services Region that doesn't support
     * multiple locations. Fleets created prior to March 2021 can't support multiple locations.
     * </p>
     * </note>
     * <p>
     * To add fleet locations, specify the fleet to be updated and provide a list of one or more locations.
     * </p>
     * <p>
     * If successful, this operation returns the list of added locations with their status set to <code>NEW</code>.
     * Amazon GameLift initiates the process of starting an instance in each added location. You can track the status of
     * each new location by monitoring location creation events using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html"
     * >DescribeFleetEvents</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-editing.html#fleets-update-locations">
     * Update fleet locations</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * service locations</a> for managed hosting.
     * </p>
     *
     * @param createFleetLocationsRequest
     * @return A Java Future containing the result of the CreateFleetLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>NotReadyException The operation failed because Amazon GameLift has not yet finished validating this
     *         compute. We recommend attempting 8 to 10 retries over 3 to 5 minutes with <a href=
     *         "http://aws.amazon.com/blogs/https:/aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/"
     *         >exponential backoffs and jitter</a>.</li>
     *         <li>InvalidFleetStatusException The requested operation would cause a conflict with the current state of
     *         a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateFleetLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleetLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFleetLocationsResponse> createFleetLocations(
            CreateFleetLocationsRequest createFleetLocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Adds remote locations to an EC2 or container fleet and begins populating the new locations with instances. The
     * new instances conform to the fleet's instance type, auto-scaling, and other configuration settings.
     * </p>
     * <note>
     * <p>
     * You can't add remote locations to a fleet that resides in an Amazon Web Services Region that doesn't support
     * multiple locations. Fleets created prior to March 2021 can't support multiple locations.
     * </p>
     * </note>
     * <p>
     * To add fleet locations, specify the fleet to be updated and provide a list of one or more locations.
     * </p>
     * <p>
     * If successful, this operation returns the list of added locations with their status set to <code>NEW</code>.
     * Amazon GameLift initiates the process of starting an instance in each added location. You can track the status of
     * each new location by monitoring location creation events using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html"
     * >DescribeFleetEvents</a>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-editing.html#fleets-update-locations">
     * Update fleet locations</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * service locations</a> for managed hosting.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetLocationsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFleetLocationsRequest#builder()}
     * </p>
     *
     * @param createFleetLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateFleetLocationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateFleetLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>NotReadyException The operation failed because Amazon GameLift has not yet finished validating this
     *         compute. We recommend attempting 8 to 10 retries over 3 to 5 minutes with <a href=
     *         "http://aws.amazon.com/blogs/https:/aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/"
     *         >exponential backoffs and jitter</a>.</li>
     *         <li>InvalidFleetStatusException The requested operation would cause a conflict with the current state of
     *         a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateFleetLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateFleetLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateFleetLocationsResponse> createFleetLocations(
            Consumer<CreateFleetLocationsRequest.Builder> createFleetLocationsRequest) {
        return createFleetLocations(CreateFleetLocationsRequest.builder().applyMutation(createFleetLocationsRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Creates a Amazon GameLift FleetIQ game server group for managing game hosting on a collection of Amazon Elastic
     * Compute Cloud instances for game hosting. This operation creates the game server group, creates an Auto Scaling
     * group in your Amazon Web Services account, and establishes a link between the two groups. You can view the status
     * of your game server groups in the Amazon GameLift console. Game server group metrics and events are emitted to
     * Amazon CloudWatch.
     * </p>
     * <p>
     * Before creating a new game server group, you must have the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Elastic Compute Cloud launch template that specifies how to launch Amazon Elastic Compute Cloud
     * instances with your game server build. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html"> Launching an Instance from
     * a Launch Template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * An IAM role that extends limited access to your Amazon Web Services account to allow Amazon GameLift FleetIQ to
     * create and interact with the Auto Scaling group. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html">Create IAM roles
     * for cross-service interaction</a> in the <i>Amazon GameLift FleetIQ Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To create a new game server group, specify a unique group name, IAM role and Amazon Elastic Compute Cloud launch
     * template, and provide a list of instance types that can be used in the group. You must also set initial maximum
     * and minimum limits on the group's instance count. You can optionally set an Auto Scaling policy with target
     * tracking based on a Amazon GameLift FleetIQ metric.
     * </p>
     * <p>
     * Once the game server group and corresponding Auto Scaling group are created, you have full access to change the
     * Auto Scaling group's configuration as needed. Several properties that are set when creating a game server group,
     * including maximum/minimum size and auto-scaling policy settings, must be updated directly in the Auto Scaling
     * group. Keep in mind that some Auto Scaling group properties are periodically updated by Amazon GameLift FleetIQ
     * as part of its balancing activities to optimize for availability and cost.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param createGameServerGroupRequest
     * @return A Java Future containing the result of the CreateGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGameServerGroupResponse> createGameServerGroup(
            CreateGameServerGroupRequest createGameServerGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Creates a Amazon GameLift FleetIQ game server group for managing game hosting on a collection of Amazon Elastic
     * Compute Cloud instances for game hosting. This operation creates the game server group, creates an Auto Scaling
     * group in your Amazon Web Services account, and establishes a link between the two groups. You can view the status
     * of your game server groups in the Amazon GameLift console. Game server group metrics and events are emitted to
     * Amazon CloudWatch.
     * </p>
     * <p>
     * Before creating a new game server group, you must have the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * An Amazon Elastic Compute Cloud launch template that specifies how to launch Amazon Elastic Compute Cloud
     * instances with your game server build. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html"> Launching an Instance from
     * a Launch Template</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * An IAM role that extends limited access to your Amazon Web Services account to allow Amazon GameLift FleetIQ to
     * create and interact with the Auto Scaling group. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-iam-permissions-roles.html">Create IAM roles
     * for cross-service interaction</a> in the <i>Amazon GameLift FleetIQ Developer Guide</i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To create a new game server group, specify a unique group name, IAM role and Amazon Elastic Compute Cloud launch
     * template, and provide a list of instance types that can be used in the group. You must also set initial maximum
     * and minimum limits on the group's instance count. You can optionally set an Auto Scaling policy with target
     * tracking based on a Amazon GameLift FleetIQ metric.
     * </p>
     * <p>
     * Once the game server group and corresponding Auto Scaling group are created, you have full access to change the
     * Auto Scaling group's configuration as needed. Several properties that are set when creating a game server group,
     * including maximum/minimum size and auto-scaling policy settings, must be updated directly in the Auto Scaling
     * group. Keep in mind that some Auto Scaling group properties are periodically updated by Amazon GameLift FleetIQ
     * as part of its balancing activities to optimize for availability and cost.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGameServerGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGameServerGroupRequest#builder()}
     * </p>
     *
     * @param createGameServerGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateGameServerGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGameServerGroupResponse> createGameServerGroup(
            Consumer<CreateGameServerGroupRequest.Builder> createGameServerGroupRequest) {
        return createGameServerGroup(CreateGameServerGroupRequest.builder().applyMutation(createGameServerGroupRequest).build());
    }

    /**
     * <p>
     * Creates a multiplayer game session for players in a specific fleet location. This operation prompts an available
     * server process to start a game session and retrieves connection information for the new game session. As an
     * alternative, consider using the Amazon GameLift game session placement feature with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> , which uses the FleetIQ algorithm and queues to optimize the placement process.
     * </p>
     * <p>
     * When creating a game session, you specify exactly where you want to place it and provide a set of game session
     * configuration settings. The target fleet must be in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * You can use this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a game session on an instance in a fleet's home Region, provide a fleet or alias ID along with your
     * game session configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a game session on an instance in a fleet's remote location, provide a fleet or alias ID and a location
     * name, along with your game session configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a game session on an instance in an Anywhere fleet, specify the fleet's custom location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, Amazon GameLift initiates a workflow to start a new game session and returns a
     * <code>GameSession</code> object containing the game session configuration and status. When the game session
     * status is <code>ACTIVE</code>, it is updated with connection information and you can create player sessions for
     * the game session. By default, newly created game sessions are open to new players. You can restrict new player
     * access by using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>
     * to change the game session's player session creation policy.
     * </p>
     * <p>
     * Amazon GameLift retains logs for active for 14 days. To access the logs, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html"
     * >GetGameSessionLogUrl</a> to download the log files.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createGameSessionRequest
     * @return A Java Future containing the result of the CreateGameSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidFleetStatusException The requested operation would cause a conflict with the current state of
     *         a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>FleetCapacityExceededException The specified fleet has no available instances to fulfill a
     *         <code>CreateGameSession</code> request. Clients can retry such requests immediately or after a waiting
     *         period.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>IdempotentParameterMismatchException A game session with this custom ID string already exists in this
     *         fleet. Resolve this conflict before retrying this request.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateGameSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGameSessionResponse> createGameSession(CreateGameSessionRequest createGameSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a multiplayer game session for players in a specific fleet location. This operation prompts an available
     * server process to start a game session and retrieves connection information for the new game session. As an
     * alternative, consider using the Amazon GameLift game session placement feature with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> , which uses the FleetIQ algorithm and queues to optimize the placement process.
     * </p>
     * <p>
     * When creating a game session, you specify exactly where you want to place it and provide a set of game session
     * configuration settings. The target fleet must be in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * You can use this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To create a game session on an instance in a fleet's home Region, provide a fleet or alias ID along with your
     * game session configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a game session on an instance in a fleet's remote location, provide a fleet or alias ID and a location
     * name, along with your game session configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * To create a game session on an instance in an Anywhere fleet, specify the fleet's custom location.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, Amazon GameLift initiates a workflow to start a new game session and returns a
     * <code>GameSession</code> object containing the game session configuration and status. When the game session
     * status is <code>ACTIVE</code>, it is updated with connection information and you can create player sessions for
     * the game session. By default, newly created game sessions are open to new players. You can restrict new player
     * access by using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>
     * to change the game session's player session creation policy.
     * </p>
     * <p>
     * Amazon GameLift retains logs for active for 14 days. To access the logs, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html"
     * >GetGameSessionLogUrl</a> to download the log files.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGameSessionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateGameSessionRequest#builder()}
     * </p>
     *
     * @param createGameSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateGameSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGameSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidFleetStatusException The requested operation would cause a conflict with the current state of
     *         a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>FleetCapacityExceededException The specified fleet has no available instances to fulfill a
     *         <code>CreateGameSession</code> request. Clients can retry such requests immediately or after a waiting
     *         period.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>IdempotentParameterMismatchException A game session with this custom ID string already exists in this
     *         fleet. Resolve this conflict before retrying this request.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateGameSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGameSessionResponse> createGameSession(
            Consumer<CreateGameSessionRequest.Builder> createGameSessionRequest) {
        return createGameSession(CreateGameSessionRequest.builder().applyMutation(createGameSessionRequest).build());
    }

    /**
     * <p>
     * Creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to
     * determine the best placement locations and find an available game server there, then prompts the game server
     * process to start a new game session.
     * </p>
     * <p>
     * A game session queue is configured with a set of destinations (Amazon GameLift fleets or aliases), which
     * determine the locations where the queue can place new game sessions. These destinations can span multiple fleet
     * types (Spot and On-Demand), instance types, and Amazon Web Services Regions. If the queue includes multi-location
     * fleets, the queue is able to place game sessions in all of a fleet's remote locations. You can opt to filter out
     * individual locations if needed.
     * </p>
     * <p>
     * The queue configuration also determines how FleetIQ selects the best available placement for a new game session.
     * Before searching for an available game server, FleetIQ first prioritizes the queue's destinations and locations,
     * with the best placement locations on top. You can set up the queue to use the FleetIQ default prioritization or
     * provide an alternate set of priorities.
     * </p>
     * <p>
     * To create a new queue, provide a name, timeout value, and a list of destinations. Optionally, specify a sort
     * configuration and/or a filter, and define a set of latency cap policies. You can also include the ARN for an
     * Amazon Simple Notification Service (SNS) topic to receive notifications of game session placement activity.
     * Notifications using SNS or CloudWatch events is the preferred way to track placement activity.
     * </p>
     * <p>
     * If successful, a new <code>GameSessionQueue</code> object is returned with an assigned queue ARN. New game
     * session requests, which are submitted to queue with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> or <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html">StartMatchmaking</a>,
     * reference a queue's name or ARN.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-design.html"> Design a game session
     * queue</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-creating.html"> Create a game session
     * queue</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">
     * CreateGameSessionQueue</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html"
     * >DescribeGameSessionQueues</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html"
     * >UpdateGameSessionQueue</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html"
     * >DeleteGameSessionQueue</a> | <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createGameSessionQueueRequest
     * @return A Java Future containing the result of the CreateGameSessionQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateGameSessionQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGameSessionQueueResponse> createGameSessionQueue(
            CreateGameSessionQueueRequest createGameSessionQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a placement queue that processes requests for new game sessions. A queue uses FleetIQ algorithms to
     * determine the best placement locations and find an available game server there, then prompts the game server
     * process to start a new game session.
     * </p>
     * <p>
     * A game session queue is configured with a set of destinations (Amazon GameLift fleets or aliases), which
     * determine the locations where the queue can place new game sessions. These destinations can span multiple fleet
     * types (Spot and On-Demand), instance types, and Amazon Web Services Regions. If the queue includes multi-location
     * fleets, the queue is able to place game sessions in all of a fleet's remote locations. You can opt to filter out
     * individual locations if needed.
     * </p>
     * <p>
     * The queue configuration also determines how FleetIQ selects the best available placement for a new game session.
     * Before searching for an available game server, FleetIQ first prioritizes the queue's destinations and locations,
     * with the best placement locations on top. You can set up the queue to use the FleetIQ default prioritization or
     * provide an alternate set of priorities.
     * </p>
     * <p>
     * To create a new queue, provide a name, timeout value, and a list of destinations. Optionally, specify a sort
     * configuration and/or a filter, and define a set of latency cap policies. You can also include the ARN for an
     * Amazon Simple Notification Service (SNS) topic to receive notifications of game session placement activity.
     * Notifications using SNS or CloudWatch events is the preferred way to track placement activity.
     * </p>
     * <p>
     * If successful, a new <code>GameSessionQueue</code> object is returned with an assigned queue ARN. New game
     * session requests, which are submitted to queue with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> or <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html">StartMatchmaking</a>,
     * reference a queue's name or ARN.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-design.html"> Design a game session
     * queue</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-creating.html"> Create a game session
     * queue</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html">
     * CreateGameSessionQueue</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html"
     * >DescribeGameSessionQueues</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html"
     * >UpdateGameSessionQueue</a> | <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html"
     * >DeleteGameSessionQueue</a> | <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGameSessionQueueRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGameSessionQueueRequest#builder()}
     * </p>
     *
     * @param createGameSessionQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateGameSessionQueueRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGameSessionQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateGameSessionQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateGameSessionQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGameSessionQueueResponse> createGameSessionQueue(
            Consumer<CreateGameSessionQueueRequest.Builder> createGameSessionQueueRequest) {
        return createGameSessionQueue(CreateGameSessionQueueRequest.builder().applyMutation(createGameSessionQueueRequest)
                .build());
    }

    /**
     * <p>
     * Creates a custom location for use in an Anywhere fleet.
     * </p>
     *
     * @param createLocationRequest
     * @return A Java Future containing the result of the CreateLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLocationResponse> createLocation(CreateLocationRequest createLocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom location for use in an Anywhere fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLocationRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLocationRequest#builder()}
     * </p>
     *
     * @param createLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateLocationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLocationResponse> createLocation(Consumer<CreateLocationRequest.Builder> createLocationRequest) {
        return createLocation(CreateLocationRequest.builder().applyMutation(createLocationRequest).build());
    }

    /**
     * <p>
     * Defines a new matchmaking configuration for use with FlexMatch. Whether your are using FlexMatch with Amazon
     * GameLift hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for
     * matching players and forming teams. If you're also using Amazon GameLift hosting, it defines how to start game
     * sessions for each match. Your matchmaking system can use multiple configurations to handle different game
     * scenarios. All matchmaking requests identify the matchmaking configuration to use and provide player attributes
     * consistent with that configuration.
     * </p>
     * <p>
     * To create a matchmaking configuration, you must provide the following: configuration name and FlexMatch mode
     * (with or without Amazon GameLift hosting); a rule set that specifies how to evaluate players and find acceptable
     * matches; whether player acceptance is required; and the maximum time allowed for a matchmaking attempt. When
     * using FlexMatch with Amazon GameLift hosting, you also need to identify the game session queue to use when
     * starting a game session for the match.
     * </p>
     * <p>
     * In addition, you must set up an Amazon Simple Notification Service topic to receive matchmaking notifications.
     * Provide the topic ARN in the matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html"> Design a FlexMatch
     * matchmaker</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set up FlexMatch
     * event notification</a>
     * </p>
     *
     * @param createMatchmakingConfigurationRequest
     * @return A Java Future containing the result of the CreateMatchmakingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateMatchmakingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMatchmakingConfigurationResponse> createMatchmakingConfiguration(
            CreateMatchmakingConfigurationRequest createMatchmakingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines a new matchmaking configuration for use with FlexMatch. Whether your are using FlexMatch with Amazon
     * GameLift hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for
     * matching players and forming teams. If you're also using Amazon GameLift hosting, it defines how to start game
     * sessions for each match. Your matchmaking system can use multiple configurations to handle different game
     * scenarios. All matchmaking requests identify the matchmaking configuration to use and provide player attributes
     * consistent with that configuration.
     * </p>
     * <p>
     * To create a matchmaking configuration, you must provide the following: configuration name and FlexMatch mode
     * (with or without Amazon GameLift hosting); a rule set that specifies how to evaluate players and find acceptable
     * matches; whether player acceptance is required; and the maximum time allowed for a matchmaking attempt. When
     * using FlexMatch with Amazon GameLift hosting, you also need to identify the game session queue to use when
     * starting a game session for the match.
     * </p>
     * <p>
     * In addition, you must set up an Amazon Simple Notification Service topic to receive matchmaking notifications.
     * Provide the topic ARN in the matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html"> Design a FlexMatch
     * matchmaker</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set up FlexMatch
     * event notification</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMatchmakingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateMatchmakingConfigurationRequest#builder()}
     * </p>
     *
     * @param createMatchmakingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateMatchmakingConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateMatchmakingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateMatchmakingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMatchmakingConfigurationResponse> createMatchmakingConfiguration(
            Consumer<CreateMatchmakingConfigurationRequest.Builder> createMatchmakingConfigurationRequest) {
        return createMatchmakingConfiguration(CreateMatchmakingConfigurationRequest.builder()
                .applyMutation(createMatchmakingConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the
     * number and size of teams. It also sets the parameters for acceptable player matches, such as minimum skill level
     * or character type.
     * </p>
     * <p>
     * To create a matchmaking rule set, provide unique rule set name and the rule set body in JSON format. Rule sets
     * must be defined in the same Region as the matchmaking configuration they are used with.
     * </p>
     * <p>
     * Since matchmaking rule sets cannot be edited, it is a good idea to check the rule set syntax using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html"
     * >ValidateMatchmakingRuleSet</a> before creating a new rule set.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html">Design a
     * matchmaker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html">Matchmaking with
     * FlexMatch</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param createMatchmakingRuleSetRequest
     * @return A Java Future containing the result of the CreateMatchmakingRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateMatchmakingRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMatchmakingRuleSetResponse> createMatchmakingRuleSet(
            CreateMatchmakingRuleSetRequest createMatchmakingRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new rule set for FlexMatch matchmaking. A rule set describes the type of match to create, such as the
     * number and size of teams. It also sets the parameters for acceptable player matches, such as minimum skill level
     * or character type.
     * </p>
     * <p>
     * To create a matchmaking rule set, provide unique rule set name and the rule set body in JSON format. Rule sets
     * must be defined in the same Region as the matchmaking configuration they are used with.
     * </p>
     * <p>
     * Since matchmaking rule sets cannot be edited, it is a good idea to check the rule set syntax using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html"
     * >ValidateMatchmakingRuleSet</a> before creating a new rule set.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-configuration.html">Design a
     * matchmaker</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-intro.html">Matchmaking with
     * FlexMatch</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMatchmakingRuleSetRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMatchmakingRuleSetRequest#builder()}
     * </p>
     *
     * @param createMatchmakingRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateMatchmakingRuleSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMatchmakingRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateMatchmakingRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateMatchmakingRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMatchmakingRuleSetResponse> createMatchmakingRuleSet(
            Consumer<CreateMatchmakingRuleSetRequest.Builder> createMatchmakingRuleSetRequest) {
        return createMatchmakingRuleSet(CreateMatchmakingRuleSetRequest.builder().applyMutation(createMatchmakingRuleSetRequest)
                .build());
    }

    /**
     * <p>
     * Reserves an open player slot in a game session for a player. New player sessions can be created in any game
     * session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of
     * <code>ACCEPT_ALL</code>. You can add a group of players to a game session with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html"
     * >CreatePlayerSessions</a> .
     * </p>
     * <p>
     * To create a player session, specify a game session ID, player ID, and optionally a set of player data.
     * </p>
     * <p>
     * If successful, a slot is reserved in the game session for the player and a new <code>PlayerSessions</code> object
     * is returned with a player session ID. The player references the player session ID when sending a connection
     * request to the game session, and the game server can use it to validate the player reservation with the Amazon
     * GameLift service. Player sessions cannot be updated.
     * </p>
     * <p>
     * The maximum number of players per game session is 200. It is not adjustable.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createPlayerSessionRequest
     * @return A Java Future containing the result of the CreatePlayerSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidGameSessionStatusException The requested operation would cause a conflict with the current
     *         state of a resource associated with the request and/or the game instance. Resolve the conflict before
     *         retrying.</li>
     *         <li>GameSessionFullException The game instance is currently full and cannot allow the requested player(s)
     *         to join. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreatePlayerSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePlayerSessionResponse> createPlayerSession(
            CreatePlayerSessionRequest createPlayerSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reserves an open player slot in a game session for a player. New player sessions can be created in any game
     * session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of
     * <code>ACCEPT_ALL</code>. You can add a group of players to a game session with <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html"
     * >CreatePlayerSessions</a> .
     * </p>
     * <p>
     * To create a player session, specify a game session ID, player ID, and optionally a set of player data.
     * </p>
     * <p>
     * If successful, a slot is reserved in the game session for the player and a new <code>PlayerSessions</code> object
     * is returned with a player session ID. The player references the player session ID when sending a connection
     * request to the game session, and the game server can use it to validate the player reservation with the Amazon
     * GameLift service. Player sessions cannot be updated.
     * </p>
     * <p>
     * The maximum number of players per game session is 200. It is not adjustable.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlayerSessionRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePlayerSessionRequest#builder()}
     * </p>
     *
     * @param createPlayerSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePlayerSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidGameSessionStatusException The requested operation would cause a conflict with the current
     *         state of a resource associated with the request and/or the game instance. Resolve the conflict before
     *         retrying.</li>
     *         <li>GameSessionFullException The game instance is currently full and cannot allow the requested player(s)
     *         to join. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreatePlayerSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSession" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePlayerSessionResponse> createPlayerSession(
            Consumer<CreatePlayerSessionRequest.Builder> createPlayerSessionRequest) {
        return createPlayerSession(CreatePlayerSessionRequest.builder().applyMutation(createPlayerSessionRequest).build());
    }

    /**
     * <p>
     * Reserves open slots in a game session for a group of players. New player sessions can be created in any game
     * session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of
     * <code>ACCEPT_ALL</code>. To add a single player to a game session, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html"
     * >CreatePlayerSession</a>
     * </p>
     * <p>
     * To create player sessions, specify a game session ID and a list of player IDs. Optionally, provide a set of
     * player data for each player ID.
     * </p>
     * <p>
     * If successful, a slot is reserved in the game session for each player, and new <code>PlayerSession</code> objects
     * are returned with player session IDs. Each player references their player session ID when sending a connection
     * request to the game session, and the game server can use it to validate the player reservation with the Amazon
     * GameLift service. Player sessions cannot be updated.
     * </p>
     * <p>
     * The maximum number of players per game session is 200. It is not adjustable.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createPlayerSessionsRequest
     * @return A Java Future containing the result of the CreatePlayerSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidGameSessionStatusException The requested operation would cause a conflict with the current
     *         state of a resource associated with the request and/or the game instance. Resolve the conflict before
     *         retrying.</li>
     *         <li>GameSessionFullException The game instance is currently full and cannot allow the requested player(s)
     *         to join. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreatePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePlayerSessionsResponse> createPlayerSessions(
            CreatePlayerSessionsRequest createPlayerSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Reserves open slots in a game session for a group of players. New player sessions can be created in any game
     * session with an open slot that is in <code>ACTIVE</code> status and has a player creation policy of
     * <code>ACCEPT_ALL</code>. To add a single player to a game session, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html"
     * >CreatePlayerSession</a>
     * </p>
     * <p>
     * To create player sessions, specify a game session ID and a list of player IDs. Optionally, provide a set of
     * player data for each player ID.
     * </p>
     * <p>
     * If successful, a slot is reserved in the game session for each player, and new <code>PlayerSession</code> objects
     * are returned with player session IDs. Each player references their player session ID when sending a connection
     * request to the game session, and the game server can use it to validate the player reservation with the Amazon
     * GameLift service. Player sessions cannot be updated.
     * </p>
     * <p>
     * The maximum number of players per game session is 200. It is not adjustable.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlayerSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePlayerSessionsRequest#builder()}
     * </p>
     *
     * @param createPlayerSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreatePlayerSessionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePlayerSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidGameSessionStatusException The requested operation would cause a conflict with the current
     *         state of a resource associated with the request and/or the game instance. Resolve the conflict before
     *         retrying.</li>
     *         <li>GameSessionFullException The game instance is currently full and cannot allow the requested player(s)
     *         to join. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreatePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreatePlayerSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePlayerSessionsResponse> createPlayerSessions(
            Consumer<CreatePlayerSessionsRequest.Builder> createPlayerSessionsRequest) {
        return createPlayerSessions(CreatePlayerSessionsRequest.builder().applyMutation(createPlayerSessionsRequest).build());
    }

    /**
     * <p>
     * Creates a new script record for your Realtime Servers script. Realtime scripts are JavaScript that provide
     * configuration settings and optional custom game logic for your game. The script is deployed when you create a
     * Realtime Servers fleet to host your game sessions. Script logic is executed during an active game session.
     * </p>
     * <p>
     * To create a new script record, specify a script name and provide the script file(s). The script files and all
     * dependencies must be zipped into a single file. You can pull the zip file from either of these locations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A locally available directory. Use the <i>ZipFile</i> parameter for this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Simple Storage Service (Amazon S3) bucket under your Amazon Web Services account. Use the
     * <i>StorageLocation</i> parameter for this option. You'll need to have an Identity Access Management (IAM) role
     * that allows the Amazon GameLift service to access your S3 bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the call is successful, a new script record is created with a unique script ID. If the script file is provided
     * as a local file, the file is uploaded to an Amazon GameLift-owned S3 bucket and the script record's storage
     * location reflects this location. If the script file is provided as an S3 bucket, Amazon GameLift accesses the
     * file at this storage location as needed for deployment.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set Up a Role for
     * Amazon GameLift Access</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createScriptRequest
     * @return A Java Future containing the result of the CreateScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateScriptResponse> createScript(CreateScriptRequest createScriptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new script record for your Realtime Servers script. Realtime scripts are JavaScript that provide
     * configuration settings and optional custom game logic for your game. The script is deployed when you create a
     * Realtime Servers fleet to host your game sessions. Script logic is executed during an active game session.
     * </p>
     * <p>
     * To create a new script record, specify a script name and provide the script file(s). The script files and all
     * dependencies must be zipped into a single file. You can pull the zip file from either of these locations:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A locally available directory. Use the <i>ZipFile</i> parameter for this option.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Simple Storage Service (Amazon S3) bucket under your Amazon Web Services account. Use the
     * <i>StorageLocation</i> parameter for this option. You'll need to have an Identity Access Management (IAM) role
     * that allows the Amazon GameLift service to access your S3 bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the call is successful, a new script record is created with a unique script ID. If the script file is provided
     * as a local file, the file is uploaded to an Amazon GameLift-owned S3 bucket and the script record's storage
     * location reflects this location. If the script file is provided as an S3 bucket, Amazon GameLift accesses the
     * file at this storage location as needed for deployment.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/setting-up-role.html">Set Up a Role for
     * Amazon GameLift Access</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScriptRequest.Builder} avoiding the need to
     * create one manually via {@link CreateScriptRequest#builder()}
     * </p>
     *
     * @param createScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateScriptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateScriptResponse> createScript(Consumer<CreateScriptRequest.Builder> createScriptRequest) {
        return createScript(CreateScriptRequest.builder().applyMutation(createScriptRequest).build());
    }

    /**
     * <p>
     * Requests authorization to create or delete a peer connection between the VPC for your Amazon GameLift fleet and a
     * virtual private cloud (VPC) in your Amazon Web Services account. VPC peering enables the game servers on your
     * fleet to communicate directly with other Amazon Web Services resources. After you've received authorization, use
     * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html">
     * CreateVpcPeeringConnection</a> to establish the peering connection. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Fleets</a>.
     * </p>
     * <p>
     * You can peer with VPCs that are owned by any Amazon Web Services account you have access to, including the
     * account that you use to manage your Amazon GameLift fleets. You cannot peer with VPCs that are in different
     * Regions.
     * </p>
     * <p>
     * To request authorization to create a connection, call this operation from the Amazon Web Services account with
     * the VPC that you want to peer to your Amazon GameLift fleet. For example, to enable your game servers to retrieve
     * data from a DynamoDB table, use the account that manages that DynamoDB resource. Identify the following values:
     * (1) The ID of the VPC that you want to peer with, and (2) the ID of the Amazon Web Services account that you use
     * to manage Amazon GameLift. If successful, VPC peering is authorized for the specified VPC.
     * </p>
     * <p>
     * To request authorization to delete a connection, call this operation from the Amazon Web Services account with
     * the VPC that is peered with your Amazon GameLift fleet. Identify the following values: (1) VPC ID that you want
     * to delete the peering connection for, and (2) ID of the Amazon Web Services account that you use to manage Amazon
     * GameLift.
     * </p>
     * <p>
     * The authorization remains valid for 24 hours unless it is canceled. You must create or delete the peering
     * connection while the authorization is valid.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createVpcPeeringAuthorizationRequest
     * @return A Java Future containing the result of the CreateVpcPeeringAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateVpcPeeringAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcPeeringAuthorizationResponse> createVpcPeeringAuthorization(
            CreateVpcPeeringAuthorizationRequest createVpcPeeringAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests authorization to create or delete a peer connection between the VPC for your Amazon GameLift fleet and a
     * virtual private cloud (VPC) in your Amazon Web Services account. VPC peering enables the game servers on your
     * fleet to communicate directly with other Amazon Web Services resources. After you've received authorization, use
     * <a href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html">
     * CreateVpcPeeringConnection</a> to establish the peering connection. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Fleets</a>.
     * </p>
     * <p>
     * You can peer with VPCs that are owned by any Amazon Web Services account you have access to, including the
     * account that you use to manage your Amazon GameLift fleets. You cannot peer with VPCs that are in different
     * Regions.
     * </p>
     * <p>
     * To request authorization to create a connection, call this operation from the Amazon Web Services account with
     * the VPC that you want to peer to your Amazon GameLift fleet. For example, to enable your game servers to retrieve
     * data from a DynamoDB table, use the account that manages that DynamoDB resource. Identify the following values:
     * (1) The ID of the VPC that you want to peer with, and (2) the ID of the Amazon Web Services account that you use
     * to manage Amazon GameLift. If successful, VPC peering is authorized for the specified VPC.
     * </p>
     * <p>
     * To request authorization to delete a connection, call this operation from the Amazon Web Services account with
     * the VPC that is peered with your Amazon GameLift fleet. Identify the following values: (1) VPC ID that you want
     * to delete the peering connection for, and (2) ID of the Amazon Web Services account that you use to manage Amazon
     * GameLift.
     * </p>
     * <p>
     * The authorization remains valid for 24 hours unless it is canceled. You must create or delete the peering
     * connection while the authorization is valid.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcPeeringAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateVpcPeeringAuthorizationRequest#builder()}
     * </p>
     *
     * @param createVpcPeeringAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringAuthorizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateVpcPeeringAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateVpcPeeringAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcPeeringAuthorizationResponse> createVpcPeeringAuthorization(
            Consumer<CreateVpcPeeringAuthorizationRequest.Builder> createVpcPeeringAuthorizationRequest) {
        return createVpcPeeringAuthorization(CreateVpcPeeringAuthorizationRequest.builder()
                .applyMutation(createVpcPeeringAuthorizationRequest).build());
    }

    /**
     * <p>
     * Establishes a VPC peering connection between a virtual private cloud (VPC) in an Amazon Web Services account with
     * the VPC for your Amazon GameLift fleet. VPC peering enables the game servers on your fleet to communicate
     * directly with other Amazon Web Services resources. You can peer with VPCs in any Amazon Web Services account that
     * you have access to, including the account that you use to manage your Amazon GameLift fleets. You cannot peer
     * with VPCs that are in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Fleets</a>.
     * </p>
     * <p>
     * Before calling this operation to establish the peering connection, you first need to use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html"
     * >CreateVpcPeeringAuthorization</a> and identify the VPC you want to peer with. Once the authorization for the
     * specified VPC is issued, you have 24 hours to establish the connection. These two operations handle all tasks
     * necessary to peer the two VPCs, including acceptance, updating routing tables, etc.
     * </p>
     * <p>
     * To establish the connection, call this operation from the Amazon Web Services account that is used to manage the
     * Amazon GameLift fleets. Identify the following values: (1) The ID of the fleet you want to be enable a VPC
     * peering connection for; (2) The Amazon Web Services account with the VPC that you want to peer with; and (3) The
     * ID of the VPC you want to peer with. This operation is asynchronous. If successful, a connection request is
     * created. You can use continuous polling to track the request's status using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html"
     * >DescribeVpcPeeringConnections</a> , or by monitoring fleet events for success or failure using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html"
     * >DescribeFleetEvents</a> .
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the CreateVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcPeeringConnectionResponse> createVpcPeeringConnection(
            CreateVpcPeeringConnectionRequest createVpcPeeringConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Establishes a VPC peering connection between a virtual private cloud (VPC) in an Amazon Web Services account with
     * the VPC for your Amazon GameLift fleet. VPC peering enables the game servers on your fleet to communicate
     * directly with other Amazon Web Services resources. You can peer with VPCs in any Amazon Web Services account that
     * you have access to, including the account that you use to manage your Amazon GameLift fleets. You cannot peer
     * with VPCs that are in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with Amazon
     * GameLift Fleets</a>.
     * </p>
     * <p>
     * Before calling this operation to establish the peering connection, you first need to use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html"
     * >CreateVpcPeeringAuthorization</a> and identify the VPC you want to peer with. Once the authorization for the
     * specified VPC is issued, you have 24 hours to establish the connection. These two operations handle all tasks
     * necessary to peer the two VPCs, including acceptance, updating routing tables, etc.
     * </p>
     * <p>
     * To establish the connection, call this operation from the Amazon Web Services account that is used to manage the
     * Amazon GameLift fleets. Identify the following values: (1) The ID of the fleet you want to be enable a VPC
     * peering connection for; (2) The Amazon Web Services account with the VPC that you want to peer with; and (3) The
     * ID of the VPC you want to peer with. This operation is asynchronous. If successful, a connection request is
     * created. You can use continuous polling to track the request's status using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html"
     * >DescribeVpcPeeringConnections</a> , or by monitoring fleet events for success or failure using <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html"
     * >DescribeFleetEvents</a> .
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateVpcPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param createVpcPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.CreateVpcPeeringConnectionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.CreateVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/CreateVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcPeeringConnectionResponse> createVpcPeeringConnection(
            Consumer<CreateVpcPeeringConnectionRequest.Builder> createVpcPeeringConnectionRequest) {
        return createVpcPeeringConnection(CreateVpcPeeringConnectionRequest.builder()
                .applyMutation(createVpcPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * Deletes an alias. This operation removes all record of the alias. Game clients attempting to access a server
     * process using the deleted alias receive an error. To delete an alias, specify the alias ID to be deleted.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteAliasRequest
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAliasResponse> deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an alias. This operation removes all record of the alias. Game clients attempting to access a server
     * process using the deleted alias receive an error. To delete an alias, specify the alias ID to be deleted.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAliasRequest#builder()}
     * </p>
     *
     * @param deleteAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAliasResponse> deleteAlias(Consumer<DeleteAliasRequest.Builder> deleteAliasRequest) {
        return deleteAlias(DeleteAliasRequest.builder().applyMutation(deleteAliasRequest).build());
    }

    /**
     * <p>
     * Deletes a build. This operation permanently deletes the build resource and any uploaded build files. Deleting a
     * build does not affect the status of any active fleets using the build, but you can no longer create new fleets
     * with the deleted build.
     * </p>
     * <p>
     * To delete a build, specify the build ID.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteBuildRequest
     * @return A Java Future containing the result of the DeleteBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBuildResponse> deleteBuild(DeleteBuildRequest deleteBuildRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a build. This operation permanently deletes the build resource and any uploaded build files. Deleting a
     * build does not affect the status of any active fleets using the build, but you can no longer create new fleets
     * with the deleted build.
     * </p>
     * <p>
     * To delete a build, specify the build ID.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBuildRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteBuildRequest#builder()}
     * </p>
     *
     * @param deleteBuildRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteBuildRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteBuildResponse> deleteBuild(Consumer<DeleteBuildRequest.Builder> deleteBuildRequest) {
        return deleteBuild(DeleteBuildRequest.builder().applyMutation(deleteBuildRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift containers feature, which is currently in public preview. </b>
     * </p>
     * <p>
     * Deletes a container group definition resource. You can delete a container group definition if there are no fleets
     * using the definition.
     * </p>
     * <p>
     * To delete a container group definition, identify the resource to delete.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Manage a
     * container group definition</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteContainerGroupDefinitionRequest
     * @return A Java Future containing the result of the DeleteContainerGroupDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteContainerGroupDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteContainerGroupDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContainerGroupDefinitionResponse> deleteContainerGroupDefinition(
            DeleteContainerGroupDefinitionRequest deleteContainerGroupDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift containers feature, which is currently in public preview. </b>
     * </p>
     * <p>
     * Deletes a container group definition resource. You can delete a container group definition if there are no fleets
     * using the definition.
     * </p>
     * <p>
     * To delete a container group definition, identify the resource to delete.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Manage a
     * container group definition</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteContainerGroupDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteContainerGroupDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteContainerGroupDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteContainerGroupDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteContainerGroupDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteContainerGroupDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteContainerGroupDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteContainerGroupDefinitionResponse> deleteContainerGroupDefinition(
            Consumer<DeleteContainerGroupDefinitionRequest.Builder> deleteContainerGroupDefinitionRequest) {
        return deleteContainerGroupDefinition(DeleteContainerGroupDefinitionRequest.builder()
                .applyMutation(deleteContainerGroupDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes all resources and information related to a fleet and shuts down any currently running fleet instances,
     * including those in remote locations.
     * </p>
     * <note>
     * <p>
     * If the fleet being deleted has a VPC peering connection, you first need to get a valid authorization (good for 24
     * hours) by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html"
     * >CreateVpcPeeringAuthorization</a>. You don't need to explicitly delete the VPC peering connection.
     * </p>
     * </note>
     * <p>
     * To delete a fleet, specify the fleet ID to be terminated. During the deletion process, the fleet status is
     * changed to <code>DELETING</code>. When completed, the status switches to <code>TERMINATED</code> and the fleet
     * event <code>FLEET_DELETED</code> is emitted.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidFleetStatusException The requested operation would cause a conflict with the current state of
     *         a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all resources and information related to a fleet and shuts down any currently running fleet instances,
     * including those in remote locations.
     * </p>
     * <note>
     * <p>
     * If the fleet being deleted has a VPC peering connection, you first need to get a valid authorization (good for 24
     * hours) by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html"
     * >CreateVpcPeeringAuthorization</a>. You don't need to explicitly delete the VPC peering connection.
     * </p>
     * </note>
     * <p>
     * To delete a fleet, specify the fleet ID to be terminated. During the deletion process, the fleet status is
     * changed to <code>DELETING</code>. When completed, the status switches to <code>TERMINATED</code> and the fleet
     * event <code>FLEET_DELETED</code> is emitted.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidFleetStatusException The requested operation would cause a conflict with the current state of
     *         a resource associated with the request and/or the fleet. Resolve the conflict before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteFleetResponse> deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest) {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Removes locations from a multi-location fleet. When deleting a location, all game server process and all
     * instances that are still active in the location are shut down.
     * </p>
     * <p>
     * To delete fleet locations, identify the fleet ID and provide a list of the locations to be deleted.
     * </p>
     * <p>
     * If successful, GameLift sets the location status to <code>DELETING</code>, and begins to shut down existing
     * server processes and terminate instances in each location being deleted. When completed, the location status
     * changes to <code>TERMINATED</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param deleteFleetLocationsRequest
     * @return A Java Future containing the result of the DeleteFleetLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteFleetLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleetLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFleetLocationsResponse> deleteFleetLocations(
            DeleteFleetLocationsRequest deleteFleetLocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes locations from a multi-location fleet. When deleting a location, all game server process and all
     * instances that are still active in the location are shut down.
     * </p>
     * <p>
     * To delete fleet locations, identify the fleet ID and provide a list of the locations to be deleted.
     * </p>
     * <p>
     * If successful, GameLift sets the location status to <code>DELETING</code>, and begins to shut down existing
     * server processes and terminate instances in each location being deleted. When completed, the location status
     * changes to <code>TERMINATED</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetLocationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFleetLocationsRequest#builder()}
     * </p>
     *
     * @param deleteFleetLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteFleetLocationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteFleetLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteFleetLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteFleetLocations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteFleetLocationsResponse> deleteFleetLocations(
            Consumer<DeleteFleetLocationsRequest.Builder> deleteFleetLocationsRequest) {
        return deleteFleetLocations(DeleteFleetLocationsRequest.builder().applyMutation(deleteFleetLocationsRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Terminates a game server group and permanently deletes the game server group record. You have several options for
     * how these resources are impacted when deleting the game server group. Depending on the type of delete operation
     * selected, this operation might affect these resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The game server group
     * </p>
     * </li>
     * <li>
     * <p>
     * The corresponding Auto Scaling group
     * </p>
     * </li>
     * <li>
     * <p>
     * All game servers that are currently running in the group
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a game server group, identify the game server group to delete and specify the type of delete operation
     * to initiate. Game server groups can only be deleted if they are in <code>ACTIVE</code> or <code>ERROR</code>
     * status.
     * </p>
     * <p>
     * If the delete request is successful, a series of operations are kicked off. The game server group status is
     * changed to <code>DELETE_SCHEDULED</code>, which prevents new game servers from being registered and stops
     * automatic scaling activity. Once all game servers in the game server group are deregistered, Amazon GameLift
     * FleetIQ can begin deleting resources. If any of the delete operations fail, the game server group is placed in
     * <code>ERROR</code> status.
     * </p>
     * <p>
     * Amazon GameLift FleetIQ emits delete events to Amazon CloudWatch.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param deleteGameServerGroupRequest
     * @return A Java Future containing the result of the DeleteGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGameServerGroupResponse> deleteGameServerGroup(
            DeleteGameServerGroupRequest deleteGameServerGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Terminates a game server group and permanently deletes the game server group record. You have several options for
     * how these resources are impacted when deleting the game server group. Depending on the type of delete operation
     * selected, this operation might affect these resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The game server group
     * </p>
     * </li>
     * <li>
     * <p>
     * The corresponding Auto Scaling group
     * </p>
     * </li>
     * <li>
     * <p>
     * All game servers that are currently running in the group
     * </p>
     * </li>
     * </ul>
     * <p>
     * To delete a game server group, identify the game server group to delete and specify the type of delete operation
     * to initiate. Game server groups can only be deleted if they are in <code>ACTIVE</code> or <code>ERROR</code>
     * status.
     * </p>
     * <p>
     * If the delete request is successful, a series of operations are kicked off. The game server group status is
     * changed to <code>DELETE_SCHEDULED</code>, which prevents new game servers from being registered and stops
     * automatic scaling activity. Once all game servers in the game server group are deregistered, Amazon GameLift
     * FleetIQ can begin deleting resources. If any of the delete operations fail, the game server group is placed in
     * <code>ERROR</code> status.
     * </p>
     * <p>
     * Amazon GameLift FleetIQ emits delete events to Amazon CloudWatch.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGameServerGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGameServerGroupRequest#builder()}
     * </p>
     *
     * @param deleteGameServerGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteGameServerGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGameServerGroupResponse> deleteGameServerGroup(
            Consumer<DeleteGameServerGroupRequest.Builder> deleteGameServerGroupRequest) {
        return deleteGameServerGroup(DeleteGameServerGroupRequest.builder().applyMutation(deleteGameServerGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a game session queue. Once a queue is successfully deleted, unfulfilled <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> requests that reference the queue will fail. To delete a queue, specify the queue
     * name.
     * </p>
     *
     * @param deleteGameSessionQueueRequest
     * @return A Java Future containing the result of the DeleteGameSessionQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteGameSessionQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGameSessionQueueResponse> deleteGameSessionQueue(
            DeleteGameSessionQueueRequest deleteGameSessionQueueRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a game session queue. Once a queue is successfully deleted, unfulfilled <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html"
     * >StartGameSessionPlacement</a> requests that reference the queue will fail. To delete a queue, specify the queue
     * name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGameSessionQueueRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGameSessionQueueRequest#builder()}
     * </p>
     *
     * @param deleteGameSessionQueueRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteGameSessionQueueRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGameSessionQueue operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteGameSessionQueue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteGameSessionQueue"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGameSessionQueueResponse> deleteGameSessionQueue(
            Consumer<DeleteGameSessionQueueRequest.Builder> deleteGameSessionQueueRequest) {
        return deleteGameSessionQueue(DeleteGameSessionQueueRequest.builder().applyMutation(deleteGameSessionQueueRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a custom location.
     * </p>
     * <p>
     * Before deleting a custom location, review any fleets currently using the custom location and deregister the
     * location if it is in use. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeregisterCompute.html">DeregisterCompute</a>.
     * </p>
     *
     * @param deleteLocationRequest
     * @return A Java Future containing the result of the DeleteLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLocationResponse> deleteLocation(DeleteLocationRequest deleteLocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom location.
     * </p>
     * <p>
     * Before deleting a custom location, review any fleets currently using the custom location and deregister the
     * location if it is in use. For more information, see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeregisterCompute.html">DeregisterCompute</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLocationRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLocationRequest#builder()}
     * </p>
     *
     * @param deleteLocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteLocationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteLocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteLocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteLocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLocationResponse> deleteLocation(Consumer<DeleteLocationRequest.Builder> deleteLocationRequest) {
        return deleteLocation(DeleteLocationRequest.builder().applyMutation(deleteLocationRequest).build());
    }

    /**
     * <p>
     * Permanently removes a FlexMatch matchmaking configuration. To delete, specify the configuration name. A
     * matchmaking configuration cannot be deleted if it is being used in any active matchmaking tickets.
     * </p>
     *
     * @param deleteMatchmakingConfigurationRequest
     * @return A Java Future containing the result of the DeleteMatchmakingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteMatchmakingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMatchmakingConfigurationResponse> deleteMatchmakingConfiguration(
            DeleteMatchmakingConfigurationRequest deleteMatchmakingConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Permanently removes a FlexMatch matchmaking configuration. To delete, specify the configuration name. A
     * matchmaking configuration cannot be deleted if it is being used in any active matchmaking tickets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMatchmakingConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteMatchmakingConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteMatchmakingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteMatchmakingConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteMatchmakingConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMatchmakingConfigurationResponse> deleteMatchmakingConfiguration(
            Consumer<DeleteMatchmakingConfigurationRequest.Builder> deleteMatchmakingConfigurationRequest) {
        return deleteMatchmakingConfiguration(DeleteMatchmakingConfigurationRequest.builder()
                .applyMutation(deleteMatchmakingConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes an existing matchmaking rule set. To delete the rule set, provide the rule set name. Rule sets cannot be
     * deleted if they are currently being used by a matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteMatchmakingRuleSetRequest
     * @return A Java Future containing the result of the DeleteMatchmakingRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteMatchmakingRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMatchmakingRuleSetResponse> deleteMatchmakingRuleSet(
            DeleteMatchmakingRuleSetRequest deleteMatchmakingRuleSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing matchmaking rule set. To delete the rule set, provide the rule set name. Rule sets cannot be
     * deleted if they are currently being used by a matchmaking configuration.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMatchmakingRuleSetRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMatchmakingRuleSetRequest#builder()}
     * </p>
     *
     * @param deleteMatchmakingRuleSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteMatchmakingRuleSetRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMatchmakingRuleSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteMatchmakingRuleSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteMatchmakingRuleSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMatchmakingRuleSetResponse> deleteMatchmakingRuleSet(
            Consumer<DeleteMatchmakingRuleSetRequest.Builder> deleteMatchmakingRuleSetRequest) {
        return deleteMatchmakingRuleSet(DeleteMatchmakingRuleSetRequest.builder().applyMutation(deleteMatchmakingRuleSetRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a fleet scaling policy. Once deleted, the policy is no longer in force and Amazon GameLift removes all
     * record of it. To delete a scaling policy, specify both the scaling policy name and the fleet ID it is associated
     * with.
     * </p>
     * <p>
     * To temporarily suspend scaling policies, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html">StopFleetActions</a>.
     * This operation suspends all policies for the fleet.
     * </p>
     *
     * @param deleteScalingPolicyRequest
     * @return A Java Future containing the result of the DeleteScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteScalingPolicyResponse> deleteScalingPolicy(
            DeleteScalingPolicyRequest deleteScalingPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet scaling policy. Once deleted, the policy is no longer in force and Amazon GameLift removes all
     * record of it. To delete a scaling policy, specify both the scaling policy name and the fleet ID it is associated
     * with.
     * </p>
     * <p>
     * To temporarily suspend scaling policies, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html">StopFleetActions</a>.
     * This operation suspends all policies for the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScalingPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScalingPolicyRequest#builder()}
     * </p>
     *
     * @param deleteScalingPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteScalingPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScalingPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteScalingPolicyResponse> deleteScalingPolicy(
            Consumer<DeleteScalingPolicyRequest.Builder> deleteScalingPolicyRequest) {
        return deleteScalingPolicy(DeleteScalingPolicyRequest.builder().applyMutation(deleteScalingPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a Realtime script. This operation permanently deletes the script record. If script files were uploaded,
     * they are also deleted (files stored in an S3 bucket are not deleted).
     * </p>
     * <p>
     * To delete a script, specify the script ID. Before deleting a script, be sure to terminate all fleets that are
     * deployed with the script being deleted. Fleet instances periodically check for script updates, and if the script
     * record no longer exists, the instance will go into an error state and be unable to host game sessions.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteScriptRequest
     * @return A Java Future containing the result of the DeleteScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteScriptResponse> deleteScript(DeleteScriptRequest deleteScriptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Realtime script. This operation permanently deletes the script record. If script files were uploaded,
     * they are also deleted (files stored in an S3 bucket are not deleted).
     * </p>
     * <p>
     * To delete a script, specify the script ID. Before deleting a script, be sure to terminate all fleets that are
     * deployed with the script being deleted. Fleet instances periodically check for script updates, and if the script
     * record no longer exists, the instance will go into an error state and be unable to host game sessions.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScriptRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteScriptRequest#builder()}
     * </p>
     *
     * @param deleteScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteScriptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteScriptResponse> deleteScript(Consumer<DeleteScriptRequest.Builder> deleteScriptRequest) {
        return deleteScript(DeleteScriptRequest.builder().applyMutation(deleteScriptRequest).build());
    }

    /**
     * <p>
     * Cancels a pending VPC peering authorization for the specified VPC. If you need to delete an existing VPC peering
     * connection, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html"
     * >DeleteVpcPeeringConnection</a>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteVpcPeeringAuthorizationRequest
     * @return A Java Future containing the result of the DeleteVpcPeeringAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteVpcPeeringAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcPeeringAuthorizationResponse> deleteVpcPeeringAuthorization(
            DeleteVpcPeeringAuthorizationRequest deleteVpcPeeringAuthorizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a pending VPC peering authorization for the specified VPC. If you need to delete an existing VPC peering
     * connection, use <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html"
     * >DeleteVpcPeeringConnection</a>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcPeeringAuthorizationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteVpcPeeringAuthorizationRequest#builder()}
     * </p>
     *
     * @param deleteVpcPeeringAuthorizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringAuthorizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteVpcPeeringAuthorization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteVpcPeeringAuthorization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringAuthorization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcPeeringAuthorizationResponse> deleteVpcPeeringAuthorization(
            Consumer<DeleteVpcPeeringAuthorizationRequest.Builder> deleteVpcPeeringAuthorizationRequest) {
        return deleteVpcPeeringAuthorization(DeleteVpcPeeringAuthorizationRequest.builder()
                .applyMutation(deleteVpcPeeringAuthorizationRequest).build());
    }

    /**
     * <p>
     * Removes a VPC peering connection. To delete the connection, you must have a valid authorization for the VPC
     * peering connection that you want to delete..
     * </p>
     * <p>
     * Once a valid authorization exists, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift fleets. Identify the connection to delete by the connection ID and fleet ID. If
     * successful, the connection is removed.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     * @return A Java Future containing the result of the DeleteVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcPeeringConnectionResponse> deleteVpcPeeringConnection(
            DeleteVpcPeeringConnectionRequest deleteVpcPeeringConnectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a VPC peering connection. To delete the connection, you must have a valid authorization for the VPC
     * peering connection that you want to delete..
     * </p>
     * <p>
     * Once a valid authorization exists, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift fleets. Identify the connection to delete by the connection ID and fleet ID. If
     * successful, the connection is removed.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcPeeringConnectionRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteVpcPeeringConnectionRequest#builder()}
     * </p>
     *
     * @param deleteVpcPeeringConnectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeleteVpcPeeringConnectionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteVpcPeeringConnection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeleteVpcPeeringConnection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeleteVpcPeeringConnection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcPeeringConnectionResponse> deleteVpcPeeringConnection(
            Consumer<DeleteVpcPeeringConnectionRequest.Builder> deleteVpcPeeringConnectionRequest) {
        return deleteVpcPeeringConnection(DeleteVpcPeeringConnectionRequest.builder()
                .applyMutation(deleteVpcPeeringConnectionRequest).build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Removes a compute resource from an Amazon GameLift Anywhere fleet or container fleet. Deregistered computes can
     * no longer host game sessions through Amazon GameLift.
     * </p>
     * <p>
     * For an Anywhere fleet or a container fleet that's running the Amazon GameLift Agent, the Agent handles all
     * compute registry tasks for you. For an Anywhere fleet that doesn't use the Agent, call this operation to
     * deregister fleet computes.
     * </p>
     * <p>
     * To deregister a compute, call this operation from the compute that's being deregistered and specify the compute
     * name and the fleet ID.
     * </p>
     *
     * @param deregisterComputeRequest
     * @return A Java Future containing the result of the DeregisterCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeregisterCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterCompute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterComputeResponse> deregisterCompute(DeregisterComputeRequest deregisterComputeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Removes a compute resource from an Amazon GameLift Anywhere fleet or container fleet. Deregistered computes can
     * no longer host game sessions through Amazon GameLift.
     * </p>
     * <p>
     * For an Anywhere fleet or a container fleet that's running the Amazon GameLift Agent, the Agent handles all
     * compute registry tasks for you. For an Anywhere fleet that doesn't use the Agent, call this operation to
     * deregister fleet computes.
     * </p>
     * <p>
     * To deregister a compute, call this operation from the compute that's being deregistered and specify the compute
     * name and the fleet ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterComputeRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterComputeRequest#builder()}
     * </p>
     *
     * @param deregisterComputeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeregisterComputeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeregisterCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterCompute" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterComputeResponse> deregisterCompute(
            Consumer<DeregisterComputeRequest.Builder> deregisterComputeRequest) {
        return deregisterCompute(DeregisterComputeRequest.builder().applyMutation(deregisterComputeRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Removes the game server from a game server group. As a result of this operation, the deregistered game server can
     * no longer be claimed and will not be returned in a list of active game servers.
     * </p>
     * <p>
     * To deregister a game server, specify the game server group and game server ID. If successful, this operation
     * emits a CloudWatch event with termination timestamp and reason.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param deregisterGameServerRequest
     * @return A Java Future containing the result of the DeregisterGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeregisterGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterGameServerResponse> deregisterGameServer(
            DeregisterGameServerRequest deregisterGameServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Removes the game server from a game server group. As a result of this operation, the deregistered game server can
     * no longer be claimed and will not be returned in a list of active game servers.
     * </p>
     * <p>
     * To deregister a game server, specify the game server group and game server ID. If successful, this operation
     * emits a CloudWatch event with termination timestamp and reason.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterGameServerRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterGameServerRequest#builder()}
     * </p>
     *
     * @param deregisterGameServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DeregisterGameServerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DeregisterGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DeregisterGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterGameServerResponse> deregisterGameServer(
            Consumer<DeregisterGameServerRequest.Builder> deregisterGameServerRequest) {
        return deregisterGameServer(DeregisterGameServerRequest.builder().applyMutation(deregisterGameServerRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for an alias. This operation returns all alias metadata and settings. To get an alias's
     * target fleet ID only, use <code>ResolveAlias</code>.
     * </p>
     * <p>
     * To get alias properties, specify the alias ID. If successful, the requested alias record is returned.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeAliasRequest
     * @return A Java Future containing the result of the DescribeAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAliasResponse> describeAlias(DescribeAliasRequest describeAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for an alias. This operation returns all alias metadata and settings. To get an alias's
     * target fleet ID only, use <code>ResolveAlias</code>.
     * </p>
     * <p>
     * To get alias properties, specify the alias ID. If successful, the requested alias record is returned.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAliasRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAliasRequest#builder()}
     * </p>
     *
     * @param describeAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAliasResponse> describeAlias(Consumer<DescribeAliasRequest.Builder> describeAliasRequest) {
        return describeAlias(DescribeAliasRequest.builder().applyMutation(describeAliasRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for a custom game build. To request a build resource, specify a build ID. If successful, an
     * object containing the build properties is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeBuildRequest
     * @return A Java Future containing the result of the DescribeBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBuildResponse> describeBuild(DescribeBuildRequest describeBuildRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for a custom game build. To request a build resource, specify a build ID. If successful, an
     * object containing the build properties is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBuildRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeBuildRequest#builder()}
     * </p>
     *
     * @param describeBuildRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeBuildRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeBuild operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeBuild
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeBuild" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeBuildResponse> describeBuild(Consumer<DescribeBuildRequest.Builder> describeBuildRequest) {
        return describeBuild(DescribeBuildRequest.builder().applyMutation(describeBuildRequest).build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves properties for a compute resource in an Amazon GameLift fleet. To get a list of all computes in a
     * fleet, call <a>ListCompute</a>.
     * </p>
     * <p>
     * To request information on a specific compute, provide the fleet ID and compute name.
     * </p>
     * <p>
     * If successful, this operation returns details for the requested compute resource. Depending on the fleet's
     * compute type, the result includes the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>EC2</code> fleets, this operation returns information about the EC2 instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>ANYWHERE</code> fleets, this operation returns information about the registered compute.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>CONTAINER</code> fleets, this operation returns information about the container that's registered as a
     * compute, and the instance it's running on. The compute name is the container name.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeComputeRequest
     * @return A Java Future containing the result of the DescribeCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeComputeResponse> describeCompute(DescribeComputeRequest describeComputeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves properties for a compute resource in an Amazon GameLift fleet. To get a list of all computes in a
     * fleet, call <a>ListCompute</a>.
     * </p>
     * <p>
     * To request information on a specific compute, provide the fleet ID and compute name.
     * </p>
     * <p>
     * If successful, this operation returns details for the requested compute resource. Depending on the fleet's
     * compute type, the result includes the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>EC2</code> fleets, this operation returns information about the EC2 instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>ANYWHERE</code> fleets, this operation returns information about the registered compute.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>CONTAINER</code> fleets, this operation returns information about the container that's registered as a
     * compute, and the instance it's running on. The compute name is the container name.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeComputeRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeComputeRequest#builder()}
     * </p>
     *
     * @param describeComputeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeComputeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeComputeResponse> describeCompute(
            Consumer<DescribeComputeRequest.Builder> describeComputeRequest) {
        return describeCompute(DescribeComputeRequest.builder().applyMutation(describeComputeRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift containers feature, which is currently in public preview. </b>
     * </p>
     * <p>
     * Retrieves the properties of a container group definition, including all container definitions in the group.
     * </p>
     * <p>
     * To retrieve a container group definition, provide a resource identifier. If successful, this operation returns
     * the complete properties of the container group definition.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Manage a
     * container group definition</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeContainerGroupDefinitionRequest
     * @return A Java Future containing the result of the DescribeContainerGroupDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeContainerGroupDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeContainerGroupDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContainerGroupDefinitionResponse> describeContainerGroupDefinition(
            DescribeContainerGroupDefinitionRequest describeContainerGroupDefinitionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift containers feature, which is currently in public preview. </b>
     * </p>
     * <p>
     * Retrieves the properties of a container group definition, including all container definitions in the group.
     * </p>
     * <p>
     * To retrieve a container group definition, provide a resource identifier. If successful, this operation returns
     * the complete properties of the container group definition.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Manage a
     * container group definition</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeContainerGroupDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeContainerGroupDefinitionRequest#builder()}
     * </p>
     *
     * @param describeContainerGroupDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeContainerGroupDefinitionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeContainerGroupDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeContainerGroupDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeContainerGroupDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeContainerGroupDefinitionResponse> describeContainerGroupDefinition(
            Consumer<DescribeContainerGroupDefinitionRequest.Builder> describeContainerGroupDefinitionRequest) {
        return describeContainerGroupDefinition(DescribeContainerGroupDefinitionRequest.builder()
                .applyMutation(describeContainerGroupDefinitionRequest).build());
    }

    /**
     * <p>
     * Retrieves the instance limits and current utilization for an Amazon Web Services Region or location. Instance
     * limits control the number of instances, per instance type, per location, that your Amazon Web Services account
     * can use. Learn more at <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>. The
     * information returned includes the maximum number of instances allowed and your account's current usage across all
     * fleets. This information can affect your ability to scale your Amazon GameLift fleets. You can request a limit
     * increase for your account by using the <b>Service limits</b> page in the Amazon GameLift console.
     * </p>
     * <p>
     * Instance limits differ based on whether the instances are deployed in a fleet's home Region or in a remote
     * location. For remote locations, limits also differ based on the combination of home Region and remote location.
     * All requests must specify an Amazon Web Services Region (either explicitly or as your default settings). To get
     * the limit for a remote location, you must also specify the location. For example, the following requests all
     * return different results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Request specifies the Region <code>ap-northeast-1</code> with no location. The result is limits and usage data on
     * all instance types that are deployed in <code>us-east-2</code>, by all of the fleets that reside in
     * <code>ap-northeast-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>us-east-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>us-east-2</code>. These limits do not affect fleets in any other Regions that deploy instances to
     * <code>ca-central-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>eu-west-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>eu-west-1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed in an Amazon Web Services Region by fleets
     * that reside in the same Region: Specify the Region only. Optionally, specify a single instance type to retrieve
     * information for.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed to a remote location by fleets that reside
     * in different Amazon Web Services Region: Provide both the Amazon Web Services Region and the remote location.
     * Optionally, specify a single instance type to retrieve information for.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, an <code>EC2InstanceLimits</code> object is returned with limits and usage data for each requested
     * instance type.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param describeEc2InstanceLimitsRequest
     * @return A Java Future containing the result of the DescribeEC2InstanceLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeEC2InstanceLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEc2InstanceLimitsResponse> describeEC2InstanceLimits(
            DescribeEc2InstanceLimitsRequest describeEc2InstanceLimitsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the instance limits and current utilization for an Amazon Web Services Region or location. Instance
     * limits control the number of instances, per instance type, per location, that your Amazon Web Services account
     * can use. Learn more at <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>. The
     * information returned includes the maximum number of instances allowed and your account's current usage across all
     * fleets. This information can affect your ability to scale your Amazon GameLift fleets. You can request a limit
     * increase for your account by using the <b>Service limits</b> page in the Amazon GameLift console.
     * </p>
     * <p>
     * Instance limits differ based on whether the instances are deployed in a fleet's home Region or in a remote
     * location. For remote locations, limits also differ based on the combination of home Region and remote location.
     * All requests must specify an Amazon Web Services Region (either explicitly or as your default settings). To get
     * the limit for a remote location, you must also specify the location. For example, the following requests all
     * return different results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Request specifies the Region <code>ap-northeast-1</code> with no location. The result is limits and usage data on
     * all instance types that are deployed in <code>us-east-2</code>, by all of the fleets that reside in
     * <code>ap-northeast-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>us-east-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>us-east-2</code>. These limits do not affect fleets in any other Regions that deploy instances to
     * <code>ca-central-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>eu-west-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>eu-west-1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed in an Amazon Web Services Region by fleets
     * that reside in the same Region: Specify the Region only. Optionally, specify a single instance type to retrieve
     * information for.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed to a remote location by fleets that reside
     * in different Amazon Web Services Region: Provide both the Amazon Web Services Region and the remote location.
     * Optionally, specify a single instance type to retrieve information for.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, an <code>EC2InstanceLimits</code> object is returned with limits and usage data for each requested
     * instance type.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEc2InstanceLimitsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeEc2InstanceLimitsRequest#builder()}
     * </p>
     *
     * @param describeEc2InstanceLimitsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeEc2InstanceLimitsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeEC2InstanceLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeEC2InstanceLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEc2InstanceLimitsResponse> describeEC2InstanceLimits(
            Consumer<DescribeEc2InstanceLimitsRequest.Builder> describeEc2InstanceLimitsRequest) {
        return describeEC2InstanceLimits(DescribeEc2InstanceLimitsRequest.builder()
                .applyMutation(describeEc2InstanceLimitsRequest).build());
    }

    /**
     * <p>
     * Retrieves the instance limits and current utilization for an Amazon Web Services Region or location. Instance
     * limits control the number of instances, per instance type, per location, that your Amazon Web Services account
     * can use. Learn more at <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>. The
     * information returned includes the maximum number of instances allowed and your account's current usage across all
     * fleets. This information can affect your ability to scale your Amazon GameLift fleets. You can request a limit
     * increase for your account by using the <b>Service limits</b> page in the Amazon GameLift console.
     * </p>
     * <p>
     * Instance limits differ based on whether the instances are deployed in a fleet's home Region or in a remote
     * location. For remote locations, limits also differ based on the combination of home Region and remote location.
     * All requests must specify an Amazon Web Services Region (either explicitly or as your default settings). To get
     * the limit for a remote location, you must also specify the location. For example, the following requests all
     * return different results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Request specifies the Region <code>ap-northeast-1</code> with no location. The result is limits and usage data on
     * all instance types that are deployed in <code>us-east-2</code>, by all of the fleets that reside in
     * <code>ap-northeast-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>us-east-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>us-east-2</code>. These limits do not affect fleets in any other Regions that deploy instances to
     * <code>ca-central-1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Request specifies the Region <code>eu-west-1</code> with location <code>ca-central-1</code>. The result is limits
     * and usage data on all instance types that are deployed in <code>ca-central-1</code>, by all of the fleets that
     * reside in <code>eu-west-1</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed in an Amazon Web Services Region by fleets
     * that reside in the same Region: Specify the Region only. Optionally, specify a single instance type to retrieve
     * information for.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get limit and usage data for all instance types that are deployed to a remote location by fleets that reside
     * in different Amazon Web Services Region: Provide both the Amazon Web Services Region and the remote location.
     * Optionally, specify a single instance type to retrieve information for.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, an <code>EC2InstanceLimits</code> object is returned with limits and usage data for each requested
     * instance type.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @return A Java Future containing the result of the DescribeEC2InstanceLimits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeEC2InstanceLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeEC2InstanceLimits"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEc2InstanceLimitsResponse> describeEC2InstanceLimits() {
        return describeEC2InstanceLimits(DescribeEc2InstanceLimitsRequest.builder().build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves core fleet-wide properties for fleets in an Amazon Web Services Region. Properties include the
     * computing hardware and deployment configuration for instances in the fleet.
     * </p>
     * <p>
     * You can use this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get attributes for specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get attributes for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet
     * identifier is not found.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param describeFleetAttributesRequest
     * @return A Java Future containing the result of the DescribeFleetAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAttributesResponse> describeFleetAttributes(
            DescribeFleetAttributesRequest describeFleetAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves core fleet-wide properties for fleets in an Amazon Web Services Region. Properties include the
     * computing hardware and deployment configuration for instances in the fleet.
     * </p>
     * <p>
     * You can use this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get attributes for specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get attributes for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet
     * identifier is not found.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFleetAttributesRequest#builder()}
     * </p>
     *
     * @param describeFleetAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFleetAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAttributesResponse> describeFleetAttributes(
            Consumer<DescribeFleetAttributesRequest.Builder> describeFleetAttributesRequest) {
        return describeFleetAttributes(DescribeFleetAttributesRequest.builder().applyMutation(describeFleetAttributesRequest)
                .build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves core fleet-wide properties for fleets in an Amazon Web Services Region. Properties include the
     * computing hardware and deployment configuration for instances in the fleet.
     * </p>
     * <p>
     * You can use this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get attributes for specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get attributes for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple fleets, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetAttributes</code> object is returned for each fleet requested, unless the fleet
     * identifier is not found.
     * </p>
     * <note>
     * <p>
     * Some API operations limit the number of fleet IDs that allowed in one request. If a request exceeds this limit,
     * the request fails and the error message contains the maximum allowed number.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @return A Java Future containing the result of the DescribeFleetAttributes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetAttributesResponse> describeFleetAttributes() {
        return describeFleetAttributes(DescribeFleetAttributesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesPublisher publisher = client.describeFleetAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesPublisher publisher = client.describeFleetAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAttributesPublisher describeFleetAttributesPaginator() {
        return describeFleetAttributesPaginator(DescribeFleetAttributesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesPublisher publisher = client.describeFleetAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesPublisher publisher = client.describeFleetAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetAttributesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAttributesPublisher describeFleetAttributesPaginator(
            DescribeFleetAttributesRequest describeFleetAttributesRequest) {
        return new DescribeFleetAttributesPublisher(this, describeFleetAttributesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesPublisher publisher = client.describeFleetAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetAttributesPublisher publisher = client.describeFleetAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetAttributesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFleetAttributesRequest#builder()}
     * </p>
     *
     * @param describeFleetAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetAttributesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetAttributesPublisher describeFleetAttributesPaginator(
            Consumer<DescribeFleetAttributesRequest.Builder> describeFleetAttributesRequest) {
        return describeFleetAttributesPaginator(DescribeFleetAttributesRequest.builder()
                .applyMutation(describeFleetAttributesRequest).build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves the resource capacity settings for one or more fleets. For a container fleet, this operation also
     * returns counts for replica container groups.
     * </p>
     * <p>
     * With multi-location fleets, this operation retrieves data for the fleet's home Region only. To retrieve capacity
     * for remote locations, see <a>DescribeFleetLocationCapacity</a>.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get capacity data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for each requested fleet ID. Each
     * <code>FleetCapacity</code> object includes a <code>Location</code> property, which is set to the fleet's home
     * Region. Capacity values are returned only for fleets that currently exist.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this
     * limit, the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @param describeFleetCapacityRequest
     * @return A Java Future containing the result of the DescribeFleetCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetCapacityResponse> describeFleetCapacity(
            DescribeFleetCapacityRequest describeFleetCapacityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves the resource capacity settings for one or more fleets. For a container fleet, this operation also
     * returns counts for replica container groups.
     * </p>
     * <p>
     * With multi-location fleets, this operation retrieves data for the fleet's home Region only. To retrieve capacity
     * for remote locations, see <a>DescribeFleetLocationCapacity</a>.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get capacity data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for each requested fleet ID. Each
     * <code>FleetCapacity</code> object includes a <code>Location</code> property, which is set to the fleet's home
     * Region. Capacity values are returned only for fleets that currently exist.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this
     * limit, the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetCapacityRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetCapacityRequest#builder()}
     * </p>
     *
     * @param describeFleetCapacityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFleetCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetCapacityResponse> describeFleetCapacity(
            Consumer<DescribeFleetCapacityRequest.Builder> describeFleetCapacityRequest) {
        return describeFleetCapacity(DescribeFleetCapacityRequest.builder().applyMutation(describeFleetCapacityRequest).build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves the resource capacity settings for one or more fleets. For a container fleet, this operation also
     * returns counts for replica container groups.
     * </p>
     * <p>
     * With multi-location fleets, this operation retrieves data for the fleet's home Region only. To retrieve capacity
     * for remote locations, see <a>DescribeFleetLocationCapacity</a>.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get capacity data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get capacity data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for each requested fleet ID. Each
     * <code>FleetCapacity</code> object includes a <code>Location</code> property, which is set to the fleet's home
     * Region. Capacity values are returned only for fleets that currently exist.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs that are allowed in one request. If a request exceeds this
     * limit, the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @return A Java Future containing the result of the DescribeFleetCapacity operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetCapacityResponse> describeFleetCapacity() {
        return describeFleetCapacity(DescribeFleetCapacityRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityPublisher publisher = client.describeFleetCapacityPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityPublisher publisher = client.describeFleetCapacityPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetCapacityPublisher describeFleetCapacityPaginator() {
        return describeFleetCapacityPaginator(DescribeFleetCapacityRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityPublisher publisher = client.describeFleetCapacityPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityPublisher publisher = client.describeFleetCapacityPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetCapacityRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetCapacityPublisher describeFleetCapacityPaginator(
            DescribeFleetCapacityRequest describeFleetCapacityRequest) {
        return new DescribeFleetCapacityPublisher(this, describeFleetCapacityRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityPublisher publisher = client.describeFleetCapacityPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetCapacityPublisher publisher = client.describeFleetCapacityPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetCapacity(software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetCapacityRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetCapacityRequest#builder()}
     * </p>
     *
     * @param describeFleetCapacityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetCapacityPublisher describeFleetCapacityPaginator(
            Consumer<DescribeFleetCapacityRequest.Builder> describeFleetCapacityRequest) {
        return describeFleetCapacityPaginator(DescribeFleetCapacityRequest.builder().applyMutation(describeFleetCapacityRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves entries from a fleet's event log. Fleet events are initiated by changes in status, such as during fleet
     * creation and termination, changes in capacity, etc. If a fleet has multiple locations, events are also initiated
     * by changes to status and capacity in remote locations.
     * </p>
     * <p>
     * You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set
     * of sequential pages.
     * </p>
     * <p>
     * If successful, a collection of event log entries matching the request are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param describeFleetEventsRequest
     * @return A Java Future containing the result of the DescribeFleetEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFleetEventsResponse> describeFleetEvents(
            DescribeFleetEventsRequest describeFleetEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves entries from a fleet's event log. Fleet events are initiated by changes in status, such as during fleet
     * creation and termination, changes in capacity, etc. If a fleet has multiple locations, events are also initiated
     * by changes to status and capacity in remote locations.
     * </p>
     * <p>
     * You can specify a time range to limit the result set. Use the pagination parameters to retrieve results as a set
     * of sequential pages.
     * </p>
     * <p>
     * If successful, a collection of event log entries matching the request are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetEventsRequest#builder()}
     * </p>
     *
     * @param describeFleetEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFleetEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeFleetEventsResponse> describeFleetEvents(
            Consumer<DescribeFleetEventsRequest.Builder> describeFleetEventsRequest) {
        return describeFleetEvents(DescribeFleetEventsRequest.builder().applyMutation(describeFleetEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetEvents(software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsPublisher publisher = client.describeFleetEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsPublisher publisher = client.describeFleetEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetEvents(software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFleetEventsPublisher describeFleetEventsPaginator(DescribeFleetEventsRequest describeFleetEventsRequest) {
        return new DescribeFleetEventsPublisher(this, describeFleetEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetEvents(software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsPublisher publisher = client.describeFleetEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetEventsPublisher publisher = client.describeFleetEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetEvents(software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetEventsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetEventsRequest#builder()}
     * </p>
     *
     * @param describeFleetEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetEvents" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeFleetEventsPublisher describeFleetEventsPaginator(
            Consumer<DescribeFleetEventsRequest.Builder> describeFleetEventsRequest) {
        return describeFleetEventsPaginator(DescribeFleetEventsRequest.builder().applyMutation(describeFleetEventsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information on a fleet's remote locations, including life-cycle status and any suspended fleet
     * activity.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get data for specific locations, provide a fleet identifier and a list of locations. Location data is returned
     * in the order that it is requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get data for all locations, provide a fleet identifier only. Location data is returned in no particular order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple locations, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>LocationAttributes</code> object is returned for each requested location. If the fleet
     * does not have a requested location, no information is returned. This operation does not return the home Region.
     * To get information on a fleet's home Region, call <code>DescribeFleetAttributes</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * service locations</a> for managed hosting
     * </p>
     *
     * @param describeFleetLocationAttributesRequest
     * @return A Java Future containing the result of the DescribeFleetLocationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetLocationAttributesResponse> describeFleetLocationAttributes(
            DescribeFleetLocationAttributesRequest describeFleetLocationAttributesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information on a fleet's remote locations, including life-cycle status and any suspended fleet
     * activity.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get data for specific locations, provide a fleet identifier and a list of locations. Location data is returned
     * in the order that it is requested.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get data for all locations, provide a fleet identifier only. Location data is returned in no particular order.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting attributes for multiple locations, use the pagination parameters to retrieve results as a set of
     * sequential pages.
     * </p>
     * <p>
     * If successful, a <code>LocationAttributes</code> object is returned for each requested location. If the fleet
     * does not have a requested location, no information is returned. This operation does not return the home Region.
     * To get information on a fleet's home Region, call <code>DescribeFleetAttributes</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * service locations</a> for managed hosting
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetLocationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetLocationAttributesRequest#builder()}
     * </p>
     *
     * @param describeFleetLocationAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeFleetLocationAttributes operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetLocationAttributesResponse> describeFleetLocationAttributes(
            Consumer<DescribeFleetLocationAttributesRequest.Builder> describeFleetLocationAttributesRequest) {
        return describeFleetLocationAttributes(DescribeFleetLocationAttributesRequest.builder()
                .applyMutation(describeFleetLocationAttributesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetLocationAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesPublisher publisher = client.describeFleetLocationAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesPublisher publisher = client.describeFleetLocationAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetLocationAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetLocationAttributesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetLocationAttributesPublisher describeFleetLocationAttributesPaginator(
            DescribeFleetLocationAttributesRequest describeFleetLocationAttributesRequest) {
        return new DescribeFleetLocationAttributesPublisher(this, describeFleetLocationAttributesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetLocationAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesPublisher publisher = client.describeFleetLocationAttributesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetLocationAttributesPublisher publisher = client.describeFleetLocationAttributesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetLocationAttributes(software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetLocationAttributesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetLocationAttributesRequest#builder()}
     * </p>
     *
     * @param describeFleetLocationAttributesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetLocationAttributesPublisher describeFleetLocationAttributesPaginator(
            Consumer<DescribeFleetLocationAttributesRequest.Builder> describeFleetLocationAttributesRequest) {
        return describeFleetLocationAttributesPaginator(DescribeFleetLocationAttributesRequest.builder()
                .applyMutation(describeFleetLocationAttributesRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource capacity settings for a fleet location. The data returned includes the current capacity
     * (number of EC2 instances) and some scaling settings for the requested fleet location. For a container fleet, this
     * operation also returns counts for replica container groups.
     * </p>
     * <p>
     * Use this operation to retrieve capacity information for a fleet's remote location or home Region (you can also
     * retrieve home Region capacity by calling <code>DescribeFleetCapacity</code>).
     * </p>
     * <p>
     * To retrieve capacity data, identify a fleet and location.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for the requested fleet location.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * service locations</a> for managed hosting
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @param describeFleetLocationCapacityRequest
     * @return A Java Future containing the result of the DescribeFleetLocationCapacity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetLocationCapacityResponse> describeFleetLocationCapacity(
            DescribeFleetLocationCapacityRequest describeFleetLocationCapacityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource capacity settings for a fleet location. The data returned includes the current capacity
     * (number of EC2 instances) and some scaling settings for the requested fleet location. For a container fleet, this
     * operation also returns counts for replica container groups.
     * </p>
     * <p>
     * Use this operation to retrieve capacity information for a fleet's remote location or home Region (you can also
     * retrieve home Region capacity by calling <code>DescribeFleetCapacity</code>).
     * </p>
     * <p>
     * To retrieve capacity data, identify a fleet and location.
     * </p>
     * <p>
     * If successful, a <code>FleetCapacity</code> object is returned for the requested fleet location.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * service locations</a> for managed hosting
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetLocationCapacityRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetLocationCapacityRequest#builder()}
     * </p>
     *
     * @param describeFleetLocationCapacityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationCapacityRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeFleetLocationCapacity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationCapacity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationCapacity"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetLocationCapacityResponse> describeFleetLocationCapacity(
            Consumer<DescribeFleetLocationCapacityRequest.Builder> describeFleetLocationCapacityRequest) {
        return describeFleetLocationCapacity(DescribeFleetLocationCapacityRequest.builder()
                .applyMutation(describeFleetLocationCapacityRequest).build());
    }

    /**
     * <p>
     * Retrieves current usage data for a fleet location. Utilization data provides a snapshot of current game hosting
     * activity at the requested location. Use this operation to retrieve utilization information for a fleet's remote
     * location or home Region (you can also retrieve home Region utilization by calling
     * <code>DescribeFleetUtilization</code>).
     * </p>
     * <p>
     * To retrieve utilization data, identify a fleet and location.
     * </p>
     * <p>
     * If successful, a <code>FleetUtilization</code> object is returned for the requested fleet location.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * service locations</a> for managed hosting
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     *
     * @param describeFleetLocationUtilizationRequest
     * @return A Java Future containing the result of the DescribeFleetLocationUtilization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetLocationUtilizationResponse> describeFleetLocationUtilization(
            DescribeFleetLocationUtilizationRequest describeFleetLocationUtilizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves current usage data for a fleet location. Utilization data provides a snapshot of current game hosting
     * activity at the requested location. Use this operation to retrieve utilization information for a fleet's remote
     * location or home Region (you can also retrieve home Region utilization by calling
     * <code>DescribeFleetUtilization</code>).
     * </p>
     * <p>
     * To retrieve utilization data, identify a fleet and location.
     * </p>
     * <p>
     * If successful, a <code>FleetUtilization</code> object is returned for the requested fleet location.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-regions.html"> Amazon GameLift
     * service locations</a> for managed hosting
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift metrics for fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetLocationUtilizationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeFleetLocationUtilizationRequest#builder()}
     * </p>
     *
     * @param describeFleetLocationUtilizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationUtilizationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeFleetLocationUtilization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetLocationUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetLocationUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetLocationUtilizationResponse> describeFleetLocationUtilization(
            Consumer<DescribeFleetLocationUtilizationRequest.Builder> describeFleetLocationUtilizationRequest) {
        return describeFleetLocationUtilization(DescribeFleetLocationUtilizationRequest.builder()
                .applyMutation(describeFleetLocationUtilizationRequest).build());
    }

    /**
     * <p>
     * Retrieves a fleet's inbound connection permissions. Connection permissions specify IP addresses and port settings
     * that incoming traffic can use to access server processes in the fleet. Game server processes that are running in
     * the fleet must use a port that falls within this range. To connect to game server processes on a container fleet,
     * the port settings should include one or more of the fleet's connection ports.
     * </p>
     * <p>
     * Use this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve the port settings for a fleet, identify the fleet's unique identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To check the status of recent updates to a fleet remote location, specify the fleet ID and a location. Port
     * setting updates can take time to propagate across all locations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, a set of <code>IpPermission</code> objects is returned for the requested fleet ID. When specifying
     * a location, this operation returns a pending status. If the requested fleet has been deleted, the result set is
     * empty.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     *
     * @param describeFleetPortSettingsRequest
     * @return A Java Future containing the result of the DescribeFleetPortSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetPortSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetPortSettingsResponse> describeFleetPortSettings(
            DescribeFleetPortSettingsRequest describeFleetPortSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a fleet's inbound connection permissions. Connection permissions specify IP addresses and port settings
     * that incoming traffic can use to access server processes in the fleet. Game server processes that are running in
     * the fleet must use a port that falls within this range. To connect to game server processes on a container fleet,
     * the port settings should include one or more of the fleet's connection ports.
     * </p>
     * <p>
     * Use this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve the port settings for a fleet, identify the fleet's unique identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To check the status of recent updates to a fleet remote location, specify the fleet ID and a location. Port
     * setting updates can take time to propagate across all locations.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If successful, a set of <code>IpPermission</code> objects is returned for the requested fleet ID. When specifying
     * a location, this operation returns a pending status. If the requested fleet has been deleted, the result set is
     * empty.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetPortSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFleetPortSettingsRequest#builder()}
     * </p>
     *
     * @param describeFleetPortSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetPortSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeFleetPortSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetPortSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetPortSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetPortSettingsResponse> describeFleetPortSettings(
            Consumer<DescribeFleetPortSettingsRequest.Builder> describeFleetPortSettingsRequest) {
        return describeFleetPortSettings(DescribeFleetPortSettingsRequest.builder()
                .applyMutation(describeFleetPortSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's
     * hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for
     * the fleet's home Region only. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html"
     * >DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet's remote locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get utilization data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html">FleetUtilization</a>
     * object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization
     * object includes a <code>Location</code> property, which is set to the fleet's home Region.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit,
     * the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift Metrics for Fleets</a>
     * </p>
     *
     * @param describeFleetUtilizationRequest
     * @return A Java Future containing the result of the DescribeFleetUtilization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetUtilizationResponse> describeFleetUtilization(
            DescribeFleetUtilizationRequest describeFleetUtilizationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's
     * hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for
     * the fleet's home Region only. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html"
     * >DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet's remote locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get utilization data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html">FleetUtilization</a>
     * object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization
     * object includes a <code>Location</code> property, which is set to the fleet's home Region.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit,
     * the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift Metrics for Fleets</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetUtilizationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFleetUtilizationRequest#builder()}
     * </p>
     *
     * @param describeFleetUtilizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFleetUtilization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetUtilizationResponse> describeFleetUtilization(
            Consumer<DescribeFleetUtilizationRequest.Builder> describeFleetUtilizationRequest) {
        return describeFleetUtilization(DescribeFleetUtilizationRequest.builder().applyMutation(describeFleetUtilizationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves utilization statistics for one or more fleets. Utilization data provides a snapshot of how the fleet's
     * hosting resources are currently being used. For fleets with remote locations, this operation retrieves data for
     * the fleet's home Region only. See <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html"
     * >DescribeFleetLocationUtilization</a> to get utilization statistics for a fleet's remote locations.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get utilization data for one or more specific fleets, provide a list of fleet IDs or fleet ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get utilization data for all fleets, do not provide a fleet identifier.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When requesting multiple fleets, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_FleetUtilization.html">FleetUtilization</a>
     * object is returned for each requested fleet ID, unless the fleet identifier is not found. Each fleet utilization
     * object includes a <code>Location</code> property, which is set to the fleet's home Region.
     * </p>
     * <note>
     * <p>
     * Some API operations may limit the number of fleet IDs allowed in one request. If a request exceeds this limit,
     * the request fails and the error message includes the maximum allowed.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * Fleets</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html#gamelift-metrics-fleet"
     * >GameLift Metrics for Fleets</a>
     * </p>
     *
     * @return A Java Future containing the result of the DescribeFleetUtilization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeFleetUtilizationResponse> describeFleetUtilization() {
        return describeFleetUtilization(DescribeFleetUtilizationRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationPublisher publisher = client.describeFleetUtilizationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationPublisher publisher = client.describeFleetUtilizationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetUtilizationPublisher describeFleetUtilizationPaginator() {
        return describeFleetUtilizationPaginator(DescribeFleetUtilizationRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationPublisher publisher = client.describeFleetUtilizationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationPublisher publisher = client.describeFleetUtilizationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeFleetUtilizationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetUtilizationPublisher describeFleetUtilizationPaginator(
            DescribeFleetUtilizationRequest describeFleetUtilizationRequest) {
        return new DescribeFleetUtilizationPublisher(this, describeFleetUtilizationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationPublisher publisher = client.describeFleetUtilizationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeFleetUtilizationPublisher publisher = client.describeFleetUtilizationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeFleetUtilization(software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetUtilizationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeFleetUtilizationRequest#builder()}
     * </p>
     *
     * @param describeFleetUtilizationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeFleetUtilizationRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeFleetUtilization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeFleetUtilization"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeFleetUtilizationPublisher describeFleetUtilizationPaginator(
            Consumer<DescribeFleetUtilizationRequest.Builder> describeFleetUtilizationRequest) {
        return describeFleetUtilizationPaginator(DescribeFleetUtilizationRequest.builder()
                .applyMutation(describeFleetUtilizationRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information for a registered game server. Information includes game server status, health check info,
     * and the instance that the game server is running on.
     * </p>
     * <p>
     * To retrieve game server information, specify the game server ID. If successful, the requested game server object
     * is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param describeGameServerRequest
     * @return A Java Future containing the result of the DescribeGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGameServerResponse> describeGameServer(DescribeGameServerRequest describeGameServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information for a registered game server. Information includes game server status, health check info,
     * and the instance that the game server is running on.
     * </p>
     * <p>
     * To retrieve game server information, specify the game server ID. If successful, the requested game server object
     * is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameServerRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGameServerRequest#builder()}
     * </p>
     *
     * @param describeGameServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameServerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGameServerResponse> describeGameServer(
            Consumer<DescribeGameServerRequest.Builder> describeGameServerRequest) {
        return describeGameServer(DescribeGameServerRequest.builder().applyMutation(describeGameServerRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information on a game server group. This operation returns only properties related to Amazon GameLift
     * FleetIQ. To view or update properties for the corresponding Auto Scaling group, such as launch template, auto
     * scaling policies, and maximum/minimum group size, access the Auto Scaling group directly.
     * </p>
     * <p>
     * To get attributes for a game server group, provide a group name or ARN value. If successful, a
     * <code>GameServerGroup</code> object is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param describeGameServerGroupRequest
     * @return A Java Future containing the result of the DescribeGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameServerGroupResponse> describeGameServerGroup(
            DescribeGameServerGroupRequest describeGameServerGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information on a game server group. This operation returns only properties related to Amazon GameLift
     * FleetIQ. To view or update properties for the corresponding Auto Scaling group, such as launch template, auto
     * scaling policies, and maximum/minimum group size, access the Auto Scaling group directly.
     * </p>
     * <p>
     * To get attributes for a game server group, provide a group name or ARN value. If successful, a
     * <code>GameServerGroup</code> object is returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameServerGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGameServerGroupRequest#builder()}
     * </p>
     *
     * @param describeGameServerGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameServerGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameServerGroupResponse> describeGameServerGroup(
            Consumer<DescribeGameServerGroupRequest.Builder> describeGameServerGroupRequest) {
        return describeGameServerGroup(DescribeGameServerGroupRequest.builder().applyMutation(describeGameServerGroupRequest)
                .build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves status information about the Amazon EC2 instances associated with a Amazon GameLift FleetIQ game server
     * group. Use this operation to detect when instances are active or not available to host new game servers.
     * </p>
     * <p>
     * To request status for all instances in the game server group, provide a game server group ID only. To request
     * status for specific instances, provide the game server group ID and one or more instance IDs. Use the pagination
     * parameters to retrieve results in sequential segments. If successful, a collection of
     * <code>GameServerInstance</code> objects is returned.
     * </p>
     * <p>
     * This operation is not designed to be called with every game server claim request; this practice can cause you to
     * exceed your API limit, which results in errors. Instead, as a best practice, cache the results and refresh your
     * cache no more than once every 10 seconds.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param describeGameServerInstancesRequest
     * @return A Java Future containing the result of the DescribeGameServerInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameServerInstancesResponse> describeGameServerInstances(
            DescribeGameServerInstancesRequest describeGameServerInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves status information about the Amazon EC2 instances associated with a Amazon GameLift FleetIQ game server
     * group. Use this operation to detect when instances are active or not available to host new game servers.
     * </p>
     * <p>
     * To request status for all instances in the game server group, provide a game server group ID only. To request
     * status for specific instances, provide the game server group ID and one or more instance IDs. Use the pagination
     * parameters to retrieve results in sequential segments. If successful, a collection of
     * <code>GameServerInstance</code> objects is returned.
     * </p>
     * <p>
     * This operation is not designed to be called with every game server claim request; this practice can cause you to
     * exceed your API limit, which results in errors. Instead, as a best practice, cache the results and refresh your
     * cache no more than once every 10 seconds.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameServerInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeGameServerInstancesRequest#builder()}
     * </p>
     *
     * @param describeGameServerInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeGameServerInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameServerInstancesResponse> describeGameServerInstances(
            Consumer<DescribeGameServerInstancesRequest.Builder> describeGameServerInstancesRequest) {
        return describeGameServerInstances(DescribeGameServerInstancesRequest.builder()
                .applyMutation(describeGameServerInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGameServerInstances(software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesPublisher publisher = client.describeGameServerInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesPublisher publisher = client.describeGameServerInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameServerInstances(software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGameServerInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameServerInstancesPublisher describeGameServerInstancesPaginator(
            DescribeGameServerInstancesRequest describeGameServerInstancesRequest) {
        return new DescribeGameServerInstancesPublisher(this, describeGameServerInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGameServerInstances(software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesPublisher publisher = client.describeGameServerInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameServerInstancesPublisher publisher = client.describeGameServerInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameServerInstances(software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameServerInstancesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeGameServerInstancesRequest#builder()}
     * </p>
     *
     * @param describeGameServerInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameServerInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameServerInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameServerInstancesPublisher describeGameServerInstancesPaginator(
            Consumer<DescribeGameServerInstancesRequest.Builder> describeGameServerInstancesRequest) {
        return describeGameServerInstancesPaginator(DescribeGameServerInstancesRequest.builder()
                .applyMutation(describeGameServerInstancesRequest).build());
    }

    /**
     * <p>
     * Retrieves additional game session properties, including the game session protection policy in force, a set of one
     * or more game sessions in a specific fleet location. You can optionally filter the results by current game session
     * status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on all locations in a fleet, provide a fleet
     * or alias ID, with an optional status filter. This approach returns details from the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on a specific fleet location, provide a
     * fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region
     * or any remote location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for a specific game session, provide the game session ID. This approach looks for the game
     * session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSessionDetail</code> object is returned for each game session that matches the
     * request.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeGameSessionDetailsRequest
     * @return A Java Future containing the result of the DescribeGameSessionDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameSessionDetailsResponse> describeGameSessionDetails(
            DescribeGameSessionDetailsRequest describeGameSessionDetailsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves additional game session properties, including the game session protection policy in force, a set of one
     * or more game sessions in a specific fleet location. You can optionally filter the results by current game session
     * status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on all locations in a fleet, provide a fleet
     * or alias ID, with an optional status filter. This approach returns details from the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for all game sessions that are currently running on a specific fleet location, provide a
     * fleet or alias ID and a location name, with optional status filter. The location can be the fleet's home Region
     * or any remote location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve details for a specific game session, provide the game session ID. This approach looks for the game
     * session ID in all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSessionDetail</code> object is returned for each game session that matches the
     * request.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGameSessionDetailsRequest#builder()}
     * </p>
     *
     * @param describeGameSessionDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeGameSessionDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameSessionDetailsResponse> describeGameSessionDetails(
            Consumer<DescribeGameSessionDetailsRequest.Builder> describeGameSessionDetailsRequest) {
        return describeGameSessionDetails(DescribeGameSessionDetailsRequest.builder()
                .applyMutation(describeGameSessionDetailsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGameSessionDetails(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsPublisher publisher = client.describeGameSessionDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsPublisher publisher = client.describeGameSessionDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessionDetails(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGameSessionDetailsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionDetailsPublisher describeGameSessionDetailsPaginator(
            DescribeGameSessionDetailsRequest describeGameSessionDetailsRequest) {
        return new DescribeGameSessionDetailsPublisher(this, describeGameSessionDetailsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGameSessionDetails(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsPublisher publisher = client.describeGameSessionDetailsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionDetailsPublisher publisher = client.describeGameSessionDetailsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessionDetails(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionDetailsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGameSessionDetailsRequest#builder()}
     * </p>
     *
     * @param describeGameSessionDetailsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameSessionDetailsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionDetailsPublisher describeGameSessionDetailsPaginator(
            Consumer<DescribeGameSessionDetailsRequest.Builder> describeGameSessionDetailsRequest) {
        return describeGameSessionDetailsPaginator(DescribeGameSessionDetailsRequest.builder()
                .applyMutation(describeGameSessionDetailsRequest).build());
    }

    /**
     * <p>
     * Retrieves information, including current status, about a game session placement request.
     * </p>
     * <p>
     * To get game session placement details, specify the placement ID.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple
     * Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessionPlacement</code> should only be used for games in development with low game session
     * usage.
     * </p>
     *
     * @param describeGameSessionPlacementRequest
     * @return A Java Future containing the result of the DescribeGameSessionPlacement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameSessionPlacementResponse> describeGameSessionPlacement(
            DescribeGameSessionPlacementRequest describeGameSessionPlacementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information, including current status, about a game session placement request.
     * </p>
     * <p>
     * To get game session placement details, specify the placement ID.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure configure an Amazon Simple
     * Notification Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessionPlacement</code> should only be used for games in development with low game session
     * usage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionPlacementRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeGameSessionPlacementRequest#builder()}
     * </p>
     *
     * @param describeGameSessionPlacementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameSessionPlacementRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeGameSessionPlacement operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameSessionPlacementResponse> describeGameSessionPlacement(
            Consumer<DescribeGameSessionPlacementRequest.Builder> describeGameSessionPlacementRequest) {
        return describeGameSessionPlacement(DescribeGameSessionPlacementRequest.builder()
                .applyMutation(describeGameSessionPlacementRequest).build());
    }

    /**
     * <p>
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination
     * parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are
     * returned only for queues that currently exist in the Region.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a>
     * </p>
     *
     * @param describeGameSessionQueuesRequest
     * @return A Java Future containing the result of the DescribeGameSessionQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameSessionQueuesResponse> describeGameSessionQueues(
            DescribeGameSessionQueuesRequest describeGameSessionQueuesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination
     * parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are
     * returned only for queues that currently exist in the Region.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionQueuesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGameSessionQueuesRequest#builder()}
     * </p>
     *
     * @param describeGameSessionQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeGameSessionQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameSessionQueuesResponse> describeGameSessionQueues(
            Consumer<DescribeGameSessionQueuesRequest.Builder> describeGameSessionQueuesRequest) {
        return describeGameSessionQueues(DescribeGameSessionQueuesRequest.builder()
                .applyMutation(describeGameSessionQueuesRequest).build());
    }

    /**
     * <p>
     * Retrieves the properties for one or more game session queues. When requesting multiple queues, use the pagination
     * parameters to retrieve results as a set of sequential pages. When specifying a list of queues, objects are
     * returned only for queues that currently exist in the Region.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/queues-console.html"> View Your Queues</a>
     * </p>
     *
     * @return A Java Future containing the result of the DescribeGameSessionQueues operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeGameSessionQueuesResponse> describeGameSessionQueues() {
        return describeGameSessionQueues(DescribeGameSessionQueuesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesPublisher publisher = client.describeGameSessionQueuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesPublisher publisher = client.describeGameSessionQueuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionQueuesPublisher describeGameSessionQueuesPaginator() {
        return describeGameSessionQueuesPaginator(DescribeGameSessionQueuesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesPublisher publisher = client.describeGameSessionQueuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesPublisher publisher = client.describeGameSessionQueuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGameSessionQueuesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionQueuesPublisher describeGameSessionQueuesPaginator(
            DescribeGameSessionQueuesRequest describeGameSessionQueuesRequest) {
        return new DescribeGameSessionQueuesPublisher(this, describeGameSessionQueuesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesPublisher publisher = client.describeGameSessionQueuesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionQueuesPublisher publisher = client.describeGameSessionQueuesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessionQueues(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionQueuesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeGameSessionQueuesRequest#builder()}
     * </p>
     *
     * @param describeGameSessionQueuesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameSessionQueuesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessionQueues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessionQueues"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeGameSessionQueuesPublisher describeGameSessionQueuesPaginator(
            Consumer<DescribeGameSessionQueuesRequest.Builder> describeGameSessionQueuesRequest) {
        return describeGameSessionQueuesPaginator(DescribeGameSessionQueuesRequest.builder()
                .applyMutation(describeGameSessionQueuesRequest).build());
    }

    /**
     * <p>
     * Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results
     * by current game session status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias
     * ID, with an optional status filter. This approach returns all game sessions in the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias
     * ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in
     * all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification
     * Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessions</code> should only be used for games in development with low game session usage.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeGameSessionsRequest
     * @return A Java Future containing the result of the DescribeGameSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGameSessionsResponse> describeGameSessions(
            DescribeGameSessionsRequest describeGameSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a set of one or more game sessions in a specific fleet location. You can optionally filter the results
     * by current game session status.
     * </p>
     * <p>
     * This operation can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on all locations in a fleet, provide a fleet or alias
     * ID, with an optional status filter. This approach returns all game sessions in the fleet's home Region and all
     * remote locations.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all game sessions that are currently running on a specific fleet location, provide a fleet or alias
     * ID and a location name, with optional status filter. The location can be the fleet's home Region or any remote
     * location.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve a specific game session, provide the game session ID. This approach looks for the game session ID in
     * all fleets that reside in the Amazon Web Services Region defined in the request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>GameSession</code> object is returned for each game session that matches the request.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track game session status. This practice can cause you
     * to exceed your API limit, which results in errors. Instead, you must configure an Amazon Simple Notification
     * Service (SNS) topic to receive notifications from FlexMatch or queues. Continuously polling with
     * <code>DescribeGameSessions</code> should only be used for games in development with low game session usage.
     * </p>
     * <p>
     * <i>Available in Amazon GameLift Local.</i>
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-find"
     * >Find a game session</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGameSessionsRequest#builder()}
     * </p>
     *
     * @param describeGameSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeGameSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeGameSessionsResponse> describeGameSessions(
            Consumer<DescribeGameSessionsRequest.Builder> describeGameSessionsRequest) {
        return describeGameSessions(DescribeGameSessionsRequest.builder().applyMutation(describeGameSessionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGameSessions(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsPublisher publisher = client.describeGameSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsPublisher publisher = client.describeGameSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessions(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeGameSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGameSessionsPublisher describeGameSessionsPaginator(DescribeGameSessionsRequest describeGameSessionsRequest) {
        return new DescribeGameSessionsPublisher(this, describeGameSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeGameSessions(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsPublisher publisher = client.describeGameSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeGameSessionsPublisher publisher = client.describeGameSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeGameSessions(software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeGameSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeGameSessionsRequest#builder()}
     * </p>
     *
     * @param describeGameSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeGameSessionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeGameSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeGameSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeGameSessionsPublisher describeGameSessionsPaginator(
            Consumer<DescribeGameSessionsRequest.Builder> describeGameSessionsRequest) {
        return describeGameSessionsPaginator(DescribeGameSessionsRequest.builder().applyMutation(describeGameSessionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the EC2 instances in an Amazon GameLift managed fleet, including instance ID,
     * connection data, and status. You can use this operation with a multi-location fleet to get location-specific
     * instance information. As an alternative, use the operations <a>ListCompute</a> and <a>DescribeCompute</a> to
     * retrieve information for compute resources, including EC2 and Anywhere fleets.
     * </p>
     * <p>
     * You can call this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get information on all instances in a fleet's home Region, specify the fleet ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on all instances in a fleet's remote location, specify the fleet ID and location name.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on a specific instance in a fleet, specify the fleet ID and instance ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, this operation returns <code>Instance</code> objects for each requested instance, listed in no
     * particular order. If you call this operation for an Anywhere fleet, you receive an InvalidRequestException.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely connect
     * to fleet instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug fleet
     * issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeInstancesRequest
     * @return A Java Future containing the result of the DescribeInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInstancesResponse> describeInstances(DescribeInstancesRequest describeInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the EC2 instances in an Amazon GameLift managed fleet, including instance ID,
     * connection data, and status. You can use this operation with a multi-location fleet to get location-specific
     * instance information. As an alternative, use the operations <a>ListCompute</a> and <a>DescribeCompute</a> to
     * retrieve information for compute resources, including EC2 and Anywhere fleets.
     * </p>
     * <p>
     * You can call this operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get information on all instances in a fleet's home Region, specify the fleet ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on all instances in a fleet's remote location, specify the fleet ID and location name.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get information on a specific instance in a fleet, specify the fleet ID and instance ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, this operation returns <code>Instance</code> objects for each requested instance, listed in no
     * particular order. If you call this operation for an Anywhere fleet, you receive an InvalidRequestException.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely connect
     * to fleet instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug fleet
     * issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeInstancesRequest#builder()}
     * </p>
     *
     * @param describeInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInstancesResponse> describeInstances(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest) {
        return describeInstances(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInstances(software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesPublisher publisher = client.describeInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesPublisher publisher = client.describeInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstances(software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancesPublisher describeInstancesPaginator(DescribeInstancesRequest describeInstancesRequest) {
        return new DescribeInstancesPublisher(this, describeInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeInstances(software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesPublisher publisher = client.describeInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeInstancesPublisher publisher = client.describeInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstances(software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancesRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeInstancesRequest#builder()}
     * </p>
     *
     * @param describeInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeInstancesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancesPublisher describeInstancesPaginator(
            Consumer<DescribeInstancesRequest.Builder> describeInstancesRequest) {
        return describeInstancesPaginator(DescribeInstancesRequest.builder().applyMutation(describeInstancesRequest).build());
    }

    /**
     * <p>
     * Retrieves one or more matchmaking tickets. Use this operation to retrieve ticket information, including--after a
     * successful match is made--connection information for the resulting new game session.
     * </p>
     * <p>
     * To request matchmaking tickets, provide a list of up to 10 ticket IDs. If the request is successful, a ticket
     * object is returned for each requested ID that currently exists.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track matchmaking ticket status. This practice can
     * cause you to exceed your API limit, which results in errors. Instead, as a best practice, set up an Amazon Simple
     * Notification Service to receive notifications, and provide the topic ARN in the matchmaking configuration.
     * </p>
     * <p/>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set Up FlexMatch
     * event notification</a>
     * </p>
     *
     * @param describeMatchmakingRequest
     * @return A Java Future containing the result of the DescribeMatchmaking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmaking
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmaking" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMatchmakingResponse> describeMatchmaking(
            DescribeMatchmakingRequest describeMatchmakingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves one or more matchmaking tickets. Use this operation to retrieve ticket information, including--after a
     * successful match is made--connection information for the resulting new game session.
     * </p>
     * <p>
     * To request matchmaking tickets, provide a list of up to 10 ticket IDs. If the request is successful, a ticket
     * object is returned for each requested ID that currently exists.
     * </p>
     * <p>
     * This operation is not designed to be continually called to track matchmaking ticket status. This practice can
     * cause you to exceed your API limit, which results in errors. Instead, as a best practice, set up an Amazon Simple
     * Notification Service to receive notifications, and provide the topic ARN in the matchmaking configuration.
     * </p>
     * <p/>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-client.html"> Add FlexMatch to a game
     * client</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html"> Set Up FlexMatch
     * event notification</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMatchmakingRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeMatchmakingRequest#builder()}
     * </p>
     *
     * @param describeMatchmakingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeMatchmaking operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmaking
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmaking" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeMatchmakingResponse> describeMatchmaking(
            Consumer<DescribeMatchmakingRequest.Builder> describeMatchmakingRequest) {
        return describeMatchmaking(DescribeMatchmakingRequest.builder().applyMutation(describeMatchmakingRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of FlexMatch matchmaking configurations.
     * </p>
     * <p>
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve
     * configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When
     * requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only
     * configurations that currently exist are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch
     * matchmakers</a>
     * </p>
     *
     * @param describeMatchmakingConfigurationsRequest
     * @return A Java Future containing the result of the DescribeMatchmakingConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMatchmakingConfigurationsResponse> describeMatchmakingConfigurations(
            DescribeMatchmakingConfigurationsRequest describeMatchmakingConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of FlexMatch matchmaking configurations.
     * </p>
     * <p>
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve
     * configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When
     * requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only
     * configurations that currently exist are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch
     * matchmakers</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMatchmakingConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMatchmakingConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeMatchmakingConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMatchmakingConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMatchmakingConfigurationsResponse> describeMatchmakingConfigurations(
            Consumer<DescribeMatchmakingConfigurationsRequest.Builder> describeMatchmakingConfigurationsRequest) {
        return describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsRequest.builder()
                .applyMutation(describeMatchmakingConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of FlexMatch matchmaking configurations.
     * </p>
     * <p>
     * This operation offers the following options: (1) retrieve all matchmaking configurations, (2) retrieve
     * configurations for a specified list, or (3) retrieve all configurations that use a specified rule set name. When
     * requesting multiple items, use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a configuration is returned for each requested name. When specifying a list of names, only
     * configurations that currently exist are returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/matchmaker-build.html"> Setting up FlexMatch
     * matchmakers</a>
     * </p>
     *
     * @return A Java Future containing the result of the DescribeMatchmakingConfigurations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMatchmakingConfigurationsResponse> describeMatchmakingConfigurations() {
        return describeMatchmakingConfigurations(DescribeMatchmakingConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsPublisher publisher = client.describeMatchmakingConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsPublisher publisher = client.describeMatchmakingConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingConfigurationsPublisher describeMatchmakingConfigurationsPaginator() {
        return describeMatchmakingConfigurationsPaginator(DescribeMatchmakingConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsPublisher publisher = client.describeMatchmakingConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsPublisher publisher = client.describeMatchmakingConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMatchmakingConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingConfigurationsPublisher describeMatchmakingConfigurationsPaginator(
            DescribeMatchmakingConfigurationsRequest describeMatchmakingConfigurationsRequest) {
        return new DescribeMatchmakingConfigurationsPublisher(this, describeMatchmakingConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsPublisher publisher = client.describeMatchmakingConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingConfigurationsPublisher publisher = client.describeMatchmakingConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingConfigurations(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMatchmakingConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMatchmakingConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeMatchmakingConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingConfigurationsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingConfigurationsPublisher describeMatchmakingConfigurationsPaginator(
            Consumer<DescribeMatchmakingConfigurationsRequest.Builder> describeMatchmakingConfigurationsRequest) {
        return describeMatchmakingConfigurationsPaginator(DescribeMatchmakingConfigurationsRequest.builder()
                .applyMutation(describeMatchmakingConfigurationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region,
     * or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to
     * retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeMatchmakingRuleSetsRequest
     * @return A Java Future containing the result of the DescribeMatchmakingRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMatchmakingRuleSetsResponse> describeMatchmakingRuleSets(
            DescribeMatchmakingRuleSetsRequest describeMatchmakingRuleSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region,
     * or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to
     * retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMatchmakingRuleSetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMatchmakingRuleSetsRequest#builder()}
     * </p>
     *
     * @param describeMatchmakingRuleSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMatchmakingRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMatchmakingRuleSetsResponse> describeMatchmakingRuleSets(
            Consumer<DescribeMatchmakingRuleSetsRequest.Builder> describeMatchmakingRuleSetsRequest) {
        return describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsRequest.builder()
                .applyMutation(describeMatchmakingRuleSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves the details for FlexMatch matchmaking rule sets. You can request all existing rule sets for the Region,
     * or provide a list of one or more rule set names. When requesting multiple items, use the pagination parameters to
     * retrieve results as a set of sequential pages. If successful, a rule set is returned for each requested name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-rulesets.html">Build a rule set</a>
     * </p>
     * </li>
     * </ul>
     *
     * @return A Java Future containing the result of the DescribeMatchmakingRuleSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMatchmakingRuleSetsResponse> describeMatchmakingRuleSets() {
        return describeMatchmakingRuleSets(DescribeMatchmakingRuleSetsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsPublisher publisher = client.describeMatchmakingRuleSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsPublisher publisher = client.describeMatchmakingRuleSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingRuleSetsPublisher describeMatchmakingRuleSetsPaginator() {
        return describeMatchmakingRuleSetsPaginator(DescribeMatchmakingRuleSetsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsPublisher publisher = client.describeMatchmakingRuleSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsPublisher publisher = client.describeMatchmakingRuleSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMatchmakingRuleSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingRuleSetsPublisher describeMatchmakingRuleSetsPaginator(
            DescribeMatchmakingRuleSetsRequest describeMatchmakingRuleSetsRequest) {
        return new DescribeMatchmakingRuleSetsPublisher(this, describeMatchmakingRuleSetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsPublisher publisher = client.describeMatchmakingRuleSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeMatchmakingRuleSetsPublisher publisher = client.describeMatchmakingRuleSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMatchmakingRuleSets(software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMatchmakingRuleSetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMatchmakingRuleSetsRequest#builder()}
     * </p>
     *
     * @param describeMatchmakingRuleSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeMatchmakingRuleSetsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeMatchmakingRuleSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMatchmakingRuleSetsPublisher describeMatchmakingRuleSetsPaginator(
            Consumer<DescribeMatchmakingRuleSetsRequest.Builder> describeMatchmakingRuleSetsRequest) {
        return describeMatchmakingRuleSetsPaginator(DescribeMatchmakingRuleSetsRequest.builder()
                .applyMutation(describeMatchmakingRuleSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for one or more player sessions.
     * </p>
     * <p>
     * This action can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve a specific player session, provide the player session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions in a game session, provide the game session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions for a specific player, provide a player ID only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter
     * this request by player session status. If you provide a specific <code>PlayerSessionId</code> or
     * <code>PlayerId</code>, Amazon GameLift ignores the filter criteria. Use the pagination parameters to retrieve
     * results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>PlayerSession</code> object is returned for each session that matches the request.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describePlayerSessionsRequest
     * @return A Java Future containing the result of the DescribePlayerSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePlayerSessionsResponse> describePlayerSessions(
            DescribePlayerSessionsRequest describePlayerSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for one or more player sessions.
     * </p>
     * <p>
     * This action can be used in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To retrieve a specific player session, provide the player session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions in a game session, provide the game session ID only.
     * </p>
     * </li>
     * <li>
     * <p>
     * To retrieve all player sessions for a specific player, provide a player ID only.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To request player sessions, specify either a player session ID, game session ID, or player ID. You can filter
     * this request by player session status. If you provide a specific <code>PlayerSessionId</code> or
     * <code>PlayerId</code>, Amazon GameLift ignores the filter criteria. Use the pagination parameters to retrieve
     * results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, a <code>PlayerSession</code> object is returned for each session that matches the request.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePlayerSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePlayerSessionsRequest#builder()}
     * </p>
     *
     * @param describePlayerSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePlayerSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribePlayerSessionsResponse> describePlayerSessions(
            Consumer<DescribePlayerSessionsRequest.Builder> describePlayerSessionsRequest) {
        return describePlayerSessions(DescribePlayerSessionsRequest.builder().applyMutation(describePlayerSessionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePlayerSessions(software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsPublisher publisher = client.describePlayerSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsPublisher publisher = client.describePlayerSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePlayerSessions(software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePlayerSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePlayerSessionsPublisher describePlayerSessionsPaginator(
            DescribePlayerSessionsRequest describePlayerSessionsRequest) {
        return new DescribePlayerSessionsPublisher(this, describePlayerSessionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describePlayerSessions(software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsPublisher publisher = client.describePlayerSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribePlayerSessionsPublisher publisher = client.describePlayerSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePlayerSessions(software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePlayerSessionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePlayerSessionsRequest#builder()}
     * </p>
     *
     * @param describePlayerSessionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribePlayerSessionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribePlayerSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribePlayerSessions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePlayerSessionsPublisher describePlayerSessionsPaginator(
            Consumer<DescribePlayerSessionsRequest.Builder> describePlayerSessionsRequest) {
        return describePlayerSessionsPaginator(DescribePlayerSessionsRequest.builder()
                .applyMutation(describePlayerSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a fleet's runtime configuration settings. The runtime configuration determines which server processes
     * run, and how, on computes in the fleet. For managed EC2 fleets, the runtime configuration describes server
     * processes that run on each fleet instance. For container fleets, the runtime configuration describes server
     * processes that run in each replica container group. You can update a fleet's runtime configuration at any time
     * using <a>UpdateRuntimeConfiguration</a>.
     * </p>
     * <p>
     * To get the current runtime configuration for a fleet, provide the fleet ID.
     * </p>
     * <p>
     * If successful, a <code>RuntimeConfiguration</code> object is returned for the requested fleet. If the requested
     * fleet has been deleted, the result set is empty.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html">Running multiple
     * processes on a fleet</a>
     * </p>
     *
     * @param describeRuntimeConfigurationRequest
     * @return A Java Future containing the result of the DescribeRuntimeConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRuntimeConfigurationResponse> describeRuntimeConfiguration(
            DescribeRuntimeConfigurationRequest describeRuntimeConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a fleet's runtime configuration settings. The runtime configuration determines which server processes
     * run, and how, on computes in the fleet. For managed EC2 fleets, the runtime configuration describes server
     * processes that run on each fleet instance. For container fleets, the runtime configuration describes server
     * processes that run in each replica container group. You can update a fleet's runtime configuration at any time
     * using <a>UpdateRuntimeConfiguration</a>.
     * </p>
     * <p>
     * To get the current runtime configuration for a fleet, provide the fleet ID.
     * </p>
     * <p>
     * If successful, a <code>RuntimeConfiguration</code> object is returned for the requested fleet. If the requested
     * fleet has been deleted, the result set is empty.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-intro.html">Setting up Amazon GameLift
     * fleets</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html">Running multiple
     * processes on a fleet</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRuntimeConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeRuntimeConfigurationRequest#builder()}
     * </p>
     *
     * @param describeRuntimeConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeRuntimeConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeRuntimeConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeRuntimeConfigurationResponse> describeRuntimeConfiguration(
            Consumer<DescribeRuntimeConfigurationRequest.Builder> describeRuntimeConfigurationRequest) {
        return describeRuntimeConfiguration(DescribeRuntimeConfigurationRequest.builder()
                .applyMutation(describeRuntimeConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves all scaling policies applied to a fleet.
     * </p>
     * <p>
     * To get a fleet's scaling policies, specify the fleet ID. You can filter this request by policy status, such as to
     * retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential
     * pages. If successful, set of <code>ScalingPolicy</code> objects is returned for the fleet.
     * </p>
     * <p>
     * A fleet may have all of its scaling policies suspended. This operation does not affect the status of the scaling
     * policies, which remains ACTIVE.
     * </p>
     *
     * @param describeScalingPoliciesRequest
     * @return A Java Future containing the result of the DescribeScalingPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeScalingPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingPoliciesResponse> describeScalingPolicies(
            DescribeScalingPoliciesRequest describeScalingPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all scaling policies applied to a fleet.
     * </p>
     * <p>
     * To get a fleet's scaling policies, specify the fleet ID. You can filter this request by policy status, such as to
     * retrieve only active scaling policies. Use the pagination parameters to retrieve results as a set of sequential
     * pages. If successful, set of <code>ScalingPolicy</code> objects is returned for the fleet.
     * </p>
     * <p>
     * A fleet may have all of its scaling policies suspended. This operation does not affect the status of the scaling
     * policies, which remains ACTIVE.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingPoliciesRequest#builder()}
     * </p>
     *
     * @param describeScalingPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeScalingPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeScalingPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeScalingPoliciesResponse> describeScalingPolicies(
            Consumer<DescribeScalingPoliciesRequest.Builder> describeScalingPoliciesRequest) {
        return describeScalingPolicies(DescribeScalingPoliciesRequest.builder().applyMutation(describeScalingPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesPublisher publisher = client.describeScalingPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesPublisher publisher = client.describeScalingPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeScalingPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeScalingPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPoliciesPublisher describeScalingPoliciesPaginator(
            DescribeScalingPoliciesRequest describeScalingPoliciesRequest) {
        return new DescribeScalingPoliciesPublisher(this, describeScalingPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesPublisher publisher = client.describeScalingPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.DescribeScalingPoliciesPublisher publisher = client.describeScalingPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeScalingPolicies(software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScalingPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeScalingPoliciesRequest#builder()}
     * </p>
     *
     * @param describeScalingPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeScalingPoliciesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeScalingPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScalingPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeScalingPoliciesPublisher describeScalingPoliciesPaginator(
            Consumer<DescribeScalingPoliciesRequest.Builder> describeScalingPoliciesRequest) {
        return describeScalingPoliciesPaginator(DescribeScalingPoliciesRequest.builder()
                .applyMutation(describeScalingPoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves properties for a Realtime script.
     * </p>
     * <p>
     * To request a script record, specify the script ID. If successful, an object containing the script properties is
     * returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeScriptRequest
     * @return A Java Future containing the result of the DescribeScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeScriptResponse> describeScript(DescribeScriptRequest describeScriptRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves properties for a Realtime script.
     * </p>
     * <p>
     * To request a script record, specify the script ID. If successful, an object containing the script properties is
     * returned.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScriptRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeScriptRequest#builder()}
     * </p>
     *
     * @param describeScriptRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeScriptRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeScript operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeScript
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeScript" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeScriptResponse> describeScript(Consumer<DescribeScriptRequest.Builder> describeScriptRequest) {
        return describeScript(DescribeScriptRequest.builder().applyMutation(describeScriptRequest).build());
    }

    /**
     * <p>
     * Retrieves valid VPC peering authorizations that are pending for the Amazon Web Services account. This operation
     * returns all VPC peering authorizations and requests for peering. This includes those initiated and received by
     * this account.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeVpcPeeringAuthorizationsRequest
     * @return A Java Future containing the result of the DescribeVpcPeeringAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeVpcPeeringAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVpcPeeringAuthorizationsResponse> describeVpcPeeringAuthorizations(
            DescribeVpcPeeringAuthorizationsRequest describeVpcPeeringAuthorizationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves valid VPC peering authorizations that are pending for the Amazon Web Services account. This operation
     * returns all VPC peering authorizations and requests for peering. This includes those initiated and received by
     * this account.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVpcPeeringAuthorizationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeVpcPeeringAuthorizationsRequest#builder()}
     * </p>
     *
     * @param describeVpcPeeringAuthorizationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringAuthorizationsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeVpcPeeringAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeVpcPeeringAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVpcPeeringAuthorizationsResponse> describeVpcPeeringAuthorizations(
            Consumer<DescribeVpcPeeringAuthorizationsRequest.Builder> describeVpcPeeringAuthorizationsRequest) {
        return describeVpcPeeringAuthorizations(DescribeVpcPeeringAuthorizationsRequest.builder()
                .applyMutation(describeVpcPeeringAuthorizationsRequest).build());
    }

    /**
     * <p>
     * Retrieves valid VPC peering authorizations that are pending for the Amazon Web Services account. This operation
     * returns all VPC peering authorizations and requests for peering. This includes those initiated and received by
     * this account.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @return A Java Future containing the result of the DescribeVpcPeeringAuthorizations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeVpcPeeringAuthorizations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringAuthorizations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVpcPeeringAuthorizationsResponse> describeVpcPeeringAuthorizations() {
        return describeVpcPeeringAuthorizations(DescribeVpcPeeringAuthorizationsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information on VPC peering connections. Use this operation to get peering information for all fleets or
     * for one specific fleet ID.
     * </p>
     * <p>
     * To retrieve connection information, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift fleets. Specify a fleet ID or leave the parameter empty to retrieve all connection
     * records. If successful, the retrieved information includes both active and pending connections. Active
     * connections identify the IpV4 CIDR block that the VPC uses to connect.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param describeVpcPeeringConnectionsRequest
     * @return A Java Future containing the result of the DescribeVpcPeeringConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeVpcPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVpcPeeringConnectionsResponse> describeVpcPeeringConnections(
            DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information on VPC peering connections. Use this operation to get peering information for all fleets or
     * for one specific fleet ID.
     * </p>
     * <p>
     * To retrieve connection information, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift fleets. Specify a fleet ID or leave the parameter empty to retrieve all connection
     * records. If successful, the retrieved information includes both active and pending connections. Active
     * connections identify the IpV4 CIDR block that the VPC uses to connect.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVpcPeeringConnectionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeVpcPeeringConnectionsRequest#builder()}
     * </p>
     *
     * @param describeVpcPeeringConnectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.DescribeVpcPeeringConnectionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeVpcPeeringConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeVpcPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVpcPeeringConnectionsResponse> describeVpcPeeringConnections(
            Consumer<DescribeVpcPeeringConnectionsRequest.Builder> describeVpcPeeringConnectionsRequest) {
        return describeVpcPeeringConnections(DescribeVpcPeeringConnectionsRequest.builder()
                .applyMutation(describeVpcPeeringConnectionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information on VPC peering connections. Use this operation to get peering information for all fleets or
     * for one specific fleet ID.
     * </p>
     * <p>
     * To retrieve connection information, call this operation from the Amazon Web Services account that is used to
     * manage the Amazon GameLift fleets. Specify a fleet ID or leave the parameter empty to retrieve all connection
     * records. If successful, the retrieved information includes both active and pending connections. Active
     * connections identify the IpV4 CIDR block that the VPC uses to connect.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @return A Java Future containing the result of the DescribeVpcPeeringConnections operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.DescribeVpcPeeringConnections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeVpcPeeringConnections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeVpcPeeringConnectionsResponse> describeVpcPeeringConnections() {
        return describeVpcPeeringConnections(DescribeVpcPeeringConnectionsRequest.builder().build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Requests authorization to remotely connect to a hosting resource in a Amazon GameLift managed fleet. This
     * operation is not used with Amazon GameLift Anywhere fleets
     * </p>
     * <p>
     * To request access, specify the compute name and the fleet ID. If successful, this operation returns a set of
     * temporary Amazon Web Services credentials, including a two-part access key and a session token.
     * </p>
     * <p>
     * <b>EC2 fleets</b>
     * </p>
     * <p>
     * With an EC2 fleet (where compute type is <code>EC2</code>), use these credentials with Amazon EC2 Systems Manager
     * (SSM) to start a session with the compute. For more details, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-sessions-start.html#sessions-start-cli"
     * > Starting a session (CLI)</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
     * </p>
     * <p>
     * <b>Container fleets</b>
     * </p>
     * <p>
     * With a container fleet (where compute type is <code>CONTAINER</code>), use these credentials and the target value
     * with SSM to connect to the fleet instance where the container is running. After you're connected to the instance,
     * use Docker commands to interact with the container.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely connect
     * to fleet instances</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug fleet
     * issues</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getComputeAccessRequest
     * @return A Java Future containing the result of the GetComputeAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetComputeAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComputeAccessResponse> getComputeAccess(GetComputeAccessRequest getComputeAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Requests authorization to remotely connect to a hosting resource in a Amazon GameLift managed fleet. This
     * operation is not used with Amazon GameLift Anywhere fleets
     * </p>
     * <p>
     * To request access, specify the compute name and the fleet ID. If successful, this operation returns a set of
     * temporary Amazon Web Services credentials, including a two-part access key and a session token.
     * </p>
     * <p>
     * <b>EC2 fleets</b>
     * </p>
     * <p>
     * With an EC2 fleet (where compute type is <code>EC2</code>), use these credentials with Amazon EC2 Systems Manager
     * (SSM) to start a session with the compute. For more details, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-sessions-start.html#sessions-start-cli"
     * > Starting a session (CLI)</a> in the <i>Amazon EC2 Systems Manager User Guide</i>.
     * </p>
     * <p>
     * <b>Container fleets</b>
     * </p>
     * <p>
     * With a container fleet (where compute type is <code>CONTAINER</code>), use these credentials and the target value
     * with SSM to connect to the fleet instance where the container is running. After you're connected to the instance,
     * use Docker commands to interact with the container.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely connect
     * to fleet instances</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug fleet
     * issues</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComputeAccessRequest.Builder} avoiding the need
     * to create one manually via {@link GetComputeAccessRequest#builder()}
     * </p>
     *
     * @param getComputeAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.GetComputeAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetComputeAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetComputeAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetComputeAccessResponse> getComputeAccess(
            Consumer<GetComputeAccessRequest.Builder> getComputeAccessRequest) {
        return getComputeAccess(GetComputeAccessRequest.builder().applyMutation(getComputeAccessRequest).build());
    }

    /**
     * <p>
     * Requests an authentication token from Amazon GameLift for a compute resource in an Amazon GameLift Anywhere fleet
     * or container fleet. Game servers that are running on the compute use this token to communicate with the Amazon
     * GameLift service, such as when calling the Amazon GameLift server SDK action <code>InitSDK()</code>.
     * Authentication tokens are valid for a limited time span, so you need to request a fresh token before the current
     * token expires.
     * </p>
     * <p>
     * Use this operation based on the fleet compute type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>EC2</code> fleets, auth token retrieval and refresh is handled automatically. All game servers that are
     * running on all fleet instances have access to a valid auth token.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>ANYWHERE</code> and <code>CONTAINER</code> fleets, if you're using the Amazon GameLift Agent, auth
     * token retrieval and refresh is handled automatically for any container or Anywhere compute where the Agent is
     * running. If you're not using the Agent, create a mechanism to retrieve and refresh auth tokens for computes that
     * are running game server processes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html">Create an
     * Anywhere fleet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html">Test your
     * integration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html">Server SDK
     * reference guides</a> (for version 5.x)
     * </p>
     * </li>
     * </ul>
     *
     * @param getComputeAuthTokenRequest
     * @return A Java Future containing the result of the GetComputeAuthToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetComputeAuthToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAuthToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetComputeAuthTokenResponse> getComputeAuthToken(
            GetComputeAuthTokenRequest getComputeAuthTokenRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests an authentication token from Amazon GameLift for a compute resource in an Amazon GameLift Anywhere fleet
     * or container fleet. Game servers that are running on the compute use this token to communicate with the Amazon
     * GameLift service, such as when calling the Amazon GameLift server SDK action <code>InitSDK()</code>.
     * Authentication tokens are valid for a limited time span, so you need to request a fresh token before the current
     * token expires.
     * </p>
     * <p>
     * Use this operation based on the fleet compute type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>EC2</code> fleets, auth token retrieval and refresh is handled automatically. All game servers that are
     * running on all fleet instances have access to a valid auth token.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>ANYWHERE</code> and <code>CONTAINER</code> fleets, if you're using the Amazon GameLift Agent, auth
     * token retrieval and refresh is handled automatically for any container or Anywhere compute where the Agent is
     * running. If you're not using the Agent, create a mechanism to retrieve and refresh auth tokens for computes that
     * are running game server processes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html">Create an
     * Anywhere fleet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html">Test your
     * integration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html">Server SDK
     * reference guides</a> (for version 5.x)
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetComputeAuthTokenRequest.Builder} avoiding the
     * need to create one manually via {@link GetComputeAuthTokenRequest#builder()}
     * </p>
     *
     * @param getComputeAuthTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.GetComputeAuthTokenRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetComputeAuthToken operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetComputeAuthToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetComputeAuthToken" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetComputeAuthTokenResponse> getComputeAuthToken(
            Consumer<GetComputeAuthTokenRequest.Builder> getComputeAuthTokenRequest) {
        return getComputeAuthToken(GetComputeAuthTokenRequest.builder().applyMutation(getComputeAuthTokenRequest).build());
    }

    /**
     * <p>
     * Retrieves the location of stored game session logs for a specified game session on Amazon GameLift managed
     * fleets. When a game session is terminated, Amazon GameLift automatically stores the logs in Amazon S3 and retains
     * them for 14 days. Use this URL to download the logs.
     * </p>
     * <note>
     * <p>
     * See the <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift">Amazon
     * Web Services Service Limits</a> page for maximum log file sizes. Log files that exceed this limit are not saved.
     * </p>
     * </note>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param getGameSessionLogUrlRequest
     * @return A Java Future containing the result of the GetGameSessionLogUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetGameSessionLogUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetGameSessionLogUrlResponse> getGameSessionLogUrl(
            GetGameSessionLogUrlRequest getGameSessionLogUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the location of stored game session logs for a specified game session on Amazon GameLift managed
     * fleets. When a game session is terminated, Amazon GameLift automatically stores the logs in Amazon S3 and retains
     * them for 14 days. Use this URL to download the logs.
     * </p>
     * <note>
     * <p>
     * See the <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_gamelift">Amazon
     * Web Services Service Limits</a> page for maximum log file sizes. Log files that exceed this limit are not saved.
     * </p>
     * </note>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGameSessionLogUrlRequest.Builder} avoiding the
     * need to create one manually via {@link GetGameSessionLogUrlRequest#builder()}
     * </p>
     *
     * @param getGameSessionLogUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.GetGameSessionLogUrlRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetGameSessionLogUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetGameSessionLogUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetGameSessionLogUrl" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetGameSessionLogUrlResponse> getGameSessionLogUrl(
            Consumer<GetGameSessionLogUrlRequest.Builder> getGameSessionLogUrlRequest) {
        return getGameSessionLogUrl(GetGameSessionLogUrlRequest.builder().applyMutation(getGameSessionLogUrlRequest).build());
    }

    /**
     * <p>
     * Requests authorization to remotely connect to an instance in an Amazon GameLift managed fleet. Use this operation
     * to connect to instances with game servers that use Amazon GameLift server SDK 4.x or earlier. To connect to
     * instances with game servers that use server SDK 5.x or later, call <a>GetComputeAccess</a>.
     * </p>
     * <p>
     * To request access to an instance, specify IDs for the instance and the fleet it belongs to. You can retrieve
     * instance IDs for a fleet by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html">DescribeInstances</a>
     * with the fleet ID.
     * </p>
     * <p>
     * If successful, this operation returns an IP address and credentials. The returned credentials match the operating
     * system of the instance, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a Windows instance: returns a user name and secret (password) for use with a Windows Remote Desktop client.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a Linux instance: returns a user name and secret (RSA private key) for use with an SSH client. You must save
     * the secret to a <code>.pem</code> file. If you're using the CLI, see the example <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess.html#API_GetInstanceAccess_Examples"
     * > Get credentials for a Linux instance</a> for tips on automatically saving the secret to a <code>.pem</code>
     * file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely connect
     * to fleet instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug fleet
     * issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param getInstanceAccessRequest
     * @return A Java Future containing the result of the GetInstanceAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetInstanceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceAccessResponse> getInstanceAccess(GetInstanceAccessRequest getInstanceAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Requests authorization to remotely connect to an instance in an Amazon GameLift managed fleet. Use this operation
     * to connect to instances with game servers that use Amazon GameLift server SDK 4.x or earlier. To connect to
     * instances with game servers that use server SDK 5.x or later, call <a>GetComputeAccess</a>.
     * </p>
     * <p>
     * To request access to an instance, specify IDs for the instance and the fleet it belongs to. You can retrieve
     * instance IDs for a fleet by calling <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html">DescribeInstances</a>
     * with the fleet ID.
     * </p>
     * <p>
     * If successful, this operation returns an IP address and credentials. The returned credentials match the operating
     * system of the instance, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For a Windows instance: returns a user name and secret (password) for use with a Windows Remote Desktop client.
     * </p>
     * </li>
     * <li>
     * <p>
     * For a Linux instance: returns a user name and secret (RSA private key) for use with an SSH client. You must save
     * the secret to a <code>.pem</code> file. If you're using the CLI, see the example <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess.html#API_GetInstanceAccess_Examples"
     * > Get credentials for a Linux instance</a> for tips on automatically saving the secret to a <code>.pem</code>
     * file.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-remote-access.html">Remotely connect
     * to fleet instances</a>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-debug.html">Debug fleet
     * issues</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInstanceAccessRequest.Builder} avoiding the need
     * to create one manually via {@link GetInstanceAccessRequest#builder()}
     * </p>
     *
     * @param getInstanceAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.GetInstanceAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInstanceAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.GetInstanceAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GetInstanceAccess" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceAccessResponse> getInstanceAccess(
            Consumer<GetInstanceAccessRequest.Builder> getInstanceAccessRequest) {
        return getInstanceAccess(GetInstanceAccessRequest.builder().applyMutation(getInstanceAccessRequest).build());
    }

    /**
     * <p>
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or
     * routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     * </p>
     * <note>
     * <p>
     * Returned aliases are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listAliasesRequest
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAliasesResponse> listAliases(ListAliasesRequest listAliasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or
     * routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     * </p>
     * <note>
     * <p>
     * Returned aliases are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListAliasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAliasesResponse> listAliases(Consumer<ListAliasesRequest.Builder> listAliasesRequest) {
        return listAliases(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Retrieves all aliases for this Amazon Web Services account. You can filter the result set by alias name and/or
     * routing strategy type. Use the pagination parameters to retrieve results in sequential pages.
     * </p>
     * <note>
     * <p>
     * Returned aliases are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAliasesResponse> listAliases() {
        return listAliases(ListAliasesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesPublisher listAliasesPaginator() {
        return listAliasesPaginator(ListAliasesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesPublisher listAliasesPaginator(ListAliasesRequest listAliasesRequest) {
        return new ListAliasesPublisher(this, listAliasesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.gamelift.model.ListAliasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAliasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListAliasesRequest#builder()}
     * </p>
     *
     * @param listAliasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListAliasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAliasesPublisher listAliasesPaginator(Consumer<ListAliasesRequest.Builder> listAliasesRequest) {
        return listAliasesPaginator(ListAliasesRequest.builder().applyMutation(listAliasesRequest).build());
    }

    /**
     * <p>
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit
     * results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination
     * parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * Build resources are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listBuildsRequest
     * @return A Java Future containing the result of the ListBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBuildsResponse> listBuilds(ListBuildsRequest listBuildsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit
     * results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination
     * parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * Build resources are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBuildsRequest#builder()}
     * </p>
     *
     * @param listBuildsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListBuildsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBuildsResponse> listBuilds(Consumer<ListBuildsRequest.Builder> listBuildsRequest) {
        return listBuilds(ListBuildsRequest.builder().applyMutation(listBuildsRequest).build());
    }

    /**
     * <p>
     * Retrieves build resources for all builds associated with the Amazon Web Services account in use. You can limit
     * results to builds that are in a specific status by using the <code>Status</code> parameter. Use the pagination
     * parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * Build resources are not listed in any particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-intro.html"> Upload a Custom
     * Server Build</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @return A Java Future containing the result of the ListBuilds operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListBuildsResponse> listBuilds() {
        return listBuilds(ListBuildsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListBuildsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListBuildsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsPublisher listBuildsPaginator() {
        return listBuildsPaginator(ListBuildsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListBuildsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListBuildsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)} operation.</b>
     * </p>
     *
     * @param listBuildsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsPublisher listBuildsPaginator(ListBuildsRequest listBuildsRequest) {
        return new ListBuildsPublisher(this, listBuildsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListBuildsPublisher publisher = client.listBuildsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListBuildsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListBuildsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBuilds(software.amazon.awssdk.services.gamelift.model.ListBuildsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBuildsRequest.Builder} avoiding the need to
     * create one manually via {@link ListBuildsRequest#builder()}
     * </p>
     *
     * @param listBuildsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListBuildsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListBuilds
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListBuilds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListBuildsPublisher listBuildsPaginator(Consumer<ListBuildsRequest.Builder> listBuildsRequest) {
        return listBuildsPaginator(ListBuildsRequest.builder().applyMutation(listBuildsRequest).build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves information on the compute resources in an Amazon GameLift fleet.
     * </p>
     * <p>
     * To request a list of computes, specify the fleet ID. Use the pagination parameters to retrieve results in a set
     * of sequential pages.
     * </p>
     * <p>
     * You can filter the result set by location.
     * </p>
     * <p>
     * If successful, this operation returns information on all computes in the requested fleet. Depending on the
     * fleet's compute type, the result includes the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>EC2</code> fleets, this operation returns information about the EC2 instance. Compute names are
     * instance IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>ANYWHERE</code> fleets, this operation returns the compute names and details provided when the compute
     * was registered with <code>RegisterCompute</code>. The <code>GameLiftServiceSdkEndpoint</code> or
     * <code>GameLiftAgentEndpoint</code> is included.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>CONTAINER</code> fleets, this operation returns information about containers that are registered as
     * computes, and the instances they're running on. Compute names are container names.
     * </p>
     * </li>
     * </ul>
     *
     * @param listComputeRequest
     * @return A Java Future containing the result of the ListCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComputeResponse> listCompute(ListComputeRequest listComputeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves information on the compute resources in an Amazon GameLift fleet.
     * </p>
     * <p>
     * To request a list of computes, specify the fleet ID. Use the pagination parameters to retrieve results in a set
     * of sequential pages.
     * </p>
     * <p>
     * You can filter the result set by location.
     * </p>
     * <p>
     * If successful, this operation returns information on all computes in the requested fleet. Depending on the
     * fleet's compute type, the result includes the following information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>EC2</code> fleets, this operation returns information about the EC2 instance. Compute names are
     * instance IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>ANYWHERE</code> fleets, this operation returns the compute names and details provided when the compute
     * was registered with <code>RegisterCompute</code>. The <code>GameLiftServiceSdkEndpoint</code> or
     * <code>GameLiftAgentEndpoint</code> is included.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>CONTAINER</code> fleets, this operation returns information about containers that are registered as
     * computes, and the instances they're running on. Compute names are container names.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComputeRequest.Builder} avoiding the need to
     * create one manually via {@link ListComputeRequest#builder()}
     * </p>
     *
     * @param listComputeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListComputeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComputeResponse> listCompute(Consumer<ListComputeRequest.Builder> listComputeRequest) {
        return listCompute(ListComputeRequest.builder().applyMutation(listComputeRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listCompute(software.amazon.awssdk.services.gamelift.model.ListComputeRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListComputePublisher publisher = client.listComputePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListComputePublisher publisher = client.listComputePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListComputeResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListComputeResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompute(software.amazon.awssdk.services.gamelift.model.ListComputeRequest)} operation.</b>
     * </p>
     *
     * @param listComputeRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComputePublisher listComputePaginator(ListComputeRequest listComputeRequest) {
        return new ListComputePublisher(this, listComputeRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listCompute(software.amazon.awssdk.services.gamelift.model.ListComputeRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListComputePublisher publisher = client.listComputePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListComputePublisher publisher = client.listComputePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListComputeResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListComputeResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCompute(software.amazon.awssdk.services.gamelift.model.ListComputeRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComputeRequest.Builder} avoiding the need to
     * create one manually via {@link ListComputeRequest#builder()}
     * </p>
     *
     * @param listComputeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListComputeRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComputePublisher listComputePaginator(Consumer<ListComputeRequest.Builder> listComputeRequest) {
        return listComputePaginator(ListComputeRequest.builder().applyMutation(listComputeRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift containers feature, which is currently in public preview. </b>
     * </p>
     * <p>
     * Retrieves all container group definitions for the Amazon Web Services account and Amazon Web Services Region that
     * are currently in use. You can filter the result set by the container groups' scheduling strategy. Use the
     * pagination parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * This operation returns the list of container group definitions in no particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Manage a
     * container group definition</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param listContainerGroupDefinitionsRequest
     * @return A Java Future containing the result of the ListContainerGroupDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListContainerGroupDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListContainerGroupDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListContainerGroupDefinitionsResponse> listContainerGroupDefinitions(
            ListContainerGroupDefinitionsRequest listContainerGroupDefinitionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift containers feature, which is currently in public preview. </b>
     * </p>
     * <p>
     * Retrieves all container group definitions for the Amazon Web Services account and Amazon Web Services Region that
     * are currently in use. You can filter the result set by the container groups' scheduling strategy. Use the
     * pagination parameters to retrieve results in a set of sequential pages.
     * </p>
     * <note>
     * <p>
     * This operation returns the list of container group definitions in no particular order.
     * </p>
     * </note>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/containers-create-groups.html">Manage a
     * container group definition</a>
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContainerGroupDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListContainerGroupDefinitionsRequest#builder()}
     * </p>
     *
     * @param listContainerGroupDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListContainerGroupDefinitions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListContainerGroupDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListContainerGroupDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListContainerGroupDefinitionsResponse> listContainerGroupDefinitions(
            Consumer<ListContainerGroupDefinitionsRequest.Builder> listContainerGroupDefinitionsRequest) {
        return listContainerGroupDefinitions(ListContainerGroupDefinitionsRequest.builder()
                .applyMutation(listContainerGroupDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContainerGroupDefinitions(software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListContainerGroupDefinitionsPublisher publisher = client.listContainerGroupDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListContainerGroupDefinitionsPublisher publisher = client.listContainerGroupDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerGroupDefinitions(software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listContainerGroupDefinitionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListContainerGroupDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListContainerGroupDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContainerGroupDefinitionsPublisher listContainerGroupDefinitionsPaginator(
            ListContainerGroupDefinitionsRequest listContainerGroupDefinitionsRequest) {
        return new ListContainerGroupDefinitionsPublisher(this, listContainerGroupDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listContainerGroupDefinitions(software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListContainerGroupDefinitionsPublisher publisher = client.listContainerGroupDefinitionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListContainerGroupDefinitionsPublisher publisher = client.listContainerGroupDefinitionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listContainerGroupDefinitions(software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListContainerGroupDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListContainerGroupDefinitionsRequest#builder()}
     * </p>
     *
     * @param listContainerGroupDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListContainerGroupDefinitionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>UnsupportedRegionException The requested operation is not supported in the Region specified.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListContainerGroupDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListContainerGroupDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListContainerGroupDefinitionsPublisher listContainerGroupDefinitionsPaginator(
            Consumer<ListContainerGroupDefinitionsRequest.Builder> listContainerGroupDefinitionsRequest) {
        return listContainerGroupDefinitionsPaginator(ListContainerGroupDefinitionsRequest.builder()
                .applyMutation(listContainerGroupDefinitionsRequest).build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can filter the result set to find
     * only those fleets that are deployed with a specific build or script. For fleets that have multiple locations,
     * this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * You can use operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get a list of all fleets in a Region, don't provide a build or script identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets where a specific game build is deployed, provide the build ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Realtime Servers fleets with a specific configuration script, provide the script ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets with a specific container group definition, provide the
     * <code>ContainerGroupDefinition</code> ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, this operation returns a list of fleet IDs that match the request parameters. A NextToken value is
     * also returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet IDs are returned in no particular order.
     * </p>
     * </note>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can filter the result set to find
     * only those fleets that are deployed with a specific build or script. For fleets that have multiple locations,
     * this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * You can use operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get a list of all fleets in a Region, don't provide a build or script identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets where a specific game build is deployed, provide the build ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Realtime Servers fleets with a specific configuration script, provide the script ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets with a specific container group definition, provide the
     * <code>ContainerGroupDefinition</code> ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, this operation returns a list of fleet IDs that match the request parameters. A NextToken value is
     * also returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet IDs are returned in no particular order.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListFleetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetsResponse> listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Retrieves a collection of fleet resources in an Amazon Web Services Region. You can filter the result set to find
     * only those fleets that are deployed with a specific build or script. For fleets that have multiple locations,
     * this operation retrieves fleets based on their home Region only.
     * </p>
     * <p>
     * You can use operation in the following ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * To get a list of all fleets in a Region, don't provide a build or script identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets where a specific game build is deployed, provide the build ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all Realtime Servers fleets with a specific configuration script, provide the script ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * To get a list of all fleets with a specific container group definition, provide the
     * <code>ContainerGroupDefinition</code> ID.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Use the pagination parameters to retrieve results as a set of sequential pages.
     * </p>
     * <p>
     * If successful, this operation returns a list of fleet IDs that match the request parameters. A NextToken value is
     * also returned if there are more result pages to retrieve.
     * </p>
     * <note>
     * <p>
     * Fleet IDs are returned in no particular order.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFleetsResponse> listFleets() {
        return listFleets(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsPublisher listFleetsPaginator() {
        return listFleetsPaginator(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsPublisher listFleetsPaginator(ListFleetsRequest listFleetsRequest) {
        return new ListFleetsPublisher(this, listFleetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.gamelift.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListFleetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsPublisher listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Lists a game server groups.
     * </p>
     *
     * @param listGameServerGroupsRequest
     * @return A Java Future containing the result of the ListGameServerGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListGameServerGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListGameServerGroupsResponse> listGameServerGroups(
            ListGameServerGroupsRequest listGameServerGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists a game server groups.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGameServerGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGameServerGroupsRequest#builder()}
     * </p>
     *
     * @param listGameServerGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGameServerGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListGameServerGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListGameServerGroupsResponse> listGameServerGroups(
            Consumer<ListGameServerGroupsRequest.Builder> listGameServerGroupsRequest) {
        return listGameServerGroups(ListGameServerGroupsRequest.builder().applyMutation(listGameServerGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGameServerGroups(software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsPublisher publisher = client.listGameServerGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsPublisher publisher = client.listGameServerGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGameServerGroups(software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGameServerGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListGameServerGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGameServerGroupsPublisher listGameServerGroupsPaginator(ListGameServerGroupsRequest listGameServerGroupsRequest) {
        return new ListGameServerGroupsPublisher(this, listGameServerGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGameServerGroups(software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsPublisher publisher = client.listGameServerGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServerGroupsPublisher publisher = client.listGameServerGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGameServerGroups(software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGameServerGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGameServerGroupsRequest#builder()}
     * </p>
     *
     * @param listGameServerGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListGameServerGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListGameServerGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServerGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListGameServerGroupsPublisher listGameServerGroupsPaginator(
            Consumer<ListGameServerGroupsRequest.Builder> listGameServerGroupsRequest) {
        return listGameServerGroupsPaginator(ListGameServerGroupsRequest.builder().applyMutation(listGameServerGroupsRequest)
                .build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information on all game servers that are currently active in a specified game server group. You can opt
     * to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential
     * segments.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param listGameServersRequest
     * @return A Java Future containing the result of the ListGameServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListGameServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGameServersResponse> listGameServers(ListGameServersRequest listGameServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Retrieves information on all game servers that are currently active in a specified game server group. You can opt
     * to sort the list by game server age. Use the pagination parameters to retrieve results in a set of sequential
     * segments.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGameServersRequest.Builder} avoiding the need
     * to create one manually via {@link ListGameServersRequest#builder()}
     * </p>
     *
     * @param listGameServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListGameServersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGameServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListGameServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGameServersResponse> listGameServers(
            Consumer<ListGameServersRequest.Builder> listGameServersRequest) {
        return listGameServers(ListGameServersRequest.builder().applyMutation(listGameServersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGameServers(software.amazon.awssdk.services.gamelift.model.ListGameServersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServersPublisher publisher = client.listGameServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServersPublisher publisher = client.listGameServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListGameServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListGameServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGameServers(software.amazon.awssdk.services.gamelift.model.ListGameServersRequest)} operation.</b>
     * </p>
     *
     * @param listGameServersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListGameServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGameServersPublisher listGameServersPaginator(ListGameServersRequest listGameServersRequest) {
        return new ListGameServersPublisher(this, listGameServersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGameServers(software.amazon.awssdk.services.gamelift.model.ListGameServersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServersPublisher publisher = client.listGameServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListGameServersPublisher publisher = client.listGameServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListGameServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListGameServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGameServers(software.amazon.awssdk.services.gamelift.model.ListGameServersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGameServersRequest.Builder} avoiding the need
     * to create one manually via {@link ListGameServersRequest#builder()}
     * </p>
     *
     * @param listGameServersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListGameServersRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListGameServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListGameServers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGameServersPublisher listGameServersPaginator(Consumer<ListGameServersRequest.Builder> listGameServersRequest) {
        return listGameServersPaginator(ListGameServersRequest.builder().applyMutation(listGameServersRequest).build());
    }

    /**
     * <p>
     * Lists all custom and Amazon Web Services locations.
     * </p>
     *
     * @param listLocationsRequest
     * @return A Java Future containing the result of the ListLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLocationsResponse> listLocations(ListLocationsRequest listLocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all custom and Amazon Web Services locations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLocationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLocationsRequest#builder()}
     * </p>
     *
     * @param listLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListLocationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLocationsResponse> listLocations(Consumer<ListLocationsRequest.Builder> listLocationsRequest) {
        return listLocations(ListLocationsRequest.builder().applyMutation(listLocationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLocations(software.amazon.awssdk.services.gamelift.model.ListLocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListLocationsPublisher publisher = client.listLocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListLocationsPublisher publisher = client.listLocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListLocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListLocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLocations(software.amazon.awssdk.services.gamelift.model.ListLocationsRequest)} operation.</b>
     * </p>
     *
     * @param listLocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsPublisher listLocationsPaginator(ListLocationsRequest listLocationsRequest) {
        return new ListLocationsPublisher(this, listLocationsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLocations(software.amazon.awssdk.services.gamelift.model.ListLocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListLocationsPublisher publisher = client.listLocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListLocationsPublisher publisher = client.listLocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListLocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListLocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLocations(software.amazon.awssdk.services.gamelift.model.ListLocationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLocationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLocationsRequest#builder()}
     * </p>
     *
     * @param listLocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListLocationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListLocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListLocations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLocationsPublisher listLocationsPaginator(Consumer<ListLocationsRequest.Builder> listLocationsRequest) {
        return listLocationsPaginator(ListLocationsRequest.builder().applyMutation(listLocationsRequest).build());
    }

    /**
     * <p>
     * Retrieves script records for all Realtime scripts that are associated with the Amazon Web Services account in
     * use.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listScriptsRequest
     * @return A Java Future containing the result of the ListScripts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListScripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListScriptsResponse> listScripts(ListScriptsRequest listScriptsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves script records for all Realtime scripts that are associated with the Amazon Web Services account in
     * use.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/realtime-intro.html">Amazon GameLift Realtime
     * Servers</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScriptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListScriptsRequest#builder()}
     * </p>
     *
     * @param listScriptsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListScriptsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListScripts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListScripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListScriptsResponse> listScripts(Consumer<ListScriptsRequest.Builder> listScriptsRequest) {
        return listScripts(ListScriptsRequest.builder().applyMutation(listScriptsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listScripts(software.amazon.awssdk.services.gamelift.model.ListScriptsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListScriptsPublisher publisher = client.listScriptsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListScriptsPublisher publisher = client.listScriptsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListScriptsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListScriptsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScripts(software.amazon.awssdk.services.gamelift.model.ListScriptsRequest)} operation.</b>
     * </p>
     *
     * @param listScriptsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListScripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScriptsPublisher listScriptsPaginator(ListScriptsRequest listScriptsRequest) {
        return new ListScriptsPublisher(this, listScriptsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listScripts(software.amazon.awssdk.services.gamelift.model.ListScriptsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListScriptsPublisher publisher = client.listScriptsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamelift.paginators.ListScriptsPublisher publisher = client.listScriptsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.gamelift.model.ListScriptsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.gamelift.model.ListScriptsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of Limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listScripts(software.amazon.awssdk.services.gamelift.model.ListScriptsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListScriptsRequest.Builder} avoiding the need to
     * create one manually via {@link ListScriptsRequest#builder()}
     * </p>
     *
     * @param listScriptsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListScriptsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListScripts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListScripts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListScriptsPublisher listScriptsPaginator(Consumer<ListScriptsRequest.Builder> listScriptsRequest) {
        return listScriptsPaginator(ListScriptsRequest.builder().applyMutation(listScriptsRequest).build());
    }

    /**
     * <p>
     * Retrieves all tags assigned to a Amazon GameLift resource. Use resource tags to organize Amazon Web Services
     * resources for a range of purposes. This operation handles the permissions necessary to manage tags for Amazon
     * GameLift resources that support tagging.
     * </p>
     * <p>
     * To list tags for a resource, specify the unique ARN value for the resource.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources</a> in the <i>Amazon Web Services General Reference</i>
     * </p>
     * <p>
     * <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging
     * Strategies</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all tags assigned to a Amazon GameLift resource. Use resource tags to organize Amazon Web Services
     * resources for a range of purposes. This operation handles the permissions necessary to manage tags for Amazon
     * GameLift resources that support tagging.
     * </p>
     * <p>
     * To list tags for a resource, specify the unique ARN value for the resource.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     * Resources</a> in the <i>Amazon Web Services General Reference</i>
     * </p>
     * <p>
     * <a href="http://aws.amazon.com/answers/account-management/aws-tagging-strategies/"> Amazon Web Services Tagging
     * Strategies</a>
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>TaggingFailedException The requested tagging operation did not succeed. This may be due to invalid
     *         tag format or the maximum tag limit may have been exceeded. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or updates a scaling policy for a fleet. Scaling policies are used to automatically scale a fleet's
     * hosting capacity to meet player demand. An active scaling policy instructs Amazon GameLift to track a fleet
     * metric and automatically change the fleet's capacity when a certain threshold is reached. There are two types of
     * scaling policies: target-based and rule-based. Use a target-based policy to quickly and efficiently manage fleet
     * scaling; this option is the most commonly used. Use rule-based policies when you need to exert fine-grained
     * control over auto-scaling.
     * </p>
     * <p>
     * Fleets can have multiple scaling policies of each type in force at the same time; you can have one target-based
     * policy, one or multiple rule-based scaling policies, or both. We recommend caution, however, because multiple
     * auto-scaling policies can have unintended consequences.
     * </p>
     * <p>
     * Learn more about how to work with auto-scaling in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-autoscaling.html">Set Up Fleet Automatic
     * Scaling</a>.
     * </p>
     * <p>
     * <b>Target-based policy</b>
     * </p>
     * <p>
     * A target-based policy tracks a single metric: PercentAvailableGameSessions. This metric tells us how much of a
     * fleet's hosting capacity is ready to host game sessions but is not currently in use. This is the fleet's buffer;
     * it measures the additional player demand that the fleet could handle at current capacity. With a target-based
     * policy, you set your ideal buffer size and leave it to Amazon GameLift to take whatever action is needed to
     * maintain that target.
     * </p>
     * <p>
     * For example, you might choose to maintain a 10% buffer for a fleet that has the capacity to host 100 simultaneous
     * game sessions. This policy tells Amazon GameLift to take action whenever the fleet's available capacity falls
     * below or rises above 10 game sessions. Amazon GameLift will start new instances or stop unused instances in order
     * to return to the 10% buffer.
     * </p>
     * <p>
     * To create or update a target-based policy, specify a fleet ID and name, and set the policy type to "TargetBased".
     * Specify the metric to track (PercentAvailableGameSessions) and reference a <code>TargetConfiguration</code>
     * object with your desired buffer value. Exclude all other parameters. On a successful request, the policy name is
     * returned. The scaling policy is automatically in force as soon as it's successfully created. If the fleet's
     * auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are
     * restarted.
     * </p>
     * <p>
     * <b>Rule-based policy</b>
     * </p>
     * <p>
     * A rule-based policy tracks specified fleet metric, sets a threshold value, and specifies the type of action to
     * initiate when triggered. With a rule-based policy, you can select from several available fleet metrics. Each
     * policy specifies whether to scale up or scale down (and by how much), so you need one policy for each type of
     * action.
     * </p>
     * <p>
     * For example, a policy may make the following statement:
     * "If the percentage of idle instances is greater than 20% for more than 15 minutes, then reduce the fleet capacity by 10%."
     * </p>
     * <p>
     * A policy's rule statement has the following structure:
     * </p>
     * <p>
     * If <code>[MetricName]</code> is <code>[ComparisonOperator]</code> <code>[Threshold]</code> for
     * <code>[EvaluationPeriods]</code> minutes, then <code>[ScalingAdjustmentType]</code> to/by
     * <code>[ScalingAdjustment]</code>.
     * </p>
     * <p>
     * To implement the example, the rule statement would look like this:
     * </p>
     * <p>
     * If <code>[PercentIdleInstances]</code> is <code>[GreaterThanThreshold]</code> <code>[20]</code> for
     * <code>[15]</code> minutes, then <code>[PercentChangeInCapacity]</code> to/by <code>[10]</code>.
     * </p>
     * <p>
     * To create or update a scaling policy, specify a unique combination of name and fleet ID, and set the policy type
     * to "RuleBased". Specify the parameter values for a policy rule statement. On a successful request, the policy
     * name is returned. Scaling policies are automatically in force as soon as they're successfully created. If the
     * fleet's auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions
     * are restarted.
     * </p>
     *
     * @param putScalingPolicyRequest
     * @return A Java Future containing the result of the PutScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.PutScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutScalingPolicyResponse> putScalingPolicy(PutScalingPolicyRequest putScalingPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a scaling policy for a fleet. Scaling policies are used to automatically scale a fleet's
     * hosting capacity to meet player demand. An active scaling policy instructs Amazon GameLift to track a fleet
     * metric and automatically change the fleet's capacity when a certain threshold is reached. There are two types of
     * scaling policies: target-based and rule-based. Use a target-based policy to quickly and efficiently manage fleet
     * scaling; this option is the most commonly used. Use rule-based policies when you need to exert fine-grained
     * control over auto-scaling.
     * </p>
     * <p>
     * Fleets can have multiple scaling policies of each type in force at the same time; you can have one target-based
     * policy, one or multiple rule-based scaling policies, or both. We recommend caution, however, because multiple
     * auto-scaling policies can have unintended consequences.
     * </p>
     * <p>
     * Learn more about how to work with auto-scaling in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-autoscaling.html">Set Up Fleet Automatic
     * Scaling</a>.
     * </p>
     * <p>
     * <b>Target-based policy</b>
     * </p>
     * <p>
     * A target-based policy tracks a single metric: PercentAvailableGameSessions. This metric tells us how much of a
     * fleet's hosting capacity is ready to host game sessions but is not currently in use. This is the fleet's buffer;
     * it measures the additional player demand that the fleet could handle at current capacity. With a target-based
     * policy, you set your ideal buffer size and leave it to Amazon GameLift to take whatever action is needed to
     * maintain that target.
     * </p>
     * <p>
     * For example, you might choose to maintain a 10% buffer for a fleet that has the capacity to host 100 simultaneous
     * game sessions. This policy tells Amazon GameLift to take action whenever the fleet's available capacity falls
     * below or rises above 10 game sessions. Amazon GameLift will start new instances or stop unused instances in order
     * to return to the 10% buffer.
     * </p>
     * <p>
     * To create or update a target-based policy, specify a fleet ID and name, and set the policy type to "TargetBased".
     * Specify the metric to track (PercentAvailableGameSessions) and reference a <code>TargetConfiguration</code>
     * object with your desired buffer value. Exclude all other parameters. On a successful request, the policy name is
     * returned. The scaling policy is automatically in force as soon as it's successfully created. If the fleet's
     * auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions are
     * restarted.
     * </p>
     * <p>
     * <b>Rule-based policy</b>
     * </p>
     * <p>
     * A rule-based policy tracks specified fleet metric, sets a threshold value, and specifies the type of action to
     * initiate when triggered. With a rule-based policy, you can select from several available fleet metrics. Each
     * policy specifies whether to scale up or scale down (and by how much), so you need one policy for each type of
     * action.
     * </p>
     * <p>
     * For example, a policy may make the following statement:
     * "If the percentage of idle instances is greater than 20% for more than 15 minutes, then reduce the fleet capacity by 10%."
     * </p>
     * <p>
     * A policy's rule statement has the following structure:
     * </p>
     * <p>
     * If <code>[MetricName]</code> is <code>[ComparisonOperator]</code> <code>[Threshold]</code> for
     * <code>[EvaluationPeriods]</code> minutes, then <code>[ScalingAdjustmentType]</code> to/by
     * <code>[ScalingAdjustment]</code>.
     * </p>
     * <p>
     * To implement the example, the rule statement would look like this:
     * </p>
     * <p>
     * If <code>[PercentIdleInstances]</code> is <code>[GreaterThanThreshold]</code> <code>[20]</code> for
     * <code>[15]</code> minutes, then <code>[PercentChangeInCapacity]</code> to/by <code>[10]</code>.
     * </p>
     * <p>
     * To create or update a scaling policy, specify a unique combination of name and fleet ID, and set the policy type
     * to "RuleBased". Specify the parameter values for a policy rule statement. On a successful request, the policy
     * name is returned. Scaling policies are automatically in force as soon as they're successfully created. If the
     * fleet's auto-scaling actions are temporarily suspended, the new policy will be in force once the fleet actions
     * are restarted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutScalingPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutScalingPolicyRequest#builder()}
     * </p>
     *
     * @param putScalingPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.PutScalingPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutScalingPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.PutScalingPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PutScalingPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutScalingPolicyResponse> putScalingPolicy(
            Consumer<PutScalingPolicyRequest.Builder> putScalingPolicyRequest) {
        return putScalingPolicy(PutScalingPolicyRequest.builder().applyMutation(putScalingPolicyRequest).build());
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Registers a compute resource in an Amazon GameLift fleet. Register computes with an Amazon GameLift Anywhere
     * fleet or a container fleet.
     * </p>
     * <p>
     * For an Anywhere fleet or a container fleet that's running the Amazon GameLift Agent, the Agent handles all
     * compute registry tasks for you. For an Anywhere fleet that doesn't use the Agent, call this operation to register
     * fleet computes.
     * </p>
     * <p>
     * To register a compute, give the compute a name (must be unique within the fleet) and specify the compute
     * resource's DNS name or IP address. Provide a fleet ID and a fleet location to associate with the compute being
     * registered. You can optionally include the path to a TLS certificate on the compute resource.
     * </p>
     * <p>
     * If successful, this operation returns compute details, including an Amazon GameLift SDK endpoint or Agent
     * endpoint. Game server processes running on the compute can use this endpoint to communicate with the Amazon
     * GameLift service. Each server process includes the SDK endpoint in its call to the Amazon GameLift server SDK
     * action <code>InitSDK()</code>.
     * </p>
     * <p>
     * To view compute details, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute.html">DescribeCompute</a> with
     * the compute name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html">Create an
     * Anywhere fleet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html">Test your
     * integration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html">Server SDK
     * reference guides</a> (for version 5.x)
     * </p>
     * </li>
     * </ul>
     *
     * @param registerComputeRequest
     * @return A Java Future containing the result of the RegisterCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotReadyException The operation failed because Amazon GameLift has not yet finished validating this
     *         compute. We recommend attempting 8 to 10 retries over 3 to 5 minutes with <a href=
     *         "http://aws.amazon.com/blogs/https:/aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/"
     *         >exponential backoffs and jitter</a>.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.RegisterCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterComputeResponse> registerCompute(RegisterComputeRequest registerComputeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation has been expanded to use with the Amazon GameLift containers feature, which is currently in
     * public preview.</b>
     * </p>
     * <p>
     * Registers a compute resource in an Amazon GameLift fleet. Register computes with an Amazon GameLift Anywhere
     * fleet or a container fleet.
     * </p>
     * <p>
     * For an Anywhere fleet or a container fleet that's running the Amazon GameLift Agent, the Agent handles all
     * compute registry tasks for you. For an Anywhere fleet that doesn't use the Agent, call this operation to register
     * fleet computes.
     * </p>
     * <p>
     * To register a compute, give the compute a name (must be unique within the fleet) and specify the compute
     * resource's DNS name or IP address. Provide a fleet ID and a fleet location to associate with the compute being
     * registered. You can optionally include the path to a TLS certificate on the compute resource.
     * </p>
     * <p>
     * If successful, this operation returns compute details, including an Amazon GameLift SDK endpoint or Agent
     * endpoint. Game server processes running on the compute can use this endpoint to communicate with the Amazon
     * GameLift service. Each server process includes the SDK endpoint in its call to the Amazon GameLift server SDK
     * action <code>InitSDK()</code>.
     * </p>
     * <p>
     * To view compute details, call <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeCompute.html">DescribeCompute</a> with
     * the compute name.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-creating-anywhere.html">Create an
     * Anywhere fleet</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/integration-testing.html">Test your
     * integration</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-serversdk.html">Server SDK
     * reference guides</a> (for version 5.x)
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterComputeRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterComputeRequest#builder()}
     * </p>
     *
     * @param registerComputeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.RegisterComputeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the RegisterCompute operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>NotReadyException The operation failed because Amazon GameLift has not yet finished validating this
     *         compute. We recommend attempting 8 to 10 retries over 3 to 5 minutes with <a href=
     *         "http://aws.amazon.com/blogs/https:/aws.amazon.com/blogs/architecture/exponential-backoff-and-jitter/"
     *         >exponential backoffs and jitter</a>.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.RegisterCompute
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterCompute" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RegisterComputeResponse> registerCompute(
            Consumer<RegisterComputeRequest.Builder> registerComputeRequest) {
        return registerCompute(RegisterComputeRequest.builder().applyMutation(registerComputeRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Creates a new game server resource and notifies Amazon GameLift FleetIQ that the game server is ready to host
     * gameplay and players. This operation is called by a game server process that is running on an instance in a game
     * server group. Registering game servers enables Amazon GameLift FleetIQ to track available game servers and
     * enables game clients and services to claim a game server for a new game session.
     * </p>
     * <p>
     * To register a game server, identify the game server group and instance where the game server is running, and
     * provide a unique identifier for the game server. You can also include connection and game server data.
     * </p>
     * <p>
     * Once a game server is successfully registered, it is put in status <code>AVAILABLE</code>. A request to register
     * a game server may fail if the instance it is running on is in the process of shutting down as part of instance
     * balancing or scale-down activity.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param registerGameServerRequest
     * @return A Java Future containing the result of the RegisterGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.RegisterGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterGameServerResponse> registerGameServer(RegisterGameServerRequest registerGameServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Creates a new game server resource and notifies Amazon GameLift FleetIQ that the game server is ready to host
     * gameplay and players. This operation is called by a game server process that is running on an instance in a game
     * server group. Registering game servers enables Amazon GameLift FleetIQ to track available game servers and
     * enables game clients and services to claim a game server for a new game session.
     * </p>
     * <p>
     * To register a game server, identify the game server group and instance where the game server is running, and
     * provide a unique identifier for the game server. You can also include connection and game server data.
     * </p>
     * <p>
     * Once a game server is successfully registered, it is put in status <code>AVAILABLE</code>. A request to register
     * a game server may fail if the instance it is running on is in the process of shutting down as part of instance
     * balancing or scale-down activity.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterGameServerRequest.Builder} avoiding the
     * need to create one manually via {@link RegisterGameServerRequest#builder()}
     * </p>
     *
     * @param registerGameServerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.RegisterGameServerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RegisterGameServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request.</p></li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>LimitExceededException The requested operation would cause the resource to exceed the allowed service
     *         limit. Resolve the issue before retrying.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.RegisterGameServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RegisterGameServer" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RegisterGameServerResponse> registerGameServer(
            Consumer<RegisterGameServerRequest.Builder> registerGameServerRequest) {
        return registerGameServer(RegisterGameServerRequest.builder().applyMutation(registerGameServerRequest).build());
    }

    /**
     * <p>
     * Retrieves a fresh set of credentials for use when uploading a new set of game build files to Amazon GameLift's
     * Amazon S3. This is done as part of the build creation process; see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html">CreateBuild</a>.
     * </p>
     * <p>
     * To request new credentials, specify the build ID as returned with an initial <code>CreateBuild</code> request. If
     * successful, a new set of credentials are returned, along with the S3 storage location associated with the build
     * ID.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"
     * > Create a Build with Files in S3</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param requestUploadCredentialsRequest
     * @return A Java Future containing the result of the RequestUploadCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.RequestUploadCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestUploadCredentialsResponse> requestUploadCredentials(
            RequestUploadCredentialsRequest requestUploadCredentialsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a fresh set of credentials for use when uploading a new set of game build files to Amazon GameLift's
     * Amazon S3. This is done as part of the build creation process; see <a
     * href="https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html">CreateBuild</a>.
     * </p>
     * <p>
     * To request new credentials, specify the build ID as returned with an initial <code>CreateBuild</code> request. If
     * successful, a new set of credentials are returned, along with the S3 storage location associated with the build
     * ID.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-build-cli-uploading.html#gamelift-build-cli-uploading-create-build"
     * > Create a Build with Files in S3</a>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestUploadCredentialsRequest.Builder} avoiding
     * the need to create one manually via {@link RequestUploadCredentialsRequest#builder()}
     * </p>
     *
     * @param requestUploadCredentialsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.RequestUploadCredentialsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RequestUploadCredentials operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.RequestUploadCredentials
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RequestUploadCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestUploadCredentialsResponse> requestUploadCredentials(
            Consumer<RequestUploadCredentialsRequest.Builder> requestUploadCredentialsRequest) {
        return requestUploadCredentials(RequestUploadCredentialsRequest.builder().applyMutation(requestUploadCredentialsRequest)
                .build());
    }

    /**
     * <p>
     * Attempts to retrieve a fleet ID that is associated with an alias. Specify a unique alias identifier.
     * </p>
     * <p>
     * If the alias has a <code>SIMPLE</code> routing strategy, Amazon GameLift returns a fleet ID. If the alias has a
     * <code>TERMINAL</code> routing strategy, the result is a <code>TerminalRoutingStrategyException</code>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     *
     * @param resolveAliasRequest
     * @return A Java Future containing the result of the ResolveAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ResolveAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResolveAliasResponse> resolveAlias(ResolveAliasRequest resolveAliasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to retrieve a fleet ID that is associated with an alias. Specify a unique alias identifier.
     * </p>
     * <p>
     * If the alias has a <code>SIMPLE</code> routing strategy, Amazon GameLift returns a fleet ID. If the alias has a
     * <code>TERMINAL</code> routing strategy, the result is a <code>TerminalRoutingStrategyException</code>.
     * </p>
     * <p>
     * <b>Related actions</b>
     * </p>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/reference-awssdk.html#reference-awssdk-resources-fleets"
     * >All APIs by task</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResolveAliasRequest.Builder} avoiding the need to
     * create one manually via {@link ResolveAliasRequest#builder()}
     * </p>
     *
     * @param resolveAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ResolveAliasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ResolveAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>TerminalRoutingStrategyException The service is unable to resolve the routing for a particular alias
     *         because it has a terminal <code>RoutingStrategy</code> associated with it. The message returned in this
     *         exception is the message defined in the routing strategy itself. Such requests should only be retried if
     *         the routing strategy for the specified alias is modified.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ResolveAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResolveAlias" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResolveAliasResponse> resolveAlias(Consumer<ResolveAliasRequest.Builder> resolveAliasRequest) {
        return resolveAlias(ResolveAliasRequest.builder().applyMutation(resolveAliasRequest).build());
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Reinstates activity on a game server group after it has been suspended. A game server group might be suspended by
     * the <a href="gamelift/latest/apireference/API_SuspendGameServerGroup.html">SuspendGameServerGroup</a> operation,
     * or it might be suspended involuntarily due to a configuration problem. In the second case, you can manually
     * resume activity on the group once the configuration problem has been resolved. Refer to the game server group
     * status and status reason for more information on why group activity is suspended.
     * </p>
     * <p>
     * To resume activity, specify a game server group ARN and the type of activity to be resumed. If successful, a
     * <code>GameServerGroup</code> object is returned showing that the resumed activity is no longer listed in
     * <code>SuspendedActions</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     *
     * @param resumeGameServerGroupRequest
     * @return A Java Future containing the result of the ResumeGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ResumeGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResumeGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResumeGameServerGroupResponse> resumeGameServerGroup(
            ResumeGameServerGroupRequest resumeGameServerGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>This operation is used with the Amazon GameLift FleetIQ solution and game server groups.</b>
     * </p>
     * <p>
     * Reinstates activity on a game server group after it has been suspended. A game server group might be suspended by
     * the <a href="gamelift/latest/apireference/API_SuspendGameServerGroup.html">SuspendGameServerGroup</a> operation,
     * or it might be suspended involuntarily due to a configuration problem. In the second case, you can manually
     * resume activity on the group once the configuration problem has been resolved. Refer to the game server group
     * status and status reason for more information on why group activity is suspended.
     * </p>
     * <p>
     * To resume activity, specify a game server group ARN and the type of activity to be resumed. If successful, a
     * <code>GameServerGroup</code> object is returned showing that the resumed activity is no longer listed in
     * <code>SuspendedActions</code>.
     * </p>
     * <p>
     * <b>Learn more</b>
     * </p>
     * <p>
     * <a href="https://docs.aws.amazon.com/gamelift/latest/fleetiqguide/gsg-intro.html">Amazon GameLift FleetIQ
     * Guide</a>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeGameServerGroupRequest.Builder} avoiding the
     * need to create one manually via {@link ResumeGameServerGroupRequest#builder()}
     * </p>
     *
     * @param resumeGameServerGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamelift.model.ResumeGameServerGroupRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ResumeGameServerGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InvalidRequestException One or more parameter values in the request are invalid. Correct the invalid
     *         parameter values before retrying.</li>
     *         <li>NotFoundException The requested resources was not found. The resource was either not created yet or
     *         deleted.</li>
     *         <li>UnauthorizedException The client failed authentication. Clients should not retry such requests.</li>
     *         <li>InternalServiceException The service encountered an unrecoverable internal failure while processing
     *         the request. Clients can retry such requests immediately or after a waiting period.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GameLiftException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GameLiftAsyncClient.ResumeGameServerGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResumeGameServerGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ResumeGameServerGroupResponse> resumeGameServerGroup(
            Consumer<ResumeGameServerGroupRequest.Builder> resumeGameServerGroupRequest) {
        return resumeGameServerGroup(ResumeGameServerGroupRequest.builder().applyMutation(resumeGameServerGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves all active game sessions that match a set of search criteria and sorts them into a specified order.
     * </p>
     * <p>
     * This operation is not designed to continually track game session status because that practice can cause you to
     * exceed your API limit and generate errors. Instead, configure an Amazon Simple Notification Service (Amazon SNS)
     * topic to receive notifications from a matchmaker or a game session placement queue.
     * </p>
     * <p>
     * When searching for game sessions, you specify exactly where you want to search and provide a search filter
     * expression, a sort expression, or both. A search request can search only one fleet, but it can search all of a
     * fleet's locations.
     * </p>
     * <p>
     * This operation can be used in the following w