/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.GameServer;
import software.amazon.awssdk.services.gamelift.model.ListGameServersRequest;
import software.amazon.awssdk.services.gamelift.model.ListGameServersResponse;

public class ListGameServersPublisher
implements SdkPublisher<ListGameServersResponse> {
    private final GameLiftAsyncClient client;
    private final ListGameServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGameServersPublisher(GameLiftAsyncClient client, ListGameServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGameServersPublisher(GameLiftAsyncClient client, ListGameServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGameServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGameServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GameServer> gameServers() {
        Function<ListGameServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameServers() != null) {
                return response.gameServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGameServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGameServersResponseFetcher
    implements AsyncPageFetcher<ListGameServersResponse> {
        private ListGameServersResponseFetcher() {
        }

        public boolean hasNextPage(ListGameServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGameServersResponse> nextPage(ListGameServersResponse previousPage) {
            if (previousPage == null) {
                return ListGameServersPublisher.this.client.listGameServers(ListGameServersPublisher.this.firstRequest);
            }
            return ListGameServersPublisher.this.client.listGameServers((ListGameServersRequest)((Object)ListGameServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

