/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeGameServerInstancesResponse;
import software.amazon.awssdk.services.gamelift.model.GameServerInstance;

public class DescribeGameServerInstancesIterable
implements SdkIterable<DescribeGameServerInstancesResponse> {
    private final GameLiftClient client;
    private final DescribeGameServerInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeGameServerInstancesIterable(GameLiftClient client, DescribeGameServerInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeGameServerInstancesResponseFetcher();
    }

    public Iterator<DescribeGameServerInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GameServerInstance> gameServerInstances() {
        Function<DescribeGameServerInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.gameServerInstances() != null) {
                return response.gameServerInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeGameServerInstancesResponseFetcher
    implements SyncPageFetcher<DescribeGameServerInstancesResponse> {
        private DescribeGameServerInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGameServerInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeGameServerInstancesResponse nextPage(DescribeGameServerInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeGameServerInstancesIterable.this.client.describeGameServerInstances(DescribeGameServerInstancesIterable.this.firstRequest);
            }
            return DescribeGameServerInstancesIterable.this.client.describeGameServerInstances((DescribeGameServerInstancesRequest)((Object)DescribeGameServerInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

