/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetCapacityResponse;
import software.amazon.awssdk.services.gamelift.model.FleetCapacity;

public class DescribeFleetCapacityPublisher
implements SdkPublisher<DescribeFleetCapacityResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeFleetCapacityRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFleetCapacityPublisher(GameLiftAsyncClient client, DescribeFleetCapacityRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFleetCapacityPublisher(GameLiftAsyncClient client, DescribeFleetCapacityRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFleetCapacityResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFleetCapacityResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FleetCapacity> fleetCapacity() {
        Function<DescribeFleetCapacityResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleetCapacity() != null) {
                return response.fleetCapacity().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeFleetCapacityResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeFleetCapacityResponseFetcher
    implements AsyncPageFetcher<DescribeFleetCapacityResponse> {
        private DescribeFleetCapacityResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetCapacityResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFleetCapacityResponse> nextPage(DescribeFleetCapacityResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetCapacityPublisher.this.client.describeFleetCapacity(DescribeFleetCapacityPublisher.this.firstRequest);
            }
            return DescribeFleetCapacityPublisher.this.client.describeFleetCapacity((DescribeFleetCapacityRequest)((Object)DescribeFleetCapacityPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

