/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetResponse extends GameLiftResponse implements
        ToCopyableBuilder<CreateFleetResponse.Builder, CreateFleetResponse> {
    private static final SdkField<FleetAttributes> FLEET_ATTRIBUTES_FIELD = SdkField
            .<FleetAttributes> builder(MarshallingType.SDK_POJO).memberName("FleetAttributes")
            .getter(getter(CreateFleetResponse::fleetAttributes)).setter(setter(Builder::fleetAttributes))
            .constructor(FleetAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetAttributes").build()).build();

    private static final SdkField<List<LocationState>> LOCATION_STATES_FIELD = SdkField
            .<List<LocationState>> builder(MarshallingType.LIST)
            .memberName("LocationStates")
            .getter(getter(CreateFleetResponse::locationStates))
            .setter(setter(Builder::locationStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationState> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ATTRIBUTES_FIELD,
            LOCATION_STATES_FIELD));

    private final FleetAttributes fleetAttributes;

    private final List<LocationState> locationStates;

    private CreateFleetResponse(BuilderImpl builder) {
        super(builder);
        this.fleetAttributes = builder.fleetAttributes;
        this.locationStates = builder.locationStates;
    }

    /**
     * <p>
     * The properties for the new fleet, including the current status. All fleets are placed in <code>NEW</code> status
     * on creation.
     * </p>
     * 
     * @return The properties for the new fleet, including the current status. All fleets are placed in <code>NEW</code>
     *         status on creation.
     */
    public final FleetAttributes fleetAttributes() {
        return fleetAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocationStates property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLocationStates() {
        return locationStates != null && !(locationStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fleet's locations and life-cycle status of each location. For new fleets, the status of all locations is set
     * to <code>NEW</code>. During fleet creation, GameLift updates each location status as instances are deployed there
     * and prepared for game hosting. This list includes an entry for the fleet's home Region. For fleets with no remote
     * locations, only one entry, representing the home Region, is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocationStates} method.
     * </p>
     * 
     * @return The fleet's locations and life-cycle status of each location. For new fleets, the status of all locations
     *         is set to <code>NEW</code>. During fleet creation, GameLift updates each location status as instances are
     *         deployed there and prepared for game hosting. This list includes an entry for the fleet's home Region.
     *         For fleets with no remote locations, only one entry, representing the home Region, is returned.
     */
    public final List<LocationState> locationStates() {
        return locationStates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocationStates() ? locationStates() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetResponse)) {
            return false;
        }
        CreateFleetResponse other = (CreateFleetResponse) obj;
        return Objects.equals(fleetAttributes(), other.fleetAttributes()) && hasLocationStates() == other.hasLocationStates()
                && Objects.equals(locationStates(), other.locationStates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFleetResponse").add("FleetAttributes", fleetAttributes())
                .add("LocationStates", hasLocationStates() ? locationStates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetAttributes":
            return Optional.ofNullable(clazz.cast(fleetAttributes()));
        case "LocationStates":
            return Optional.ofNullable(clazz.cast(locationStates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetResponse, T> g) {
        return obj -> g.apply((CreateFleetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetResponse> {
        /**
         * <p>
         * The properties for the new fleet, including the current status. All fleets are placed in <code>NEW</code>
         * status on creation.
         * </p>
         * 
         * @param fleetAttributes
         *        The properties for the new fleet, including the current status. All fleets are placed in
         *        <code>NEW</code> status on creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetAttributes(FleetAttributes fleetAttributes);

        /**
         * <p>
         * The properties for the new fleet, including the current status. All fleets are placed in <code>NEW</code>
         * status on creation.
         * </p>
         * This is a convenience method that creates an instance of the {@link FleetAttributes.Builder} avoiding the
         * need to create one manually via {@link FleetAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FleetAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #fleetAttributes(FleetAttributes)}.
         * 
         * @param fleetAttributes
         *        a consumer that will call methods on {@link FleetAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetAttributes(FleetAttributes)
         */
        default Builder fleetAttributes(Consumer<FleetAttributes.Builder> fleetAttributes) {
            return fleetAttributes(FleetAttributes.builder().applyMutation(fleetAttributes).build());
        }

        /**
         * <p>
         * The fleet's locations and life-cycle status of each location. For new fleets, the status of all locations is
         * set to <code>NEW</code>. During fleet creation, GameLift updates each location status as instances are
         * deployed there and prepared for game hosting. This list includes an entry for the fleet's home Region. For
         * fleets with no remote locations, only one entry, representing the home Region, is returned.
         * </p>
         * 
         * @param locationStates
         *        The fleet's locations and life-cycle status of each location. For new fleets, the status of all
         *        locations is set to <code>NEW</code>. During fleet creation, GameLift updates each location status as
         *        instances are deployed there and prepared for game hosting. This list includes an entry for the
         *        fleet's home Region. For fleets with no remote locations, only one entry, representing the home
         *        Region, is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationStates(Collection<LocationState> locationStates);

        /**
         * <p>
         * The fleet's locations and life-cycle status of each location. For new fleets, the status of all locations is
         * set to <code>NEW</code>. During fleet creation, GameLift updates each location status as instances are
         * deployed there and prepared for game hosting. This list includes an entry for the fleet's home Region. For
         * fleets with no remote locations, only one entry, representing the home Region, is returned.
         * </p>
         * 
         * @param locationStates
         *        The fleet's locations and life-cycle status of each location. For new fleets, the status of all
         *        locations is set to <code>NEW</code>. During fleet creation, GameLift updates each location status as
         *        instances are deployed there and prepared for game hosting. This list includes an entry for the
         *        fleet's home Region. For fleets with no remote locations, only one entry, representing the home
         *        Region, is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locationStates(LocationState... locationStates);

        /**
         * <p>
         * The fleet's locations and life-cycle status of each location. For new fleets, the status of all locations is
         * set to <code>NEW</code>. During fleet creation, GameLift updates each location status as instances are
         * deployed there and prepared for game hosting. This list includes an entry for the fleet's home Region. For
         * fleets with no remote locations, only one entry, representing the home Region, is returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.LocationState.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.LocationState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.LocationState.Builder#build()} is called immediately
         * and its result is passed to {@link #locationStates(List<LocationState>)}.
         * 
         * @param locationStates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.LocationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locationStates(java.util.Collection<LocationState>)
         */
        Builder locationStates(Consumer<LocationState.Builder>... locationStates);
    }

    static final class BuilderImpl extends GameLiftResponse.BuilderImpl implements Builder {
        private FleetAttributes fleetAttributes;

        private List<LocationState> locationStates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetResponse model) {
            super(model);
            fleetAttributes(model.fleetAttributes);
            locationStates(model.locationStates);
        }

        public final FleetAttributes.Builder getFleetAttributes() {
            return fleetAttributes != null ? fleetAttributes.toBuilder() : null;
        }

        public final void setFleetAttributes(FleetAttributes.BuilderImpl fleetAttributes) {
            this.fleetAttributes = fleetAttributes != null ? fleetAttributes.build() : null;
        }

        @Override
        public final Builder fleetAttributes(FleetAttributes fleetAttributes) {
            this.fleetAttributes = fleetAttributes;
            return this;
        }

        public final List<LocationState.Builder> getLocationStates() {
            List<LocationState.Builder> result = LocationStateListCopier.copyToBuilder(this.locationStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocationStates(Collection<LocationState.BuilderImpl> locationStates) {
            this.locationStates = LocationStateListCopier.copyFromBuilder(locationStates);
        }

        @Override
        public final Builder locationStates(Collection<LocationState> locationStates) {
            this.locationStates = LocationStateListCopier.copy(locationStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationStates(LocationState... locationStates) {
            locationStates(Arrays.asList(locationStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationStates(Consumer<LocationState.Builder>... locationStates) {
            locationStates(Stream.of(locationStates).map(c -> LocationState.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateFleetResponse build() {
            return new CreateFleetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
