/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFleetRequest extends GameLiftRequest implements
        ToCopyableBuilder<CreateFleetRequest.Builder, CreateFleetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateFleetRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateFleetRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> BUILD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BuildId").getter(getter(CreateFleetRequest::buildId)).setter(setter(Builder::buildId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildId").build()).build();

    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScriptId").getter(getter(CreateFleetRequest::scriptId)).setter(setter(Builder::scriptId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()).build();

    private static final SdkField<String> SERVER_LAUNCH_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerLaunchPath").getter(getter(CreateFleetRequest::serverLaunchPath))
            .setter(setter(Builder::serverLaunchPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchPath").build()).build();

    private static final SdkField<String> SERVER_LAUNCH_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerLaunchParameters").getter(getter(CreateFleetRequest::serverLaunchParameters))
            .setter(setter(Builder::serverLaunchParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchParameters").build())
            .build();

    private static final SdkField<List<String>> LOG_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogPaths")
            .getter(getter(CreateFleetRequest::logPaths))
            .setter(setter(Builder::logPaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2InstanceType").getter(getter(CreateFleetRequest::ec2InstanceTypeAsString))
            .setter(setter(Builder::ec2InstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceType").build()).build();

    private static final SdkField<List<IpPermission>> EC2_INBOUND_PERMISSIONS_FIELD = SdkField
            .<List<IpPermission>> builder(MarshallingType.LIST)
            .memberName("EC2InboundPermissions")
            .getter(getter(CreateFleetRequest::ec2InboundPermissions))
            .setter(setter(Builder::ec2InboundPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InboundPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpPermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpPermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NewGameSessionProtectionPolicy")
            .getter(getter(CreateFleetRequest::newGameSessionProtectionPolicyAsString))
            .setter(setter(Builder::newGameSessionProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy")
                    .build()).build();

    private static final SdkField<RuntimeConfiguration> RUNTIME_CONFIGURATION_FIELD = SdkField
            .<RuntimeConfiguration> builder(MarshallingType.SDK_POJO).memberName("RuntimeConfiguration")
            .getter(getter(CreateFleetRequest::runtimeConfiguration)).setter(setter(Builder::runtimeConfiguration))
            .constructor(RuntimeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfiguration").build())
            .build();

    private static final SdkField<ResourceCreationLimitPolicy> RESOURCE_CREATION_LIMIT_POLICY_FIELD = SdkField
            .<ResourceCreationLimitPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceCreationLimitPolicy")
            .getter(getter(CreateFleetRequest::resourceCreationLimitPolicy))
            .setter(setter(Builder::resourceCreationLimitPolicy))
            .constructor(ResourceCreationLimitPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCreationLimitPolicy")
                    .build()).build();

    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetricGroups")
            .getter(getter(CreateFleetRequest::metricGroups))
            .setter(setter(Builder::metricGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PEER_VPC_AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerVpcAwsAccountId").getter(getter(CreateFleetRequest::peerVpcAwsAccountId))
            .setter(setter(Builder::peerVpcAwsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcAwsAccountId").build())
            .build();

    private static final SdkField<String> PEER_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PeerVpcId").getter(getter(CreateFleetRequest::peerVpcId)).setter(setter(Builder::peerVpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcId").build()).build();

    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetType").getter(getter(CreateFleetRequest::fleetTypeAsString)).setter(setter(Builder::fleetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()).build();

    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceRoleArn").getter(getter(CreateFleetRequest::instanceRoleArn))
            .setter(setter(Builder::instanceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRoleArn").build()).build();

    private static final SdkField<CertificateConfiguration> CERTIFICATE_CONFIGURATION_FIELD = SdkField
            .<CertificateConfiguration> builder(MarshallingType.SDK_POJO).memberName("CertificateConfiguration")
            .getter(getter(CreateFleetRequest::certificateConfiguration)).setter(setter(Builder::certificateConfiguration))
            .constructor(CertificateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateConfiguration").build())
            .build();

    private static final SdkField<List<LocationConfiguration>> LOCATIONS_FIELD = SdkField
            .<List<LocationConfiguration>> builder(MarshallingType.LIST)
            .memberName("Locations")
            .getter(getter(CreateFleetRequest::locations))
            .setter(setter(Builder::locations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LocationConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocationConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFleetRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeType").getter(getter(CreateFleetRequest::computeTypeAsString))
            .setter(setter(Builder::computeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeType").build()).build();

    private static final SdkField<AnywhereConfiguration> ANYWHERE_CONFIGURATION_FIELD = SdkField
            .<AnywhereConfiguration> builder(MarshallingType.SDK_POJO).memberName("AnywhereConfiguration")
            .getter(getter(CreateFleetRequest::anywhereConfiguration)).setter(setter(Builder::anywhereConfiguration))
            .constructor(AnywhereConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnywhereConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            BUILD_ID_FIELD, SCRIPT_ID_FIELD, SERVER_LAUNCH_PATH_FIELD, SERVER_LAUNCH_PARAMETERS_FIELD, LOG_PATHS_FIELD,
            EC2_INSTANCE_TYPE_FIELD, EC2_INBOUND_PERMISSIONS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD,
            RUNTIME_CONFIGURATION_FIELD, RESOURCE_CREATION_LIMIT_POLICY_FIELD, METRIC_GROUPS_FIELD,
            PEER_VPC_AWS_ACCOUNT_ID_FIELD, PEER_VPC_ID_FIELD, FLEET_TYPE_FIELD, INSTANCE_ROLE_ARN_FIELD,
            CERTIFICATE_CONFIGURATION_FIELD, LOCATIONS_FIELD, TAGS_FIELD, COMPUTE_TYPE_FIELD, ANYWHERE_CONFIGURATION_FIELD));

    private final String name;

    private final String description;

    private final String buildId;

    private final String scriptId;

    private final String serverLaunchPath;

    private final String serverLaunchParameters;

    private final List<String> logPaths;

    private final String ec2InstanceType;

    private final List<IpPermission> ec2InboundPermissions;

    private final String newGameSessionProtectionPolicy;

    private final RuntimeConfiguration runtimeConfiguration;

    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;

    private final List<String> metricGroups;

    private final String peerVpcAwsAccountId;

    private final String peerVpcId;

    private final String fleetType;

    private final String instanceRoleArn;

    private final CertificateConfiguration certificateConfiguration;

    private final List<LocationConfiguration> locations;

    private final List<Tag> tags;

    private final String computeType;

    private final AnywhereConfiguration anywhereConfiguration;

    private CreateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.buildId = builder.buildId;
        this.scriptId = builder.scriptId;
        this.serverLaunchPath = builder.serverLaunchPath;
        this.serverLaunchParameters = builder.serverLaunchParameters;
        this.logPaths = builder.logPaths;
        this.ec2InstanceType = builder.ec2InstanceType;
        this.ec2InboundPermissions = builder.ec2InboundPermissions;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.runtimeConfiguration = builder.runtimeConfiguration;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
        this.peerVpcAwsAccountId = builder.peerVpcAwsAccountId;
        this.peerVpcId = builder.peerVpcId;
        this.fleetType = builder.fleetType;
        this.instanceRoleArn = builder.instanceRoleArn;
        this.certificateConfiguration = builder.certificateConfiguration;
        this.locations = builder.locations;
        this.tags = builder.tags;
        this.computeType = builder.computeType;
        this.anywhereConfiguration = builder.anywhereConfiguration;
    }

    /**
     * <p>
     * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the fleet.
     * </p>
     * 
     * @return A description for the fleet.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier for a custom game server build to be deployed on fleet instances. You can use either the
     * build ID or ARN. The build must be uploaded to GameLift and in <code>READY</code> status. This fleet property
     * cannot be changed later.
     * </p>
     * 
     * @return The unique identifier for a custom game server build to be deployed on fleet instances. You can use
     *         either the build ID or ARN. The build must be uploaded to GameLift and in <code>READY</code> status. This
     *         fleet property cannot be changed later.
     */
    public final String buildId() {
        return buildId;
    }

    /**
     * <p>
     * The unique identifier for a Realtime configuration script to be deployed on fleet instances. You can use either
     * the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet. This fleet property
     * cannot be changed later.
     * </p>
     * 
     * @return The unique identifier for a Realtime configuration script to be deployed on fleet instances. You can use
     *         either the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet. This fleet
     *         property cannot be changed later.
     */
    public final String scriptId() {
        return scriptId;
    }

    /**
     * <p>
     * <b>This parameter is no longer used.</b> Specify a server launch path using the <code>RuntimeConfiguration</code>
     * parameter. Requests that use this parameter instead continue to be valid.
     * </p>
     * 
     * @return <b>This parameter is no longer used.</b> Specify a server launch path using the
     *         <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be
     *         valid.
     */
    public final String serverLaunchPath() {
        return serverLaunchPath;
    }

    /**
     * <p>
     * <b>This parameter is no longer used.</b> Specify server launch parameters using the
     * <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.
     * </p>
     * 
     * @return <b>This parameter is no longer used.</b> Specify server launch parameters using the
     *         <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be
     *         valid.
     */
    public final String serverLaunchParameters() {
        return serverLaunchParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogPaths property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogPaths() {
        return logPaths != null && !(logPaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <b>This parameter is no longer used.</b> To specify where GameLift should store log files once a server process
     * shuts down, use the GameLift server API <code>ProcessReady()</code> and specify one or more directory paths in
     * <code>logParameters</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-initialize"
     * >Initialize the server process</a> in the <i>GameLift Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogPaths} method.
     * </p>
     * 
     * @return <b>This parameter is no longer used.</b> To specify where GameLift should store log files once a server
     *         process shuts down, use the GameLift server API <code>ProcessReady()</code> and specify one or more
     *         directory paths in <code>logParameters</code>. For more information, see <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-initialize"
     *         >Initialize the server process</a> in the <i>GameLift Developer Guide</i>.
     */
    public final List<String> logPaths() {
        return logPaths;
    }

    /**
     * <p>
     * The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type determines the
     * computing resources that will be used to host your game servers, including CPU, memory, storage, and networking
     * capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a>
     * for detailed descriptions of Amazon EC2 instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type determines
     *         the computing resources that will be used to host your game servers, including CPU, memory, storage, and
     *         networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud
     *         Instance Types</a> for detailed descriptions of Amazon EC2 instance types.
     * @see EC2InstanceType
     */
    public final EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(ec2InstanceType);
    }

    /**
     * <p>
     * The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type determines the
     * computing resources that will be used to host your game servers, including CPU, memory, storage, and networking
     * capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud Instance Types</a>
     * for detailed descriptions of Amazon EC2 instance types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ec2InstanceType}
     * will return {@link EC2InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ec2InstanceTypeAsString}.
     * </p>
     * 
     * @return The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type determines
     *         the computing resources that will be used to host your game servers, including CPU, memory, storage, and
     *         networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud
     *         Instance Types</a> for detailed descriptions of Amazon EC2 instance types.
     * @see EC2InstanceType
     */
    public final String ec2InstanceTypeAsString() {
        return ec2InstanceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the EC2InboundPermissions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEc2InboundPermissions() {
        return ec2InboundPermissions != null && !(ec2InboundPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this fleet.
     * If the fleet is hosting a custom game build, this property must be set before players can connect to game
     * sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEc2InboundPermissions} method.
     * </p>
     * 
     * @return The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on
     *         this fleet. If the fleet is hosting a custom game build, this property must be set before players can
     *         connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
     */
    public final List<IpPermission> ec2InboundPermissions() {
        return ec2InboundPermissions;
    }

    /**
     * <p>
     * The status of termination protection for active game sessions on the fleet. By default, this property is set to
     * <code>NoProtection</code>. You can also set game session protection for an individual game session by calling <a
     * href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a scale-down
     * event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return The status of termination protection for active game sessions on the fleet. By default, this property is
     *         set to <code>NoProtection</code>. You can also set game session protection for an individual game session
     *         by calling <a href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a scale-down
     *         event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a
     *         scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public final ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(newGameSessionProtectionPolicy);
    }

    /**
     * <p>
     * The status of termination protection for active game sessions on the fleet. By default, this property is set to
     * <code>NoProtection</code>. You can also set game session protection for an individual game session by calling <a
     * href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a scale-down
     * event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return The status of termination protection for active game sessions on the fleet. By default, this property is
     *         set to <code>NoProtection</code>. You can also set game session protection for an individual game session
     *         by calling <a href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a scale-down
     *         event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a
     *         scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public final String newGameSessionProtectionPolicyAsString() {
        return newGameSessionProtectionPolicy;
    }

    /**
     * <p>
     * Instructions for how to launch and maintain server processes on instances in the fleet. The runtime configuration
     * defines one or more server process configurations, each identifying a build executable or Realtime script file
     * and the number of processes of that type to run concurrently.
     * </p>
     * <note>
     * <p>
     * The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the older
     * parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, which are still supported for
     * backward compatibility.
     * </p>
     * </note>
     * 
     * @return Instructions for how to launch and maintain server processes on instances in the fleet. The runtime
     *         configuration defines one or more server process configurations, each identifying a build executable or
     *         Realtime script file and the number of processes of that type to run concurrently. </p> <note>
     *         <p>
     *         The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using
     *         the older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, which are
     *         still supported for backward compatibility.
     *         </p>
     */
    public final RuntimeConfiguration runtimeConfiguration() {
        return runtimeConfiguration;
    }

    /**
     * <p>
     * A policy that limits the number of game sessions that an individual player can create on instances in this fleet
     * within a specified span of time.
     * </p>
     * 
     * @return A policy that limits the number of game sessions that an individual player can create on instances in
     *         this fleet within a specified span of time.
     */
    public final ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return resourceCreationLimitPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricGroups() {
        return metricGroups != null && !(metricGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. A metric group is used to
     * aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to
     * create a new metric group. A fleet can be included in only one metric group at a time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricGroups} method.
     * </p>
     * 
     * @return The name of an Amazon Web Services CloudWatch metric group to add this fleet to. A metric group is used
     *         to aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new
     *         name to create a new metric group. A fleet can be included in only one metric group at a time.
     */
    public final List<String> metricGroups() {
        return metricGroups;
    }

    /**
     * <p>
     * Used when peering your GameLift fleet with a VPC, the unique identifier for the Amazon Web Services account that
     * owns the VPC. You can find your account ID in the Amazon Web Services Management Console under account settings.
     * </p>
     * 
     * @return Used when peering your GameLift fleet with a VPC, the unique identifier for the Amazon Web Services
     *         account that owns the VPC. You can find your account ID in the Amazon Web Services Management Console
     *         under account settings.
     */
    public final String peerVpcAwsAccountId() {
        return peerVpcAwsAccountId;
    }

    /**
     * <p>
     * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the same
     * Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC
     * Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift
     * Fleets</a>.
     * </p>
     * 
     * @return A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in
     *         the same Region as your fleet. To look up a VPC ID, use the <a
     *         href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management
     *         Console. Learn more about VPC peering in <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with
     *         GameLift Fleets</a>.
     */
    public final String peerVpcId() {
        return peerVpcId;
    }

    /**
     * <p>
     * Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to
     * <code>ON_DEMAND</code>. Learn more about when to use <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     * > On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to
     *         <code>ON_DEMAND</code>. Learn more about when to use <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     *         > On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.
     * @see FleetType
     */
    public final FleetType fleetType() {
        return FleetType.fromValue(fleetType);
    }

    /**
     * <p>
     * Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to
     * <code>ON_DEMAND</code>. Learn more about when to use <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     * > On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to
     *         <code>ON_DEMAND</code>. Learn more about when to use <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
     *         > On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.
     * @see FleetType
     */
    public final String fleetTypeAsString() {
        return fleetType;
    }

    /**
     * <p>
     * A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an instance
     * role ARN set, any application that runs on an instance in this fleet can assume the role, including install
     * scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN by using the
     * <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the Amazon Web Services Management Console.
     * Learn more about using on-box credentials for your game servers at <a
     * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access
     * external resources from a game server</a>. This property cannot be changed after the fleet is created.
     * </p>
     * 
     * @return A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an
     *         instance role ARN set, any application that runs on an instance in this fleet can assume the role,
     *         including install scripts, server processes, and daemons (background processes). Create a role or look up
     *         a role's ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the Amazon
     *         Web Services Management Console. Learn more about using on-box credentials for your game servers at <a
     *         href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">
     *         Access external resources from a game server</a>. This property cannot be changed after the fleet is
     *         created.
     */
    public final String instanceRoleArn() {
        return instanceRoleArn;
    }

    /**
     * <p>
     * Prompts GameLift to generate a TLS/SSL certificate for the fleet. GameLift uses the certificates to encrypt
     * traffic between game clients and the game servers running on GameLift. By default, the
     * <code>CertificateConfiguration</code> is <code>DISABLED</code>. You can't change this property after you create
     * the fleet.
     * </p>
     * <p>
     * Certificate Manager (ACM) certificates expire after 13 months. Certificate expiration can cause fleets to fail,
     * preventing players from connecting to instances in the fleet. We recommend you replace fleets before 13 months,
     * consider using fleet aliases for a smooth transition.
     * </p>
     * <note>
     * <p>
     * ACM isn't available in all Amazon Web Services regions. A fleet creation request with certificate generation
     * enabled in an unsupported Region, fails with a 4xx error. For more information about the supported Regions, see
     * <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html">Supported Regions</a> in the
     * <i>Certificate Manager User Guide</i>.
     * </p>
     * </note>
     * 
     * @return Prompts GameLift to generate a TLS/SSL certificate for the fleet. GameLift uses the certificates to
     *         encrypt traffic between game clients and the game servers running on GameLift. By default, the
     *         <code>CertificateConfiguration</code> is <code>DISABLED</code>. You can't change this property after you
     *         create the fleet. </p>
     *         <p>
     *         Certificate Manager (ACM) certificates expire after 13 months. Certificate expiration can cause fleets to
     *         fail, preventing players from connecting to instances in the fleet. We recommend you replace fleets
     *         before 13 months, consider using fleet aliases for a smooth transition.
     *         </p>
     *         <note>
     *         <p>
     *         ACM isn't available in all Amazon Web Services regions. A fleet creation request with certificate
     *         generation enabled in an unsupported Region, fails with a 4xx error. For more information about the
     *         supported Regions, see <a
     *         href="https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html">Supported Regions</a> in the
     *         <i>Certificate Manager User Guide</i>.
     *         </p>
     */
    public final CertificateConfiguration certificateConfiguration() {
        return certificateConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Locations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLocations() {
        return locations != null && !(locations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter can
     * only be used when creating fleets in Amazon Web Services Regions that support multiple locations. You can add any
     * GameLift-supported Amazon Web Services Region as a remote location, in the form of an Amazon Web Services Region
     * code such as <code>us-west-2</code>. To create a fleet with instances in the home Region only, omit this
     * parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocations} method.
     * </p>
     * 
     * @return A set of remote locations to deploy additional instances to and manage as part of the fleet. This
     *         parameter can only be used when creating fleets in Amazon Web Services Regions that support multiple
     *         locations. You can add any GameLift-supported Amazon Web Services Region as a remote location, in the
     *         form of an Amazon Web Services Region code such as <code>us-west-2</code>. To create a fleet with
     *         instances in the home Region only, omit this parameter.
     */
    public final List<LocationConfiguration> locations() {
        return locations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging Amazon
     * Web Services resources are useful for resource management, access management and cost allocation. For more
     * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web
     * Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging
     *         Amazon Web Services resources are useful for resource management, access management and cost allocation.
     *         For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">
     *         Tagging Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of compute resource used to host your game servers. You can use your own compute resources with GameLift
     * Anywhere or use Amazon EC2 instances with managed GameLift.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return The type of compute resource used to host your game servers. You can use your own compute resources with
     *         GameLift Anywhere or use Amazon EC2 instances with managed GameLift.
     * @see ComputeType
     */
    public final ComputeType computeType() {
        return ComputeType.fromValue(computeType);
    }

    /**
     * <p>
     * The type of compute resource used to host your game servers. You can use your own compute resources with GameLift
     * Anywhere or use Amazon EC2 instances with managed GameLift.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return The type of compute resource used to host your game servers. You can use your own compute resources with
     *         GameLift Anywhere or use Amazon EC2 instances with managed GameLift.
     * @see ComputeType
     */
    public final String computeTypeAsString() {
        return computeType;
    }

    /**
     * <p>
     * GameLift Anywhere configuration options.
     * </p>
     * 
     * @return GameLift Anywhere configuration options.
     */
    public final AnywhereConfiguration anywhereConfiguration() {
        return anywhereConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(buildId());
        hashCode = 31 * hashCode + Objects.hashCode(scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(serverLaunchPath());
        hashCode = 31 * hashCode + Objects.hashCode(serverLaunchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogPaths() ? logPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2InboundPermissions() ? ec2InboundPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricGroups() ? metricGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocations() ? locations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(anywhereConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(buildId(), other.buildId()) && Objects.equals(scriptId(), other.scriptId())
                && Objects.equals(serverLaunchPath(), other.serverLaunchPath())
                && Objects.equals(serverLaunchParameters(), other.serverLaunchParameters())
                && hasLogPaths() == other.hasLogPaths() && Objects.equals(logPaths(), other.logPaths())
                && Objects.equals(ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString())
                && hasEc2InboundPermissions() == other.hasEc2InboundPermissions()
                && Objects.equals(ec2InboundPermissions(), other.ec2InboundPermissions())
                && Objects.equals(newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString())
                && Objects.equals(runtimeConfiguration(), other.runtimeConfiguration())
                && Objects.equals(resourceCreationLimitPolicy(), other.resourceCreationLimitPolicy())
                && hasMetricGroups() == other.hasMetricGroups() && Objects.equals(metricGroups(), other.metricGroups())
                && Objects.equals(peerVpcAwsAccountId(), other.peerVpcAwsAccountId())
                && Objects.equals(peerVpcId(), other.peerVpcId())
                && Objects.equals(fleetTypeAsString(), other.fleetTypeAsString())
                && Objects.equals(instanceRoleArn(), other.instanceRoleArn())
                && Objects.equals(certificateConfiguration(), other.certificateConfiguration())
                && hasLocations() == other.hasLocations() && Objects.equals(locations(), other.locations())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(computeTypeAsString(), other.computeTypeAsString())
                && Objects.equals(anywhereConfiguration(), other.anywhereConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFleetRequest").add("Name", name()).add("Description", description())
                .add("BuildId", buildId()).add("ScriptId", scriptId()).add("ServerLaunchPath", serverLaunchPath())
                .add("ServerLaunchParameters", serverLaunchParameters()).add("LogPaths", hasLogPaths() ? logPaths() : null)
                .add("EC2InstanceType", ec2InstanceTypeAsString())
                .add("EC2InboundPermissions", hasEc2InboundPermissions() ? ec2InboundPermissions() : null)
                .add("NewGameSessionProtectionPolicy", newGameSessionProtectionPolicyAsString())
                .add("RuntimeConfiguration", runtimeConfiguration())
                .add("ResourceCreationLimitPolicy", resourceCreationLimitPolicy())
                .add("MetricGroups", hasMetricGroups() ? metricGroups() : null).add("PeerVpcAwsAccountId", peerVpcAwsAccountId())
                .add("PeerVpcId", peerVpcId()).add("FleetType", fleetTypeAsString()).add("InstanceRoleArn", instanceRoleArn())
                .add("CertificateConfiguration", certificateConfiguration())
                .add("Locations", hasLocations() ? locations() : null).add("Tags", hasTags() ? tags() : null)
                .add("ComputeType", computeTypeAsString()).add("AnywhereConfiguration", anywhereConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "BuildId":
            return Optional.ofNullable(clazz.cast(buildId()));
        case "ScriptId":
            return Optional.ofNullable(clazz.cast(scriptId()));
        case "ServerLaunchPath":
            return Optional.ofNullable(clazz.cast(serverLaunchPath()));
        case "ServerLaunchParameters":
            return Optional.ofNullable(clazz.cast(serverLaunchParameters()));
        case "LogPaths":
            return Optional.ofNullable(clazz.cast(logPaths()));
        case "EC2InstanceType":
            return Optional.ofNullable(clazz.cast(ec2InstanceTypeAsString()));
        case "EC2InboundPermissions":
            return Optional.ofNullable(clazz.cast(ec2InboundPermissions()));
        case "NewGameSessionProtectionPolicy":
            return Optional.ofNullable(clazz.cast(newGameSessionProtectionPolicyAsString()));
        case "RuntimeConfiguration":
            return Optional.ofNullable(clazz.cast(runtimeConfiguration()));
        case "ResourceCreationLimitPolicy":
            return Optional.ofNullable(clazz.cast(resourceCreationLimitPolicy()));
        case "MetricGroups":
            return Optional.ofNullable(clazz.cast(metricGroups()));
        case "PeerVpcAwsAccountId":
            return Optional.ofNullable(clazz.cast(peerVpcAwsAccountId()));
        case "PeerVpcId":
            return Optional.ofNullable(clazz.cast(peerVpcId()));
        case "FleetType":
            return Optional.ofNullable(clazz.cast(fleetTypeAsString()));
        case "InstanceRoleArn":
            return Optional.ofNullable(clazz.cast(instanceRoleArn()));
        case "CertificateConfiguration":
            return Optional.ofNullable(clazz.cast(certificateConfiguration()));
        case "Locations":
            return Optional.ofNullable(clazz.cast(locations()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ComputeType":
            return Optional.ofNullable(clazz.cast(computeTypeAsString()));
        case "AnywhereConfiguration":
            return Optional.ofNullable(clazz.cast(anywhereConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetRequest, T> g) {
        return obj -> g.apply((CreateFleetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFleetRequest> {
        /**
         * <p>
         * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the fleet.
         * </p>
         * 
         * @param description
         *        A description for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier for a custom game server build to be deployed on fleet instances. You can use either
         * the build ID or ARN. The build must be uploaded to GameLift and in <code>READY</code> status. This fleet
         * property cannot be changed later.
         * </p>
         * 
         * @param buildId
         *        The unique identifier for a custom game server build to be deployed on fleet instances. You can use
         *        either the build ID or ARN. The build must be uploaded to GameLift and in <code>READY</code> status.
         *        This fleet property cannot be changed later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildId(String buildId);

        /**
         * <p>
         * The unique identifier for a Realtime configuration script to be deployed on fleet instances. You can use
         * either the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet. This fleet
         * property cannot be changed later.
         * </p>
         * 
         * @param scriptId
         *        The unique identifier for a Realtime configuration script to be deployed on fleet instances. You can
         *        use either the script ID or ARN. Scripts must be uploaded to GameLift prior to creating the fleet.
         *        This fleet property cannot be changed later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptId(String scriptId);

        /**
         * <p>
         * <b>This parameter is no longer used.</b> Specify a server launch path using the
         * <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.
         * </p>
         * 
         * @param serverLaunchPath
         *        <b>This parameter is no longer used.</b> Specify a server launch path using the
         *        <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be
         *        valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverLaunchPath(String serverLaunchPath);

        /**
         * <p>
         * <b>This parameter is no longer used.</b> Specify server launch parameters using the
         * <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be valid.
         * </p>
         * 
         * @param serverLaunchParameters
         *        <b>This parameter is no longer used.</b> Specify server launch parameters using the
         *        <code>RuntimeConfiguration</code> parameter. Requests that use this parameter instead continue to be
         *        valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverLaunchParameters(String serverLaunchParameters);

        /**
         * <p>
         * <b>This parameter is no longer used.</b> To specify where GameLift should store log files once a server
         * process shuts down, use the GameLift server API <code>ProcessReady()</code> and specify one or more directory
         * paths in <code>logParameters</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-initialize"
         * >Initialize the server process</a> in the <i>GameLift Developer Guide</i>.
         * </p>
         * 
         * @param logPaths
         *        <b>This parameter is no longer used.</b> To specify where GameLift should store log files once a
         *        server process shuts down, use the GameLift server API <code>ProcessReady()</code> and specify one or
         *        more directory paths in <code>logParameters</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-initialize"
         *        >Initialize the server process</a> in the <i>GameLift Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPaths(Collection<String> logPaths);

        /**
         * <p>
         * <b>This parameter is no longer used.</b> To specify where GameLift should store log files once a server
         * process shuts down, use the GameLift server API <code>ProcessReady()</code> and specify one or more directory
         * paths in <code>logParameters</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-initialize"
         * >Initialize the server process</a> in the <i>GameLift Developer Guide</i>.
         * </p>
         * 
         * @param logPaths
         *        <b>This parameter is no longer used.</b> To specify where GameLift should store log files once a
         *        server process shuts down, use the GameLift server API <code>ProcessReady()</code> and specify one or
         *        more directory paths in <code>logParameters</code>. For more information, see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-initialize"
         *        >Initialize the server process</a> in the <i>GameLift Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPaths(String... logPaths);

        /**
         * <p>
         * The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type determines the
         * computing resources that will be used to host your game servers, including CPU, memory, storage, and
         * networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud
         * Instance Types</a> for detailed descriptions of Amazon EC2 instance types.
         * </p>
         * 
         * @param ec2InstanceType
         *        The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type
         *        determines the computing resources that will be used to host your game servers, including CPU, memory,
         *        storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon
         *        Elastic Compute Cloud Instance Types</a> for detailed descriptions of Amazon EC2 instance types.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder ec2InstanceType(String ec2InstanceType);

        /**
         * <p>
         * The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type determines the
         * computing resources that will be used to host your game servers, including CPU, memory, storage, and
         * networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon Elastic Compute Cloud
         * Instance Types</a> for detailed descriptions of Amazon EC2 instance types.
         * </p>
         * 
         * @param ec2InstanceType
         *        The GameLift-supported Amazon EC2 instance type to use for all fleet instances. Instance type
         *        determines the computing resources that will be used to host your game servers, including CPU, memory,
         *        storage, and networking capacity. See <a href="http://aws.amazon.com/ec2/instance-types/">Amazon
         *        Elastic Compute Cloud Instance Types</a> for detailed descriptions of Amazon EC2 instance types.
         * @see EC2InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EC2InstanceType
         */
        Builder ec2InstanceType(EC2InstanceType ec2InstanceType);

        /**
         * <p>
         * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this
         * fleet. If the fleet is hosting a custom game build, this property must be set before players can connect to
         * game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
         * </p>
         * 
         * @param ec2InboundPermissions
         *        The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on
         *        this fleet. If the fleet is hosting a custom game build, this property must be set before players can
         *        connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InboundPermissions(Collection<IpPermission> ec2InboundPermissions);

        /**
         * <p>
         * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this
         * fleet. If the fleet is hosting a custom game build, this property must be set before players can connect to
         * game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
         * </p>
         * 
         * @param ec2InboundPermissions
         *        The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on
         *        this fleet. If the fleet is hosting a custom game build, this property must be set before players can
         *        connect to game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InboundPermissions(IpPermission... ec2InboundPermissions);

        /**
         * <p>
         * The allowed IP address ranges and port settings that allow inbound traffic to access game sessions on this
         * fleet. If the fleet is hosting a custom game build, this property must be set before players can connect to
         * game sessions. For Realtime Servers fleets, GameLift automatically sets TCP and UDP ranges.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.gamelift.model.IpPermission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder#build()} is called immediately and
         * its result is passed to {@link #ec2InboundPermissions(List<IpPermission>)}.
         * 
         * @param ec2InboundPermissions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.IpPermission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InboundPermissions(java.util.Collection<IpPermission>)
         */
        Builder ec2InboundPermissions(Consumer<IpPermission.Builder>... ec2InboundPermissions);

        /**
         * <p>
         * The status of termination protection for active game sessions on the fleet. By default, this property is set
         * to <code>NoProtection</code>. You can also set game session protection for an individual game session by
         * calling <a href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a scale-down
         * event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a scale-down
         * event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newGameSessionProtectionPolicy
         *        The status of termination protection for active game sessions on the fleet. By default, this property
         *        is set to <code>NoProtection</code>. You can also set game session protection for an individual game
         *        session by calling <a
         *        href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a
         *        scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a
         *        scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy);

        /**
         * <p>
         * The status of termination protection for active game sessions on the fleet. By default, this property is set
         * to <code>NoProtection</code>. You can also set game session protection for an individual game session by
         * calling <a href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a scale-down
         * event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a scale-down
         * event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newGameSessionProtectionPolicy
         *        The status of termination protection for active game sessions on the fleet. By default, this property
         *        is set to <code>NoProtection</code>. You can also set game session protection for an individual game
         *        session by calling <a
         *        href="gamelift/latest/apireference/API_UpdateGameSession.html">UpdateGameSession</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> - Game sessions can be terminated during active gameplay as a result of a
         *        scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> - Game sessions in <code>ACTIVE</code> status cannot be terminated during a
         *        scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy);

        /**
         * <p>
         * Instructions for how to launch and maintain server processes on instances in the fleet. The runtime
         * configuration defines one or more server process configurations, each identifying a build executable or
         * Realtime script file and the number of processes of that type to run concurrently.
         * </p>
         * <note>
         * <p>
         * The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the
         * older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, which are still
         * supported for backward compatibility.
         * </p>
         * </note>
         * 
         * @param runtimeConfiguration
         *        Instructions for how to launch and maintain server processes on instances in the fleet. The runtime
         *        configuration defines one or more server process configurations, each identifying a build executable
         *        or Realtime script file and the number of processes of that type to run concurrently. </p> <note>
         *        <p>
         *        The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using
         *        the older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, which are
         *        still supported for backward compatibility.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration);

        /**
         * <p>
         * Instructions for how to launch and maintain server processes on instances in the fleet. The runtime
         * configuration defines one or more server process configurations, each identifying a build executable or
         * Realtime script file and the number of processes of that type to run concurrently.
         * </p>
         * <note>
         * <p>
         * The <code>RuntimeConfiguration</code> parameter is required unless the fleet is being configured using the
         * older parameters <code>ServerLaunchPath</code> and <code>ServerLaunchParameters</code>, which are still
         * supported for backward compatibility.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link RuntimeConfiguration.Builder}
         * avoiding the need to create one manually via {@link RuntimeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuntimeConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #runtimeConfiguration(RuntimeConfiguration)}.
         * 
         * @param runtimeConfiguration
         *        a consumer that will call methods on {@link RuntimeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeConfiguration(RuntimeConfiguration)
         */
        default Builder runtimeConfiguration(Consumer<RuntimeConfiguration.Builder> runtimeConfiguration) {
            return runtimeConfiguration(RuntimeConfiguration.builder().applyMutation(runtimeConfiguration).build());
        }

        /**
         * <p>
         * A policy that limits the number of game sessions that an individual player can create on instances in this
         * fleet within a specified span of time.
         * </p>
         * 
         * @param resourceCreationLimitPolicy
         *        A policy that limits the number of game sessions that an individual player can create on instances in
         *        this fleet within a specified span of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy);

        /**
         * <p>
         * A policy that limits the number of game sessions that an individual player can create on instances in this
         * fleet within a specified span of time.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceCreationLimitPolicy.Builder}
         * avoiding the need to create one manually via {@link ResourceCreationLimitPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCreationLimitPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceCreationLimitPolicy(ResourceCreationLimitPolicy)}.
         * 
         * @param resourceCreationLimitPolicy
         *        a consumer that will call methods on {@link ResourceCreationLimitPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCreationLimitPolicy(ResourceCreationLimitPolicy)
         */
        default Builder resourceCreationLimitPolicy(Consumer<ResourceCreationLimitPolicy.Builder> resourceCreationLimitPolicy) {
            return resourceCreationLimitPolicy(ResourceCreationLimitPolicy.builder().applyMutation(resourceCreationLimitPolicy)
                    .build());
        }

        /**
         * <p>
         * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. A metric group is used to
         * aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to
         * create a new metric group. A fleet can be included in only one metric group at a time.
         * </p>
         * 
         * @param metricGroups
         *        The name of an Amazon Web Services CloudWatch metric group to add this fleet to. A metric group is
         *        used to aggregate the metrics for multiple fleets. You can specify an existing metric group name or
         *        set a new name to create a new metric group. A fleet can be included in only one metric group at a
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(Collection<String> metricGroups);

        /**
         * <p>
         * The name of an Amazon Web Services CloudWatch metric group to add this fleet to. A metric group is used to
         * aggregate the metrics for multiple fleets. You can specify an existing metric group name or set a new name to
         * create a new metric group. A fleet can be included in only one metric group at a time.
         * </p>
         * 
         * @param metricGroups
         *        The name of an Amazon Web Services CloudWatch metric group to add this fleet to. A metric group is
         *        used to aggregate the metrics for multiple fleets. You can specify an existing metric group name or
         *        set a new name to create a new metric group. A fleet can be included in only one metric group at a
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(String... metricGroups);

        /**
         * <p>
         * Used when peering your GameLift fleet with a VPC, the unique identifier for the Amazon Web Services account
         * that owns the VPC. You can find your account ID in the Amazon Web Services Management Console under account
         * settings.
         * </p>
         * 
         * @param peerVpcAwsAccountId
         *        Used when peering your GameLift fleet with a VPC, the unique identifier for the Amazon Web Services
         *        account that owns the VPC. You can find your account ID in the Amazon Web Services Management Console
         *        under account settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcAwsAccountId(String peerVpcAwsAccountId);

        /**
         * <p>
         * A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in the
         * same Region as your fleet. To look up a VPC ID, use the <a href="https://console.aws.amazon.com/vpc/">VPC
         * Dashboard</a> in the Amazon Web Services Management Console. Learn more about VPC peering in <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with GameLift
         * Fleets</a>.
         * </p>
         * 
         * @param peerVpcId
         *        A unique identifier for a VPC with resources to be accessed by your GameLift fleet. The VPC must be in
         *        the same Region as your fleet. To look up a VPC ID, use the <a
         *        href="https://console.aws.amazon.com/vpc/">VPC Dashboard</a> in the Amazon Web Services Management
         *        Console. Learn more about VPC peering in <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html">VPC Peering with
         *        GameLift Fleets</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcId(String peerVpcId);

        /**
         * <p>
         * Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to
         * <code>ON_DEMAND</code>. Learn more about when to use <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         * > On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.
         * </p>
         * 
         * @param fleetType
         *        Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set
         *        to <code>ON_DEMAND</code>. Learn more about when to use <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         *        > On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(String fleetType);

        /**
         * <p>
         * Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set to
         * <code>ON_DEMAND</code>. Learn more about when to use <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         * > On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.
         * </p>
         * 
         * @param fleetType
         *        Indicates whether to use On-Demand or Spot instances for this fleet. By default, this property is set
         *        to <code>ON_DEMAND</code>. Learn more about when to use <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-ec2-instances.html#gamelift-ec2-instances-spot"
         *        > On-Demand versus Spot Instances</a>. This property cannot be changed after the fleet is created.
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(FleetType fleetType);

        /**
         * <p>
         * A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an
         * instance role ARN set, any application that runs on an instance in this fleet can assume the role, including
         * install scripts, server processes, and daemons (background processes). Create a role or look up a role's ARN
         * by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the Amazon Web Services
         * Management Console. Learn more about using on-box credentials for your game servers at <a
         * href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html"> Access
         * external resources from a game server</a>. This property cannot be changed after the fleet is created.
         * </p>
         * 
         * @param instanceRoleArn
         *        A unique identifier for an IAM role that manages access to your Amazon Web Services services. With an
         *        instance role ARN set, any application that runs on an instance in this fleet can assume the role,
         *        including install scripts, server processes, and daemons (background processes). Create a role or look
         *        up a role's ARN by using the <a href="https://console.aws.amazon.com/iam/">IAM dashboard</a> in the
         *        Amazon Web Services Management Console. Learn more about using on-box credentials for your game
         *        servers at <a
         *        href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html">
         *        Access external resources from a game server</a>. This property cannot be changed after the fleet is
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceRoleArn(String instanceRoleArn);

        /**
         * <p>
         * Prompts GameLift to generate a TLS/SSL certificate for the fleet. GameLift uses the certificates to encrypt
         * traffic between game clients and the game servers running on GameLift. By default, the
         * <code>CertificateConfiguration</code> is <code>DISABLED</code>. You can't change this property after you
         * create the fleet.
         * </p>
         * <p>
         * Certificate Manager (ACM) certificates expire after 13 months. Certificate expiration can cause fleets to
         * fail, preventing players from connecting to instances in the fleet. We recommend you replace fleets before 13
         * months, consider using fleet aliases for a smooth transition.
         * </p>
         * <note>
         * <p>
         * ACM isn't available in all Amazon Web Services regions. A fleet creation request with certificate generation
         * enabled in an unsupported Region, fails with a 4xx error. For more information about the supported Regions,
         * see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html">Supported Regions</a> in the
         * <i>Certificate Manager User Guide</i>.
         * </p>
         * </note>
         * 
         * @param certificateConfiguration
         *        Prompts GameLift to generate a TLS/SSL certificate for the fleet. GameLift uses the certificates to
         *        encrypt traffic between game clients and the game servers running on GameLift. By default, the
         *        <code>CertificateConfiguration</code> is <code>DISABLED</code>. You can't change this property after
         *        you create the fleet. </p>
         *        <p>
         *        Certificate Manager (ACM) certificates expire after 13 months. Certificate expiration can cause fleets
         *        to fail, preventing players from connecting to instances in the fleet. We recommend you replace fleets
         *        before 13 months, consider using fleet aliases for a smooth transition.
         *        </p>
         *        <note>
         *        <p>
         *        ACM isn't available in all Amazon Web Services regions. A fleet creation request with certificate
         *        generation enabled in an unsupported Region, fails with a 4xx error. For more information about the
         *        supported Regions, see <a
         *        href="https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html">Supported Regions</a> in the
         *        <i>Certificate Manager User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateConfiguration(CertificateConfiguration certificateConfiguration);

        /**
         * <p>
         * Prompts GameLift to generate a TLS/SSL certificate for the fleet. GameLift uses the certificates to encrypt
         * traffic between game clients and the game servers running on GameLift. By default, the
         * <code>CertificateConfiguration</code> is <code>DISABLED</code>. You can't change this property after you
         * create the fleet.
         * </p>
         * <p>
         * Certificate Manager (ACM) certificates expire after 13 months. Certificate expiration can cause fleets to
         * fail, preventing players from connecting to instances in the fleet. We recommend you replace fleets before 13
         * months, consider using fleet aliases for a smooth transition.
         * </p>
         * <note>
         * <p>
         * ACM isn't available in all Amazon Web Services regions. A fleet creation request with certificate generation
         * enabled in an unsupported Region, fails with a 4xx error. For more information about the supported Regions,
         * see <a href="https://docs.aws.amazon.com/acm/latest/userguide/acm-regions.html">Supported Regions</a> in the
         * <i>Certificate Manager User Guide</i>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link CertificateConfiguration.Builder}
         * avoiding the need to create one manually via {@link CertificateConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CertificateConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #certificateConfiguration(CertificateConfiguration)}.
         * 
         * @param certificateConfiguration
         *        a consumer that will call methods on {@link CertificateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateConfiguration(CertificateConfiguration)
         */
        default Builder certificateConfiguration(Consumer<CertificateConfiguration.Builder> certificateConfiguration) {
            return certificateConfiguration(CertificateConfiguration.builder().applyMutation(certificateConfiguration).build());
        }

        /**
         * <p>
         * A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter
         * can only be used when creating fleets in Amazon Web Services Regions that support multiple locations. You can
         * add any GameLift-supported Amazon Web Services Region as a remote location, in the form of an Amazon Web
         * Services Region code such as <code>us-west-2</code>. To create a fleet with instances in the home Region
         * only, omit this parameter.
         * </p>
         * 
         * @param locations
         *        A set of remote locations to deploy additional instances to and manage as part of the fleet. This
         *        parameter can only be used when creating fleets in Amazon Web Services Regions that support multiple
         *        locations. You can add any GameLift-supported Amazon Web Services Region as a remote location, in the
         *        form of an Amazon Web Services Region code such as <code>us-west-2</code>. To create a fleet with
         *        instances in the home Region only, omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(Collection<LocationConfiguration> locations);

        /**
         * <p>
         * A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter
         * can only be used when creating fleets in Amazon Web Services Regions that support multiple locations. You can
         * add any GameLift-supported Amazon Web Services Region as a remote location, in the form of an Amazon Web
         * Services Region code such as <code>us-west-2</code>. To create a fleet with instances in the home Region
         * only, omit this parameter.
         * </p>
         * 
         * @param locations
         *        A set of remote locations to deploy additional instances to and manage as part of the fleet. This
         *        parameter can only be used when creating fleets in Amazon Web Services Regions that support multiple
         *        locations. You can add any GameLift-supported Amazon Web Services Region as a remote location, in the
         *        form of an Amazon Web Services Region code such as <code>us-west-2</code>. To create a fleet with
         *        instances in the home Region only, omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locations(LocationConfiguration... locations);

        /**
         * <p>
         * A set of remote locations to deploy additional instances to and manage as part of the fleet. This parameter
         * can only be used when creating fleets in Amazon Web Services Regions that support multiple locations. You can
         * add any GameLift-supported Amazon Web Services Region as a remote location, in the form of an Amazon Web
         * Services Region code such as <code>us-west-2</code>. To create a fleet with instances in the home Region
         * only, omit this parameter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.LocationConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.gamelift.model.LocationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.LocationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #locations(List<LocationConfiguration>)}.
         * 
         * @param locations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.LocationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #locations(java.util.Collection<LocationConfiguration>)
         */
        Builder locations(Consumer<LocationConfiguration.Builder>... locations);

        /**
         * <p>
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging
         * Amazon Web Services resources are useful for resource management, access management and cost allocation. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging
         * Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs.
         *        Tagging Amazon Web Services resources are useful for resource management, access management and cost
         *        allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         *        Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging
         * Amazon Web Services resources are useful for resource management, access management and cost allocation. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging
         * Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param tags
         *        A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs.
         *        Tagging Amazon Web Services resources are useful for resource management, access management and cost
         *        allocation. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging Amazon Web Services
         *        Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of labels to assign to the new fleet resource. Tags are developer-defined key-value pairs. Tagging
         * Amazon Web Services resources are useful for resource management, access management and cost allocation. For
         * more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html"> Tagging
         * Amazon Web Services Resources</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.gamelift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.gamelift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The type of compute resource used to host your game servers. You can use your own compute resources with
         * GameLift Anywhere or use Amazon EC2 instances with managed GameLift.
         * </p>
         * 
         * @param computeType
         *        The type of compute resource used to host your game servers. You can use your own compute resources
         *        with GameLift Anywhere or use Amazon EC2 instances with managed GameLift.
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(String computeType);

        /**
         * <p>
         * The type of compute resource used to host your game servers. You can use your own compute resources with
         * GameLift Anywhere or use Amazon EC2 instances with managed GameLift.
         * </p>
         * 
         * @param computeType
         *        The type of compute resource used to host your game servers. You can use your own compute resources
         *        with GameLift Anywhere or use Amazon EC2 instances with managed GameLift.
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(ComputeType computeType);

        /**
         * <p>
         * GameLift Anywhere configuration options.
         * </p>
         * 
         * @param anywhereConfiguration
         *        GameLift Anywhere configuration options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anywhereConfiguration(AnywhereConfiguration anywhereConfiguration);

        /**
         * <p>
         * GameLift Anywhere configuration options.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnywhereConfiguration.Builder} avoiding
         * the need to create one manually via {@link AnywhereConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnywhereConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #anywhereConfiguration(AnywhereConfiguration)}.
         * 
         * @param anywhereConfiguration
         *        a consumer that will call methods on {@link AnywhereConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anywhereConfiguration(AnywhereConfiguration)
         */
        default Builder anywhereConfiguration(Consumer<AnywhereConfiguration.Builder> anywhereConfiguration) {
            return anywhereConfiguration(AnywhereConfiguration.builder().applyMutation(anywhereConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String buildId;

        private String scriptId;

        private String serverLaunchPath;

        private String serverLaunchParameters;

        private List<String> logPaths = DefaultSdkAutoConstructList.getInstance();

        private String ec2InstanceType;

        private List<IpPermission> ec2InboundPermissions = DefaultSdkAutoConstructList.getInstance();

        private String newGameSessionProtectionPolicy;

        private RuntimeConfiguration runtimeConfiguration;

        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;

        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();

        private String peerVpcAwsAccountId;

        private String peerVpcId;

        private String fleetType;

        private String instanceRoleArn;

        private CertificateConfiguration certificateConfiguration;

        private List<LocationConfiguration> locations = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String computeType;

        private AnywhereConfiguration anywhereConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            buildId(model.buildId);
            scriptId(model.scriptId);
            serverLaunchPath(model.serverLaunchPath);
            serverLaunchParameters(model.serverLaunchParameters);
            logPaths(model.logPaths);
            ec2InstanceType(model.ec2InstanceType);
            ec2InboundPermissions(model.ec2InboundPermissions);
            newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            runtimeConfiguration(model.runtimeConfiguration);
            resourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            metricGroups(model.metricGroups);
            peerVpcAwsAccountId(model.peerVpcAwsAccountId);
            peerVpcId(model.peerVpcId);
            fleetType(model.fleetType);
            instanceRoleArn(model.instanceRoleArn);
            certificateConfiguration(model.certificateConfiguration);
            locations(model.locations);
            tags(model.tags);
            computeType(model.computeType);
            anywhereConfiguration(model.anywhereConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBuildId() {
            return buildId;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final String getScriptId() {
            return scriptId;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        @Override
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final String getServerLaunchPath() {
            return serverLaunchPath;
        }

        public final void setServerLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
        }

        @Override
        public final Builder serverLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
            return this;
        }

        public final String getServerLaunchParameters() {
            return serverLaunchParameters;
        }

        public final void setServerLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
        }

        @Override
        public final Builder serverLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
            return this;
        }

        public final Collection<String> getLogPaths() {
            if (logPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return logPaths;
        }

        public final void setLogPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
        }

        @Override
        public final Builder logPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPaths(String... logPaths) {
            logPaths(Arrays.asList(logPaths));
            return this;
        }

        public final String getEc2InstanceType() {
            return ec2InstanceType;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType == null ? null : ec2InstanceType.toString());
            return this;
        }

        public final List<IpPermission.Builder> getEc2InboundPermissions() {
            List<IpPermission.Builder> result = IpPermissionsListCopier.copyToBuilder(this.ec2InboundPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InboundPermissions(Collection<IpPermission.BuilderImpl> ec2InboundPermissions) {
            this.ec2InboundPermissions = IpPermissionsListCopier.copyFromBuilder(ec2InboundPermissions);
        }

        @Override
        public final Builder ec2InboundPermissions(Collection<IpPermission> ec2InboundPermissions) {
            this.ec2InboundPermissions = IpPermissionsListCopier.copy(ec2InboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InboundPermissions(IpPermission... ec2InboundPermissions) {
            ec2InboundPermissions(Arrays.asList(ec2InboundPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InboundPermissions(Consumer<IpPermission.Builder>... ec2InboundPermissions) {
            ec2InboundPermissions(Stream.of(ec2InboundPermissions).map(c -> IpPermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNewGameSessionProtectionPolicy() {
            return newGameSessionProtectionPolicy;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy
                    .toString());
            return this;
        }

        public final RuntimeConfiguration.Builder getRuntimeConfiguration() {
            return runtimeConfiguration != null ? runtimeConfiguration.toBuilder() : null;
        }

        public final void setRuntimeConfiguration(RuntimeConfiguration.BuilderImpl runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration != null ? runtimeConfiguration.build() : null;
        }

        @Override
        public final Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        public final ResourceCreationLimitPolicy.Builder getResourceCreationLimitPolicy() {
            return resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.toBuilder() : null;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy.BuilderImpl resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.build() : null;
        }

        @Override
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final Collection<String> getMetricGroups() {
            if (metricGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return metricGroups;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String... metricGroups) {
            metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final String getPeerVpcAwsAccountId() {
            return peerVpcAwsAccountId;
        }

        public final void setPeerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
        }

        @Override
        public final Builder peerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
            return this;
        }

        public final String getPeerVpcId() {
            return peerVpcId;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final String getFleetType() {
            return fleetType;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType == null ? null : fleetType.toString());
            return this;
        }

        public final String getInstanceRoleArn() {
            return instanceRoleArn;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        @Override
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        public final CertificateConfiguration.Builder getCertificateConfiguration() {
            return certificateConfiguration != null ? certificateConfiguration.toBuilder() : null;
        }

        public final void setCertificateConfiguration(CertificateConfiguration.BuilderImpl certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration != null ? certificateConfiguration.build() : null;
        }

        @Override
        public final Builder certificateConfiguration(CertificateConfiguration certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration;
            return this;
        }

        public final List<LocationConfiguration.Builder> getLocations() {
            List<LocationConfiguration.Builder> result = LocationConfigurationListCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<LocationConfiguration.BuilderImpl> locations) {
            this.locations = LocationConfigurationListCopier.copyFromBuilder(locations);
        }

        @Override
        public final Builder locations(Collection<LocationConfiguration> locations) {
            this.locations = LocationConfigurationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(LocationConfiguration... locations) {
            locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<LocationConfiguration.Builder>... locations) {
            locations(Stream.of(locations).map(c -> LocationConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getComputeType() {
            return computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final AnywhereConfiguration.Builder getAnywhereConfiguration() {
            return anywhereConfiguration != null ? anywhereConfiguration.toBuilder() : null;
        }

        public final void setAnywhereConfiguration(AnywhereConfiguration.BuilderImpl anywhereConfiguration) {
            this.anywhereConfiguration = anywhereConfiguration != null ? anywhereConfiguration.build() : null;
        }

        @Override
        public final Builder anywhereConfiguration(AnywhereConfiguration anywhereConfiguration) {
            this.anywhereConfiguration = anywhereConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
