/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftAsyncClient;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetLocationAttributesResponse;

public class DescribeFleetLocationAttributesPublisher
implements SdkPublisher<DescribeFleetLocationAttributesResponse> {
    private final GameLiftAsyncClient client;
    private final DescribeFleetLocationAttributesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeFleetLocationAttributesPublisher(GameLiftAsyncClient client, DescribeFleetLocationAttributesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeFleetLocationAttributesPublisher(GameLiftAsyncClient client, DescribeFleetLocationAttributesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeFleetLocationAttributesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeFleetLocationAttributesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeFleetLocationAttributesResponseFetcher
    implements AsyncPageFetcher<DescribeFleetLocationAttributesResponse> {
        private DescribeFleetLocationAttributesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetLocationAttributesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeFleetLocationAttributesResponse> nextPage(DescribeFleetLocationAttributesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetLocationAttributesPublisher.this.client.describeFleetLocationAttributes(DescribeFleetLocationAttributesPublisher.this.firstRequest);
            }
            return DescribeFleetLocationAttributesPublisher.this.client.describeFleetLocationAttributes((DescribeFleetLocationAttributesRequest)((Object)DescribeFleetLocationAttributesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

