/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFleetAttributesRequest extends GameLiftRequest implements
        ToCopyableBuilder<UpdateFleetAttributesRequest.Builder, UpdateFleetAttributesRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetId").getter(getter(UpdateFleetAttributesRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateFleetAttributesRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateFleetAttributesRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NewGameSessionProtectionPolicy")
            .getter(getter(UpdateFleetAttributesRequest::newGameSessionProtectionPolicyAsString))
            .setter(setter(Builder::newGameSessionProtectionPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy")
                    .build()).build();

    private static final SdkField<ResourceCreationLimitPolicy> RESOURCE_CREATION_LIMIT_POLICY_FIELD = SdkField
            .<ResourceCreationLimitPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("ResourceCreationLimitPolicy")
            .getter(getter(UpdateFleetAttributesRequest::resourceCreationLimitPolicy))
            .setter(setter(Builder::resourceCreationLimitPolicy))
            .constructor(ResourceCreationLimitPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCreationLimitPolicy")
                    .build()).build();

    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MetricGroups")
            .getter(getter(UpdateFleetAttributesRequest::metricGroups))
            .setter(setter(Builder::metricGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD, RESOURCE_CREATION_LIMIT_POLICY_FIELD,
            METRIC_GROUPS_FIELD));

    private final String fleetId;

    private final String name;

    private final String description;

    private final String newGameSessionProtectionPolicy;

    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;

    private final List<String> metricGroups;

    private UpdateFleetAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.name = builder.name;
        this.description = builder.description;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
    }

    /**
     * <p>
     * A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or ARN value.
     * </p>
     * 
     * @return A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or
     *         ARN value.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A human-readable description of a fleet.
     * </p>
     * 
     * @return A human-readable description of a fleet.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The game session protection policy to apply to all new instances created in this fleet. Instances that already
     * exist are not affected. You can set protection for individual instances using <a>UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during
     * a scale-down event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return The game session protection policy to apply to all new instances created in this fleet. Instances that
     *         already exist are not affected. You can set protection for individual instances using
     *         <a>UpdateGameSession</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *         during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public final ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(newGameSessionProtectionPolicy);
    }

    /**
     * <p>
     * The game session protection policy to apply to all new instances created in this fleet. Instances that already
     * exist are not affected. You can set protection for individual instances using <a>UpdateGameSession</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated during
     * a scale-down event.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #newGameSessionProtectionPolicy} will return {@link ProtectionPolicy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #newGameSessionProtectionPolicyAsString}.
     * </p>
     * 
     * @return The game session protection policy to apply to all new instances created in this fleet. Instances that
     *         already exist are not affected. You can set protection for individual instances using
     *         <a>UpdateGameSession</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
     *         during a scale-down event.
     *         </p>
     *         </li>
     * @see ProtectionPolicy
     */
    public final String newGameSessionProtectionPolicyAsString() {
        return newGameSessionProtectionPolicy;
    }

    /**
     * <p>
     * Policy settings that limit the number of game sessions an individual player can create over a span of time.
     * </p>
     * 
     * @return Policy settings that limit the number of game sessions an individual player can create over a span of
     *         time.
     */
    public final ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return resourceCreationLimitPolicy;
    }

    /**
     * Returns true if the MetricGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMetricGroups() {
        return metricGroups != null && !(metricGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the metrics
     * from multiple fleets. Provide an existing metric group name, or create a new metric group by providing a new
     * name. A fleet can only be in one metric group at a time.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the
     *         metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by
     *         providing a new name. A fleet can only be in one metric group at a time.
     */
    public final List<String> metricGroups() {
        return metricGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricGroups() ? metricGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFleetAttributesRequest)) {
            return false;
        }
        UpdateFleetAttributesRequest other = (UpdateFleetAttributesRequest) obj;
        return Objects.equals(fleetId(), other.fleetId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString())
                && Objects.equals(resourceCreationLimitPolicy(), other.resourceCreationLimitPolicy())
                && hasMetricGroups() == other.hasMetricGroups() && Objects.equals(metricGroups(), other.metricGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFleetAttributesRequest").add("FleetId", fleetId()).add("Name", name())
                .add("Description", description())
                .add("NewGameSessionProtectionPolicy", newGameSessionProtectionPolicyAsString())
                .add("ResourceCreationLimitPolicy", resourceCreationLimitPolicy())
                .add("MetricGroups", hasMetricGroups() ? metricGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "NewGameSessionProtectionPolicy":
            return Optional.ofNullable(clazz.cast(newGameSessionProtectionPolicyAsString()));
        case "ResourceCreationLimitPolicy":
            return Optional.ofNullable(clazz.cast(resourceCreationLimitPolicy()));
        case "MetricGroups":
            return Optional.ofNullable(clazz.cast(metricGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFleetAttributesRequest, T> g) {
        return obj -> g.apply((UpdateFleetAttributesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFleetAttributesRequest> {
        /**
         * <p>
         * A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or ARN
         * value.
         * </p>
         * 
         * @param fleetId
         *        A unique identifier for the fleet to update attribute metadata for. You can use either the fleet ID or
         *        ARN value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         * </p>
         * 
         * @param name
         *        A descriptive label that is associated with a fleet. Fleet names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A human-readable description of a fleet.
         * </p>
         * 
         * @param description
         *        A human-readable description of a fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The game session protection policy to apply to all new instances created in this fleet. Instances that
         * already exist are not affected. You can set protection for individual instances using
         * <a>UpdateGameSession</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
         * during a scale-down event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newGameSessionProtectionPolicy
         *        The game session protection policy to apply to all new instances created in this fleet. Instances that
         *        already exist are not affected. You can set protection for individual instances using
         *        <a>UpdateGameSession</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
         *        terminated during a scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy);

        /**
         * <p>
         * The game session protection policy to apply to all new instances created in this fleet. Instances that
         * already exist are not affected. You can set protection for individual instances using
         * <a>UpdateGameSession</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be terminated
         * during a scale-down event.
         * </p>
         * </li>
         * </ul>
         * 
         * @param newGameSessionProtectionPolicy
         *        The game session protection policy to apply to all new instances created in this fleet. Instances that
         *        already exist are not affected. You can set protection for individual instances using
         *        <a>UpdateGameSession</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>NoProtection</b> -- The game session can be terminated during a scale-down event.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FullProtection</b> -- If the game session is in an <code>ACTIVE</code> status, it cannot be
         *        terminated during a scale-down event.
         *        </p>
         *        </li>
         * @see ProtectionPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectionPolicy
         */
        Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy);

        /**
         * <p>
         * Policy settings that limit the number of game sessions an individual player can create over a span of time.
         * </p>
         * 
         * @param resourceCreationLimitPolicy
         *        Policy settings that limit the number of game sessions an individual player can create over a span of
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy);

        /**
         * <p>
         * Policy settings that limit the number of game sessions an individual player can create over a span of time.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceCreationLimitPolicy.Builder} avoiding
         * the need to create one manually via {@link ResourceCreationLimitPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceCreationLimitPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceCreationLimitPolicy(ResourceCreationLimitPolicy)}.
         * 
         * @param resourceCreationLimitPolicy
         *        a consumer that will call methods on {@link ResourceCreationLimitPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCreationLimitPolicy(ResourceCreationLimitPolicy)
         */
        default Builder resourceCreationLimitPolicy(Consumer<ResourceCreationLimitPolicy.Builder> resourceCreationLimitPolicy) {
            return resourceCreationLimitPolicy(ResourceCreationLimitPolicy.builder().applyMutation(resourceCreationLimitPolicy)
                    .build());
        }

        /**
         * <p>
         * The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the
         * metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by
         * providing a new name. A fleet can only be in one metric group at a time.
         * </p>
         * 
         * @param metricGroups
         *        The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate
         *        the metrics from multiple fleets. Provide an existing metric group name, or create a new metric group
         *        by providing a new name. A fleet can only be in one metric group at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(Collection<String> metricGroups);

        /**
         * <p>
         * The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate the
         * metrics from multiple fleets. Provide an existing metric group name, or create a new metric group by
         * providing a new name. A fleet can only be in one metric group at a time.
         * </p>
         * 
         * @param metricGroups
         *        The name of a metric group to add this fleet to. Use a metric group in Amazon CloudWatch to aggregate
         *        the metrics from multiple fleets. Provide an existing metric group name, or create a new metric group
         *        by providing a new name. A fleet can only be in one metric group at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricGroups(String... metricGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String fleetId;

        private String name;

        private String description;

        private String newGameSessionProtectionPolicy;

        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;

        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFleetAttributesRequest model) {
            super(model);
            fleetId(model.fleetId);
            name(model.name);
            description(model.description);
            newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            resourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            metricGroups(model.metricGroups);
        }

        public final String getFleetId() {
            return fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getNewGameSessionProtectionPolicy() {
            return newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy
                    .toString());
            return this;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        public final ResourceCreationLimitPolicy.Builder getResourceCreationLimitPolicy() {
            return resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.toBuilder() : null;
        }

        @Override
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy.BuilderImpl resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.build() : null;
        }

        public final Collection<String> getMetricGroups() {
            if (metricGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return metricGroups;
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String... metricGroups) {
            metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFleetAttributesRequest build() {
            return new UpdateFleetAttributesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
