/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input for a request operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartGameSessionPlacementRequest extends GameLiftRequest implements
        ToCopyableBuilder<StartGameSessionPlacementRequest.Builder, StartGameSessionPlacementRequest> {
    private static final SdkField<String> PLACEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlacementId").getter(getter(StartGameSessionPlacementRequest::placementId))
            .setter(setter(Builder::placementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementId").build()).build();

    private static final SdkField<String> GAME_SESSION_QUEUE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionQueueName").getter(getter(StartGameSessionPlacementRequest::gameSessionQueueName))
            .setter(setter(Builder::gameSessionQueueName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionQueueName").build())
            .build();

    private static final SdkField<List<GameProperty>> GAME_PROPERTIES_FIELD = SdkField
            .<List<GameProperty>> builder(MarshallingType.LIST)
            .memberName("GameProperties")
            .getter(getter(StartGameSessionPlacementRequest::gameProperties))
            .setter(setter(Builder::gameProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GameProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(GameProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAXIMUM_PLAYER_SESSION_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaximumPlayerSessionCount")
            .getter(getter(StartGameSessionPlacementRequest::maximumPlayerSessionCount))
            .setter(setter(Builder::maximumPlayerSessionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPlayerSessionCount").build())
            .build();

    private static final SdkField<String> GAME_SESSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionName").getter(getter(StartGameSessionPlacementRequest::gameSessionName))
            .setter(setter(Builder::gameSessionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionName").build()).build();

    private static final SdkField<List<PlayerLatency>> PLAYER_LATENCIES_FIELD = SdkField
            .<List<PlayerLatency>> builder(MarshallingType.LIST)
            .memberName("PlayerLatencies")
            .getter(getter(StartGameSessionPlacementRequest::playerLatencies))
            .setter(setter(Builder::playerLatencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlayerLatencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PlayerLatency> builder(MarshallingType.SDK_POJO)
                                            .constructor(PlayerLatency::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DesiredPlayerSession>> DESIRED_PLAYER_SESSIONS_FIELD = SdkField
            .<List<DesiredPlayerSession>> builder(MarshallingType.LIST)
            .memberName("DesiredPlayerSessions")
            .getter(getter(StartGameSessionPlacementRequest::desiredPlayerSessions))
            .setter(setter(Builder::desiredPlayerSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredPlayerSessions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DesiredPlayerSession> builder(MarshallingType.SDK_POJO)
                                            .constructor(DesiredPlayerSession::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> GAME_SESSION_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GameSessionData").getter(getter(StartGameSessionPlacementRequest::gameSessionData))
            .setter(setter(Builder::gameSessionData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GameSessionData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACEMENT_ID_FIELD,
            GAME_SESSION_QUEUE_NAME_FIELD, GAME_PROPERTIES_FIELD, MAXIMUM_PLAYER_SESSION_COUNT_FIELD, GAME_SESSION_NAME_FIELD,
            PLAYER_LATENCIES_FIELD, DESIRED_PLAYER_SESSIONS_FIELD, GAME_SESSION_DATA_FIELD));

    private final String placementId;

    private final String gameSessionQueueName;

    private final List<GameProperty> gameProperties;

    private final Integer maximumPlayerSessionCount;

    private final String gameSessionName;

    private final List<PlayerLatency> playerLatencies;

    private final List<DesiredPlayerSession> desiredPlayerSessions;

    private final String gameSessionData;

    private StartGameSessionPlacementRequest(BuilderImpl builder) {
        super(builder);
        this.placementId = builder.placementId;
        this.gameSessionQueueName = builder.gameSessionQueueName;
        this.gameProperties = builder.gameProperties;
        this.maximumPlayerSessionCount = builder.maximumPlayerSessionCount;
        this.gameSessionName = builder.gameSessionName;
        this.playerLatencies = builder.playerLatencies;
        this.desiredPlayerSessions = builder.desiredPlayerSessions;
        this.gameSessionData = builder.gameSessionData;
    }

    /**
     * <p>
     * A unique identifier to assign to the new game session placement. This value is developer-defined. The value must
     * be unique across all Regions and cannot be reused unless you are resubmitting a canceled or timed-out placement
     * request.
     * </p>
     * 
     * @return A unique identifier to assign to the new game session placement. This value is developer-defined. The
     *         value must be unique across all Regions and cannot be reused unless you are resubmitting a canceled or
     *         timed-out placement request.
     */
    public final String placementId() {
        return placementId;
    }

    /**
     * <p>
     * Name of the queue to use to place the new game session. You can use either the queue name or ARN value.
     * </p>
     * 
     * @return Name of the queue to use to place the new game session. You can use either the queue name or ARN value.
     */
    public final String gameSessionQueueName() {
        return gameSessionQueueName;
    }

    /**
     * Returns true if the GameProperties property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGameProperties() {
        return gameProperties != null && !(gameProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a
     * game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a Game Session</a>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGameProperties()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of custom properties for a game session, formatted as key:value pairs. These properties are passed
     *         to a game server process in the <a>GameSession</a> object with a request to start a new game session (see
     *         <a href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     *         >Start a Game Session</a>).
     */
    public final List<GameProperty> gameProperties() {
        return gameProperties;
    }

    /**
     * <p>
     * The maximum number of players that can be connected simultaneously to the game session.
     * </p>
     * 
     * @return The maximum number of players that can be connected simultaneously to the game session.
     */
    public final Integer maximumPlayerSessionCount() {
        return maximumPlayerSessionCount;
    }

    /**
     * <p>
     * A descriptive label that is associated with a game session. Session names do not need to be unique.
     * </p>
     * 
     * @return A descriptive label that is associated with a game session. Session names do not need to be unique.
     */
    public final String gameSessionName() {
        return gameSessionName;
    }

    /**
     * Returns true if the PlayerLatencies property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPlayerLatencies() {
        return playerLatencies != null && !(playerLatencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences when
     * connected to AWS Regions. This information is used to try to place the new game session where it can offer the
     * best possible gameplay experience for the players.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPlayerLatencies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A set of values, expressed in milliseconds, that indicates the amount of latency that a player
     *         experiences when connected to AWS Regions. This information is used to try to place the new game session
     *         where it can offer the best possible gameplay experience for the players.
     */
    public final List<PlayerLatency> playerLatencies() {
        return playerLatencies;
    }

    /**
     * Returns true if the DesiredPlayerSessions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDesiredPlayerSessions() {
        return desiredPlayerSessions != null && !(desiredPlayerSessions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Set of information on each player to create a player session for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDesiredPlayerSessions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Set of information on each player to create a player session for.
     */
    public final List<DesiredPlayerSession> desiredPlayerSessions() {
        return desiredPlayerSessions;
    }

    /**
     * <p>
     * A set of custom game session properties, formatted as a single string value. This data is passed to a game server
     * process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
     * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     * >Start a Game Session</a>).
     * </p>
     * 
     * @return A set of custom game session properties, formatted as a single string value. This data is passed to a
     *         game server process in the <a>GameSession</a> object with a request to start a new game session (see <a
     *         href=
     *         "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
     *         >Start a Game Session</a>).
     */
    public final String gameSessionData() {
        return gameSessionData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(placementId());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionQueueName());
        hashCode = 31 * hashCode + Objects.hashCode(hasGameProperties() ? gameProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maximumPlayerSessionCount());
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlayerLatencies() ? playerLatencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDesiredPlayerSessions() ? desiredPlayerSessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gameSessionData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartGameSessionPlacementRequest)) {
            return false;
        }
        StartGameSessionPlacementRequest other = (StartGameSessionPlacementRequest) obj;
        return Objects.equals(placementId(), other.placementId())
                && Objects.equals(gameSessionQueueName(), other.gameSessionQueueName())
                && hasGameProperties() == other.hasGameProperties() && Objects.equals(gameProperties(), other.gameProperties())
                && Objects.equals(maximumPlayerSessionCount(), other.maximumPlayerSessionCount())
                && Objects.equals(gameSessionName(), other.gameSessionName())
                && hasPlayerLatencies() == other.hasPlayerLatencies()
                && Objects.equals(playerLatencies(), other.playerLatencies())
                && hasDesiredPlayerSessions() == other.hasDesiredPlayerSessions()
                && Objects.equals(desiredPlayerSessions(), other.desiredPlayerSessions())
                && Objects.equals(gameSessionData(), other.gameSessionData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartGameSessionPlacementRequest").add("PlacementId", placementId())
                .add("GameSessionQueueName", gameSessionQueueName())
                .add("GameProperties", hasGameProperties() ? gameProperties() : null)
                .add("MaximumPlayerSessionCount", maximumPlayerSessionCount()).add("GameSessionName", gameSessionName())
                .add("PlayerLatencies", hasPlayerLatencies() ? playerLatencies() : null)
                .add("DesiredPlayerSessions", hasDesiredPlayerSessions() ? desiredPlayerSessions() : null)
                .add("GameSessionData", gameSessionData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PlacementId":
            return Optional.ofNullable(clazz.cast(placementId()));
        case "GameSessionQueueName":
            return Optional.ofNullable(clazz.cast(gameSessionQueueName()));
        case "GameProperties":
            return Optional.ofNullable(clazz.cast(gameProperties()));
        case "MaximumPlayerSessionCount":
            return Optional.ofNullable(clazz.cast(maximumPlayerSessionCount()));
        case "GameSessionName":
            return Optional.ofNullable(clazz.cast(gameSessionName()));
        case "PlayerLatencies":
            return Optional.ofNullable(clazz.cast(playerLatencies()));
        case "DesiredPlayerSessions":
            return Optional.ofNullable(clazz.cast(desiredPlayerSessions()));
        case "GameSessionData":
            return Optional.ofNullable(clazz.cast(gameSessionData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartGameSessionPlacementRequest, T> g) {
        return obj -> g.apply((StartGameSessionPlacementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GameLiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartGameSessionPlacementRequest> {
        /**
         * <p>
         * A unique identifier to assign to the new game session placement. This value is developer-defined. The value
         * must be unique across all Regions and cannot be reused unless you are resubmitting a canceled or timed-out
         * placement request.
         * </p>
         * 
         * @param placementId
         *        A unique identifier to assign to the new game session placement. This value is developer-defined. The
         *        value must be unique across all Regions and cannot be reused unless you are resubmitting a canceled or
         *        timed-out placement request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementId(String placementId);

        /**
         * <p>
         * Name of the queue to use to place the new game session. You can use either the queue name or ARN value.
         * </p>
         * 
         * @param gameSessionQueueName
         *        Name of the queue to use to place the new game session. You can use either the queue name or ARN
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionQueueName(String gameSessionQueueName);

        /**
         * <p>
         * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a
         * game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         * >Start a Game Session</a>).
         * </p>
         * 
         * @param gameProperties
         *        A set of custom properties for a game session, formatted as key:value pairs. These properties are
         *        passed to a game server process in the <a>GameSession</a> object with a request to start a new game
         *        session (see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         *        >Start a Game Session</a>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameProperties(Collection<GameProperty> gameProperties);

        /**
         * <p>
         * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a
         * game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         * >Start a Game Session</a>).
         * </p>
         * 
         * @param gameProperties
         *        A set of custom properties for a game session, formatted as key:value pairs. These properties are
         *        passed to a game server process in the <a>GameSession</a> object with a request to start a new game
         *        session (see <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         *        >Start a Game Session</a>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameProperties(GameProperty... gameProperties);

        /**
         * <p>
         * A set of custom properties for a game session, formatted as key:value pairs. These properties are passed to a
         * game server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         * >Start a Game Session</a>).
         * </p>
         * This is a convenience that creates an instance of the {@link List<GameProperty>.Builder} avoiding the need to
         * create one manually via {@link List<GameProperty>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GameProperty>.Builder#build()} is called immediately and its
         * result is passed to {@link #gameProperties(List<GameProperty>)}.
         * 
         * @param gameProperties
         *        a consumer that will call methods on {@link List<GameProperty>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gameProperties(List<GameProperty>)
         */
        Builder gameProperties(Consumer<GameProperty.Builder>... gameProperties);

        /**
         * <p>
         * The maximum number of players that can be connected simultaneously to the game session.
         * </p>
         * 
         * @param maximumPlayerSessionCount
         *        The maximum number of players that can be connected simultaneously to the game session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount);

        /**
         * <p>
         * A descriptive label that is associated with a game session. Session names do not need to be unique.
         * </p>
         * 
         * @param gameSessionName
         *        A descriptive label that is associated with a game session. Session names do not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionName(String gameSessionName);

        /**
         * <p>
         * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences
         * when connected to AWS Regions. This information is used to try to place the new game session where it can
         * offer the best possible gameplay experience for the players.
         * </p>
         * 
         * @param playerLatencies
         *        A set of values, expressed in milliseconds, that indicates the amount of latency that a player
         *        experiences when connected to AWS Regions. This information is used to try to place the new game
         *        session where it can offer the best possible gameplay experience for the players.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerLatencies(Collection<PlayerLatency> playerLatencies);

        /**
         * <p>
         * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences
         * when connected to AWS Regions. This information is used to try to place the new game session where it can
         * offer the best possible gameplay experience for the players.
         * </p>
         * 
         * @param playerLatencies
         *        A set of values, expressed in milliseconds, that indicates the amount of latency that a player
         *        experiences when connected to AWS Regions. This information is used to try to place the new game
         *        session where it can offer the best possible gameplay experience for the players.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playerLatencies(PlayerLatency... playerLatencies);

        /**
         * <p>
         * A set of values, expressed in milliseconds, that indicates the amount of latency that a player experiences
         * when connected to AWS Regions. This information is used to try to place the new game session where it can
         * offer the best possible gameplay experience for the players.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PlayerLatency>.Builder} avoiding the need
         * to create one manually via {@link List<PlayerLatency>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PlayerLatency>.Builder#build()} is called immediately and
         * its result is passed to {@link #playerLatencies(List<PlayerLatency>)}.
         * 
         * @param playerLatencies
         *        a consumer that will call methods on {@link List<PlayerLatency>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #playerLatencies(List<PlayerLatency>)
         */
        Builder playerLatencies(Consumer<PlayerLatency.Builder>... playerLatencies);

        /**
         * <p>
         * Set of information on each player to create a player session for.
         * </p>
         * 
         * @param desiredPlayerSessions
         *        Set of information on each player to create a player session for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredPlayerSessions(Collection<DesiredPlayerSession> desiredPlayerSessions);

        /**
         * <p>
         * Set of information on each player to create a player session for.
         * </p>
         * 
         * @param desiredPlayerSessions
         *        Set of information on each player to create a player session for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredPlayerSessions(DesiredPlayerSession... desiredPlayerSessions);

        /**
         * <p>
         * Set of information on each player to create a player session for.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DesiredPlayerSession>.Builder} avoiding the
         * need to create one manually via {@link List<DesiredPlayerSession>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DesiredPlayerSession>.Builder#build()} is called immediately
         * and its result is passed to {@link #desiredPlayerSessions(List<DesiredPlayerSession>)}.
         * 
         * @param desiredPlayerSessions
         *        a consumer that will call methods on {@link List<DesiredPlayerSession>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #desiredPlayerSessions(List<DesiredPlayerSession>)
         */
        Builder desiredPlayerSessions(Consumer<DesiredPlayerSession.Builder>... desiredPlayerSessions);

        /**
         * <p>
         * A set of custom game session properties, formatted as a single string value. This data is passed to a game
         * server process in the <a>GameSession</a> object with a request to start a new game session (see <a href=
         * "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         * >Start a Game Session</a>).
         * </p>
         * 
         * @param gameSessionData
         *        A set of custom game session properties, formatted as a single string value. This data is passed to a
         *        game server process in the <a>GameSession</a> object with a request to start a new game session (see
         *        <a href=
         *        "https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession"
         *        >Start a Game Session</a>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gameSessionData(String gameSessionData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GameLiftRequest.BuilderImpl implements Builder {
        private String placementId;

        private String gameSessionQueueName;

        private List<GameProperty> gameProperties = DefaultSdkAutoConstructList.getInstance();

        private Integer maximumPlayerSessionCount;

        private String gameSessionName;

        private List<PlayerLatency> playerLatencies = DefaultSdkAutoConstructList.getInstance();

        private List<DesiredPlayerSession> desiredPlayerSessions = DefaultSdkAutoConstructList.getInstance();

        private String gameSessionData;

        private BuilderImpl() {
        }

        private BuilderImpl(StartGameSessionPlacementRequest model) {
            super(model);
            placementId(model.placementId);
            gameSessionQueueName(model.gameSessionQueueName);
            gameProperties(model.gameProperties);
            maximumPlayerSessionCount(model.maximumPlayerSessionCount);
            gameSessionName(model.gameSessionName);
            playerLatencies(model.playerLatencies);
            desiredPlayerSessions(model.desiredPlayerSessions);
            gameSessionData(model.gameSessionData);
        }

        public final String getPlacementId() {
            return placementId;
        }

        @Override
        public final Builder placementId(String placementId) {
            this.placementId = placementId;
            return this;
        }

        public final void setPlacementId(String placementId) {
            this.placementId = placementId;
        }

        public final String getGameSessionQueueName() {
            return gameSessionQueueName;
        }

        @Override
        public final Builder gameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
            return this;
        }

        public final void setGameSessionQueueName(String gameSessionQueueName) {
            this.gameSessionQueueName = gameSessionQueueName;
        }

        public final List<GameProperty.Builder> getGameProperties() {
            List<GameProperty.Builder> result = GamePropertyListCopier.copyToBuilder(this.gameProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder gameProperties(Collection<GameProperty> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copy(gameProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(GameProperty... gameProperties) {
            gameProperties(Arrays.asList(gameProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gameProperties(Consumer<GameProperty.Builder>... gameProperties) {
            gameProperties(Stream.of(gameProperties).map(c -> GameProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setGameProperties(Collection<GameProperty.BuilderImpl> gameProperties) {
            this.gameProperties = GamePropertyListCopier.copyFromBuilder(gameProperties);
        }

        public final Integer getMaximumPlayerSessionCount() {
            return maximumPlayerSessionCount;
        }

        @Override
        public final Builder maximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
            return this;
        }

        public final void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
            this.maximumPlayerSessionCount = maximumPlayerSessionCount;
        }

        public final String getGameSessionName() {
            return gameSessionName;
        }

        @Override
        public final Builder gameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
            return this;
        }

        public final void setGameSessionName(String gameSessionName) {
            this.gameSessionName = gameSessionName;
        }

        public final List<PlayerLatency.Builder> getPlayerLatencies() {
            List<PlayerLatency.Builder> result = PlayerLatencyListCopier.copyToBuilder(this.playerLatencies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder playerLatencies(Collection<PlayerLatency> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copy(playerLatencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencies(PlayerLatency... playerLatencies) {
            playerLatencies(Arrays.asList(playerLatencies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder playerLatencies(Consumer<PlayerLatency.Builder>... playerLatencies) {
            playerLatencies(Stream.of(playerLatencies).map(c -> PlayerLatency.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPlayerLatencies(Collection<PlayerLatency.BuilderImpl> playerLatencies) {
            this.playerLatencies = PlayerLatencyListCopier.copyFromBuilder(playerLatencies);
        }

        public final List<DesiredPlayerSession.Builder> getDesiredPlayerSessions() {
            List<DesiredPlayerSession.Builder> result = DesiredPlayerSessionListCopier.copyToBuilder(this.desiredPlayerSessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder desiredPlayerSessions(Collection<DesiredPlayerSession> desiredPlayerSessions) {
            this.desiredPlayerSessions = DesiredPlayerSessionListCopier.copy(desiredPlayerSessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredPlayerSessions(DesiredPlayerSession... desiredPlayerSessions) {
            desiredPlayerSessions(Arrays.asList(desiredPlayerSessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder desiredPlayerSessions(Consumer<DesiredPlayerSession.Builder>... desiredPlayerSessions) {
            desiredPlayerSessions(Stream.of(desiredPlayerSessions)
                    .map(c -> DesiredPlayerSession.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDesiredPlayerSessions(Collection<DesiredPlayerSession.BuilderImpl> desiredPlayerSessions) {
            this.desiredPlayerSessions = DesiredPlayerSessionListCopier.copyFromBuilder(desiredPlayerSessions);
        }

        public final String getGameSessionData() {
            return gameSessionData;
        }

        @Override
        public final Builder gameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
            return this;
        }

        public final void setGameSessionData(String gameSessionData) {
            this.gameSessionData = gameSessionData;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartGameSessionPlacementRequest build() {
            return new StartGameSessionPlacementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
