/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.OntapEndpointIpAddressesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SvmEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SvmEndpoint> {
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DNSName").getter(SvmEndpoint.getter(SvmEndpoint::dnsName)).setter(SvmEndpoint.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").build()}).build();
    private static final SdkField<List<String>> IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpAddresses").getter(SvmEndpoint.getter(SvmEndpoint::ipAddresses)).setter(SvmEndpoint.setter(Builder::ipAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_NAME_FIELD, IP_ADDRESSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SvmEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dnsName;
    private final List<String> ipAddresses;

    private SvmEndpoint(BuilderImpl builder) {
        this.dnsName = builder.dnsName;
        this.ipAddresses = builder.ipAddresses;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final boolean hasIpAddresses() {
        return this.ipAddresses != null && !(this.ipAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipAddresses() {
        return this.ipAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpAddresses() ? this.ipAddresses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SvmEndpoint)) {
            return false;
        }
        SvmEndpoint other = (SvmEndpoint)obj;
        return Objects.equals(this.dnsName(), other.dnsName()) && this.hasIpAddresses() == other.hasIpAddresses() && Objects.equals(this.ipAddresses(), other.ipAddresses());
    }

    public final String toString() {
        return ToString.builder((String)"SvmEndpoint").add("DNSName", (Object)this.dnsName()).add("IpAddresses", this.hasIpAddresses() ? this.ipAddresses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DNSName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "IpAddresses": {
                return Optional.ofNullable(clazz.cast(this.ipAddresses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DNSName", DNS_NAME_FIELD);
        map.put("IpAddresses", IP_ADDRESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SvmEndpoint, T> g) {
        return obj -> g.apply((SvmEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dnsName;
        private List<String> ipAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SvmEndpoint model) {
            this.dnsName(model.dnsName);
            this.ipAddresses(model.ipAddresses);
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final Collection<String> getIpAddresses() {
            if (this.ipAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipAddresses;
        }

        public final void setIpAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = OntapEndpointIpAddressesCopier.copy(ipAddresses);
        }

        @Override
        public final Builder ipAddresses(Collection<String> ipAddresses) {
            this.ipAddresses = OntapEndpointIpAddressesCopier.copy(ipAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipAddresses(String ... ipAddresses) {
            this.ipAddresses(Arrays.asList(ipAddresses));
            return this;
        }

        public SvmEndpoint build() {
            return new SvmEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SvmEndpoint> {
        public Builder dnsName(String var1);

        public Builder ipAddresses(Collection<String> var1);

        public Builder ipAddresses(String ... var1);
    }
}

