/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataRepositoryLifecycle {
    CREATING("CREATING"),
    AVAILABLE("AVAILABLE"),
    MISCONFIGURED("MISCONFIGURED"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataRepositoryLifecycle> VALUE_MAP;
    private final String value;

    private DataRepositoryLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataRepositoryLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataRepositoryLifecycle> knownValues() {
        EnumSet<DataRepositoryLifecycle> knownValues = EnumSet.allOf(DataRepositoryLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataRepositoryLifecycle.class, DataRepositoryLifecycle::toString);
    }
}

