/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.services.fsx.model.RestoreOpenZFSVolumeOption;
import software.amazon.awssdk.services.fsx.model.RestoreOpenZFSVolumeOptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreVolumeFromSnapshotRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, RestoreVolumeFromSnapshotRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(RestoreVolumeFromSnapshotRequest.getter(RestoreVolumeFromSnapshotRequest::clientRequestToken)).setter(RestoreVolumeFromSnapshotRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(RestoreVolumeFromSnapshotRequest.getter(RestoreVolumeFromSnapshotRequest::volumeId)).setter(RestoreVolumeFromSnapshotRequest.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(RestoreVolumeFromSnapshotRequest.getter(RestoreVolumeFromSnapshotRequest::snapshotId)).setter(RestoreVolumeFromSnapshotRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()}).build();
    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(RestoreVolumeFromSnapshotRequest.getter(RestoreVolumeFromSnapshotRequest::optionsAsStrings)).setter(RestoreVolumeFromSnapshotRequest.setter(Builder::optionsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, VOLUME_ID_FIELD, SNAPSHOT_ID_FIELD, OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreVolumeFromSnapshotRequest.memberNameToFieldInitializer();
    private final String clientRequestToken;
    private final String volumeId;
    private final String snapshotId;
    private final List<String> options;

    private RestoreVolumeFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.volumeId = builder.volumeId;
        this.snapshotId = builder.snapshotId;
        this.options = builder.options;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final List<RestoreOpenZFSVolumeOption> options() {
        return RestoreOpenZFSVolumeOptionsCopier.copyStringToEnum(this.options);
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<String> optionsAsStrings() {
        return this.options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.optionsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreVolumeFromSnapshotRequest)) {
            return false;
        }
        RestoreVolumeFromSnapshotRequest other = (RestoreVolumeFromSnapshotRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.optionsAsStrings(), other.optionsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreVolumeFromSnapshotRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("VolumeId", (Object)this.volumeId()).add("SnapshotId", (Object)this.snapshotId()).add("Options", this.hasOptions() ? this.optionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.optionsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("Options", OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreVolumeFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreVolumeFromSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String volumeId;
        private String snapshotId;
        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreVolumeFromSnapshotRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.volumeId(model.volumeId);
            this.snapshotId(model.snapshotId);
            this.optionsWithStrings(model.options);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final Collection<String> getOptions() {
            if (this.options instanceof SdkAutoConstructList) {
                return null;
            }
            return this.options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = RestoreOpenZFSVolumeOptionsCopier.copy(options);
        }

        @Override
        public final Builder optionsWithStrings(Collection<String> options) {
            this.options = RestoreOpenZFSVolumeOptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsWithStrings(String ... options) {
            this.optionsWithStrings(Arrays.asList(options));
            return this;
        }

        @Override
        public final Builder options(Collection<RestoreOpenZFSVolumeOption> options) {
            this.options = RestoreOpenZFSVolumeOptionsCopier.copyEnumToString(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(RestoreOpenZFSVolumeOption ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreVolumeFromSnapshotRequest build() {
            return new RestoreVolumeFromSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreVolumeFromSnapshotRequest> {
        public Builder clientRequestToken(String var1);

        public Builder volumeId(String var1);

        public Builder snapshotId(String var1);

        public Builder optionsWithStrings(Collection<String> var1);

        public Builder optionsWithStrings(String ... var1);

        public Builder options(Collection<RestoreOpenZFSVolumeOption> var1);

        public Builder options(RestoreOpenZFSVolumeOption ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

