/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOpenZFSOriginSnapshotConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateOpenZFSOriginSnapshotConfiguration> {
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotARN").getter(CreateOpenZFSOriginSnapshotConfiguration.getter(CreateOpenZFSOriginSnapshotConfiguration::snapshotARN)).setter(CreateOpenZFSOriginSnapshotConfiguration.setter(Builder::snapshotARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotARN").build()}).build();
    private static final SdkField<String> COPY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CopyStrategy").getter(CreateOpenZFSOriginSnapshotConfiguration.getter(CreateOpenZFSOriginSnapshotConfiguration::copyStrategyAsString)).setter(CreateOpenZFSOriginSnapshotConfiguration.setter(Builder::copyStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ARN_FIELD, COPY_STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String snapshotARN;
    private final String copyStrategy;

    private CreateOpenZFSOriginSnapshotConfiguration(BuilderImpl builder) {
        this.snapshotARN = builder.snapshotARN;
        this.copyStrategy = builder.copyStrategy;
    }

    public final String snapshotARN() {
        return this.snapshotARN;
    }

    public final OpenZFSCopyStrategy copyStrategy() {
        return OpenZFSCopyStrategy.fromValue(this.copyStrategy);
    }

    public final String copyStrategyAsString() {
        return this.copyStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyStrategyAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpenZFSOriginSnapshotConfiguration)) {
            return false;
        }
        CreateOpenZFSOriginSnapshotConfiguration other = (CreateOpenZFSOriginSnapshotConfiguration)obj;
        return Objects.equals(this.snapshotARN(), other.snapshotARN()) && Objects.equals(this.copyStrategyAsString(), other.copyStrategyAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOpenZFSOriginSnapshotConfiguration").add("SnapshotARN", (Object)this.snapshotARN()).add("CopyStrategy", (Object)this.copyStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotARN": {
                return Optional.ofNullable(clazz.cast(this.snapshotARN()));
            }
            case "CopyStrategy": {
                return Optional.ofNullable(clazz.cast(this.copyStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOpenZFSOriginSnapshotConfiguration, T> g) {
        return obj -> g.apply((CreateOpenZFSOriginSnapshotConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String snapshotARN;
        private String copyStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOpenZFSOriginSnapshotConfiguration model) {
            this.snapshotARN(model.snapshotARN);
            this.copyStrategy(model.copyStrategy);
        }

        public final String getSnapshotARN() {
            return this.snapshotARN;
        }

        public final void setSnapshotARN(String snapshotARN) {
            this.snapshotARN = snapshotARN;
        }

        @Override
        public final Builder snapshotARN(String snapshotARN) {
            this.snapshotARN = snapshotARN;
            return this;
        }

        public final String getCopyStrategy() {
            return this.copyStrategy;
        }

        public final void setCopyStrategy(String copyStrategy) {
            this.copyStrategy = copyStrategy;
        }

        @Override
        public final Builder copyStrategy(String copyStrategy) {
            this.copyStrategy = copyStrategy;
            return this;
        }

        @Override
        public final Builder copyStrategy(OpenZFSCopyStrategy copyStrategy) {
            this.copyStrategy(copyStrategy == null ? null : copyStrategy.toString());
            return this;
        }

        public CreateOpenZFSOriginSnapshotConfiguration build() {
            return new CreateOpenZFSOriginSnapshotConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateOpenZFSOriginSnapshotConfiguration> {
        public Builder snapshotARN(String var1);

        public Builder copyStrategy(String var1);

        public Builder copyStrategy(OpenZFSCopyStrategy var1);
    }
}

