/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.InputOntapVolumeType;
import software.amazon.awssdk.services.fsx.model.SecurityStyle;
import software.amazon.awssdk.services.fsx.model.TieringPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOntapVolumeConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateOntapVolumeConfiguration> {
    private static final SdkField<String> JUNCTION_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JunctionPath").getter(CreateOntapVolumeConfiguration.getter(CreateOntapVolumeConfiguration::junctionPath)).setter(CreateOntapVolumeConfiguration.setter(Builder::junctionPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JunctionPath").build()}).build();
    private static final SdkField<String> SECURITY_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityStyle").getter(CreateOntapVolumeConfiguration.getter(CreateOntapVolumeConfiguration::securityStyleAsString)).setter(CreateOntapVolumeConfiguration.setter(Builder::securityStyle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityStyle").build()}).build();
    private static final SdkField<Integer> SIZE_IN_MEGABYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SizeInMegabytes").getter(CreateOntapVolumeConfiguration.getter(CreateOntapVolumeConfiguration::sizeInMegabytes)).setter(CreateOntapVolumeConfiguration.setter(Builder::sizeInMegabytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInMegabytes").build()}).build();
    private static final SdkField<Boolean> STORAGE_EFFICIENCY_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEfficiencyEnabled").getter(CreateOntapVolumeConfiguration.getter(CreateOntapVolumeConfiguration::storageEfficiencyEnabled)).setter(CreateOntapVolumeConfiguration.setter(Builder::storageEfficiencyEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEfficiencyEnabled").build()}).build();
    private static final SdkField<String> STORAGE_VIRTUAL_MACHINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageVirtualMachineId").getter(CreateOntapVolumeConfiguration.getter(CreateOntapVolumeConfiguration::storageVirtualMachineId)).setter(CreateOntapVolumeConfiguration.setter(Builder::storageVirtualMachineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVirtualMachineId").build()}).build();
    private static final SdkField<TieringPolicy> TIERING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TieringPolicy").getter(CreateOntapVolumeConfiguration.getter(CreateOntapVolumeConfiguration::tieringPolicy)).setter(CreateOntapVolumeConfiguration.setter(Builder::tieringPolicy)).constructor(TieringPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringPolicy").build()}).build();
    private static final SdkField<String> ONTAP_VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OntapVolumeType").getter(CreateOntapVolumeConfiguration.getter(CreateOntapVolumeConfiguration::ontapVolumeTypeAsString)).setter(CreateOntapVolumeConfiguration.setter(Builder::ontapVolumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapVolumeType").build()}).build();
    private static final SdkField<String> SNAPSHOT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotPolicy").getter(CreateOntapVolumeConfiguration.getter(CreateOntapVolumeConfiguration::snapshotPolicy)).setter(CreateOntapVolumeConfiguration.setter(Builder::snapshotPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotPolicy").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToBackups").getter(CreateOntapVolumeConfiguration.getter(CreateOntapVolumeConfiguration::copyTagsToBackups)).setter(CreateOntapVolumeConfiguration.setter(Builder::copyTagsToBackups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JUNCTION_PATH_FIELD, SECURITY_STYLE_FIELD, SIZE_IN_MEGABYTES_FIELD, STORAGE_EFFICIENCY_ENABLED_FIELD, STORAGE_VIRTUAL_MACHINE_ID_FIELD, TIERING_POLICY_FIELD, ONTAP_VOLUME_TYPE_FIELD, SNAPSHOT_POLICY_FIELD, COPY_TAGS_TO_BACKUPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String junctionPath;
    private final String securityStyle;
    private final Integer sizeInMegabytes;
    private final Boolean storageEfficiencyEnabled;
    private final String storageVirtualMachineId;
    private final TieringPolicy tieringPolicy;
    private final String ontapVolumeType;
    private final String snapshotPolicy;
    private final Boolean copyTagsToBackups;

    private CreateOntapVolumeConfiguration(BuilderImpl builder) {
        this.junctionPath = builder.junctionPath;
        this.securityStyle = builder.securityStyle;
        this.sizeInMegabytes = builder.sizeInMegabytes;
        this.storageEfficiencyEnabled = builder.storageEfficiencyEnabled;
        this.storageVirtualMachineId = builder.storageVirtualMachineId;
        this.tieringPolicy = builder.tieringPolicy;
        this.ontapVolumeType = builder.ontapVolumeType;
        this.snapshotPolicy = builder.snapshotPolicy;
        this.copyTagsToBackups = builder.copyTagsToBackups;
    }

    public final String junctionPath() {
        return this.junctionPath;
    }

    public final SecurityStyle securityStyle() {
        return SecurityStyle.fromValue(this.securityStyle);
    }

    public final String securityStyleAsString() {
        return this.securityStyle;
    }

    public final Integer sizeInMegabytes() {
        return this.sizeInMegabytes;
    }

    public final Boolean storageEfficiencyEnabled() {
        return this.storageEfficiencyEnabled;
    }

    public final String storageVirtualMachineId() {
        return this.storageVirtualMachineId;
    }

    public final TieringPolicy tieringPolicy() {
        return this.tieringPolicy;
    }

    public final InputOntapVolumeType ontapVolumeType() {
        return InputOntapVolumeType.fromValue(this.ontapVolumeType);
    }

    public final String ontapVolumeTypeAsString() {
        return this.ontapVolumeType;
    }

    public final String snapshotPolicy() {
        return this.snapshotPolicy;
    }

    public final Boolean copyTagsToBackups() {
        return this.copyTagsToBackups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.junctionPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityStyleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInMegabytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEfficiencyEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageVirtualMachineId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tieringPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.ontapVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToBackups());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOntapVolumeConfiguration)) {
            return false;
        }
        CreateOntapVolumeConfiguration other = (CreateOntapVolumeConfiguration)obj;
        return Objects.equals(this.junctionPath(), other.junctionPath()) && Objects.equals(this.securityStyleAsString(), other.securityStyleAsString()) && Objects.equals(this.sizeInMegabytes(), other.sizeInMegabytes()) && Objects.equals(this.storageEfficiencyEnabled(), other.storageEfficiencyEnabled()) && Objects.equals(this.storageVirtualMachineId(), other.storageVirtualMachineId()) && Objects.equals(this.tieringPolicy(), other.tieringPolicy()) && Objects.equals(this.ontapVolumeTypeAsString(), other.ontapVolumeTypeAsString()) && Objects.equals(this.snapshotPolicy(), other.snapshotPolicy()) && Objects.equals(this.copyTagsToBackups(), other.copyTagsToBackups());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOntapVolumeConfiguration").add("JunctionPath", (Object)this.junctionPath()).add("SecurityStyle", (Object)this.securityStyleAsString()).add("SizeInMegabytes", (Object)this.sizeInMegabytes()).add("StorageEfficiencyEnabled", (Object)this.storageEfficiencyEnabled()).add("StorageVirtualMachineId", (Object)this.storageVirtualMachineId()).add("TieringPolicy", (Object)this.tieringPolicy()).add("OntapVolumeType", (Object)this.ontapVolumeTypeAsString()).add("SnapshotPolicy", (Object)this.snapshotPolicy()).add("CopyTagsToBackups", (Object)this.copyTagsToBackups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JunctionPath": {
                return Optional.ofNullable(clazz.cast(this.junctionPath()));
            }
            case "SecurityStyle": {
                return Optional.ofNullable(clazz.cast(this.securityStyleAsString()));
            }
            case "SizeInMegabytes": {
                return Optional.ofNullable(clazz.cast(this.sizeInMegabytes()));
            }
            case "StorageEfficiencyEnabled": {
                return Optional.ofNullable(clazz.cast(this.storageEfficiencyEnabled()));
            }
            case "StorageVirtualMachineId": {
                return Optional.ofNullable(clazz.cast(this.storageVirtualMachineId()));
            }
            case "TieringPolicy": {
                return Optional.ofNullable(clazz.cast(this.tieringPolicy()));
            }
            case "OntapVolumeType": {
                return Optional.ofNullable(clazz.cast(this.ontapVolumeTypeAsString()));
            }
            case "SnapshotPolicy": {
                return Optional.ofNullable(clazz.cast(this.snapshotPolicy()));
            }
            case "CopyTagsToBackups": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToBackups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateOntapVolumeConfiguration, T> g) {
        return obj -> g.apply((CreateOntapVolumeConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String junctionPath;
        private String securityStyle;
        private Integer sizeInMegabytes;
        private Boolean storageEfficiencyEnabled;
        private String storageVirtualMachineId;
        private TieringPolicy tieringPolicy;
        private String ontapVolumeType;
        private String snapshotPolicy;
        private Boolean copyTagsToBackups;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOntapVolumeConfiguration model) {
            this.junctionPath(model.junctionPath);
            this.securityStyle(model.securityStyle);
            this.sizeInMegabytes(model.sizeInMegabytes);
            this.storageEfficiencyEnabled(model.storageEfficiencyEnabled);
            this.storageVirtualMachineId(model.storageVirtualMachineId);
            this.tieringPolicy(model.tieringPolicy);
            this.ontapVolumeType(model.ontapVolumeType);
            this.snapshotPolicy(model.snapshotPolicy);
            this.copyTagsToBackups(model.copyTagsToBackups);
        }

        public final String getJunctionPath() {
            return this.junctionPath;
        }

        public final void setJunctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
        }

        @Override
        public final Builder junctionPath(String junctionPath) {
            this.junctionPath = junctionPath;
            return this;
        }

        public final String getSecurityStyle() {
            return this.securityStyle;
        }

        public final void setSecurityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
        }

        @Override
        public final Builder securityStyle(String securityStyle) {
            this.securityStyle = securityStyle;
            return this;
        }

        @Override
        public final Builder securityStyle(SecurityStyle securityStyle) {
            this.securityStyle(securityStyle == null ? null : securityStyle.toString());
            return this;
        }

        public final Integer getSizeInMegabytes() {
            return this.sizeInMegabytes;
        }

        public final void setSizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
        }

        @Override
        public final Builder sizeInMegabytes(Integer sizeInMegabytes) {
            this.sizeInMegabytes = sizeInMegabytes;
            return this;
        }

        public final Boolean getStorageEfficiencyEnabled() {
            return this.storageEfficiencyEnabled;
        }

        public final void setStorageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
        }

        @Override
        public final Builder storageEfficiencyEnabled(Boolean storageEfficiencyEnabled) {
            this.storageEfficiencyEnabled = storageEfficiencyEnabled;
            return this;
        }

        public final String getStorageVirtualMachineId() {
            return this.storageVirtualMachineId;
        }

        public final void setStorageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
        }

        @Override
        public final Builder storageVirtualMachineId(String storageVirtualMachineId) {
            this.storageVirtualMachineId = storageVirtualMachineId;
            return this;
        }

        public final TieringPolicy.Builder getTieringPolicy() {
            return this.tieringPolicy != null ? this.tieringPolicy.toBuilder() : null;
        }

        public final void setTieringPolicy(TieringPolicy.BuilderImpl tieringPolicy) {
            this.tieringPolicy = tieringPolicy != null ? tieringPolicy.build() : null;
        }

        @Override
        public final Builder tieringPolicy(TieringPolicy tieringPolicy) {
            this.tieringPolicy = tieringPolicy;
            return this;
        }

        public final String getOntapVolumeType() {
            return this.ontapVolumeType;
        }

        public final void setOntapVolumeType(String ontapVolumeType) {
            this.ontapVolumeType = ontapVolumeType;
        }

        @Override
        public final Builder ontapVolumeType(String ontapVolumeType) {
            this.ontapVolumeType = ontapVolumeType;
            return this;
        }

        @Override
        public final Builder ontapVolumeType(InputOntapVolumeType ontapVolumeType) {
            this.ontapVolumeType(ontapVolumeType == null ? null : ontapVolumeType.toString());
            return this;
        }

        public final String getSnapshotPolicy() {
            return this.snapshotPolicy;
        }

        public final void setSnapshotPolicy(String snapshotPolicy) {
            this.snapshotPolicy = snapshotPolicy;
        }

        @Override
        public final Builder snapshotPolicy(String snapshotPolicy) {
            this.snapshotPolicy = snapshotPolicy;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return this.copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public CreateOntapVolumeConfiguration build() {
            return new CreateOntapVolumeConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateOntapVolumeConfiguration> {
        public Builder junctionPath(String var1);

        public Builder securityStyle(String var1);

        public Builder securityStyle(SecurityStyle var1);

        public Builder sizeInMegabytes(Integer var1);

        public Builder storageEfficiencyEnabled(Boolean var1);

        public Builder storageVirtualMachineId(String var1);

        public Builder tieringPolicy(TieringPolicy var1);

        default public Builder tieringPolicy(Consumer<TieringPolicy.Builder> tieringPolicy) {
            return this.tieringPolicy((TieringPolicy)((TieringPolicy.Builder)TieringPolicy.builder().applyMutation(tieringPolicy)).build());
        }

        public Builder ontapVolumeType(String var1);

        public Builder ontapVolumeType(InputOntapVolumeType var1);

        public Builder snapshotPolicy(String var1);

        public Builder copyTagsToBackups(Boolean var1);
    }
}

