/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.AlternateDNSNamesCopier;
import software.amazon.awssdk.services.fsx.model.FSxRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateFileSystemAliasesRequest
extends FSxRequest
implements ToCopyableBuilder<Builder, AssociateFileSystemAliasesRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(AssociateFileSystemAliasesRequest.getter(AssociateFileSystemAliasesRequest::clientRequestToken)).setter(AssociateFileSystemAliasesRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileSystemId").getter(AssociateFileSystemAliasesRequest.getter(AssociateFileSystemAliasesRequest::fileSystemId)).setter(AssociateFileSystemAliasesRequest.setter(Builder::fileSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()}).build();
    private static final SdkField<List<String>> ALIASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Aliases").getter(AssociateFileSystemAliasesRequest.getter(AssociateFileSystemAliasesRequest::aliases)).setter(AssociateFileSystemAliasesRequest.setter(Builder::aliases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD, ALIASES_FIELD));
    private final String clientRequestToken;
    private final String fileSystemId;
    private final List<String> aliases;

    private AssociateFileSystemAliasesRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.fileSystemId = builder.fileSystemId;
        this.aliases = builder.aliases;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String fileSystemId() {
        return this.fileSystemId;
    }

    public final boolean hasAliases() {
        return this.aliases != null && !(this.aliases instanceof SdkAutoConstructList);
    }

    public final List<String> aliases() {
        return this.aliases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAliases() ? this.aliases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateFileSystemAliasesRequest)) {
            return false;
        }
        AssociateFileSystemAliasesRequest other = (AssociateFileSystemAliasesRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.fileSystemId(), other.fileSystemId()) && this.hasAliases() == other.hasAliases() && Objects.equals(this.aliases(), other.aliases());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateFileSystemAliasesRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("FileSystemId", (Object)this.fileSystemId()).add("Aliases", this.hasAliases() ? this.aliases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "FileSystemId": {
                return Optional.ofNullable(clazz.cast(this.fileSystemId()));
            }
            case "Aliases": {
                return Optional.ofNullable(clazz.cast(this.aliases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateFileSystemAliasesRequest, T> g) {
        return obj -> g.apply((AssociateFileSystemAliasesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FSxRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String fileSystemId;
        private List<String> aliases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateFileSystemAliasesRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.fileSystemId(model.fileSystemId);
            this.aliases(model.aliases);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getFileSystemId() {
            return this.fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        public final Collection<String> getAliases() {
            if (this.aliases instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aliases;
        }

        @Override
        public final Builder aliases(Collection<String> aliases) {
            this.aliases = AlternateDNSNamesCopier.copy(aliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aliases(String ... aliases) {
            this.aliases(Arrays.asList(aliases));
            return this;
        }

        public final void setAliases(Collection<String> aliases) {
            this.aliases = AlternateDNSNamesCopier.copy(aliases);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateFileSystemAliasesRequest build() {
            return new AssociateFileSystemAliasesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FSxRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateFileSystemAliasesRequest> {
        public Builder clientRequestToken(String var1);

        public Builder fileSystemId(String var1);

        public Builder aliases(Collection<String> var1);

        public Builder aliases(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

