/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.PredictionExplanations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelVersionEvaluation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelVersionEvaluation> {
    private static final SdkField<String> OUTPUT_VARIABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputVariableName").getter(ModelVersionEvaluation.getter(ModelVersionEvaluation::outputVariableName)).setter(ModelVersionEvaluation.setter(Builder::outputVariableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputVariableName").build()}).build();
    private static final SdkField<String> EVALUATION_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationScore").getter(ModelVersionEvaluation.getter(ModelVersionEvaluation::evaluationScore)).setter(ModelVersionEvaluation.setter(Builder::evaluationScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationScore").build()}).build();
    private static final SdkField<PredictionExplanations> PREDICTION_EXPLANATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("predictionExplanations").getter(ModelVersionEvaluation.getter(ModelVersionEvaluation::predictionExplanations)).setter(ModelVersionEvaluation.setter(Builder::predictionExplanations)).constructor(PredictionExplanations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionExplanations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_VARIABLE_NAME_FIELD, EVALUATION_SCORE_FIELD, PREDICTION_EXPLANATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModelVersionEvaluation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String outputVariableName;
    private final String evaluationScore;
    private final PredictionExplanations predictionExplanations;

    private ModelVersionEvaluation(BuilderImpl builder) {
        this.outputVariableName = builder.outputVariableName;
        this.evaluationScore = builder.evaluationScore;
        this.predictionExplanations = builder.predictionExplanations;
    }

    public final String outputVariableName() {
        return this.outputVariableName;
    }

    public final String evaluationScore() {
        return this.evaluationScore;
    }

    public final PredictionExplanations predictionExplanations() {
        return this.predictionExplanations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputVariableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionExplanations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVersionEvaluation)) {
            return false;
        }
        ModelVersionEvaluation other = (ModelVersionEvaluation)obj;
        return Objects.equals(this.outputVariableName(), other.outputVariableName()) && Objects.equals(this.evaluationScore(), other.evaluationScore()) && Objects.equals(this.predictionExplanations(), other.predictionExplanations());
    }

    public final String toString() {
        return ToString.builder((String)"ModelVersionEvaluation").add("OutputVariableName", (Object)this.outputVariableName()).add("EvaluationScore", (Object)this.evaluationScore()).add("PredictionExplanations", (Object)this.predictionExplanations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outputVariableName": {
                return Optional.ofNullable(clazz.cast(this.outputVariableName()));
            }
            case "evaluationScore": {
                return Optional.ofNullable(clazz.cast(this.evaluationScore()));
            }
            case "predictionExplanations": {
                return Optional.ofNullable(clazz.cast(this.predictionExplanations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("outputVariableName", OUTPUT_VARIABLE_NAME_FIELD);
        map.put("evaluationScore", EVALUATION_SCORE_FIELD);
        map.put("predictionExplanations", PREDICTION_EXPLANATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelVersionEvaluation, T> g) {
        return obj -> g.apply((ModelVersionEvaluation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String outputVariableName;
        private String evaluationScore;
        private PredictionExplanations predictionExplanations;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVersionEvaluation model) {
            this.outputVariableName(model.outputVariableName);
            this.evaluationScore(model.evaluationScore);
            this.predictionExplanations(model.predictionExplanations);
        }

        public final String getOutputVariableName() {
            return this.outputVariableName;
        }

        public final void setOutputVariableName(String outputVariableName) {
            this.outputVariableName = outputVariableName;
        }

        @Override
        public final Builder outputVariableName(String outputVariableName) {
            this.outputVariableName = outputVariableName;
            return this;
        }

        public final String getEvaluationScore() {
            return this.evaluationScore;
        }

        public final void setEvaluationScore(String evaluationScore) {
            this.evaluationScore = evaluationScore;
        }

        @Override
        public final Builder evaluationScore(String evaluationScore) {
            this.evaluationScore = evaluationScore;
            return this;
        }

        public final PredictionExplanations.Builder getPredictionExplanations() {
            return this.predictionExplanations != null ? this.predictionExplanations.toBuilder() : null;
        }

        public final void setPredictionExplanations(PredictionExplanations.BuilderImpl predictionExplanations) {
            this.predictionExplanations = predictionExplanations != null ? predictionExplanations.build() : null;
        }

        @Override
        public final Builder predictionExplanations(PredictionExplanations predictionExplanations) {
            this.predictionExplanations = predictionExplanations;
            return this;
        }

        public ModelVersionEvaluation build() {
            return new ModelVersionEvaluation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelVersionEvaluation> {
        public Builder outputVariableName(String var1);

        public Builder evaluationScore(String var1);

        public Builder predictionExplanations(PredictionExplanations var1);

        default public Builder predictionExplanations(Consumer<PredictionExplanations.Builder> predictionExplanations) {
            return this.predictionExplanations((PredictionExplanations)((PredictionExplanations.Builder)PredictionExplanations.builder().applyMutation(predictionExplanations)).build());
        }
    }
}

