/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.internal.UserAgentUtils;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse;

public class GetExternalModelsPublisher
implements SdkPublisher<GetExternalModelsResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetExternalModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetExternalModelsPublisher(FraudDetectorAsyncClient client, GetExternalModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetExternalModelsPublisher(FraudDetectorAsyncClient client, GetExternalModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetExternalModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetExternalModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetExternalModelsResponseFetcher
    implements AsyncPageFetcher<GetExternalModelsResponse> {
        private GetExternalModelsResponseFetcher() {
        }

        public boolean hasNextPage(GetExternalModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetExternalModelsResponse> nextPage(GetExternalModelsResponse previousPage) {
            if (previousPage == null) {
                return GetExternalModelsPublisher.this.client.getExternalModels(GetExternalModelsPublisher.this.firstRequest);
            }
            return GetExternalModelsPublisher.this.client.getExternalModels((GetExternalModelsRequest)((Object)GetExternalModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

