/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VariableImpactExplanation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VariableImpactExplanation> {
    private static final SdkField<String> EVENT_VARIABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventVariableName").getter(VariableImpactExplanation.getter(VariableImpactExplanation::eventVariableName)).setter(VariableImpactExplanation.setter(Builder::eventVariableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariableName").build()}).build();
    private static final SdkField<String> RELATIVE_IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relativeImpact").getter(VariableImpactExplanation.getter(VariableImpactExplanation::relativeImpact)).setter(VariableImpactExplanation.setter(Builder::relativeImpact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relativeImpact").build()}).build();
    private static final SdkField<Float> LOG_ODDS_IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("logOddsImpact").getter(VariableImpactExplanation.getter(VariableImpactExplanation::logOddsImpact)).setter(VariableImpactExplanation.setter(Builder::logOddsImpact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logOddsImpact").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_VARIABLE_NAME_FIELD, RELATIVE_IMPACT_FIELD, LOG_ODDS_IMPACT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventVariableName;
    private final String relativeImpact;
    private final Float logOddsImpact;

    private VariableImpactExplanation(BuilderImpl builder) {
        this.eventVariableName = builder.eventVariableName;
        this.relativeImpact = builder.relativeImpact;
        this.logOddsImpact = builder.logOddsImpact;
    }

    public final String eventVariableName() {
        return this.eventVariableName;
    }

    public final String relativeImpact() {
        return this.relativeImpact;
    }

    public final Float logOddsImpact() {
        return this.logOddsImpact;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventVariableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.relativeImpact());
        hashCode = 31 * hashCode + Objects.hashCode(this.logOddsImpact());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VariableImpactExplanation)) {
            return false;
        }
        VariableImpactExplanation other = (VariableImpactExplanation)obj;
        return Objects.equals(this.eventVariableName(), other.eventVariableName()) && Objects.equals(this.relativeImpact(), other.relativeImpact()) && Objects.equals(this.logOddsImpact(), other.logOddsImpact());
    }

    public final String toString() {
        return ToString.builder((String)"VariableImpactExplanation").add("EventVariableName", (Object)this.eventVariableName()).add("RelativeImpact", (Object)this.relativeImpact()).add("LogOddsImpact", (Object)this.logOddsImpact()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventVariableName": {
                return Optional.ofNullable(clazz.cast(this.eventVariableName()));
            }
            case "relativeImpact": {
                return Optional.ofNullable(clazz.cast(this.relativeImpact()));
            }
            case "logOddsImpact": {
                return Optional.ofNullable(clazz.cast(this.logOddsImpact()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VariableImpactExplanation, T> g) {
        return obj -> g.apply((VariableImpactExplanation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventVariableName;
        private String relativeImpact;
        private Float logOddsImpact;

        private BuilderImpl() {
        }

        private BuilderImpl(VariableImpactExplanation model) {
            this.eventVariableName(model.eventVariableName);
            this.relativeImpact(model.relativeImpact);
            this.logOddsImpact(model.logOddsImpact);
        }

        public final String getEventVariableName() {
            return this.eventVariableName;
        }

        public final void setEventVariableName(String eventVariableName) {
            this.eventVariableName = eventVariableName;
        }

        @Override
        public final Builder eventVariableName(String eventVariableName) {
            this.eventVariableName = eventVariableName;
            return this;
        }

        public final String getRelativeImpact() {
            return this.relativeImpact;
        }

        public final void setRelativeImpact(String relativeImpact) {
            this.relativeImpact = relativeImpact;
        }

        @Override
        public final Builder relativeImpact(String relativeImpact) {
            this.relativeImpact = relativeImpact;
            return this;
        }

        public final Float getLogOddsImpact() {
            return this.logOddsImpact;
        }

        public final void setLogOddsImpact(Float logOddsImpact) {
            this.logOddsImpact = logOddsImpact;
        }

        @Override
        public final Builder logOddsImpact(Float logOddsImpact) {
            this.logOddsImpact = logOddsImpact;
            return this;
        }

        public VariableImpactExplanation build() {
            return new VariableImpactExplanation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VariableImpactExplanation> {
        public Builder eventVariableName(String var1);

        public Builder relativeImpact(String var1);

        public Builder logOddsImpact(Float var1);
    }
}

