/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse;

public class GetDetectorsIterable
implements SdkIterable<GetDetectorsResponse> {
    private final FraudDetectorClient client;
    private final GetDetectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetDetectorsIterable(FraudDetectorClient client, GetDetectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetDetectorsResponseFetcher();
    }

    public Iterator<GetDetectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetDetectorsResponseFetcher
    implements SyncPageFetcher<GetDetectorsResponse> {
        private GetDetectorsResponseFetcher() {
        }

        public boolean hasNextPage(GetDetectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetDetectorsResponse nextPage(GetDetectorsResponse previousPage) {
            if (previousPage == null) {
                return GetDetectorsIterable.this.client.getDetectors(GetDetectorsIterable.this.firstRequest);
            }
            return GetDetectorsIterable.this.client.getDetectors((GetDetectorsRequest)((Object)GetDetectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

