/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEventPredictionMetadataRequest extends FraudDetectorRequest implements
        ToCopyableBuilder<GetEventPredictionMetadataRequest.Builder, GetEventPredictionMetadataRequest> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(GetEventPredictionMetadataRequest::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventTypeName").getter(getter(GetEventPredictionMetadataRequest::eventTypeName))
            .setter(setter(Builder::eventTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()).build();

    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorId").getter(getter(GetEventPredictionMetadataRequest::detectorId))
            .setter(setter(Builder::detectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()).build();

    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorVersionId").getter(getter(GetEventPredictionMetadataRequest::detectorVersionId))
            .setter(setter(Builder::detectorVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()).build();

    private static final SdkField<String> PREDICTION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("predictionTimestamp").getter(getter(GetEventPredictionMetadataRequest::predictionTimestamp))
            .setter(setter(Builder::predictionTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD,
            EVENT_TYPE_NAME_FIELD, DETECTOR_ID_FIELD, DETECTOR_VERSION_ID_FIELD, PREDICTION_TIMESTAMP_FIELD));

    private final String eventId;

    private final String eventTypeName;

    private final String detectorId;

    private final String detectorVersionId;

    private final String predictionTimestamp;

    private GetEventPredictionMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.predictionTimestamp = builder.predictionTimestamp;
    }

    /**
     * <p>
     * The event ID.
     * </p>
     * 
     * @return The event ID.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event type associated with the detector specified for the prediction.
     * </p>
     * 
     * @return The event type associated with the detector specified for the prediction.
     */
    public final String eventTypeName() {
        return eventTypeName;
    }

    /**
     * <p>
     * The detector ID.
     * </p>
     * 
     * @return The detector ID.
     */
    public final String detectorId() {
        return detectorId;
    }

    /**
     * <p>
     * The detector version ID.
     * </p>
     * 
     * @return The detector version ID.
     */
    public final String detectorVersionId() {
        return detectorVersionId;
    }

    /**
     * <p>
     * The timestamp that defines when the prediction was generated.
     * </p>
     * 
     * @return The timestamp that defines when the prediction was generated.
     */
    public final String predictionTimestamp() {
        return predictionTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(predictionTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventPredictionMetadataRequest)) {
            return false;
        }
        GetEventPredictionMetadataRequest other = (GetEventPredictionMetadataRequest) obj;
        return Objects.equals(eventId(), other.eventId()) && Objects.equals(eventTypeName(), other.eventTypeName())
                && Objects.equals(detectorId(), other.detectorId())
                && Objects.equals(detectorVersionId(), other.detectorVersionId())
                && Objects.equals(predictionTimestamp(), other.predictionTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEventPredictionMetadataRequest").add("EventId", eventId())
                .add("EventTypeName", eventTypeName()).add("DetectorId", detectorId())
                .add("DetectorVersionId", detectorVersionId()).add("PredictionTimestamp", predictionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "eventTypeName":
            return Optional.ofNullable(clazz.cast(eventTypeName()));
        case "detectorId":
            return Optional.ofNullable(clazz.cast(detectorId()));
        case "detectorVersionId":
            return Optional.ofNullable(clazz.cast(detectorVersionId()));
        case "predictionTimestamp":
            return Optional.ofNullable(clazz.cast(predictionTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventPredictionMetadataRequest, T> g) {
        return obj -> g.apply((GetEventPredictionMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEventPredictionMetadataRequest> {
        /**
         * <p>
         * The event ID.
         * </p>
         * 
         * @param eventId
         *        The event ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The event type associated with the detector specified for the prediction.
         * </p>
         * 
         * @param eventTypeName
         *        The event type associated with the detector specified for the prediction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventTypeName(String eventTypeName);

        /**
         * <p>
         * The detector ID.
         * </p>
         * 
         * @param detectorId
         *        The detector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorId(String detectorId);

        /**
         * <p>
         * The detector version ID.
         * </p>
         * 
         * @param detectorVersionId
         *        The detector version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorVersionId(String detectorVersionId);

        /**
         * <p>
         * The timestamp that defines when the prediction was generated.
         * </p>
         * 
         * @param predictionTimestamp
         *        The timestamp that defines when the prediction was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictionTimestamp(String predictionTimestamp);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FraudDetectorRequest.BuilderImpl implements Builder {
        private String eventId;

        private String eventTypeName;

        private String detectorId;

        private String detectorVersionId;

        private String predictionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventPredictionMetadataRequest model) {
            super(model);
            eventId(model.eventId);
            eventTypeName(model.eventTypeName);
            detectorId(model.detectorId);
            detectorVersionId(model.detectorVersionId);
            predictionTimestamp(model.predictionTimestamp);
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getDetectorId() {
            return detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorVersionId() {
            return detectorVersionId;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        @Override
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final String getPredictionTimestamp() {
            return predictionTimestamp;
        }

        public final void setPredictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
        }

        @Override
        public final Builder predictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEventPredictionMetadataRequest build() {
            return new GetEventPredictionMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
