/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBatchPredictionJobsResponse extends FraudDetectorResponse implements
        ToCopyableBuilder<GetBatchPredictionJobsResponse.Builder, GetBatchPredictionJobsResponse> {
    private static final SdkField<List<BatchPrediction>> BATCH_PREDICTIONS_FIELD = SdkField
            .<List<BatchPrediction>> builder(MarshallingType.LIST)
            .memberName("batchPredictions")
            .getter(getter(GetBatchPredictionJobsResponse::batchPredictions))
            .setter(setter(Builder::batchPredictions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchPredictions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchPrediction> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchPrediction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetBatchPredictionJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_PREDICTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<BatchPrediction> batchPredictions;

    private final String nextToken;

    private GetBatchPredictionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.batchPredictions = builder.batchPredictions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchPredictions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBatchPredictions() {
        return batchPredictions != null && !(batchPredictions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the details of each batch prediction job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchPredictions} method.
     * </p>
     * 
     * @return An array containing the details of each batch prediction job.
     */
    public final List<BatchPrediction> batchPredictions() {
        return batchPredictions;
    }

    /**
     * <p>
     * The next token for the subsequent request.
     * </p>
     * 
     * @return The next token for the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBatchPredictions() ? batchPredictions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBatchPredictionJobsResponse)) {
            return false;
        }
        GetBatchPredictionJobsResponse other = (GetBatchPredictionJobsResponse) obj;
        return hasBatchPredictions() == other.hasBatchPredictions()
                && Objects.equals(batchPredictions(), other.batchPredictions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBatchPredictionJobsResponse")
                .add("BatchPredictions", hasBatchPredictions() ? batchPredictions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchPredictions":
            return Optional.ofNullable(clazz.cast(batchPredictions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBatchPredictionJobsResponse, T> g) {
        return obj -> g.apply((GetBatchPredictionJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FraudDetectorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBatchPredictionJobsResponse> {
        /**
         * <p>
         * An array containing the details of each batch prediction job.
         * </p>
         * 
         * @param batchPredictions
         *        An array containing the details of each batch prediction job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictions(Collection<BatchPrediction> batchPredictions);

        /**
         * <p>
         * An array containing the details of each batch prediction job.
         * </p>
         * 
         * @param batchPredictions
         *        An array containing the details of each batch prediction job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchPredictions(BatchPrediction... batchPredictions);

        /**
         * <p>
         * An array containing the details of each batch prediction job.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<BatchPrediction>.Builder} avoiding
         * the need to create one manually via {@link List<BatchPrediction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchPrediction>.Builder#build()} is called immediately and
         * its result is passed to {@link #batchPredictions(List<BatchPrediction>)}.
         * 
         * @param batchPredictions
         *        a consumer that will call methods on {@link List<BatchPrediction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchPredictions(List<BatchPrediction>)
         */
        Builder batchPredictions(Consumer<BatchPrediction.Builder>... batchPredictions);

        /**
         * <p>
         * The next token for the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        The next token for the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends FraudDetectorResponse.BuilderImpl implements Builder {
        private List<BatchPrediction> batchPredictions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBatchPredictionJobsResponse model) {
            super(model);
            batchPredictions(model.batchPredictions);
            nextToken(model.nextToken);
        }

        public final List<BatchPrediction.Builder> getBatchPredictions() {
            List<BatchPrediction.Builder> result = BatchPredictionListCopier.copyToBuilder(this.batchPredictions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchPredictions(Collection<BatchPrediction.BuilderImpl> batchPredictions) {
            this.batchPredictions = BatchPredictionListCopier.copyFromBuilder(batchPredictions);
        }

        @Override
        public final Builder batchPredictions(Collection<BatchPrediction> batchPredictions) {
            this.batchPredictions = BatchPredictionListCopier.copy(batchPredictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchPredictions(BatchPrediction... batchPredictions) {
            batchPredictions(Arrays.asList(batchPredictions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchPredictions(Consumer<BatchPrediction.Builder>... batchPredictions) {
            batchPredictions(Stream.of(batchPredictions).map(c -> BatchPrediction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetBatchPredictionJobsResponse build() {
            return new GetBatchPredictionJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
