/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The model training validation messages.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataValidationMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<DataValidationMetrics.Builder, DataValidationMetrics> {
    private static final SdkField<List<FileValidationMessage>> FILE_LEVEL_MESSAGES_FIELD = SdkField
            .<List<FileValidationMessage>> builder(MarshallingType.LIST)
            .memberName("fileLevelMessages")
            .getter(getter(DataValidationMetrics::fileLevelMessages))
            .setter(setter(Builder::fileLevelMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileLevelMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileValidationMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileValidationMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FieldValidationMessage>> FIELD_LEVEL_MESSAGES_FIELD = SdkField
            .<List<FieldValidationMessage>> builder(MarshallingType.LIST)
            .memberName("fieldLevelMessages")
            .getter(getter(DataValidationMetrics::fieldLevelMessages))
            .setter(setter(Builder::fieldLevelMessages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldLevelMessages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FieldValidationMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(FieldValidationMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_LEVEL_MESSAGES_FIELD,
            FIELD_LEVEL_MESSAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<FileValidationMessage> fileLevelMessages;

    private final List<FieldValidationMessage> fieldLevelMessages;

    private DataValidationMetrics(BuilderImpl builder) {
        this.fileLevelMessages = builder.fileLevelMessages;
        this.fieldLevelMessages = builder.fieldLevelMessages;
    }

    /**
     * For responses, this returns true if the service returned a value for the FileLevelMessages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFileLevelMessages() {
        return fileLevelMessages != null && !(fileLevelMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The file-specific model training validation messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFileLevelMessages} method.
     * </p>
     * 
     * @return The file-specific model training validation messages.
     */
    public final List<FileValidationMessage> fileLevelMessages() {
        return fileLevelMessages;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldLevelMessages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFieldLevelMessages() {
        return fieldLevelMessages != null && !(fieldLevelMessages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The field-specific model training validation messages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldLevelMessages} method.
     * </p>
     * 
     * @return The field-specific model training validation messages.
     */
    public final List<FieldValidationMessage> fieldLevelMessages() {
        return fieldLevelMessages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasFileLevelMessages() ? fileLevelMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldLevelMessages() ? fieldLevelMessages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataValidationMetrics)) {
            return false;
        }
        DataValidationMetrics other = (DataValidationMetrics) obj;
        return hasFileLevelMessages() == other.hasFileLevelMessages()
                && Objects.equals(fileLevelMessages(), other.fileLevelMessages())
                && hasFieldLevelMessages() == other.hasFieldLevelMessages()
                && Objects.equals(fieldLevelMessages(), other.fieldLevelMessages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataValidationMetrics")
                .add("FileLevelMessages", hasFileLevelMessages() ? fileLevelMessages() : null)
                .add("FieldLevelMessages", hasFieldLevelMessages() ? fieldLevelMessages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileLevelMessages":
            return Optional.ofNullable(clazz.cast(fileLevelMessages()));
        case "fieldLevelMessages":
            return Optional.ofNullable(clazz.cast(fieldLevelMessages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataValidationMetrics, T> g) {
        return obj -> g.apply((DataValidationMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataValidationMetrics> {
        /**
         * <p>
         * The file-specific model training validation messages.
         * </p>
         * 
         * @param fileLevelMessages
         *        The file-specific model training validation messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileLevelMessages(Collection<FileValidationMessage> fileLevelMessages);

        /**
         * <p>
         * The file-specific model training validation messages.
         * </p>
         * 
         * @param fileLevelMessages
         *        The file-specific model training validation messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileLevelMessages(FileValidationMessage... fileLevelMessages);

        /**
         * <p>
         * The file-specific model training validation messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FileValidationMessage>.Builder}
         * avoiding the need to create one manually via {@link List<FileValidationMessage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FileValidationMessage>.Builder#build()} is called
         * immediately and its result is passed to {@link #fileLevelMessages(List<FileValidationMessage>)}.
         * 
         * @param fileLevelMessages
         *        a consumer that will call methods on {@link List<FileValidationMessage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileLevelMessages(List<FileValidationMessage>)
         */
        Builder fileLevelMessages(Consumer<FileValidationMessage.Builder>... fileLevelMessages);

        /**
         * <p>
         * The field-specific model training validation messages.
         * </p>
         * 
         * @param fieldLevelMessages
         *        The field-specific model training validation messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelMessages(Collection<FieldValidationMessage> fieldLevelMessages);

        /**
         * <p>
         * The field-specific model training validation messages.
         * </p>
         * 
         * @param fieldLevelMessages
         *        The field-specific model training validation messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLevelMessages(FieldValidationMessage... fieldLevelMessages);

        /**
         * <p>
         * The field-specific model training validation messages.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FieldValidationMessage>.Builder}
         * avoiding the need to create one manually via {@link List<FieldValidationMessage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FieldValidationMessage>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldLevelMessages(List<FieldValidationMessage>)}.
         * 
         * @param fieldLevelMessages
         *        a consumer that will call methods on {@link List<FieldValidationMessage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldLevelMessages(List<FieldValidationMessage>)
         */
        Builder fieldLevelMessages(Consumer<FieldValidationMessage.Builder>... fieldLevelMessages);
    }

    static final class BuilderImpl implements Builder {
        private List<FileValidationMessage> fileLevelMessages = DefaultSdkAutoConstructList.getInstance();

        private List<FieldValidationMessage> fieldLevelMessages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataValidationMetrics model) {
            fileLevelMessages(model.fileLevelMessages);
            fieldLevelMessages(model.fieldLevelMessages);
        }

        public final List<FileValidationMessage.Builder> getFileLevelMessages() {
            List<FileValidationMessage.Builder> result = _fileValidationMessageListCopier.copyToBuilder(this.fileLevelMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileLevelMessages(Collection<FileValidationMessage.BuilderImpl> fileLevelMessages) {
            this.fileLevelMessages = _fileValidationMessageListCopier.copyFromBuilder(fileLevelMessages);
        }

        @Override
        public final Builder fileLevelMessages(Collection<FileValidationMessage> fileLevelMessages) {
            this.fileLevelMessages = _fileValidationMessageListCopier.copy(fileLevelMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileLevelMessages(FileValidationMessage... fileLevelMessages) {
            fileLevelMessages(Arrays.asList(fileLevelMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileLevelMessages(Consumer<FileValidationMessage.Builder>... fileLevelMessages) {
            fileLevelMessages(Stream.of(fileLevelMessages).map(c -> FileValidationMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FieldValidationMessage.Builder> getFieldLevelMessages() {
            List<FieldValidationMessage.Builder> result = _fieldValidationMessageListCopier
                    .copyToBuilder(this.fieldLevelMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldLevelMessages(Collection<FieldValidationMessage.BuilderImpl> fieldLevelMessages) {
            this.fieldLevelMessages = _fieldValidationMessageListCopier.copyFromBuilder(fieldLevelMessages);
        }

        @Override
        public final Builder fieldLevelMessages(Collection<FieldValidationMessage> fieldLevelMessages) {
            this.fieldLevelMessages = _fieldValidationMessageListCopier.copy(fieldLevelMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldLevelMessages(FieldValidationMessage... fieldLevelMessages) {
            fieldLevelMessages(Arrays.asList(fieldLevelMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldLevelMessages(Consumer<FieldValidationMessage.Builder>... fieldLevelMessages) {
            fieldLevelMessages(Stream.of(fieldLevelMessages).map(c -> FieldValidationMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataValidationMetrics build() {
            return new DataValidationMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
