/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.frauddetector;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchCreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchImportJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchImportJobResponse;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchPredictionJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CancelBatchPredictionJobResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchImportJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchImportJobResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchPredictionJobRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateBatchPredictionJobResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateModelRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateModelResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateRuleResponse;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.CreateVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchImportJobRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchImportJobResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchPredictionJobRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteBatchPredictionJobResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEntityTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEntityTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventsByEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteEventsByEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteExternalModelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteExternalModelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteOutcomeRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteOutcomeResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteRuleRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteRuleResponse;
import software.amazon.awssdk.services.frauddetector.model.DeleteVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.DeleteVariableResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest;
import software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDeleteEventsByEventTypeStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDeleteEventsByEventTypeStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventPredictionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventResponse;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetKmsEncryptionKeyRequest;
import software.amazon.awssdk.services.frauddetector.model.GetKmsEncryptionKeyResponse;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.GetModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetModelsResponse;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetRulesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetRulesResponse;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest;
import software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse;
import software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsRequest;
import software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsResponse;
import software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.PutDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.PutEntityTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutEntityTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.PutEventTypeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutEventTypeResponse;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutExternalModelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutKmsEncryptionKeyRequest;
import software.amazon.awssdk.services.frauddetector.model.PutKmsEncryptionKeyResponse;
import software.amazon.awssdk.services.frauddetector.model.PutLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.PutLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeRequest;
import software.amazon.awssdk.services.frauddetector.model.PutOutcomeResponse;
import software.amazon.awssdk.services.frauddetector.model.SendEventRequest;
import software.amazon.awssdk.services.frauddetector.model.SendEventResponse;
import software.amazon.awssdk.services.frauddetector.model.TagResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.TagResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.UntagResourceRequest;
import software.amazon.awssdk.services.frauddetector.model.UntagResourceResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateDetectorVersionStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateEventLabelRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateEventLabelResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionStatusRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateModelVersionStatusResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleMetadataResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateRuleVersionResponse;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableRequest;
import software.amazon.awssdk.services.frauddetector.model.UpdateVariableResponse;
import software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetBatchImportJobsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetBatchPredictionJobsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetLabelsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetModelsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetRulesPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.GetVariablesPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.ListEventPredictionsPublisher;
import software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourcePublisher;

/**
 * Service client for accessing Amazon Fraud Detector asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * This is the Amazon Fraud Detector API Reference. This guide is for developers who need detailed information about
 * Amazon Fraud Detector API actions, data types, and errors. For more information about Amazon Fraud Detector features,
 * see the <a href="https://docs.aws.amazon.com/frauddetector/latest/ug/">Amazon Fraud Detector User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface FraudDetectorAsyncClient extends SdkClient {
    String SERVICE_NAME = "frauddetector";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "frauddetector";

    /**
     * Create a {@link FraudDetectorAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static FraudDetectorAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link FraudDetectorAsyncClient}.
     */
    static FraudDetectorAsyncClientBuilder builder() {
        return new DefaultFraudDetectorAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a batch of variables.
     * </p>
     *
     * @param batchCreateVariableRequest
     * @return A Java Future containing the result of the BatchCreateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.BatchCreateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateVariableResponse> batchCreateVariable(
            BatchCreateVariableRequest batchCreateVariableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a batch of variables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateVariableRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreateVariableRequest#builder()}
     * </p>
     *
     * @param batchCreateVariableRequest
     *        A {@link Consumer} that will call methods on {@link BatchCreateVariableRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchCreateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.BatchCreateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchCreateVariable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchCreateVariableResponse> batchCreateVariable(
            Consumer<BatchCreateVariableRequest.Builder> batchCreateVariableRequest) {
        return batchCreateVariable(BatchCreateVariableRequest.builder().applyMutation(batchCreateVariableRequest).build());
    }

    /**
     * <p>
     * Gets a batch of variables.
     * </p>
     *
     * @param batchGetVariableRequest
     * @return A Java Future containing the result of the BatchGetVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.BatchGetVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetVariableResponse> batchGetVariable(BatchGetVariableRequest batchGetVariableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a batch of variables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetVariableRequest.Builder} avoiding the need
     * to create one manually via {@link BatchGetVariableRequest#builder()}
     * </p>
     *
     * @param batchGetVariableRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetVariableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.BatchGetVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/BatchGetVariable"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetVariableResponse> batchGetVariable(
            Consumer<BatchGetVariableRequest.Builder> batchGetVariableRequest) {
        return batchGetVariable(BatchGetVariableRequest.builder().applyMutation(batchGetVariableRequest).build());
    }

    /**
     * <p>
     * Cancels an in-progress batch import job.
     * </p>
     *
     * @param cancelBatchImportJobRequest
     * @return A Java Future containing the result of the CancelBatchImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CancelBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelBatchImportJobResponse> cancelBatchImportJob(
            CancelBatchImportJobRequest cancelBatchImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an in-progress batch import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelBatchImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelBatchImportJobRequest#builder()}
     * </p>
     *
     * @param cancelBatchImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelBatchImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelBatchImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CancelBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelBatchImportJobResponse> cancelBatchImportJob(
            Consumer<CancelBatchImportJobRequest.Builder> cancelBatchImportJobRequest) {
        return cancelBatchImportJob(CancelBatchImportJobRequest.builder().applyMutation(cancelBatchImportJobRequest).build());
    }

    /**
     * <p>
     * Cancels the specified batch prediction job.
     * </p>
     *
     * @param cancelBatchPredictionJobRequest
     * @return A Java Future containing the result of the CancelBatchPredictionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CancelBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelBatchPredictionJobResponse> cancelBatchPredictionJob(
            CancelBatchPredictionJobRequest cancelBatchPredictionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified batch prediction job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelBatchPredictionJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelBatchPredictionJobRequest#builder()}
     * </p>
     *
     * @param cancelBatchPredictionJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelBatchPredictionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelBatchPredictionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CancelBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CancelBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelBatchPredictionJobResponse> cancelBatchPredictionJob(
            Consumer<CancelBatchPredictionJobRequest.Builder> cancelBatchPredictionJobRequest) {
        return cancelBatchPredictionJob(CancelBatchPredictionJobRequest.builder().applyMutation(cancelBatchPredictionJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a batch import job.
     * </p>
     *
     * @param createBatchImportJobRequest
     * @return A Java Future containing the result of the CreateBatchImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBatchImportJobResponse> createBatchImportJob(
            CreateBatchImportJobRequest createBatchImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a batch import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBatchImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBatchImportJobRequest#builder()}
     * </p>
     *
     * @param createBatchImportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateBatchImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBatchImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBatchImportJobResponse> createBatchImportJob(
            Consumer<CreateBatchImportJobRequest.Builder> createBatchImportJobRequest) {
        return createBatchImportJob(CreateBatchImportJobRequest.builder().applyMutation(createBatchImportJobRequest).build());
    }

    /**
     * <p>
     * Creates a batch prediction job.
     * </p>
     *
     * @param createBatchPredictionJobRequest
     * @return A Java Future containing the result of the CreateBatchPredictionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBatchPredictionJobResponse> createBatchPredictionJob(
            CreateBatchPredictionJobRequest createBatchPredictionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a batch prediction job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBatchPredictionJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateBatchPredictionJobRequest#builder()}
     * </p>
     *
     * @param createBatchPredictionJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateBatchPredictionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateBatchPredictionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBatchPredictionJobResponse> createBatchPredictionJob(
            Consumer<CreateBatchPredictionJobRequest.Builder> createBatchPredictionJobRequest) {
        return createBatchPredictionJob(CreateBatchPredictionJobRequest.builder().applyMutation(createBatchPredictionJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a detector version. The detector version starts in a <code>DRAFT</code> status.
     * </p>
     *
     * @param createDetectorVersionRequest
     * @return A Java Future containing the result of the CreateDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDetectorVersionResponse> createDetectorVersion(
            CreateDetectorVersionRequest createDetectorVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a detector version. The detector version starts in a <code>DRAFT</code> status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDetectorVersionRequest#builder()}
     * </p>
     *
     * @param createDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateDetectorVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateDetectorVersionResponse> createDetectorVersion(
            Consumer<CreateDetectorVersionRequest.Builder> createDetectorVersionRequest) {
        return createDetectorVersion(CreateDetectorVersionRequest.builder().applyMutation(createDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Creates a model using the specified model type.
     * </p>
     *
     * @param createModelRequest
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a model using the specified model type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelRequest.Builder} avoiding the need to
     * create one manually via {@link CreateModelRequest#builder()}
     * </p>
     *
     * @param createModelRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateModelResponse> createModel(Consumer<CreateModelRequest.Builder> createModelRequest) {
        return createModel(CreateModelRequest.builder().applyMutation(createModelRequest).build());
    }

    /**
     * <p>
     * Creates a version of the model using the specified model type and model id.
     * </p>
     *
     * @param createModelVersionRequest
     * @return A Java Future containing the result of the CreateModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelVersionResponse> createModelVersion(CreateModelVersionRequest createModelVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a version of the model using the specified model type and model id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateModelVersionRequest#builder()}
     * </p>
     *
     * @param createModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateModelVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateModelVersionResponse> createModelVersion(
            Consumer<CreateModelVersionRequest.Builder> createModelVersionRequest) {
        return createModelVersion(CreateModelVersionRequest.builder().applyMutation(createModelVersionRequest).build());
    }

    /**
     * <p>
     * Creates a rule for use with the specified detector.
     * </p>
     *
     * @param createRuleRequest
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(CreateRuleRequest createRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule for use with the specified detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRuleRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRuleRequest#builder()}
     * </p>
     *
     * @param createRuleRequest
     *        A {@link Consumer} that will call methods on {@link CreateRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRuleResponse> createRule(Consumer<CreateRuleRequest.Builder> createRuleRequest) {
        return createRule(CreateRuleRequest.builder().applyMutation(createRuleRequest).build());
    }

    /**
     * <p>
     * Creates a variable.
     * </p>
     *
     * @param createVariableRequest
     * @return A Java Future containing the result of the CreateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVariableResponse> createVariable(CreateVariableRequest createVariableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a variable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVariableRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVariableRequest#builder()}
     * </p>
     *
     * @param createVariableRequest
     *        A {@link Consumer} that will call methods on {@link CreateVariableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.CreateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/CreateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateVariableResponse> createVariable(Consumer<CreateVariableRequest.Builder> createVariableRequest) {
        return createVariable(CreateVariableRequest.builder().applyMutation(createVariableRequest).build());
    }

    /**
     * <p>
     * Deletes data that was batch imported to Amazon Fraud Detector.
     * </p>
     *
     * @param deleteBatchImportJobRequest
     * @return A Java Future containing the result of the DeleteBatchImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBatchImportJobResponse> deleteBatchImportJob(
            DeleteBatchImportJobRequest deleteBatchImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes data that was batch imported to Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBatchImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBatchImportJobRequest#builder()}
     * </p>
     *
     * @param deleteBatchImportJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBatchImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBatchImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteBatchImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBatchImportJobResponse> deleteBatchImportJob(
            Consumer<DeleteBatchImportJobRequest.Builder> deleteBatchImportJobRequest) {
        return deleteBatchImportJob(DeleteBatchImportJobRequest.builder().applyMutation(deleteBatchImportJobRequest).build());
    }

    /**
     * <p>
     * Deletes a batch prediction job.
     * </p>
     *
     * @param deleteBatchPredictionJobRequest
     * @return A Java Future containing the result of the DeleteBatchPredictionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBatchPredictionJobResponse> deleteBatchPredictionJob(
            DeleteBatchPredictionJobRequest deleteBatchPredictionJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a batch prediction job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBatchPredictionJobRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteBatchPredictionJobRequest#builder()}
     * </p>
     *
     * @param deleteBatchPredictionJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteBatchPredictionJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteBatchPredictionJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteBatchPredictionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteBatchPredictionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBatchPredictionJobResponse> deleteBatchPredictionJob(
            Consumer<DeleteBatchPredictionJobRequest.Builder> deleteBatchPredictionJobRequest) {
        return deleteBatchPredictionJob(DeleteBatchPredictionJobRequest.builder().applyMutation(deleteBatchPredictionJobRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions
     * associated with the detector.
     * </p>
     * <p>
     * When you delete a detector, Amazon Fraud Detector permanently deletes the detector and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteDetectorRequest
     * @return A Java Future containing the result of the DeleteDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDetectorResponse> deleteDetector(DeleteDetectorRequest deleteDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the detector. Before deleting a detector, you must first delete all detector versions and rule versions
     * associated with the detector.
     * </p>
     * <p>
     * When you delete a detector, Amazon Fraud Detector permanently deletes the detector and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDetectorRequest#builder()}
     * </p>
     *
     * @param deleteDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDetectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetector" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteDetectorResponse> deleteDetector(Consumer<DeleteDetectorRequest.Builder> deleteDetectorRequest) {
        return deleteDetector(DeleteDetectorRequest.builder().applyMutation(deleteDetectorRequest).build());
    }

    /**
     * <p>
     * Deletes the detector version. You cannot delete detector versions that are in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * When you delete a detector version, Amazon Fraud Detector permanently deletes the detector and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteDetectorVersionRequest
     * @return A Java Future containing the result of the DeleteDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDetectorVersionResponse> deleteDetectorVersion(
            DeleteDetectorVersionRequest deleteDetectorVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the detector version. You cannot delete detector versions that are in <code>ACTIVE</code> status.
     * </p>
     * <p>
     * When you delete a detector version, Amazon Fraud Detector permanently deletes the detector and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDetectorVersionRequest#builder()}
     * </p>
     *
     * @param deleteDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDetectorVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteDetectorVersionResponse> deleteDetectorVersion(
            Consumer<DeleteDetectorVersionRequest.Builder> deleteDetectorVersionRequest) {
        return deleteDetectorVersion(DeleteDetectorVersionRequest.builder().applyMutation(deleteDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an entity type.
     * </p>
     * <p>
     * You cannot delete an entity type that is included in an event type.
     * </p>
     * <p>
     * When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteEntityTypeRequest
     * @return A Java Future containing the result of the DeleteEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEntityType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEntityTypeResponse> deleteEntityType(DeleteEntityTypeRequest deleteEntityTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an entity type.
     * </p>
     * <p>
     * You cannot delete an entity type that is included in an event type.
     * </p>
     * <p>
     * When you delete an entity type, Amazon Fraud Detector permanently deletes that entity type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEntityTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEntityTypeRequest#builder()}
     * </p>
     *
     * @param deleteEntityTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEntityTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEntityType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEntityTypeResponse> deleteEntityType(
            Consumer<DeleteEntityTypeRequest.Builder> deleteEntityTypeRequest) {
        return deleteEntityType(DeleteEntityTypeRequest.builder().applyMutation(deleteEntityTypeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified event.
     * </p>
     * <p>
     * When you delete an event, Amazon Fraud Detector permanently deletes that event and the event data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteEventRequest
     * @return A Java Future containing the result of the DeleteEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEventResponse> deleteEvent(DeleteEventRequest deleteEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified event.
     * </p>
     * <p>
     * When you delete an event, Amazon Fraud Detector permanently deletes that event and the event data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteEventRequest#builder()}
     * </p>
     *
     * @param deleteEventRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteEventResponse> deleteEvent(Consumer<DeleteEventRequest.Builder> deleteEventRequest) {
        return deleteEvent(DeleteEventRequest.builder().applyMutation(deleteEventRequest).build());
    }

    /**
     * <p>
     * Deletes an event type.
     * </p>
     * <p>
     * You cannot delete an event type that is used in a detector or a model.
     * </p>
     * <p>
     * When you delete an event type, Amazon Fraud Detector permanently deletes that event type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteEventTypeRequest
     * @return A Java Future containing the result of the DeleteEventType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventTypeResponse> deleteEventType(DeleteEventTypeRequest deleteEventTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an event type.
     * </p>
     * <p>
     * You cannot delete an event type that is used in a detector or a model.
     * </p>
     * <p>
     * When you delete an event type, Amazon Fraud Detector permanently deletes that event type and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEventTypeRequest#builder()}
     * </p>
     *
     * @param deleteEventTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteEventType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteEventTypeResponse> deleteEventType(
            Consumer<DeleteEventTypeRequest.Builder> deleteEventTypeRequest) {
        return deleteEventType(DeleteEventTypeRequest.builder().applyMutation(deleteEventTypeRequest).build());
    }

    /**
     * <p>
     * Deletes all events of a particular event type.
     * </p>
     *
     * @param deleteEventsByEventTypeRequest
     * @return A Java Future containing the result of the DeleteEventsByEventType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEventsByEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventsByEventType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventsByEventTypeResponse> deleteEventsByEventType(
            DeleteEventsByEventTypeRequest deleteEventsByEventTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all events of a particular event type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventsByEventTypeRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteEventsByEventTypeRequest#builder()}
     * </p>
     *
     * @param deleteEventsByEventTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventsByEventTypeRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteEventsByEventType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteEventsByEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteEventsByEventType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteEventsByEventTypeResponse> deleteEventsByEventType(
            Consumer<DeleteEventsByEventTypeRequest.Builder> deleteEventsByEventTypeRequest) {
        return deleteEventsByEventType(DeleteEventsByEventTypeRequest.builder().applyMutation(deleteEventsByEventTypeRequest)
                .build());
    }

    /**
     * <p>
     * Removes a SageMaker model from Amazon Fraud Detector.
     * </p>
     * <p>
     * You can remove an Amazon SageMaker model if it is not associated with a detector version. Removing a SageMaker
     * model disconnects it from Amazon Fraud Detector, but the model remains available in SageMaker.
     * </p>
     *
     * @param deleteExternalModelRequest
     * @return A Java Future containing the result of the DeleteExternalModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteExternalModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteExternalModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteExternalModelResponse> deleteExternalModel(
            DeleteExternalModelRequest deleteExternalModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a SageMaker model from Amazon Fraud Detector.
     * </p>
     * <p>
     * You can remove an Amazon SageMaker model if it is not associated with a detector version. Removing a SageMaker
     * model disconnects it from Amazon Fraud Detector, but the model remains available in SageMaker.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteExternalModelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteExternalModelRequest#builder()}
     * </p>
     *
     * @param deleteExternalModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteExternalModelRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteExternalModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteExternalModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteExternalModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteExternalModelResponse> deleteExternalModel(
            Consumer<DeleteExternalModelRequest.Builder> deleteExternalModelRequest) {
        return deleteExternalModel(DeleteExternalModelRequest.builder().applyMutation(deleteExternalModelRequest).build());
    }

    /**
     * <p>
     * Deletes a label.
     * </p>
     * <p>
     * You cannot delete labels that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * You cannot delete a label assigned to an event ID. You must first delete the relevant event ID.
     * </p>
     * <p>
     * When you delete a label, Amazon Fraud Detector permanently deletes that label and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteLabelRequest
     * @return A Java Future containing the result of the DeleteLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteLabel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLabelResponse> deleteLabel(DeleteLabelRequest deleteLabelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a label.
     * </p>
     * <p>
     * You cannot delete labels that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * You cannot delete a label assigned to an event ID. You must first delete the relevant event ID.
     * </p>
     * <p>
     * When you delete a label, Amazon Fraud Detector permanently deletes that label and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLabelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteLabelRequest#builder()}
     * </p>
     *
     * @param deleteLabelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLabelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteLabel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLabelResponse> deleteLabel(Consumer<DeleteLabelRequest.Builder> deleteLabelRequest) {
        return deleteLabel(DeleteLabelRequest.builder().applyMutation(deleteLabelRequest).build());
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model, Amazon Fraud Detector permanently deletes that model and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteModelRequest
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model, Amazon Fraud Detector permanently deletes that model and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteModelRequest#builder()}
     * </p>
     *
     * @param deleteModelRequest
     *        A {@link Consumer} that will call methods on {@link DeleteModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteModelResponse> deleteModel(Consumer<DeleteModelRequest.Builder> deleteModelRequest) {
        return deleteModel(DeleteModelRequest.builder().applyMutation(deleteModelRequest).build());
    }

    /**
     * <p>
     * Deletes a model version.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model version, Amazon Fraud Detector permanently deletes that model version and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteModelVersionRequest
     * @return A Java Future containing the result of the DeleteModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelVersionResponse> deleteModelVersion(DeleteModelVersionRequest deleteModelVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a model version.
     * </p>
     * <p>
     * You can delete models and model versions in Amazon Fraud Detector, provided that they are not associated with a
     * detector version.
     * </p>
     * <p>
     * When you delete a model version, Amazon Fraud Detector permanently deletes that model version and the data is no
     * longer stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteModelVersionRequest#builder()}
     * </p>
     *
     * @param deleteModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteModelVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteModelVersionResponse> deleteModelVersion(
            Consumer<DeleteModelVersionRequest.Builder> deleteModelVersionRequest) {
        return deleteModelVersion(DeleteModelVersionRequest.builder().applyMutation(deleteModelVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an outcome.
     * </p>
     * <p>
     * You cannot delete an outcome that is used in a rule version.
     * </p>
     * <p>
     * When you delete an outcome, Amazon Fraud Detector permanently deletes that outcome and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteOutcomeRequest
     * @return A Java Future containing the result of the DeleteOutcome operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteOutcome
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteOutcome" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteOutcomeResponse> deleteOutcome(DeleteOutcomeRequest deleteOutcomeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an outcome.
     * </p>
     * <p>
     * You cannot delete an outcome that is used in a rule version.
     * </p>
     * <p>
     * When you delete an outcome, Amazon Fraud Detector permanently deletes that outcome and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOutcomeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteOutcomeRequest#builder()}
     * </p>
     *
     * @param deleteOutcomeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOutcomeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteOutcome operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteOutcome
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteOutcome" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteOutcomeResponse> deleteOutcome(Consumer<DeleteOutcomeRequest.Builder> deleteOutcomeRequest) {
        return deleteOutcome(DeleteOutcomeRequest.builder().applyMutation(deleteOutcomeRequest).build());
    }

    /**
     * <p>
     * Deletes the rule. You cannot delete a rule if it is used by an <code>ACTIVE</code> or <code>INACTIVE</code>
     * detector version.
     * </p>
     * <p>
     * When you delete a rule, Amazon Fraud Detector permanently deletes that rule and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     *
     * @param deleteRuleRequest
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(DeleteRuleRequest deleteRuleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the rule. You cannot delete a rule if it is used by an <code>ACTIVE</code> or <code>INACTIVE</code>
     * detector version.
     * </p>
     * <p>
     * When you delete a rule, Amazon Fraud Detector permanently deletes that rule and the data is no longer stored in
     * Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRuleRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRuleRequest#builder()}
     * </p>
     *
     * @param deleteRuleRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRuleRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRule operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteRule" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRuleResponse> deleteRule(Consumer<DeleteRuleRequest.Builder> deleteRuleRequest) {
        return deleteRule(DeleteRuleRequest.builder().applyMutation(deleteRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a variable.
     * </p>
     * <p>
     * You can't delete variables that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * Amazon Fraud Detector automatically deletes model output variables and SageMaker model output variables when you
     * delete the model. You can't delete these variables manually.
     * </p>
     * <p>
     * When you delete a variable, Amazon Fraud Detector permanently deletes that variable and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     *
     * @param deleteVariableRequest
     * @return A Java Future containing the result of the DeleteVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVariableResponse> deleteVariable(DeleteVariableRequest deleteVariableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a variable.
     * </p>
     * <p>
     * You can't delete variables that are included in an event type in Amazon Fraud Detector.
     * </p>
     * <p>
     * Amazon Fraud Detector automatically deletes model output variables and SageMaker model output variables when you
     * delete the model. You can't delete these variables manually.
     * </p>
     * <p>
     * When you delete a variable, Amazon Fraud Detector permanently deletes that variable and the data is no longer
     * stored in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVariableRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVariableRequest#builder()}
     * </p>
     *
     * @param deleteVariableRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVariableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DeleteVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DeleteVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteVariableResponse> deleteVariable(Consumer<DeleteVariableRequest.Builder> deleteVariableRequest) {
        return deleteVariable(DeleteVariableRequest.builder().applyMutation(deleteVariableRequest).build());
    }

    /**
     * <p>
     * Gets all versions for a specified detector.
     * </p>
     *
     * @param describeDetectorRequest
     * @return A Java Future containing the result of the DescribeDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorResponse> describeDetector(DescribeDetectorRequest describeDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all versions for a specified detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectorRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDetectorRequest#builder()}
     * </p>
     *
     * @param describeDetectorRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDetectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeDetector"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDetectorResponse> describeDetector(
            Consumer<DescribeDetectorRequest.Builder> describeDetectorRequest) {
        return describeDetector(DescribeDetectorRequest.builder().applyMutation(describeDetectorRequest).build());
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     *
     * @param describeModelVersionsRequest
     * @return A Java Future containing the result of the DescribeModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelVersionsResponse> describeModelVersions(
            DescribeModelVersionsRequest describeModelVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelVersionsRequest#builder()}
     * </p>
     *
     * @param describeModelVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeModelVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeModelVersionsResponse> describeModelVersions(
            Consumer<DescribeModelVersionsRequest.Builder> describeModelVersionsRequest) {
        return describeModelVersions(DescribeModelVersionsRequest.builder().applyMutation(describeModelVersionsRequest).build());
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsPublisher publisher = client.describeModelVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsPublisher publisher = client.describeModelVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeModelVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelVersionsPublisher describeModelVersionsPaginator(
            DescribeModelVersionsRequest describeModelVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the model versions for the specified model type or for the specified model type and model ID. You can
     * also get details for a single, specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsPublisher publisher = client.describeModelVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.DescribeModelVersionsPublisher publisher = client.describeModelVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeModelVersions(software.amazon.awssdk.services.frauddetector.model.DescribeModelVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeModelVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeModelVersionsRequest#builder()}
     * </p>
     *
     * @param describeModelVersionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeModelVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.DescribeModelVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/DescribeModelVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeModelVersionsPublisher describeModelVersionsPaginator(
            Consumer<DescribeModelVersionsRequest.Builder> describeModelVersionsRequest) {
        return describeModelVersionsPaginator(DescribeModelVersionsRequest.builder().applyMutation(describeModelVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets all batch import jobs or a specific job of the specified ID. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 1 and 50. To get the next page results, provide the pagination
     * token from the <code>GetBatchImportJobsResponse</code> as part of your request. A null pagination token fetches
     * the records from the beginning.
     * </p>
     *
     * @param getBatchImportJobsRequest
     * @return A Java Future containing the result of the GetBatchImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetBatchImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBatchImportJobsResponse> getBatchImportJobs(GetBatchImportJobsRequest getBatchImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all batch import jobs or a specific job of the specified ID. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 1 and 50. To get the next page results, provide the pagination
     * token from the <code>GetBatchImportJobsResponse</code> as part of your request. A null pagination token fetches
     * the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBatchImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBatchImportJobsRequest#builder()}
     * </p>
     *
     * @param getBatchImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetBatchImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBatchImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetBatchImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBatchImportJobsResponse> getBatchImportJobs(
            Consumer<GetBatchImportJobsRequest.Builder> getBatchImportJobsRequest) {
        return getBatchImportJobs(GetBatchImportJobsRequest.builder().applyMutation(getBatchImportJobsRequest).build());
    }

    /**
     * <p>
     * Gets all batch import jobs or a specific job of the specified ID. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 1 and 50. To get the next page results, provide the pagination
     * token from the <code>GetBatchImportJobsResponse</code> as part of your request. A null pagination token fetches
     * the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBatchImportJobs(software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetBatchImportJobsPublisher publisher = client.getBatchImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetBatchImportJobsPublisher publisher = client.getBatchImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBatchImportJobs(software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBatchImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetBatchImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBatchImportJobsPublisher getBatchImportJobsPaginator(GetBatchImportJobsRequest getBatchImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all batch import jobs or a specific job of the specified ID. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 1 and 50. To get the next page results, provide the pagination
     * token from the <code>GetBatchImportJobsResponse</code> as part of your request. A null pagination token fetches
     * the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBatchImportJobs(software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetBatchImportJobsPublisher publisher = client.getBatchImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetBatchImportJobsPublisher publisher = client.getBatchImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBatchImportJobs(software.amazon.awssdk.services.frauddetector.model.GetBatchImportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBatchImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBatchImportJobsRequest#builder()}
     * </p>
     *
     * @param getBatchImportJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetBatchImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetBatchImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBatchImportJobsPublisher getBatchImportJobsPaginator(
            Consumer<GetBatchImportJobsRequest.Builder> getBatchImportJobsRequest) {
        return getBatchImportJobsPaginator(GetBatchImportJobsRequest.builder().applyMutation(getBatchImportJobsRequest).build());
    }

    /**
     * <p>
     * Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide
     * a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value
     * must be between 1 and 50. To get the next page results, provide the pagination token from the
     * GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     *
     * @param getBatchPredictionJobsRequest
     * @return A Java Future containing the result of the GetBatchPredictionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetBatchPredictionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchPredictionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBatchPredictionJobsResponse> getBatchPredictionJobs(
            GetBatchPredictionJobsRequest getBatchPredictionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide
     * a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value
     * must be between 1 and 50. To get the next page results, provide the pagination token from the
     * GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBatchPredictionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBatchPredictionJobsRequest#builder()}
     * </p>
     *
     * @param getBatchPredictionJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetBatchPredictionJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBatchPredictionJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetBatchPredictionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchPredictionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBatchPredictionJobsResponse> getBatchPredictionJobs(
            Consumer<GetBatchPredictionJobsRequest.Builder> getBatchPredictionJobsRequest) {
        return getBatchPredictionJobs(GetBatchPredictionJobsRequest.builder().applyMutation(getBatchPredictionJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide
     * a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value
     * must be between 1 and 50. To get the next page results, provide the pagination token from the
     * GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBatchPredictionJobs(software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetBatchPredictionJobsPublisher publisher = client.getBatchPredictionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetBatchPredictionJobsPublisher publisher = client.getBatchPredictionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBatchPredictionJobs(software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBatchPredictionJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetBatchPredictionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchPredictionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBatchPredictionJobsPublisher getBatchPredictionJobsPaginator(
            GetBatchPredictionJobsRequest getBatchPredictionJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all batch prediction jobs or a specific job if you specify a job ID. This is a paginated API. If you provide
     * a null maxResults, this action retrieves a maximum of 50 records per page. If you provide a maxResults, the value
     * must be between 1 and 50. To get the next page results, provide the pagination token from the
     * GetBatchPredictionJobsResponse as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBatchPredictionJobs(software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetBatchPredictionJobsPublisher publisher = client.getBatchPredictionJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetBatchPredictionJobsPublisher publisher = client.getBatchPredictionJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBatchPredictionJobs(software.amazon.awssdk.services.frauddetector.model.GetBatchPredictionJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBatchPredictionJobsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBatchPredictionJobsRequest#builder()}
     * </p>
     *
     * @param getBatchPredictionJobsRequest
     *        A {@link Consumer} that will call methods on {@link GetBatchPredictionJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetBatchPredictionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetBatchPredictionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default GetBatchPredictionJobsPublisher getBatchPredictionJobsPaginator(
            Consumer<GetBatchPredictionJobsRequest.Builder> getBatchPredictionJobsRequest) {
        return getBatchPredictionJobsPaginator(GetBatchPredictionJobsRequest.builder()
                .applyMutation(getBatchPredictionJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves the status of a <code>DeleteEventsByEventType</code> action.
     * </p>
     *
     * @param getDeleteEventsByEventTypeStatusRequest
     * @return A Java Future containing the result of the GetDeleteEventsByEventTypeStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDeleteEventsByEventTypeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDeleteEventsByEventTypeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeleteEventsByEventTypeStatusResponse> getDeleteEventsByEventTypeStatus(
            GetDeleteEventsByEventTypeStatusRequest getDeleteEventsByEventTypeStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of a <code>DeleteEventsByEventType</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDeleteEventsByEventTypeStatusRequest.Builder}
     * avoiding the need to create one manually via {@link GetDeleteEventsByEventTypeStatusRequest#builder()}
     * </p>
     *
     * @param getDeleteEventsByEventTypeStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetDeleteEventsByEventTypeStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetDeleteEventsByEventTypeStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDeleteEventsByEventTypeStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDeleteEventsByEventTypeStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeleteEventsByEventTypeStatusResponse> getDeleteEventsByEventTypeStatus(
            Consumer<GetDeleteEventsByEventTypeStatusRequest.Builder> getDeleteEventsByEventTypeStatusRequest) {
        return getDeleteEventsByEventTypeStatus(GetDeleteEventsByEventTypeStatusRequest.builder()
                .applyMutation(getDeleteEventsByEventTypeStatusRequest).build());
    }

    /**
     * <p>
     * Gets a particular detector version.
     * </p>
     *
     * @param getDetectorVersionRequest
     * @return A Java Future containing the result of the GetDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDetectorVersionResponse> getDetectorVersion(GetDetectorVersionRequest getDetectorVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a particular detector version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetDetectorVersionRequest#builder()}
     * </p>
     *
     * @param getDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetDetectorVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDetectorVersionResponse> getDetectorVersion(
            Consumer<GetDetectorVersionRequest.Builder> getDetectorVersionRequest) {
        return getDetectorVersion(GetDetectorVersionRequest.builder().applyMutation(getDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If
     * you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you
     * provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the
     * pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getDetectorsRequest
     * @return A Java Future containing the result of the GetDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDetectorsResponse> getDetectors(GetDetectorsRequest getDetectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If
     * you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you
     * provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the
     * pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDetectorsRequest#builder()}
     * </p>
     *
     * @param getDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetDetectorsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDetectors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDetectorsResponse> getDetectors(Consumer<GetDetectorsRequest.Builder> getDetectorsRequest) {
        return getDetectors(GetDetectorsRequest.builder().applyMutation(getDetectorsRequest).build());
    }

    /**
     * <p>
     * Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If
     * you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you
     * provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the
     * pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsPublisher publisher = client.getDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsPublisher publisher = client.getDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation.</b>
     * </p>
     *
     * @param getDetectorsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDetectorsPublisher getDetectorsPaginator(GetDetectorsRequest getDetectorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all detectors or a single detector if a <code>detectorId</code> is specified. This is a paginated API. If
     * you provide a null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you
     * provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the
     * pagination token from the <code>GetDetectorsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsPublisher publisher = client.getDetectorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetDetectorsPublisher publisher = client.getDetectorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetDetectorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getDetectors(software.amazon.awssdk.services.frauddetector.model.GetDetectorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDetectorsRequest.Builder} avoiding the need to
     * create one manually via {@link GetDetectorsRequest#builder()}
     * </p>
     *
     * @param getDetectorsRequest
     *        A {@link Consumer} that will call methods on {@link GetDetectorsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetDetectors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetDetectors" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDetectorsPublisher getDetectorsPaginator(Consumer<GetDetectorsRequest.Builder> getDetectorsRequest) {
        return getDetectorsPaginator(GetDetectorsRequest.builder().applyMutation(getDetectorsRequest).build());
    }

    /**
     * <p>
     * Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a
     * null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getEntityTypesRequest
     * @return A Java Future containing the result of the GetEntityTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEntityTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEntityTypesResponse> getEntityTypes(GetEntityTypesRequest getEntityTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a
     * null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntityTypesRequest.Builder} avoiding the need to
     * create one manually via {@link GetEntityTypesRequest#builder()}
     * </p>
     *
     * @param getEntityTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetEntityTypesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEntityTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEntityTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEntityTypesResponse> getEntityTypes(Consumer<GetEntityTypesRequest.Builder> getEntityTypesRequest) {
        return getEntityTypes(GetEntityTypesRequest.builder().applyMutation(getEntityTypesRequest).build());
    }

    /**
     * <p>
     * Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a
     * null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEntityTypes(software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesPublisher publisher = client.getEntityTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesPublisher publisher = client.getEntityTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEntityTypes(software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest)} operation.</b>
     * </p>
     *
     * @param getEntityTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEntityTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEntityTypesPublisher getEntityTypesPaginator(GetEntityTypesRequest getEntityTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all entity types or a specific entity type if a name is specified. This is a paginated API. If you provide a
     * null <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEntityTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEntityTypes(software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesPublisher publisher = client.getEntityTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEntityTypesPublisher publisher = client.getEntityTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetEntityTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEntityTypes(software.amazon.awssdk.services.frauddetector.model.GetEntityTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntityTypesRequest.Builder} avoiding the need to
     * create one manually via {@link GetEntityTypesRequest#builder()}
     * </p>
     *
     * @param getEntityTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetEntityTypesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEntityTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEntityTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEntityTypesPublisher getEntityTypesPaginator(Consumer<GetEntityTypesRequest.Builder> getEntityTypesRequest) {
        return getEntityTypesPaginator(GetEntityTypesRequest.builder().applyMutation(getEntityTypesRequest).build());
    }

    /**
     * <p>
     * Retrieves details of events stored with Amazon Fraud Detector. This action does not retrieve prediction results.
     * </p>
     *
     * @param getEventRequest
     * @return A Java Future containing the result of the GetEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEventResponse> getEvent(GetEventRequest getEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details of events stored with Amazon Fraud Detector. This action does not retrieve prediction results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventRequest#builder()}
     * </p>
     *
     * @param getEventRequest
     *        A {@link Consumer} that will call methods on {@link GetEventRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetEventResponse> getEvent(Consumer<GetEventRequest.Builder> getEventRequest) {
        return getEvent(GetEventRequest.builder().applyMutation(getEventRequest).build());
    }

    /**
     * <p>
     * Evaluates an event against a detector version. If a version ID is not provided, the detector’s (
     * <code>ACTIVE</code>) version is used.
     * </p>
     *
     * @param getEventPredictionRequest
     * @return A Java Future containing the result of the GetEventPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ResourceUnavailableException An exception indicating that the attached customer-owned (external)
     *         model threw an exception when Amazon Fraud Detector invoked the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventPrediction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPrediction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventPredictionResponse> getEventPrediction(GetEventPredictionRequest getEventPredictionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates an event against a detector version. If a version ID is not provided, the detector’s (
     * <code>ACTIVE</code>) version is used.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventPredictionRequest.Builder} avoiding the
     * need to create one manually via {@link GetEventPredictionRequest#builder()}
     * </p>
     *
     * @param getEventPredictionRequest
     *        A {@link Consumer} that will call methods on {@link GetEventPredictionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEventPrediction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ResourceUnavailableException An exception indicating that the attached customer-owned (external)
     *         model threw an exception when Amazon Fraud Detector invoked the model.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventPrediction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPrediction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventPredictionResponse> getEventPrediction(
            Consumer<GetEventPredictionRequest.Builder> getEventPredictionRequest) {
        return getEventPrediction(GetEventPredictionRequest.builder().applyMutation(getEventPredictionRequest).build());
    }

    /**
     * <p>
     * Gets details of the past fraud predictions for the specified event ID, event type, detector ID, and detector
     * version ID that was generated in the specified time period.
     * </p>
     *
     * @param getEventPredictionMetadataRequest
     * @return A Java Future containing the result of the GetEventPredictionMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventPredictionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPredictionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventPredictionMetadataResponse> getEventPredictionMetadata(
            GetEventPredictionMetadataRequest getEventPredictionMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details of the past fraud predictions for the specified event ID, event type, detector ID, and detector
     * version ID that was generated in the specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventPredictionMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link GetEventPredictionMetadataRequest#builder()}
     * </p>
     *
     * @param getEventPredictionMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetEventPredictionMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetEventPredictionMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventPredictionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventPredictionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetEventPredictionMetadataResponse> getEventPredictionMetadata(
            Consumer<GetEventPredictionMetadataRequest.Builder> getEventPredictionMetadataRequest) {
        return getEventPredictionMetadata(GetEventPredictionMetadataRequest.builder()
                .applyMutation(getEventPredictionMetadataRequest).build());
    }

    /**
     * <p>
     * Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getEventTypesRequest
     * @return A Java Future containing the result of the GetEventTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventTypesResponse> getEventTypes(GetEventTypesRequest getEventTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventTypesRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventTypesRequest#builder()}
     * </p>
     *
     * @param getEventTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetEventTypesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetEventTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetEventTypesResponse> getEventTypes(Consumer<GetEventTypesRequest.Builder> getEventTypesRequest) {
        return getEventTypes(GetEventTypesRequest.builder().applyMutation(getEventTypesRequest).build());
    }

    /**
     * <p>
     * Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEventTypes(software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesPublisher publisher = client.getEventTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesPublisher publisher = client.getEventTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEventTypes(software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest)} operation.</b>
     * </p>
     *
     * @param getEventTypesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventTypesPublisher getEventTypesPaginator(GetEventTypesRequest getEventTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all event types or a specific event type if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 10 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 5 and 10. To get the next page results, provide the pagination
     * token from the <code>GetEventTypesResponse</code> as part of your request. A null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getEventTypes(software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesPublisher publisher = client.getEventTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetEventTypesPublisher publisher = client.getEventTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetEventTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEventTypes(software.amazon.awssdk.services.frauddetector.model.GetEventTypesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventTypesRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventTypesRequest#builder()}
     * </p>
     *
     * @param getEventTypesRequest
     *        A {@link Consumer} that will call methods on {@link GetEventTypesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetEventTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetEventTypes" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEventTypesPublisher getEventTypesPaginator(Consumer<GetEventTypesRequest.Builder> getEventTypesRequest) {
        return getEventTypesPaginator(GetEventTypesRequest.builder().applyMutation(getEventTypesRequest).build());
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per
     * page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results,
     * provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null
     * pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getExternalModelsRequest
     * @return A Java Future containing the result of the GetExternalModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetExternalModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetExternalModelsResponse> getExternalModels(GetExternalModelsRequest getExternalModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per
     * page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results,
     * provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null
     * pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExternalModelsRequest.Builder} avoiding the need
     * to create one manually via {@link GetExternalModelsRequest#builder()}
     * </p>
     *
     * @param getExternalModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetExternalModelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetExternalModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetExternalModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetExternalModelsResponse> getExternalModels(
            Consumer<GetExternalModelsRequest.Builder> getExternalModelsRequest) {
        return getExternalModels(GetExternalModelsRequest.builder().applyMutation(getExternalModelsRequest).build());
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per
     * page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results,
     * provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null
     * pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsPublisher publisher = client.getExternalModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsPublisher publisher = client.getExternalModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getExternalModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetExternalModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExternalModelsPublisher getExternalModelsPaginator(GetExternalModelsRequest getExternalModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details for one or more Amazon SageMaker models that have been imported into the service. This is a
     * paginated API. If you provide a null <code>maxResults</code>, this actions retrieves a maximum of 10 records per
     * page. If you provide a <code>maxResults</code>, the value must be between 5 and 10. To get the next page results,
     * provide the pagination token from the <code>GetExternalModelsResult</code> as part of your request. A null
     * pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsPublisher publisher = client.getExternalModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetExternalModelsPublisher publisher = client.getExternalModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getExternalModels(software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExternalModelsRequest.Builder} avoiding the need
     * to create one manually via {@link GetExternalModelsRequest#builder()}
     * </p>
     *
     * @param getExternalModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetExternalModelsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetExternalModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetExternalModels"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExternalModelsPublisher getExternalModelsPaginator(
            Consumer<GetExternalModelsRequest.Builder> getExternalModelsRequest) {
        return getExternalModelsPaginator(GetExternalModelsRequest.builder().applyMutation(getExternalModelsRequest).build());
    }

    /**
     * <p>
     * Gets the encryption key if a KMS key has been specified to be used to encrypt content in Amazon Fraud Detector.
     * </p>
     *
     * @param getKmsEncryptionKeyRequest
     * @return A Java Future containing the result of the GetKMSEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetKMSEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetKmsEncryptionKeyResponse> getKMSEncryptionKey(
            GetKmsEncryptionKeyRequest getKmsEncryptionKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the encryption key if a KMS key has been specified to be used to encrypt content in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetKmsEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link GetKmsEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param getKmsEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on {@link GetKmsEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetKMSEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetKMSEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetKmsEncryptionKeyResponse> getKMSEncryptionKey(
            Consumer<GetKmsEncryptionKeyRequest.Builder> getKmsEncryptionKeyRequest) {
        return getKMSEncryptionKey(GetKmsEncryptionKeyRequest.builder().applyMutation(getKmsEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the
     * pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getLabelsRequest
     * @return A Java Future containing the result of the GetLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLabelsResponse> getLabels(GetLabelsRequest getLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the
     * pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetLabelsRequest#builder()}
     * </p>
     *
     * @param getLabelsRequest
     *        A {@link Consumer} that will call methods on {@link GetLabelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLabels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLabelsResponse> getLabels(Consumer<GetLabelsRequest.Builder> getLabelsRequest) {
        return getLabels(GetLabelsRequest.builder().applyMutation(getLabelsRequest).build());
    }

    /**
     * <p>
     * Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the
     * pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getLabels(software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetLabelsPublisher publisher = client.getLabelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetLabelsPublisher publisher = client.getLabelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLabels(software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest)} operation.</b>
     * </p>
     *
     * @param getLabelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLabelsPublisher getLabelsPaginator(GetLabelsRequest getLabelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all labels or a specific label if name is provided. This is a paginated API. If you provide a null
     * <code>maxResults</code>, this action retrieves a maximum of 50 records per page. If you provide a
     * <code>maxResults</code>, the value must be between 10 and 50. To get the next page results, provide the
     * pagination token from the <code>GetGetLabelsResponse</code> as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getLabels(software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetLabelsPublisher publisher = client.getLabelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetLabelsPublisher publisher = client.getLabelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getLabels(software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLabelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetLabelsRequest#builder()}
     * </p>
     *
     * @param getLabelsRequest
     *        A {@link Consumer} that will call methods on {@link GetLabelsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetLabels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetLabels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLabelsPublisher getLabelsPaginator(Consumer<GetLabelsRequest.Builder> getLabelsRequest) {
        return getLabelsPaginator(GetLabelsRequest.builder().applyMutation(getLabelsRequest).build());
    }

    /**
     * <p>
     * Gets the details of the specified model version.
     * </p>
     *
     * @param getModelVersionRequest
     * @return A Java Future containing the result of the GetModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetModelVersionResponse> getModelVersion(GetModelVersionRequest getModelVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the details of the specified model version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetModelVersionRequest#builder()}
     * </p>
     *
     * @param getModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link GetModelVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModelVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetModelVersionResponse> getModelVersion(
            Consumer<GetModelVersionRequest.Builder> getModelVersionRequest) {
        return getModelVersion(GetModelVersionRequest.builder().applyMutation(getModelVersionRequest).build());
    }

    /**
     * <p>
     * Gets one or more models. Gets all models for the Amazon Web Services account if no model type and no model id
     * provided. Gets all models for the Amazon Web Services account and model type, if the model type is specified but
     * model id is not provided. Gets a specific model if (model type, model id) tuple is specified.
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next
     * page results, provide the pagination token from the response as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     *
     * @param getModelsRequest
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetModelsResponse> getModels(GetModelsRequest getModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets one or more models. Gets all models for the Amazon Web Services account if no model type and no model id
     * provided. Gets all models for the Amazon Web Services account and model type, if the model type is specified but
     * model id is not provided. Gets a specific model if (model type, model id) tuple is specified.
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next
     * page results, provide the pagination token from the response as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetModelsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetModels operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetModelsResponse> getModels(Consumer<GetModelsRequest.Builder> getModelsRequest) {
        return getModels(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Gets one or more models. Gets all models for the Amazon Web Services account if no model type and no model id
     * provided. Gets all models for the Amazon Web Services account and model type, if the model type is specified but
     * model id is not provided. Gets a specific model if (model type, model id) tuple is specified.
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next
     * page results, provide the pagination token from the response as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)} operation.</b>
     * </p>
     *
     * @param getModelsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetModelsPublisher getModelsPaginator(GetModelsRequest getModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets one or more models. Gets all models for the Amazon Web Services account if no model type and no model id
     * provided. Gets all models for the Amazon Web Services account and model type, if the model type is specified but
     * model id is not provided. Gets a specific model if (model type, model id) tuple is specified.
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action retrieves a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 1 and 10. To get the next
     * page results, provide the pagination token from the response as part of your request. A null pagination token
     * fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetModelsPublisher publisher = client.getModelsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetModelsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetModelsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getModels(software.amazon.awssdk.services.frauddetector.model.GetModelsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetModelsRequest.Builder} avoiding the need to
     * create one manually via {@link GetModelsRequest#builder()}
     * </p>
     *
     * @param getModelsRequest
     *        A {@link Consumer} that will call methods on {@link GetModelsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetModels
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetModels" target="_top">AWS API
     *      Documentation</a>
     */
    default GetModelsPublisher getModelsPaginator(Consumer<GetModelsRequest.Builder> getModelsRequest) {
        return getModelsPaginator(GetModelsRequest.builder().applyMutation(getModelsRequest).build());
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions
     * retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between
     * 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as
     * part of your request. A null pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getOutcomesRequest
     * @return A Java Future containing the result of the GetOutcomes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetOutcomes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOutcomesResponse> getOutcomes(GetOutcomesRequest getOutcomesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions
     * retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between
     * 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as
     * part of your request. A null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutcomesRequest.Builder} avoiding the need to
     * create one manually via {@link GetOutcomesRequest#builder()}
     * </p>
     *
     * @param getOutcomesRequest
     *        A {@link Consumer} that will call methods on {@link GetOutcomesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOutcomes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetOutcomes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOutcomesResponse> getOutcomes(Consumer<GetOutcomesRequest.Builder> getOutcomesRequest) {
        return getOutcomes(GetOutcomesRequest.builder().applyMutation(getOutcomesRequest).build());
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions
     * retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between
     * 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as
     * part of your request. A null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesPublisher publisher = client.getOutcomesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesPublisher publisher = client.getOutcomesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)} operation.</b>
     * </p>
     *
     * @param getOutcomesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetOutcomes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOutcomesPublisher getOutcomesPaginator(GetOutcomesRequest getOutcomesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets one or more outcomes. This is a paginated API. If you provide a null <code>maxResults</code>, this actions
     * retrieves a maximum of 100 records per page. If you provide a <code>maxResults</code>, the value must be between
     * 50 and 100. To get the next page results, provide the pagination token from the <code>GetOutcomesResult</code> as
     * part of your request. A null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesPublisher publisher = client.getOutcomesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetOutcomesPublisher publisher = client.getOutcomesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetOutcomesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOutcomes(software.amazon.awssdk.services.frauddetector.model.GetOutcomesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOutcomesRequest.Builder} avoiding the need to
     * create one manually via {@link GetOutcomesRequest#builder()}
     * </p>
     *
     * @param getOutcomesRequest
     *        A {@link Consumer} that will call methods on {@link GetOutcomesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetOutcomes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetOutcomes" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOutcomesPublisher getOutcomesPaginator(Consumer<GetOutcomesRequest.Builder> getOutcomesRequest) {
        return getOutcomesPaginator(GetOutcomesRequest.builder().applyMutation(getOutcomesRequest).build());
    }

    /**
     * <p>
     * Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified.
     * Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both
     * the <code>ruleId</code> and the <code>ruleVersion</code> are specified.
     * </p>
     * <p>
     * This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you
     * provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination
     * token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.
     * </p>
     *
     * @param getRulesRequest
     * @return A Java Future containing the result of the GetRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRulesResponse> getRules(GetRulesRequest getRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified.
     * Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both
     * the <code>ruleId</code> and the <code>ruleVersion</code> are specified.
     * </p>
     * <p>
     * This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you
     * provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination
     * token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRulesRequest.Builder} avoiding the need to
     * create one manually via {@link GetRulesRequest#builder()}
     * </p>
     *
     * @param getRulesRequest
     *        A {@link Consumer} that will call methods on {@link GetRulesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRules operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRulesResponse> getRules(Consumer<GetRulesRequest.Builder> getRulesRequest) {
        return getRules(GetRulesRequest.builder().applyMutation(getRulesRequest).build());
    }

    /**
     * <p>
     * Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified.
     * Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both
     * the <code>ruleId</code> and the <code>ruleVersion</code> are specified.
     * </p>
     * <p>
     * This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you
     * provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination
     * token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesPublisher publisher = client.getRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesPublisher publisher = client.getRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)} operation.</b>
     * </p>
     *
     * @param getRulesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRulesPublisher getRulesPaginator(GetRulesRequest getRulesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get all rules for a detector (paginated) if <code>ruleId</code> and <code>ruleVersion</code> are not specified.
     * Gets all rules for the detector and the <code>ruleId</code> if present (paginated). Gets a specific rule if both
     * the <code>ruleId</code> and the <code>ruleVersion</code> are specified.
     * </p>
     * <p>
     * This is a paginated API. Providing null maxResults results in retrieving maximum of 100 records per page. If you
     * provide maxResults the value must be between 50 and 100. To get the next page result, a provide a pagination
     * token from GetRulesResult as part of your request. Null pagination token fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesPublisher publisher = client.getRulesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetRulesPublisher publisher = client.getRulesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetRulesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetRulesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getRules(software.amazon.awssdk.services.frauddetector.model.GetRulesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRulesRequest.Builder} avoiding the need to
     * create one manually via {@link GetRulesRequest#builder()}
     * </p>
     *
     * @param getRulesRequest
     *        A {@link Consumer} that will call methods on {@link GetRulesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetRules" target="_top">AWS API
     *      Documentation</a>
     */
    default GetRulesPublisher getRulesPaginator(Consumer<GetRulesRequest.Builder> getRulesRequest) {
        return getRulesPaginator(GetRulesRequest.builder().applyMutation(getRulesRequest).build());
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     *
     * @param getVariablesRequest
     * @return A Java Future containing the result of the GetVariables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetVariablesResponse> getVariables(GetVariablesRequest getVariablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVariablesRequest.Builder} avoiding the need to
     * create one manually via {@link GetVariablesRequest#builder()}
     * </p>
     *
     * @param getVariablesRequest
     *        A {@link Consumer} that will call methods on {@link GetVariablesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVariables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetVariablesResponse> getVariables(Consumer<GetVariablesRequest.Builder> getVariablesRequest) {
        return getVariables(GetVariablesRequest.builder().applyMutation(getVariablesRequest).build());
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesPublisher publisher = client.getVariablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesPublisher publisher = client.getVariablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation.</b>
     * </p>
     *
     * @param getVariablesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS
     *      API Documentation</a>
     */
    default GetVariablesPublisher getVariablesPaginator(GetVariablesRequest getVariablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all of the variables or the specific variable. This is a paginated API. Providing null
     * <code>maxSizePerPage</code> results in retrieving maximum of 100 records per page. If you provide
     * <code>maxSizePerPage</code> the value must be between 50 and 100. To get the next page result, a provide a
     * pagination token from <code>GetVariablesResult</code> as part of your request. Null pagination token fetches the
     * records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesPublisher publisher = client.getVariablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.GetVariablesPublisher publisher = client.getVariablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.GetVariablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getVariables(software.amazon.awssdk.services.frauddetector.model.GetVariablesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVariablesRequest.Builder} avoiding the need to
     * create one manually via {@link GetVariablesRequest#builder()}
     * </p>
     *
     * @param getVariablesRequest
     *        A {@link Consumer} that will call methods on {@link GetVariablesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.GetVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/GetVariables" target="_top">AWS
     *      API Documentation</a>
     */
    default GetVariablesPublisher getVariablesPaginator(Consumer<GetVariablesRequest.Builder> getVariablesRequest) {
        return getVariablesPaginator(GetVariablesRequest.builder().applyMutation(getVariablesRequest).build());
    }

    /**
     * <p>
     * Gets a list of past predictions. The list can be filtered by detector ID, detector version ID, event ID, event
     * type, or by specifying a time period. If filter is not specified, the most recent prediction is returned.
     * </p>
     * <p>
     * For example, the following filter lists all past predictions for <code>xyz</code> event type -
     * <code>{ "eventType":{ "value": "xyz" }” } </code>
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action will retrieve a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 50 and 100. To get the next
     * page results, provide the <code>nextToken</code> from the response as part of your request. A null
     * <code>nextToken</code> fetches the records from the beginning.
     * </p>
     *
     * @param listEventPredictionsRequest
     * @return A Java Future containing the result of the ListEventPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.ListEventPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListEventPredictions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventPredictionsResponse> listEventPredictions(
            ListEventPredictionsRequest listEventPredictionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of past predictions. The list can be filtered by detector ID, detector version ID, event ID, event
     * type, or by specifying a time period. If filter is not specified, the most recent prediction is returned.
     * </p>
     * <p>
     * For example, the following filter lists all past predictions for <code>xyz</code> event type -
     * <code>{ "eventType":{ "value": "xyz" }” } </code>
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action will retrieve a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 50 and 100. To get the next
     * page results, provide the <code>nextToken</code> from the response as part of your request. A null
     * <code>nextToken</code> fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventPredictionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventPredictionsRequest#builder()}
     * </p>
     *
     * @param listEventPredictionsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventPredictionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListEventPredictions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.ListEventPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListEventPredictions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListEventPredictionsResponse> listEventPredictions(
            Consumer<ListEventPredictionsRequest.Builder> listEventPredictionsRequest) {
        return listEventPredictions(ListEventPredictionsRequest.builder().applyMutation(listEventPredictionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of past predictions. The list can be filtered by detector ID, detector version ID, event ID, event
     * type, or by specifying a time period. If filter is not specified, the most recent prediction is returned.
     * </p>
     * <p>
     * For example, the following filter lists all past predictions for <code>xyz</code> event type -
     * <code>{ "eventType":{ "value": "xyz" }” } </code>
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action will retrieve a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 50 and 100. To get the next
     * page results, provide the <code>nextToken</code> from the response as part of your request. A null
     * <code>nextToken</code> fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventPredictions(software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListEventPredictionsPublisher publisher = client.listEventPredictionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListEventPredictionsPublisher publisher = client.listEventPredictionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventPredictions(software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventPredictionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.ListEventPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListEventPredictions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventPredictionsPublisher listEventPredictionsPaginator(ListEventPredictionsRequest listEventPredictionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of past predictions. The list can be filtered by detector ID, detector version ID, event ID, event
     * type, or by specifying a time period. If filter is not specified, the most recent prediction is returned.
     * </p>
     * <p>
     * For example, the following filter lists all past predictions for <code>xyz</code> event type -
     * <code>{ "eventType":{ "value": "xyz" }” } </code>
     * </p>
     * <p>
     * This is a paginated API. If you provide a null <code>maxResults</code>, this action will retrieve a maximum of 10
     * records per page. If you provide a <code>maxResults</code>, the value must be between 50 and 100. To get the next
     * page results, provide the <code>nextToken</code> from the response as part of your request. A null
     * <code>nextToken</code> fetches the records from the beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventPredictions(software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListEventPredictionsPublisher publisher = client.listEventPredictionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListEventPredictionsPublisher publisher = client.listEventPredictionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventPredictions(software.amazon.awssdk.services.frauddetector.model.ListEventPredictionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventPredictionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListEventPredictionsRequest#builder()}
     * </p>
     *
     * @param listEventPredictionsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventPredictionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.ListEventPredictions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListEventPredictions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventPredictionsPublisher listEventPredictionsPaginator(
            Consumer<ListEventPredictionsRequest.Builder> listEventPredictionsRequest) {
        return listEventPredictionsPaginator(ListEventPredictionsRequest.builder().applyMutation(listEventPredictionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the
     * pagination token from the response as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the
     * pagination token from the response as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the
     * pagination token from the response as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with the resource. This is a paginated API. To get the next page results, provide the
     * pagination token from the response as part of your request. A null pagination token fetches the records from the
     * beginning.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.frauddetector.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.frauddetector.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourcePublisher listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Creates or updates a detector.
     * </p>
     *
     * @param putDetectorRequest
     * @return A Java Future containing the result of the PutDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDetectorResponse> putDetector(PutDetectorRequest putDetectorRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutDetectorRequest.Builder} avoiding the need to
     * create one manually via {@link PutDetectorRequest#builder()}
     * </p>
     *
     * @param putDetectorRequest
     *        A {@link Consumer} that will call methods on {@link PutDetectorRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutDetector operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutDetector
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutDetector" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutDetectorResponse> putDetector(Consumer<PutDetectorRequest.Builder> putDetectorRequest) {
        return putDetector(PutDetectorRequest.builder().applyMutation(putDetectorRequest).build());
    }

    /**
     * <p>
     * Creates or updates an entity type. An entity represents who is performing the event. As part of a fraud
     * prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type
     * classifies the entity. Example classifications include customer, merchant, or account.
     * </p>
     *
     * @param putEntityTypeRequest
     * @return A Java Future containing the result of the PutEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEntityTypeResponse> putEntityType(PutEntityTypeRequest putEntityTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an entity type. An entity represents who is performing the event. As part of a fraud
     * prediction, you pass the entity ID to indicate the specific entity who performed the event. An entity type
     * classifies the entity. Example classifications include customer, merchant, or account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEntityTypeRequest.Builder} avoiding the need to
     * create one manually via {@link PutEntityTypeRequest#builder()}
     * </p>
     *
     * @param putEntityTypeRequest
     *        A {@link Consumer} that will call methods on {@link PutEntityTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutEntityType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutEntityType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEntityType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEntityTypeResponse> putEntityType(Consumer<PutEntityTypeRequest.Builder> putEntityTypeRequest) {
        return putEntityType(PutEntityTypeRequest.builder().applyMutation(putEntityTypeRequest).build());
    }

    /**
     * <p>
     * Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon
     * Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent
     * to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event
     * (such as a customer), and the labels that classify the event. Example event types include online payment
     * transactions, account registrations, and authentications.
     * </p>
     *
     * @param putEventTypeRequest
     * @return A Java Future containing the result of the PutEventType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEventTypeResponse> putEventType(PutEventTypeRequest putEventTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an event type. An event is a business activity that is evaluated for fraud risk. With Amazon
     * Fraud Detector, you generate fraud predictions for events. An event type defines the structure for an event sent
     * to Amazon Fraud Detector. This includes the variables sent as part of the event, the entity performing the event
     * (such as a customer), and the labels that classify the event. Example event types include online payment
     * transactions, account registrations, and authentications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutEventTypeRequest.Builder} avoiding the need to
     * create one manually via {@link PutEventTypeRequest#builder()}
     * </p>
     *
     * @param putEventTypeRequest
     *        A {@link Consumer} that will call methods on {@link PutEventTypeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutEventType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutEventType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutEventType" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<PutEventTypeResponse> putEventType(Consumer<PutEventTypeRequest.Builder> putEventTypeRequest) {
        return putEventType(PutEventTypeRequest.builder().applyMutation(putEventTypeRequest).build());
    }

    /**
     * <p>
     * Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration
     * of the model endpoint, including the IAM role and/or the mapped variables.
     * </p>
     *
     * @param putExternalModelRequest
     * @return A Java Future containing the result of the PutExternalModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutExternalModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutExternalModelResponse> putExternalModel(PutExternalModelRequest putExternalModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an Amazon SageMaker model endpoint. You can also use this action to update the configuration
     * of the model endpoint, including the IAM role and/or the mapped variables.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutExternalModelRequest.Builder} avoiding the need
     * to create one manually via {@link PutExternalModelRequest#builder()}
     * </p>
     *
     * @param putExternalModelRequest
     *        A {@link Consumer} that will call methods on {@link PutExternalModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutExternalModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutExternalModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutExternalModel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutExternalModelResponse> putExternalModel(
            Consumer<PutExternalModelRequest.Builder> putExternalModelRequest) {
        return putExternalModel(PutExternalModelRequest.builder().applyMutation(putExternalModelRequest).build());
    }

    /**
     * <p>
     * Specifies the KMS key to be used to encrypt content in Amazon Fraud Detector.
     * </p>
     *
     * @param putKmsEncryptionKeyRequest
     * @return A Java Future containing the result of the PutKMSEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutKMSEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutKmsEncryptionKeyResponse> putKMSEncryptionKey(
            PutKmsEncryptionKeyRequest putKmsEncryptionKeyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies the KMS key to be used to encrypt content in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutKmsEncryptionKeyRequest.Builder} avoiding the
     * need to create one manually via {@link PutKmsEncryptionKeyRequest#builder()}
     * </p>
     *
     * @param putKmsEncryptionKeyRequest
     *        A {@link Consumer} that will call methods on {@link PutKMSEncryptionKeyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutKMSEncryptionKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutKMSEncryptionKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutKMSEncryptionKey"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutKmsEncryptionKeyResponse> putKMSEncryptionKey(
            Consumer<PutKmsEncryptionKeyRequest.Builder> putKmsEncryptionKeyRequest) {
        return putKMSEncryptionKey(PutKmsEncryptionKeyRequest.builder().applyMutation(putKmsEncryptionKeyRequest).build());
    }

    /**
     * <p>
     * Creates or updates label. A label classifies an event as fraudulent or legitimate. Labels are associated with
     * event types and used to train supervised machine learning models in Amazon Fraud Detector.
     * </p>
     *
     * @param putLabelRequest
     * @return A Java Future containing the result of the PutLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutLabel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutLabelResponse> putLabel(PutLabelRequest putLabelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates label. A label classifies an event as fraudulent or legitimate. Labels are associated with
     * event types and used to train supervised machine learning models in Amazon Fraud Detector.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutLabelRequest.Builder} avoiding the need to
     * create one manually via {@link PutLabelRequest#builder()}
     * </p>
     *
     * @param putLabelRequest
     *        A {@link Consumer} that will call methods on {@link PutLabelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutLabel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutLabelResponse> putLabel(Consumer<PutLabelRequest.Builder> putLabelRequest) {
        return putLabel(PutLabelRequest.builder().applyMutation(putLabelRequest).build());
    }

    /**
     * <p>
     * Creates or updates an outcome.
     * </p>
     *
     * @param putOutcomeRequest
     * @return A Java Future containing the result of the PutOutcome operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutOutcome
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutOutcomeResponse> putOutcome(PutOutcomeRequest putOutcomeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates an outcome.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutOutcomeRequest.Builder} avoiding the need to
     * create one manually via {@link PutOutcomeRequest#builder()}
     * </p>
     *
     * @param putOutcomeRequest
     *        A {@link Consumer} that will call methods on {@link PutOutcomeRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutOutcome operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.PutOutcome
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/PutOutcome" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutOutcomeResponse> putOutcome(Consumer<PutOutcomeRequest.Builder> putOutcomeRequest) {
        return putOutcome(PutOutcomeRequest.builder().applyMutation(putOutcomeRequest).build());
    }

    /**
     * <p>
     * Stores events in Amazon Fraud Detector without generating fraud predictions for those events. For example, you
     * can use <code>SendEvent</code> to upload a historical dataset, which you can then later use to train a model.
     * </p>
     *
     * @param sendEventRequest
     * @return A Java Future containing the result of the SendEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.SendEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/SendEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendEventResponse> sendEvent(SendEventRequest sendEventRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stores events in Amazon Fraud Detector without generating fraud predictions for those events. For example, you
     * can use <code>SendEvent</code> to upload a historical dataset, which you can then later use to train a model.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendEventRequest.Builder} avoiding the need to
     * create one manually via {@link SendEventRequest#builder()}
     * </p>
     *
     * @param sendEventRequest
     *        A {@link Consumer} that will call methods on {@link SendEventRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SendEvent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.SendEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/SendEvent" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SendEventResponse> sendEvent(Consumer<SendEventRequest.Builder> sendEventRequest) {
        return sendEvent(SendEventRequest.builder().applyMutation(sendEventRequest).build());
    }

    /**
     * <p>
     * Assigns tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a detector version. The detector version attributes that you can update include models, external model
     * endpoints, rules, rule execution mode, and description. You can only update a <code>DRAFT</code> detector
     * version.
     * </p>
     *
     * @param updateDetectorVersionRequest
     * @return A Java Future containing the result of the UpdateDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionResponse> updateDetectorVersion(
            UpdateDetectorVersionRequest updateDetectorVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a detector version. The detector version attributes that you can update include models, external model
     * endpoints, rules, rule execution mode, and description. You can only update a <code>DRAFT</code> detector
     * version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDetectorVersionRequest#builder()}
     * </p>
     *
     * @param updateDetectorVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDetectorVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionResponse> updateDetectorVersion(
            Consumer<UpdateDetectorVersionRequest.Builder> updateDetectorVersionRequest) {
        return updateDetectorVersion(UpdateDetectorVersionRequest.builder().applyMutation(updateDetectorVersionRequest).build());
    }

    /**
     * <p>
     * Updates the detector version's description. You can update the metadata for any detector version (
     * <code>DRAFT, ACTIVE,</code> or <code>INACTIVE</code>).
     * </p>
     *
     * @param updateDetectorVersionMetadataRequest
     * @return A Java Future containing the result of the UpdateDetectorVersionMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionMetadataResponse> updateDetectorVersionMetadata(
            UpdateDetectorVersionMetadataRequest updateDetectorVersionMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the detector version's description. You can update the metadata for any detector version (
     * <code>DRAFT, ACTIVE,</code> or <code>INACTIVE</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorVersionMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDetectorVersionMetadataRequest#builder()}
     * </p>
     *
     * @param updateDetectorVersionMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorVersionMetadataRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateDetectorVersionMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionMetadataResponse> updateDetectorVersionMetadata(
            Consumer<UpdateDetectorVersionMetadataRequest.Builder> updateDetectorVersionMetadataRequest) {
        return updateDetectorVersionMetadata(UpdateDetectorVersionMetadataRequest.builder()
                .applyMutation(updateDetectorVersionMetadataRequest).build());
    }

    /**
     * <p>
     * Updates the detector version’s status. You can perform the following promotions or demotions using
     * <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to
     * <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.
     * </p>
     *
     * @param updateDetectorVersionStatusRequest
     * @return A Java Future containing the result of the UpdateDetectorVersionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionStatusResponse> updateDetectorVersionStatus(
            UpdateDetectorVersionStatusRequest updateDetectorVersionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the detector version’s status. You can perform the following promotions or demotions using
     * <code>UpdateDetectorVersionStatus</code>: <code>DRAFT</code> to <code>ACTIVE</code>, <code>ACTIVE</code> to
     * <code>INACTIVE</code>, and <code>INACTIVE</code> to <code>ACTIVE</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDetectorVersionStatusRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDetectorVersionStatusRequest#builder()}
     * </p>
     *
     * @param updateDetectorVersionStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDetectorVersionStatusRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateDetectorVersionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateDetectorVersionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateDetectorVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateDetectorVersionStatusResponse> updateDetectorVersionStatus(
            Consumer<UpdateDetectorVersionStatusRequest.Builder> updateDetectorVersionStatusRequest) {
        return updateDetectorVersionStatus(UpdateDetectorVersionStatusRequest.builder()
                .applyMutation(updateDetectorVersionStatusRequest).build());
    }

    /**
     * <p>
     * Updates the specified event with a new label.
     * </p>
     *
     * @param updateEventLabelRequest
     * @return A Java Future containing the result of the UpdateEventLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateEventLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateEventLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventLabelResponse> updateEventLabel(UpdateEventLabelRequest updateEventLabelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified event with a new label.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEventLabelRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEventLabelRequest#builder()}
     * </p>
     *
     * @param updateEventLabelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEventLabelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateEventLabel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateEventLabel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateEventLabel"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateEventLabelResponse> updateEventLabel(
            Consumer<UpdateEventLabelRequest.Builder> updateEventLabelRequest) {
        return updateEventLabel(UpdateEventLabelRequest.builder().applyMutation(updateEventLabelRequest).build());
    }

    /**
     * <p>
     * Updates model description.
     * </p>
     *
     * @param updateModelRequest
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateModelResponse> updateModel(UpdateModelRequest updateModelRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates model description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateModelRequest#builder()}
     * </p>
     *
     * @param updateModelRequest
     *        A {@link Consumer} that will call methods on {@link UpdateModelRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateModel operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModel
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModel" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateModelResponse> updateModel(Consumer<UpdateModelRequest.Builder> updateModelRequest) {
        return updateModel(UpdateModelRequest.builder().applyMutation(updateModelRequest).build());
    }

    /**
     * <p>
     * Updates a model version. Updating a model version retrains an existing model version using updated training data
     * and produces a new minor version of the model. You can update the training data set location and data access role
     * attributes using this action. This action creates and trains a new minor version of the model, for example
     * version 1.01, 1.02, 1.03.
     * </p>
     *
     * @param updateModelVersionRequest
     * @return A Java Future containing the result of the UpdateModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateModelVersionResponse> updateModelVersion(UpdateModelVersionRequest updateModelVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a model version. Updating a model version retrains an existing model version using updated training data
     * and produces a new minor version of the model. You can update the training data set location and data access role
     * attributes using this action. This action creates and trains a new minor version of the model, for example
     * version 1.01, 1.02, 1.03.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateModelVersionRequest#builder()}
     * </p>
     *
     * @param updateModelVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateModelVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateModelVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModelVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateModelVersionResponse> updateModelVersion(
            Consumer<UpdateModelVersionRequest.Builder> updateModelVersionRequest) {
        return updateModelVersion(UpdateModelVersionRequest.builder().applyMutation(updateModelVersionRequest).build());
    }

    /**
     * <p>
     * Updates the status of a model version.
     * </p>
     * <p>
     * You can perform the following status updates:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change <code>ACTIVE</code> to <code>INACTIVE</code>.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateModelVersionStatusRequest
     * @return A Java Future containing the result of the UpdateModelVersionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModelVersionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateModelVersionStatusResponse> updateModelVersionStatus(
            UpdateModelVersionStatusRequest updateModelVersionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the status of a model version.
     * </p>
     * <p>
     * You can perform the following status updates:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Change the <code>TRAINING_COMPLETE</code> status to <code>ACTIVE</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Change <code>ACTIVE</code> to <code>INACTIVE</code>.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateModelVersionStatusRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateModelVersionStatusRequest#builder()}
     * </p>
     *
     * @param updateModelVersionStatusRequest
     *        A {@link Consumer} that will call methods on {@link UpdateModelVersionStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateModelVersionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateModelVersionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateModelVersionStatusResponse> updateModelVersionStatus(
            Consumer<UpdateModelVersionStatusRequest.Builder> updateModelVersionStatusRequest) {
        return updateModelVersionStatus(UpdateModelVersionStatusRequest.builder().applyMutation(updateModelVersionStatusRequest)
                .build());
    }

    /**
     * <p>
     * Updates a rule's metadata. The description attribute can be updated.
     * </p>
     *
     * @param updateRuleMetadataRequest
     * @return A Java Future containing the result of the UpdateRuleMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateRuleMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRuleMetadataResponse> updateRuleMetadata(UpdateRuleMetadataRequest updateRuleMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a rule's metadata. The description attribute can be updated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRuleMetadataRequest#builder()}
     * </p>
     *
     * @param updateRuleMetadataRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRuleMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateRuleMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateRuleMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRuleMetadataResponse> updateRuleMetadata(
            Consumer<UpdateRuleMetadataRequest.Builder> updateRuleMetadataRequest) {
        return updateRuleMetadata(UpdateRuleMetadataRequest.builder().applyMutation(updateRuleMetadataRequest).build());
    }

    /**
     * <p>
     * Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version
     * (version 1, 2, 3 ...).
     * </p>
     *
     * @param updateRuleVersionRequest
     * @return A Java Future containing the result of the UpdateRuleVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateRuleVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRuleVersionResponse> updateRuleVersion(UpdateRuleVersionRequest updateRuleVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a rule version resulting in a new rule version. Updates a rule version resulting in a new rule version
     * (version 1, 2, 3 ...).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRuleVersionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateRuleVersionRequest#builder()}
     * </p>
     *
     * @param updateRuleVersionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRuleVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRuleVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateRuleVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateRuleVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRuleVersionResponse> updateRuleVersion(
            Consumer<UpdateRuleVersionRequest.Builder> updateRuleVersionRequest) {
        return updateRuleVersion(UpdateRuleVersionRequest.builder().applyMutation(updateRuleVersionRequest).build());
    }

    /**
     * <p>
     * Updates a variable.
     * </p>
     *
     * @param updateVariableRequest
     * @return A Java Future containing the result of the UpdateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVariableResponse> updateVariable(UpdateVariableRequest updateVariableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a variable.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVariableRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateVariableRequest#builder()}
     * </p>
     *
     * @param updateVariableRequest
     *        A {@link Consumer} that will call methods on {@link UpdateVariableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateVariable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException An exception indicating a specified value is not allowed.</li>
     *         <li>ResourceNotFoundException An exception indicating the specified resource was not found.</li>
     *         <li>InternalServerException An exception indicating an internal server error.</li>
     *         <li>ThrottlingException An exception indicating a throttling error.</li>
     *         <li>AccessDeniedException An exception indicating Amazon Fraud Detector does not have the needed
     *         permissions. This can occur if you submit a request, such as <code>PutExternalModel</code>, that
     *         specifies a role that is not in your account.</li>
     *         <li>ConflictException An exception indicating there was a conflict during a delete operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>FraudDetectorException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample FraudDetectorAsyncClient.UpdateVariable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateVariable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateVariableResponse> updateVariable(Consumer<UpdateVariableRequest.Builder> updateVariableRequest) {
        return updateVariable(UpdateVariableRequest.builder().applyMutation(updateVariableRequest).build());
    }
}
