/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorClient;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetExternalModelsResponse;

public class GetExternalModelsIterable
implements SdkIterable<GetExternalModelsResponse> {
    private final FraudDetectorClient client;
    private final GetExternalModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetExternalModelsIterable(FraudDetectorClient client, GetExternalModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetExternalModelsResponseFetcher();
    }

    public Iterator<GetExternalModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetExternalModelsResponseFetcher
    implements SyncPageFetcher<GetExternalModelsResponse> {
        private GetExternalModelsResponseFetcher() {
        }

        public boolean hasNextPage(GetExternalModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetExternalModelsResponse nextPage(GetExternalModelsResponse previousPage) {
            if (previousPage == null) {
                return GetExternalModelsIterable.this.client.getExternalModels(GetExternalModelsIterable.this.firstRequest);
            }
            return GetExternalModelsIterable.this.client.getExternalModels((GetExternalModelsRequest)((Object)GetExternalModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

