/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.DetectorVersionSummary;
import software.amazon.awssdk.services.frauddetector.model.DetectorVersionSummaryListCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDetectorResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, DescribeDetectorResponse> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDetectorResponse.getter(DescribeDetectorResponse::detectorId)).setter(DescribeDetectorResponse.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<List<DetectorVersionSummary>> DETECTOR_VERSION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDetectorResponse.getter(DescribeDetectorResponse::detectorVersionSummaries)).setter(DescribeDetectorResponse.setter(Builder::detectorVersionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetectorVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDetectorResponse.getter(DescribeDetectorResponse::nextToken)).setter(DescribeDetectorResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, DETECTOR_VERSION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final String detectorId;
    private final List<DetectorVersionSummary> detectorVersionSummaries;
    private final String nextToken;

    private DescribeDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.detectorVersionSummaries = builder.detectorVersionSummaries;
        this.nextToken = builder.nextToken;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public boolean hasDetectorVersionSummaries() {
        return this.detectorVersionSummaries != null && !(this.detectorVersionSummaries instanceof SdkAutoConstructList);
    }

    public List<DetectorVersionSummary> detectorVersionSummaries() {
        return this.detectorVersionSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersionSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDetectorResponse)) {
            return false;
        }
        DescribeDetectorResponse other = (DescribeDetectorResponse)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorVersionSummaries(), other.detectorVersionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDetectorResponse").add("DetectorId", (Object)this.detectorId()).add("DetectorVersionSummaries", this.detectorVersionSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorVersionSummaries": {
                return Optional.ofNullable(clazz.cast(this.detectorVersionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDetectorResponse, T> g) {
        return obj -> g.apply((DescribeDetectorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private String detectorId;
        private List<DetectorVersionSummary> detectorVersionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDetectorResponse model) {
            super(model);
            this.detectorId(model.detectorId);
            this.detectorVersionSummaries(model.detectorVersionSummaries);
            this.nextToken(model.nextToken);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Collection<DetectorVersionSummary.Builder> getDetectorVersionSummaries() {
            return this.detectorVersionSummaries != null ? (Collection)this.detectorVersionSummaries.stream().map(DetectorVersionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder detectorVersionSummaries(Collection<DetectorVersionSummary> detectorVersionSummaries) {
            this.detectorVersionSummaries = DetectorVersionSummaryListCopier.copy(detectorVersionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorVersionSummaries(DetectorVersionSummary ... detectorVersionSummaries) {
            this.detectorVersionSummaries(Arrays.asList(detectorVersionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorVersionSummaries(Consumer<DetectorVersionSummary.Builder> ... detectorVersionSummaries) {
            this.detectorVersionSummaries(Stream.of(detectorVersionSummaries).map(c -> (DetectorVersionSummary)((DetectorVersionSummary.Builder)DetectorVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDetectorVersionSummaries(Collection<DetectorVersionSummary.BuilderImpl> detectorVersionSummaries) {
            this.detectorVersionSummaries = DetectorVersionSummaryListCopier.copyFromBuilder(detectorVersionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDetectorResponse build() {
            return new DescribeDetectorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDetectorResponse> {
        public Builder detectorId(String var1);

        public Builder detectorVersionSummaries(Collection<DetectorVersionSummary> var1);

        public Builder detectorVersionSummaries(DetectorVersionSummary ... var1);

        public Builder detectorVersionSummaries(Consumer<DetectorVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

