/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecastquery.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class PredictionsCopier {
    static Map<String, List<DataPoint>> copy(Map<String, ? extends Collection<? extends DataPoint>> predictionsParam) {
        Map<String, List<DataPoint>> map;
        if (predictionsParam == null || predictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<DataPoint>> modifiableMap = new LinkedHashMap<>();
            predictionsParam.forEach((key, value) -> {
                List<DataPoint> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<DataPoint> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        modifiableList.add(entry);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<DataPoint>> copyFromBuilder(
            Map<String, ? extends Collection<? extends DataPoint.Builder>> predictionsParam) {
        Map<String, List<DataPoint>> map;
        if (predictionsParam == null || predictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<DataPoint>> modifiableMap = new LinkedHashMap<>();
            predictionsParam.forEach((key, value) -> {
                List<DataPoint> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<DataPoint> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        DataPoint member = entry == null ? null : entry.build();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, List<DataPoint.Builder>> copyToBuilder(
            Map<String, ? extends Collection<? extends DataPoint>> predictionsParam) {
        Map<String, List<DataPoint.Builder>> map;
        if (predictionsParam == null || predictionsParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, List<DataPoint.Builder>> modifiableMap = new LinkedHashMap<>();
            predictionsParam.forEach((key, value) -> {
                List<DataPoint.Builder> list;
                if (value == null || value instanceof SdkAutoConstructList) {
                    list = DefaultSdkAutoConstructList.getInstance();
                } else {
                    List<DataPoint.Builder> modifiableList = new ArrayList<>();
                    value.forEach(entry -> {
                        DataPoint.Builder member = entry == null ? null : entry.toBuilder();
                        modifiableList.add(member);
                    });
                    list = Collections.unmodifiableList(modifiableList);
                }
                modifiableMap.put(key, list);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
