/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetImportJobRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateDatasetImportJobRequest.Builder, CreateDatasetImportJobRequest> {
    private static final SdkField<String> DATASET_IMPORT_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDatasetImportJobRequest::datasetImportJobName)).setter(setter(Builder::datasetImportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobName").build())
            .build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDatasetImportJobRequest::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDatasetImportJobRequest::dataSource)).setter(setter(Builder::dataSource))
            .constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDatasetImportJobRequest::timestampFormat)).setter(setter(Builder::timestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_NAME_FIELD,
            DATASET_ARN_FIELD, DATA_SOURCE_FIELD, TIMESTAMP_FORMAT_FIELD));

    private final String datasetImportJobName;

    private final String datasetArn;

    private final DataSource dataSource;

    private final String timestampFormat;

    private CreateDatasetImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.datasetImportJobName = builder.datasetImportJobName;
        this.datasetArn = builder.datasetArn;
        this.dataSource = builder.dataSource;
        this.timestampFormat = builder.timestampFormat;
    }

    /**
     * <p>
     * The name for the dataset import job. It is recommended to include the current timestamp in the name to guard
     * against getting a <code>ResourceAlreadyExistsException</code> exception, for example,
     * <code>20190721DatasetImport</code>.
     * </p>
     * 
     * @return The name for the dataset import job. It is recommended to include the current timestamp in the name to
     *         guard against getting a <code>ResourceAlreadyExistsException</code> exception, for example,
     *         <code>20190721DatasetImport</code>.
     */
    public String datasetImportJobName() {
        return datasetImportJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.
     */
    public String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon
     * Forecast can assume to access the data.
     * </p>
     * 
     * @return The location of the training data to import and an AWS Identity and Access Management (IAM) role that
     *         Amazon Forecast can assume to access the data.
     */
    public DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The format of timestamps in the dataset. Two formats are supported, dependent on the <code>DataFrequency</code>
     * specified when the dataset was created.
     * </p>
     * <ul>
     * <li>
     * <p>
     * "yyyy-MM-dd"
     * </p>
     * <p>
     * For data frequencies: Y, M, W, and D
     * </p>
     * </li>
     * <li>
     * <p>
     * "yyyy-MM-dd HH:mm:ss"
     * </p>
     * <p>
     * For data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
     * </p>
     * </li>
     * </ul>
     * 
     * @return The format of timestamps in the dataset. Two formats are supported, dependent on the
     *         <code>DataFrequency</code> specified when the dataset was created.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         "yyyy-MM-dd"
     *         </p>
     *         <p>
     *         For data frequencies: Y, M, W, and D
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "yyyy-MM-dd HH:mm:ss"
     *         </p>
     *         <p>
     *         For data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
     *         </p>
     *         </li>
     */
    public String timestampFormat() {
        return timestampFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(timestampFormat());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetImportJobRequest)) {
            return false;
        }
        CreateDatasetImportJobRequest other = (CreateDatasetImportJobRequest) obj;
        return Objects.equals(datasetImportJobName(), other.datasetImportJobName())
                && Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(timestampFormat(), other.timestampFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDatasetImportJobRequest").add("DatasetImportJobName", datasetImportJobName())
                .add("DatasetArn", datasetArn()).add("DataSource", dataSource()).add("TimestampFormat", timestampFormat())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetImportJobName":
            return Optional.ofNullable(clazz.cast(datasetImportJobName()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "TimestampFormat":
            return Optional.ofNullable(clazz.cast(timestampFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetImportJobRequest, T> g) {
        return obj -> g.apply((CreateDatasetImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetImportJobRequest> {
        /**
         * <p>
         * The name for the dataset import job. It is recommended to include the current timestamp in the name to guard
         * against getting a <code>ResourceAlreadyExistsException</code> exception, for example,
         * <code>20190721DatasetImport</code>.
         * </p>
         * 
         * @param datasetImportJobName
         *        The name for the dataset import job. It is recommended to include the current timestamp in the name to
         *        guard against getting a <code>ResourceAlreadyExistsException</code> exception, for example,
         *        <code>20190721DatasetImport</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobName(String datasetImportJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the data.
         * </p>
         * 
         * @param dataSource
         *        The location of the training data to import and an AWS Identity and Access Management (IAM) role that
         *        Amazon Forecast can assume to access the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the data.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSource.Builder} avoiding the need to create
         * one manually via {@link DataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The format of timestamps in the dataset. Two formats are supported, dependent on the
         * <code>DataFrequency</code> specified when the dataset was created.
         * </p>
         * <ul>
         * <li>
         * <p>
         * "yyyy-MM-dd"
         * </p>
         * <p>
         * For data frequencies: Y, M, W, and D
         * </p>
         * </li>
         * <li>
         * <p>
         * "yyyy-MM-dd HH:mm:ss"
         * </p>
         * <p>
         * For data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
         * </p>
         * </li>
         * </ul>
         * 
         * @param timestampFormat
         *        The format of timestamps in the dataset. Two formats are supported, dependent on the
         *        <code>DataFrequency</code> specified when the dataset was created.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        "yyyy-MM-dd"
         *        </p>
         *        <p>
         *        For data frequencies: Y, M, W, and D
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "yyyy-MM-dd HH:mm:ss"
         *        </p>
         *        <p>
         *        For data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormat(String timestampFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String datasetImportJobName;

        private String datasetArn;

        private DataSource dataSource;

        private String timestampFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetImportJobRequest model) {
            super(model);
            datasetImportJobName(model.datasetImportJobName);
            datasetArn(model.datasetArn);
            dataSource(model.dataSource);
            timestampFormat(model.timestampFormat);
        }

        public final String getDatasetImportJobName() {
            return datasetImportJobName;
        }

        @Override
        public final Builder datasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
            return this;
        }

        public final void setDatasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public final String getTimestampFormat() {
            return timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetImportJobRequest build() {
            return new CreateDatasetImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
