/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the fields of a dataset. This object is specified in the <a>CreateDataset</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Schema implements SdkPojo, Serializable, ToCopyableBuilder<Schema.Builder, Schema> {
    private static final SdkField<List<SchemaAttribute>> ATTRIBUTES_FIELD = SdkField
            .<List<SchemaAttribute>> builder(MarshallingType.LIST)
            .getter(getter(Schema::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SchemaAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(SchemaAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<SchemaAttribute> attributes;

    private Schema(BuilderImpl builder) {
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * An array of attributes specifying the name and type of each field in a dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of attributes specifying the name and type of each field in a dataset.
     */
    public List<SchemaAttribute> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schema)) {
            return false;
        }
        Schema other = (Schema) obj;
        return Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Schema").add("Attributes", attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Schema, T> g) {
        return obj -> g.apply((Schema) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Schema> {
        /**
         * <p>
         * An array of attributes specifying the name and type of each field in a dataset.
         * </p>
         * 
         * @param attributes
         *        An array of attributes specifying the name and type of each field in a dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<SchemaAttribute> attributes);

        /**
         * <p>
         * An array of attributes specifying the name and type of each field in a dataset.
         * </p>
         * 
         * @param attributes
         *        An array of attributes specifying the name and type of each field in a dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(SchemaAttribute... attributes);

        /**
         * <p>
         * An array of attributes specifying the name and type of each field in a dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SchemaAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<SchemaAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SchemaAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #attributes(List<SchemaAttribute>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<SchemaAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<SchemaAttribute>)
         */
        Builder attributes(Consumer<SchemaAttribute.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private List<SchemaAttribute> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Schema model) {
            attributes(model.attributes);
        }

        public final Collection<SchemaAttribute.Builder> getAttributes() {
            return attributes != null ? attributes.stream().map(SchemaAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<SchemaAttribute> attributes) {
            this.attributes = SchemaAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(SchemaAttribute... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<SchemaAttribute.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> SchemaAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<SchemaAttribute.BuilderImpl> attributes) {
            this.attributes = SchemaAttributesCopier.copyFromBuilder(attributes);
        }

        @Override
        public Schema build() {
            return new Schema(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
