/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateForecastRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreateForecastRequest> {
    private static final SdkField<String> FORECAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateForecastRequest.getter(CreateForecastRequest::forecastName)).setter(CreateForecastRequest.setter(Builder::forecastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastName").build()}).build();
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateForecastRequest.getter(CreateForecastRequest::predictorArn)).setter(CreateForecastRequest.setter(Builder::predictorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_NAME_FIELD, PREDICTOR_ARN_FIELD));
    private final String forecastName;
    private final String predictorArn;

    private CreateForecastRequest(BuilderImpl builder) {
        super(builder);
        this.forecastName = builder.forecastName;
        this.predictorArn = builder.predictorArn;
    }

    public String forecastName() {
        return this.forecastName;
    }

    public String predictorArn() {
        return this.predictorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictorArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateForecastRequest)) {
            return false;
        }
        CreateForecastRequest other = (CreateForecastRequest)((Object)obj);
        return Objects.equals(this.forecastName(), other.forecastName()) && Objects.equals(this.predictorArn(), other.predictorArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateForecastRequest").add("ForecastName", (Object)this.forecastName()).add("PredictorArn", (Object)this.predictorArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastName": {
                return Optional.ofNullable(clazz.cast(this.forecastName()));
            }
            case "PredictorArn": {
                return Optional.ofNullable(clazz.cast(this.predictorArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateForecastRequest, T> g) {
        return obj -> g.apply((CreateForecastRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String forecastName;
        private String predictorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateForecastRequest model) {
            super(model);
            this.forecastName(model.forecastName);
            this.predictorArn(model.predictorArn);
        }

        public final String getForecastName() {
            return this.forecastName;
        }

        @Override
        public final Builder forecastName(String forecastName) {
            this.forecastName = forecastName;
            return this;
        }

        public final void setForecastName(String forecastName) {
            this.forecastName = forecastName;
        }

        public final String getPredictorArn() {
            return this.predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateForecastRequest build() {
            return new CreateForecastRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateForecastRequest> {
        public Builder forecastName(String var1);

        public Builder predictorArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

