/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.EvaluationType;
import software.amazon.awssdk.services.forecast.model.Metrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WindowSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WindowSummary> {
    private static final SdkField<Instant> TEST_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(WindowSummary.getter(WindowSummary::testWindowStart)).setter(WindowSummary.setter(Builder::testWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestWindowStart").build()}).build();
    private static final SdkField<Instant> TEST_WINDOW_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(WindowSummary.getter(WindowSummary::testWindowEnd)).setter(WindowSummary.setter(Builder::testWindowEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestWindowEnd").build()}).build();
    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(WindowSummary.getter(WindowSummary::itemCount)).setter(WindowSummary.setter(Builder::itemCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()}).build();
    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WindowSummary.getter(WindowSummary::evaluationTypeAsString)).setter(WindowSummary.setter(Builder::evaluationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()}).build();
    private static final SdkField<Metrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WindowSummary.getter(WindowSummary::metrics)).setter(WindowSummary.setter(Builder::metrics)).constructor(Metrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_WINDOW_START_FIELD, TEST_WINDOW_END_FIELD, ITEM_COUNT_FIELD, EVALUATION_TYPE_FIELD, METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant testWindowStart;
    private final Instant testWindowEnd;
    private final Integer itemCount;
    private final String evaluationType;
    private final Metrics metrics;

    private WindowSummary(BuilderImpl builder) {
        this.testWindowStart = builder.testWindowStart;
        this.testWindowEnd = builder.testWindowEnd;
        this.itemCount = builder.itemCount;
        this.evaluationType = builder.evaluationType;
        this.metrics = builder.metrics;
    }

    public Instant testWindowStart() {
        return this.testWindowStart;
    }

    public Instant testWindowEnd() {
        return this.testWindowEnd;
    }

    public Integer itemCount() {
        return this.itemCount;
    }

    public EvaluationType evaluationType() {
        return EvaluationType.fromValue(this.evaluationType);
    }

    public String evaluationTypeAsString() {
        return this.evaluationType;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.testWindowEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowSummary)) {
            return false;
        }
        WindowSummary other = (WindowSummary)obj;
        return Objects.equals(this.testWindowStart(), other.testWindowStart()) && Objects.equals(this.testWindowEnd(), other.testWindowEnd()) && Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.evaluationTypeAsString(), other.evaluationTypeAsString()) && Objects.equals(this.metrics(), other.metrics());
    }

    public String toString() {
        return ToString.builder((String)"WindowSummary").add("TestWindowStart", (Object)this.testWindowStart()).add("TestWindowEnd", (Object)this.testWindowEnd()).add("ItemCount", (Object)this.itemCount()).add("EvaluationType", (Object)this.evaluationTypeAsString()).add("Metrics", (Object)this.metrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TestWindowStart": {
                return Optional.ofNullable(clazz.cast(this.testWindowStart()));
            }
            case "TestWindowEnd": {
                return Optional.ofNullable(clazz.cast(this.testWindowEnd()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "EvaluationType": {
                return Optional.ofNullable(clazz.cast(this.evaluationTypeAsString()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WindowSummary, T> g) {
        return obj -> g.apply((WindowSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant testWindowStart;
        private Instant testWindowEnd;
        private Integer itemCount;
        private String evaluationType;
        private Metrics metrics;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowSummary model) {
            this.testWindowStart(model.testWindowStart);
            this.testWindowEnd(model.testWindowEnd);
            this.itemCount(model.itemCount);
            this.evaluationType(model.evaluationType);
            this.metrics(model.metrics);
        }

        public final Instant getTestWindowStart() {
            return this.testWindowStart;
        }

        @Override
        public final Builder testWindowStart(Instant testWindowStart) {
            this.testWindowStart = testWindowStart;
            return this;
        }

        public final void setTestWindowStart(Instant testWindowStart) {
            this.testWindowStart = testWindowStart;
        }

        public final Instant getTestWindowEnd() {
            return this.testWindowEnd;
        }

        @Override
        public final Builder testWindowEnd(Instant testWindowEnd) {
            this.testWindowEnd = testWindowEnd;
            return this;
        }

        public final void setTestWindowEnd(Instant testWindowEnd) {
            this.testWindowEnd = testWindowEnd;
        }

        public final Integer getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        public final String getEvaluationTypeAsString() {
            return this.evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        public final Metrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        @Override
        public final Builder metrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final void setMetrics(Metrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        public WindowSummary build() {
            return new WindowSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WindowSummary> {
        public Builder testWindowStart(Instant var1);

        public Builder testWindowEnd(Instant var1);

        public Builder itemCount(Integer var1);

        public Builder evaluationType(String var1);

        public Builder evaluationType(EvaluationType var1);

        public Builder metrics(Metrics var1);

        default public Builder metrics(Consumer<Metrics.Builder> metrics) {
            return this.metrics((Metrics)((Metrics.Builder)Metrics.builder().applyMutation(metrics)).build());
        }
    }
}

