/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.forecast.model.DataDestination;
import software.amazon.awssdk.services.forecast.model.ForecastRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateForecastExportJobRequest
extends ForecastRequest
implements ToCopyableBuilder<Builder, CreateForecastExportJobRequest> {
    private static final SdkField<String> FORECAST_EXPORT_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateForecastExportJobRequest.getter(CreateForecastExportJobRequest::forecastExportJobName)).setter(CreateForecastExportJobRequest.setter(Builder::forecastExportJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastExportJobName").build()}).build();
    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateForecastExportJobRequest.getter(CreateForecastExportJobRequest::forecastArn)).setter(CreateForecastExportJobRequest.setter(Builder::forecastArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()}).build();
    private static final SdkField<DataDestination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateForecastExportJobRequest.getter(CreateForecastExportJobRequest::destination)).setter(CreateForecastExportJobRequest.setter(Builder::destination)).constructor(DataDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORECAST_EXPORT_JOB_NAME_FIELD, FORECAST_ARN_FIELD, DESTINATION_FIELD));
    private final String forecastExportJobName;
    private final String forecastArn;
    private final DataDestination destination;

    private CreateForecastExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.forecastExportJobName = builder.forecastExportJobName;
        this.forecastArn = builder.forecastArn;
        this.destination = builder.destination;
    }

    public String forecastExportJobName() {
        return this.forecastExportJobName;
    }

    public String forecastArn() {
        return this.forecastArn;
    }

    public DataDestination destination() {
        return this.destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastExportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateForecastExportJobRequest)) {
            return false;
        }
        CreateForecastExportJobRequest other = (CreateForecastExportJobRequest)((Object)obj);
        return Objects.equals(this.forecastExportJobName(), other.forecastExportJobName()) && Objects.equals(this.forecastArn(), other.forecastArn()) && Objects.equals(this.destination(), other.destination());
    }

    public String toString() {
        return ToString.builder((String)"CreateForecastExportJobRequest").add("ForecastExportJobName", (Object)this.forecastExportJobName()).add("ForecastArn", (Object)this.forecastArn()).add("Destination", (Object)this.destination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForecastExportJobName": {
                return Optional.ofNullable(clazz.cast(this.forecastExportJobName()));
            }
            case "ForecastArn": {
                return Optional.ofNullable(clazz.cast(this.forecastArn()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateForecastExportJobRequest, T> g) {
        return obj -> g.apply((CreateForecastExportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastRequest.BuilderImpl
    implements Builder {
        private String forecastExportJobName;
        private String forecastArn;
        private DataDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateForecastExportJobRequest model) {
            super(model);
            this.forecastExportJobName(model.forecastExportJobName);
            this.forecastArn(model.forecastArn);
            this.destination(model.destination);
        }

        public final String getForecastExportJobName() {
            return this.forecastExportJobName;
        }

        @Override
        public final Builder forecastExportJobName(String forecastExportJobName) {
            this.forecastExportJobName = forecastExportJobName;
            return this;
        }

        public final void setForecastExportJobName(String forecastExportJobName) {
            this.forecastExportJobName = forecastExportJobName;
        }

        public final String getForecastArn() {
            return this.forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        public final DataDestination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(DataDestination destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(DataDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateForecastExportJobRequest build() {
            return new CreateForecastExportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ForecastRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateForecastExportJobRequest> {
        public Builder forecastExportJobName(String var1);

        public Builder forecastArn(String var1);

        public Builder destination(DataDestination var1);

        default public Builder destination(Consumer<DataDestination.Builder> destination) {
            return this.destination((DataDestination)((DataDestination.Builder)DataDestination.builder().applyMutation(destination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

