/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metrics for a time range within the evaluation portion of a dataset. This object is part of the
 * <a>EvaluationResult</a> object.
 * </p>
 * <p>
 * The <code>TestWindowStart</code> and <code>TestWindowEnd</code> parameters are determined by the
 * <code>BackTestWindowOffset</code> parameter of the <a>EvaluationParameters</a> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WindowSummary implements SdkPojo, Serializable, ToCopyableBuilder<WindowSummary.Builder, WindowSummary> {
    private static final SdkField<Instant> TEST_WINDOW_START_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(WindowSummary::testWindowStart)).setter(setter(Builder::testWindowStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestWindowStart").build()).build();

    private static final SdkField<Instant> TEST_WINDOW_END_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(WindowSummary::testWindowEnd)).setter(setter(Builder::testWindowEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestWindowEnd").build()).build();

    private static final SdkField<Integer> ITEM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(WindowSummary::itemCount)).setter(setter(Builder::itemCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCount").build()).build();

    private static final SdkField<String> EVALUATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(WindowSummary::evaluationTypeAsString)).setter(setter(Builder::evaluationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationType").build()).build();

    private static final SdkField<Metrics> METRICS_FIELD = SdkField.<Metrics> builder(MarshallingType.SDK_POJO)
            .getter(getter(WindowSummary::metrics)).setter(setter(Builder::metrics)).constructor(Metrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_WINDOW_START_FIELD,
            TEST_WINDOW_END_FIELD, ITEM_COUNT_FIELD, EVALUATION_TYPE_FIELD, METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant testWindowStart;

    private final Instant testWindowEnd;

    private final Integer itemCount;

    private final String evaluationType;

    private final Metrics metrics;

    private WindowSummary(BuilderImpl builder) {
        this.testWindowStart = builder.testWindowStart;
        this.testWindowEnd = builder.testWindowEnd;
        this.itemCount = builder.itemCount;
        this.evaluationType = builder.evaluationType;
        this.metrics = builder.metrics;
    }

    /**
     * <p>
     * The timestamp that defines the start of the window.
     * </p>
     * 
     * @return The timestamp that defines the start of the window.
     */
    public Instant testWindowStart() {
        return testWindowStart;
    }

    /**
     * <p>
     * The timestamp that defines the end of the window.
     * </p>
     * 
     * @return The timestamp that defines the end of the window.
     */
    public Instant testWindowEnd() {
        return testWindowEnd;
    }

    /**
     * <p>
     * The number of data points within the window.
     * </p>
     * 
     * @return The number of data points within the window.
     */
    public Integer itemCount() {
        return itemCount;
    }

    /**
     * <p>
     * The type of evaluation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUMMARY</code> - The average metrics across all windows.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPUTED</code> - The metrics for the specified window.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationType}
     * will return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationTypeAsString}.
     * </p>
     * 
     * @return The type of evaluation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUMMARY</code> - The average metrics across all windows.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPUTED</code> - The metrics for the specified window.
     *         </p>
     *         </li>
     * @see EvaluationType
     */
    public EvaluationType evaluationType() {
        return EvaluationType.fromValue(evaluationType);
    }

    /**
     * <p>
     * The type of evaluation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>SUMMARY</code> - The average metrics across all windows.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPUTED</code> - The metrics for the specified window.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #evaluationType}
     * will return {@link EvaluationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #evaluationTypeAsString}.
     * </p>
     * 
     * @return The type of evaluation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>SUMMARY</code> - The average metrics across all windows.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPUTED</code> - The metrics for the specified window.
     *         </p>
     *         </li>
     * @see EvaluationType
     */
    public String evaluationTypeAsString() {
        return evaluationType;
    }

    /**
     * Returns the value of the Metrics property for this object.
     * 
     * @return The value of the Metrics property for this object.
     */
    public Metrics metrics() {
        return metrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(testWindowEnd());
        hashCode = 31 * hashCode + Objects.hashCode(itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WindowSummary)) {
            return false;
        }
        WindowSummary other = (WindowSummary) obj;
        return Objects.equals(testWindowStart(), other.testWindowStart())
                && Objects.equals(testWindowEnd(), other.testWindowEnd()) && Objects.equals(itemCount(), other.itemCount())
                && Objects.equals(evaluationTypeAsString(), other.evaluationTypeAsString())
                && Objects.equals(metrics(), other.metrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("WindowSummary").add("TestWindowStart", testWindowStart()).add("TestWindowEnd", testWindowEnd())
                .add("ItemCount", itemCount()).add("EvaluationType", evaluationTypeAsString()).add("Metrics", metrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TestWindowStart":
            return Optional.ofNullable(clazz.cast(testWindowStart()));
        case "TestWindowEnd":
            return Optional.ofNullable(clazz.cast(testWindowEnd()));
        case "ItemCount":
            return Optional.ofNullable(clazz.cast(itemCount()));
        case "EvaluationType":
            return Optional.ofNullable(clazz.cast(evaluationTypeAsString()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WindowSummary, T> g) {
        return obj -> g.apply((WindowSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WindowSummary> {
        /**
         * <p>
         * The timestamp that defines the start of the window.
         * </p>
         * 
         * @param testWindowStart
         *        The timestamp that defines the start of the window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testWindowStart(Instant testWindowStart);

        /**
         * <p>
         * The timestamp that defines the end of the window.
         * </p>
         * 
         * @param testWindowEnd
         *        The timestamp that defines the end of the window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testWindowEnd(Instant testWindowEnd);

        /**
         * <p>
         * The number of data points within the window.
         * </p>
         * 
         * @param itemCount
         *        The number of data points within the window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemCount(Integer itemCount);

        /**
         * <p>
         * The type of evaluation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUMMARY</code> - The average metrics across all windows.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPUTED</code> - The metrics for the specified window.
         * </p>
         * </li>
         * </ul>
         * 
         * @param evaluationType
         *        The type of evaluation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUMMARY</code> - The average metrics across all windows.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPUTED</code> - The metrics for the specified window.
         *        </p>
         *        </li>
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluationType(String evaluationType);

        /**
         * <p>
         * The type of evaluation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>SUMMARY</code> - The average metrics across all windows.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPUTED</code> - The metrics for the specified window.
         * </p>
         * </li>
         * </ul>
         * 
         * @param evaluationType
         *        The type of evaluation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>SUMMARY</code> - The average metrics across all windows.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPUTED</code> - The metrics for the specified window.
         *        </p>
         *        </li>
         * @see EvaluationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EvaluationType
         */
        Builder evaluationType(EvaluationType evaluationType);

        /**
         * Sets the value of the Metrics property for this object.
         *
         * @param metrics
         *        The new value for the Metrics property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Metrics metrics);

        /**
         * Sets the value of the Metrics property for this object.
         *
         * This is a convenience that creates an instance of the {@link Metrics.Builder} avoiding the need to create one
         * manually via {@link Metrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link Metrics.Builder#build()} is called immediately and its result is
         * passed to {@link #metrics(Metrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link Metrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(Metrics)
         */
        default Builder metrics(Consumer<Metrics.Builder> metrics) {
            return metrics(Metrics.builder().applyMutation(metrics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant testWindowStart;

        private Instant testWindowEnd;

        private Integer itemCount;

        private String evaluationType;

        private Metrics metrics;

        private BuilderImpl() {
        }

        private BuilderImpl(WindowSummary model) {
            testWindowStart(model.testWindowStart);
            testWindowEnd(model.testWindowEnd);
            itemCount(model.itemCount);
            evaluationType(model.evaluationType);
            metrics(model.metrics);
        }

        public final Instant getTestWindowStart() {
            return testWindowStart;
        }

        @Override
        public final Builder testWindowStart(Instant testWindowStart) {
            this.testWindowStart = testWindowStart;
            return this;
        }

        public final void setTestWindowStart(Instant testWindowStart) {
            this.testWindowStart = testWindowStart;
        }

        public final Instant getTestWindowEnd() {
            return testWindowEnd;
        }

        @Override
        public final Builder testWindowEnd(Instant testWindowEnd) {
            this.testWindowEnd = testWindowEnd;
            return this;
        }

        public final void setTestWindowEnd(Instant testWindowEnd) {
            this.testWindowEnd = testWindowEnd;
        }

        public final Integer getItemCount() {
            return itemCount;
        }

        @Override
        public final Builder itemCount(Integer itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Integer itemCount) {
            this.itemCount = itemCount;
        }

        public final String getEvaluationTypeAsString() {
            return evaluationType;
        }

        @Override
        public final Builder evaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
            return this;
        }

        @Override
        public final Builder evaluationType(EvaluationType evaluationType) {
            this.evaluationType(evaluationType == null ? null : evaluationType.toString());
            return this;
        }

        public final void setEvaluationType(String evaluationType) {
            this.evaluationType = evaluationType;
        }

        public final Metrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        @Override
        public final Builder metrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final void setMetrics(Metrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public WindowSummary build() {
            return new WindowSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
