/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.forecast.model.AutoMLOverrideStrategy;
import software.amazon.awssdk.services.forecast.model.EvaluationResult;
import software.amazon.awssdk.services.forecast.model.ForecastResponse;
import software.amazon.awssdk.services.forecast.model.OptimizationMetric;
import software.amazon.awssdk.services.forecast.model.PredictorEvaluationResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccuracyMetricsResponse
extends ForecastResponse
implements ToCopyableBuilder<Builder, GetAccuracyMetricsResponse> {
    private static final SdkField<List<EvaluationResult>> PREDICTOR_EVALUATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PredictorEvaluationResults").getter(GetAccuracyMetricsResponse.getter(GetAccuracyMetricsResponse::predictorEvaluationResults)).setter(GetAccuracyMetricsResponse.setter(Builder::predictorEvaluationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorEvaluationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_AUTO_PREDICTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsAutoPredictor").getter(GetAccuracyMetricsResponse.getter(GetAccuracyMetricsResponse::isAutoPredictor)).setter(GetAccuracyMetricsResponse.setter(Builder::isAutoPredictor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAutoPredictor").build()}).build();
    private static final SdkField<String> AUTO_ML_OVERRIDE_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLOverrideStrategy").getter(GetAccuracyMetricsResponse.getter(GetAccuracyMetricsResponse::autoMLOverrideStrategyAsString)).setter(GetAccuracyMetricsResponse.setter(Builder::autoMLOverrideStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLOverrideStrategy").build()}).build();
    private static final SdkField<String> OPTIMIZATION_METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptimizationMetric").getter(GetAccuracyMetricsResponse.getter(GetAccuracyMetricsResponse::optimizationMetricAsString)).setter(GetAccuracyMetricsResponse.setter(Builder::optimizationMetric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationMetric").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_EVALUATION_RESULTS_FIELD, IS_AUTO_PREDICTOR_FIELD, AUTO_ML_OVERRIDE_STRATEGY_FIELD, OPTIMIZATION_METRIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAccuracyMetricsResponse.memberNameToFieldInitializer();
    private final List<EvaluationResult> predictorEvaluationResults;
    private final Boolean isAutoPredictor;
    private final String autoMLOverrideStrategy;
    private final String optimizationMetric;

    private GetAccuracyMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.predictorEvaluationResults = builder.predictorEvaluationResults;
        this.isAutoPredictor = builder.isAutoPredictor;
        this.autoMLOverrideStrategy = builder.autoMLOverrideStrategy;
        this.optimizationMetric = builder.optimizationMetric;
    }

    public final boolean hasPredictorEvaluationResults() {
        return this.predictorEvaluationResults != null && !(this.predictorEvaluationResults instanceof SdkAutoConstructList);
    }

    public final List<EvaluationResult> predictorEvaluationResults() {
        return this.predictorEvaluationResults;
    }

    public final Boolean isAutoPredictor() {
        return this.isAutoPredictor;
    }

    public final AutoMLOverrideStrategy autoMLOverrideStrategy() {
        return AutoMLOverrideStrategy.fromValue(this.autoMLOverrideStrategy);
    }

    public final String autoMLOverrideStrategyAsString() {
        return this.autoMLOverrideStrategy;
    }

    public final OptimizationMetric optimizationMetric() {
        return OptimizationMetric.fromValue(this.optimizationMetric);
    }

    public final String optimizationMetricAsString() {
        return this.optimizationMetric;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPredictorEvaluationResults() ? this.predictorEvaluationResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isAutoPredictor());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLOverrideStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizationMetricAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccuracyMetricsResponse)) {
            return false;
        }
        GetAccuracyMetricsResponse other = (GetAccuracyMetricsResponse)((Object)obj);
        return this.hasPredictorEvaluationResults() == other.hasPredictorEvaluationResults() && Objects.equals(this.predictorEvaluationResults(), other.predictorEvaluationResults()) && Objects.equals(this.isAutoPredictor(), other.isAutoPredictor()) && Objects.equals(this.autoMLOverrideStrategyAsString(), other.autoMLOverrideStrategyAsString()) && Objects.equals(this.optimizationMetricAsString(), other.optimizationMetricAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccuracyMetricsResponse").add("PredictorEvaluationResults", this.hasPredictorEvaluationResults() ? this.predictorEvaluationResults() : null).add("IsAutoPredictor", (Object)this.isAutoPredictor()).add("AutoMLOverrideStrategy", (Object)this.autoMLOverrideStrategyAsString()).add("OptimizationMetric", (Object)this.optimizationMetricAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredictorEvaluationResults": {
                return Optional.ofNullable(clazz.cast(this.predictorEvaluationResults()));
            }
            case "IsAutoPredictor": {
                return Optional.ofNullable(clazz.cast(this.isAutoPredictor()));
            }
            case "AutoMLOverrideStrategy": {
                return Optional.ofNullable(clazz.cast(this.autoMLOverrideStrategyAsString()));
            }
            case "OptimizationMetric": {
                return Optional.ofNullable(clazz.cast(this.optimizationMetricAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PredictorEvaluationResults", PREDICTOR_EVALUATION_RESULTS_FIELD);
        map.put("IsAutoPredictor", IS_AUTO_PREDICTOR_FIELD);
        map.put("AutoMLOverrideStrategy", AUTO_ML_OVERRIDE_STRATEGY_FIELD);
        map.put("OptimizationMetric", OPTIMIZATION_METRIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccuracyMetricsResponse, T> g) {
        return obj -> g.apply((GetAccuracyMetricsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ForecastResponse.BuilderImpl
    implements Builder {
        private List<EvaluationResult> predictorEvaluationResults = DefaultSdkAutoConstructList.getInstance();
        private Boolean isAutoPredictor;
        private String autoMLOverrideStrategy;
        private String optimizationMetric;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccuracyMetricsResponse model) {
            super(model);
            this.predictorEvaluationResults(model.predictorEvaluationResults);
            this.isAutoPredictor(model.isAutoPredictor);
            this.autoMLOverrideStrategy(model.autoMLOverrideStrategy);
            this.optimizationMetric(model.optimizationMetric);
        }

        public final List<EvaluationResult.Builder> getPredictorEvaluationResults() {
            List<EvaluationResult.Builder> result = PredictorEvaluationResultsCopier.copyToBuilder(this.predictorEvaluationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPredictorEvaluationResults(Collection<EvaluationResult.BuilderImpl> predictorEvaluationResults) {
            this.predictorEvaluationResults = PredictorEvaluationResultsCopier.copyFromBuilder(predictorEvaluationResults);
        }

        @Override
        public final Builder predictorEvaluationResults(Collection<EvaluationResult> predictorEvaluationResults) {
            this.predictorEvaluationResults = PredictorEvaluationResultsCopier.copy(predictorEvaluationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorEvaluationResults(EvaluationResult ... predictorEvaluationResults) {
            this.predictorEvaluationResults(Arrays.asList(predictorEvaluationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorEvaluationResults(Consumer<EvaluationResult.Builder> ... predictorEvaluationResults) {
            this.predictorEvaluationResults(Stream.of(predictorEvaluationResults).map(c -> (EvaluationResult)((EvaluationResult.Builder)EvaluationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsAutoPredictor() {
            return this.isAutoPredictor;
        }

        public final void setIsAutoPredictor(Boolean isAutoPredictor) {
            this.isAutoPredictor = isAutoPredictor;
        }

        @Override
        public final Builder isAutoPredictor(Boolean isAutoPredictor) {
            this.isAutoPredictor = isAutoPredictor;
            return this;
        }

        public final String getAutoMLOverrideStrategy() {
            return this.autoMLOverrideStrategy;
        }

        public final void setAutoMLOverrideStrategy(String autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy = autoMLOverrideStrategy;
        }

        @Override
        public final Builder autoMLOverrideStrategy(String autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy = autoMLOverrideStrategy;
            return this;
        }

        @Override
        public final Builder autoMLOverrideStrategy(AutoMLOverrideStrategy autoMLOverrideStrategy) {
            this.autoMLOverrideStrategy(autoMLOverrideStrategy == null ? null : autoMLOverrideStrategy.toString());
            return this;
        }

        public final String getOptimizationMetric() {
            return this.optimizationMetric;
        }

        public final void setOptimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
        }

        @Override
        public final Builder optimizationMetric(String optimizationMetric) {
            this.optimizationMetric = optimizationMetric;
            return this;
        }

        @Override
        public final Builder optimizationMetric(OptimizationMetric optimizationMetric) {
            this.optimizationMetric(optimizationMetric == null ? null : optimizationMetric.toString());
            return this;
        }

        @Override
        public GetAccuracyMetricsResponse build() {
            return new GetAccuracyMetricsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ForecastResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccuracyMetricsResponse> {
        public Builder predictorEvaluationResults(Collection<EvaluationResult> var1);

        public Builder predictorEvaluationResults(EvaluationResult ... var1);

        public Builder predictorEvaluationResults(Consumer<EvaluationResult.Builder> ... var1);

        public Builder isAutoPredictor(Boolean var1);

        public Builder autoMLOverrideStrategy(String var1);

        public Builder autoMLOverrideStrategy(AutoMLOverrideStrategy var1);

        public Builder optimizationMetric(String var1);

        public Builder optimizationMetric(OptimizationMetric var1);
    }
}

