/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OptimizationMetric {
    WAPE("WAPE"),
    RMSE("RMSE"),
    AVERAGE_WEIGHTED_QUANTILE_LOSS("AverageWeightedQuantileLoss"),
    MASE("MASE"),
    MAPE("MAPE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OptimizationMetric> VALUE_MAP;
    private final String value;

    private OptimizationMetric(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OptimizationMetric fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OptimizationMetric> knownValues() {
        EnumSet<OptimizationMetric> knownValues = EnumSet.allOf(OptimizationMetric.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OptimizationMetric.class, OptimizationMetric::toString);
    }
}

