/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.forecast.ForecastClient;
import software.amazon.awssdk.services.forecast.internal.UserAgentUtils;
import software.amazon.awssdk.services.forecast.model.ForecastExportJobSummary;
import software.amazon.awssdk.services.forecast.model.ListForecastExportJobsRequest;
import software.amazon.awssdk.services.forecast.model.ListForecastExportJobsResponse;

public class ListForecastExportJobsIterable
implements SdkIterable<ListForecastExportJobsResponse> {
    private final ForecastClient client;
    private final ListForecastExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListForecastExportJobsIterable(ForecastClient client, ListForecastExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListForecastExportJobsResponseFetcher();
    }

    public Iterator<ListForecastExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ForecastExportJobSummary> forecastExportJobs() {
        Function<ListForecastExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.forecastExportJobs() != null) {
                return response.forecastExportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListForecastExportJobsResponseFetcher
    implements SyncPageFetcher<ListForecastExportJobsResponse> {
        private ListForecastExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListForecastExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListForecastExportJobsResponse nextPage(ListForecastExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListForecastExportJobsIterable.this.client.listForecastExportJobs(ListForecastExportJobsIterable.this.firstRequest);
            }
            return ListForecastExportJobsIterable.this.client.listForecastExportJobs((ListForecastExportJobsRequest)((Object)ListForecastExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

