/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of the predictor properties that are used in the <a>ListPredictors</a> operation. To get the
 * complete set of properties, call the <a>DescribePredictor</a> operation, and provide the listed
 * <code>PredictorArn</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictorSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictorSummary.Builder, PredictorSummary> {
    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorArn").getter(getter(PredictorSummary::predictorArn)).setter(setter(Builder::predictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()).build();

    private static final SdkField<String> PREDICTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorName").getter(getter(PredictorSummary::predictorName)).setter(setter(Builder::predictorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorName").build()).build();

    private static final SdkField<String> DATASET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetGroupArn").getter(getter(PredictorSummary::datasetGroupArn))
            .setter(setter(Builder::datasetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetGroupArn").build()).build();

    private static final SdkField<Boolean> IS_AUTO_PREDICTOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsAutoPredictor").getter(getter(PredictorSummary::isAutoPredictor))
            .setter(setter(Builder::isAutoPredictor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAutoPredictor").build()).build();

    private static final SdkField<ReferencePredictorSummary> REFERENCE_PREDICTOR_SUMMARY_FIELD = SdkField
            .<ReferencePredictorSummary> builder(MarshallingType.SDK_POJO).memberName("ReferencePredictorSummary")
            .getter(getter(PredictorSummary::referencePredictorSummary)).setter(setter(Builder::referencePredictorSummary))
            .constructor(ReferencePredictorSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferencePredictorSummary").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(PredictorSummary::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(PredictorSummary::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(PredictorSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(PredictorSummary::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_ARN_FIELD,
            PREDICTOR_NAME_FIELD, DATASET_GROUP_ARN_FIELD, IS_AUTO_PREDICTOR_FIELD, REFERENCE_PREDICTOR_SUMMARY_FIELD,
            STATUS_FIELD, MESSAGE_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String predictorArn;

    private final String predictorName;

    private final String datasetGroupArn;

    private final Boolean isAutoPredictor;

    private final ReferencePredictorSummary referencePredictorSummary;

    private final String status;

    private final String message;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private PredictorSummary(BuilderImpl builder) {
        this.predictorArn = builder.predictorArn;
        this.predictorName = builder.predictorName;
        this.datasetGroupArn = builder.datasetGroupArn;
        this.isAutoPredictor = builder.isAutoPredictor;
        this.referencePredictorSummary = builder.referencePredictorSummary;
        this.status = builder.status;
        this.message = builder.message;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    /**
     * <p>
     * The ARN of the predictor.
     * </p>
     * 
     * @return The ARN of the predictor.
     */
    public final String predictorArn() {
        return predictorArn;
    }

    /**
     * <p>
     * The name of the predictor.
     * </p>
     * 
     * @return The name of the predictor.
     */
    public final String predictorName() {
        return predictorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the predictor.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the predictor.
     */
    public final String datasetGroupArn() {
        return datasetGroupArn;
    }

    /**
     * <p>
     * Whether AutoPredictor was used to create the predictor.
     * </p>
     * 
     * @return Whether AutoPredictor was used to create the predictor.
     */
    public final Boolean isAutoPredictor() {
        return isAutoPredictor;
    }

    /**
     * <p>
     * A summary of the reference predictor used if the predictor was retrained or upgraded.
     * </p>
     * 
     * @return A summary of the reference predictor used if the predictor was retrained or upgraded.
     */
    public final ReferencePredictorSummary referencePredictorSummary() {
        return referencePredictorSummary;
    }

    /**
     * <p>
     * The status of the predictor. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to create a
     * forecast.
     * </p>
     * </note>
     * 
     * @return The status of the predictor. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to
     *         create a forecast.
     *         </p>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * If an error occurred, an informational message about the error.
     * </p>
     * 
     * @return If an error occurred, an informational message about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * When the model training task was created.
     * </p>
     * 
     * @return When the model training task was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the resource was modified. The timestamp depends on the status of the job:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPING</code> - The current timestamp.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_STOPPED</code> - When the job stopped.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The last time the resource was modified. The timestamp depends on the status of the job:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_IN_PROGRESS</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPING</code> - The current timestamp.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_STOPPED</code> - When the job stopped.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
     *         </p>
     *         </li>
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predictorArn());
        hashCode = 31 * hashCode + Objects.hashCode(predictorName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(isAutoPredictor());
        hashCode = 31 * hashCode + Objects.hashCode(referencePredictorSummary());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorSummary)) {
            return false;
        }
        PredictorSummary other = (PredictorSummary) obj;
        return Objects.equals(predictorArn(), other.predictorArn()) && Objects.equals(predictorName(), other.predictorName())
                && Objects.equals(datasetGroupArn(), other.datasetGroupArn())
                && Objects.equals(isAutoPredictor(), other.isAutoPredictor())
                && Objects.equals(referencePredictorSummary(), other.referencePredictorSummary())
                && Objects.equals(status(), other.status()) && Objects.equals(message(), other.message())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictorSummary").add("PredictorArn", predictorArn()).add("PredictorName", predictorName())
                .add("DatasetGroupArn", datasetGroupArn()).add("IsAutoPredictor", isAutoPredictor())
                .add("ReferencePredictorSummary", referencePredictorSummary()).add("Status", status()).add("Message", message())
                .add("CreationTime", creationTime()).add("LastModificationTime", lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorArn":
            return Optional.ofNullable(clazz.cast(predictorArn()));
        case "PredictorName":
            return Optional.ofNullable(clazz.cast(predictorName()));
        case "DatasetGroupArn":
            return Optional.ofNullable(clazz.cast(datasetGroupArn()));
        case "IsAutoPredictor":
            return Optional.ofNullable(clazz.cast(isAutoPredictor()));
        case "ReferencePredictorSummary":
            return Optional.ofNullable(clazz.cast(referencePredictorSummary()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictorSummary, T> g) {
        return obj -> g.apply((PredictorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictorSummary> {
        /**
         * <p>
         * The ARN of the predictor.
         * </p>
         * 
         * @param predictorArn
         *        The ARN of the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorArn(String predictorArn);

        /**
         * <p>
         * The name of the predictor.
         * </p>
         * 
         * @param predictorName
         *        The name of the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorName(String predictorName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the predictor.
         * </p>
         * 
         * @param datasetGroupArn
         *        The Amazon Resource Name (ARN) of the dataset group that contains the data used to train the
         *        predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetGroupArn(String datasetGroupArn);

        /**
         * <p>
         * Whether AutoPredictor was used to create the predictor.
         * </p>
         * 
         * @param isAutoPredictor
         *        Whether AutoPredictor was used to create the predictor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAutoPredictor(Boolean isAutoPredictor);

        /**
         * <p>
         * A summary of the reference predictor used if the predictor was retrained or upgraded.
         * </p>
         * 
         * @param referencePredictorSummary
         *        A summary of the reference predictor used if the predictor was retrained or upgraded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencePredictorSummary(ReferencePredictorSummary referencePredictorSummary);

        /**
         * <p>
         * A summary of the reference predictor used if the predictor was retrained or upgraded.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReferencePredictorSummary.Builder}
         * avoiding the need to create one manually via {@link ReferencePredictorSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReferencePredictorSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #referencePredictorSummary(ReferencePredictorSummary)}.
         * 
         * @param referencePredictorSummary
         *        a consumer that will call methods on {@link ReferencePredictorSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referencePredictorSummary(ReferencePredictorSummary)
         */
        default Builder referencePredictorSummary(Consumer<ReferencePredictorSummary.Builder> referencePredictorSummary) {
            return referencePredictorSummary(ReferencePredictorSummary.builder().applyMutation(referencePredictorSummary).build());
        }

        /**
         * <p>
         * The status of the predictor. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor to
         * create a forecast.
         * </p>
         * </note>
         * 
         * @param status
         *        The status of the predictor. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code>, <code>CREATE_IN_PROGRESS</code>, <code>CREATE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETE_PENDING</code>, <code>DELETE_IN_PROGRESS</code>, <code>DELETE_FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code>, <code>CREATE_STOPPED</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The <code>Status</code> of the predictor must be <code>ACTIVE</code> before you can use the predictor
         *        to create a forecast.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * If an error occurred, an informational message about the error.
         * </p>
         * 
         * @param message
         *        If an error occurred, an informational message about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the model training task was created.
         * </p>
         * 
         * @param creationTime
         *        When the model training task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the resource was modified. The timestamp depends on the status of the job:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPING</code> - The current timestamp.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_STOPPED</code> - When the job stopped.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastModificationTime
         *        The last time the resource was modified. The timestamp depends on the status of the job:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATE_PENDING</code> - The <code>CreationTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_IN_PROGRESS</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPING</code> - The current timestamp.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_STOPPED</code> - When the job stopped.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> or <code>CREATE_FAILED</code> - When the job finished or failed.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);
    }

    static final class BuilderImpl implements Builder {
        private String predictorArn;

        private String predictorName;

        private String datasetGroupArn;

        private Boolean isAutoPredictor;

        private ReferencePredictorSummary referencePredictorSummary;

        private String status;

        private String message;

        private Instant creationTime;

        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictorSummary model) {
            predictorArn(model.predictorArn);
            predictorName(model.predictorName);
            datasetGroupArn(model.datasetGroupArn);
            isAutoPredictor(model.isAutoPredictor);
            referencePredictorSummary(model.referencePredictorSummary);
            status(model.status);
            message(model.message);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
        }

        public final String getPredictorArn() {
            return predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        public final String getPredictorName() {
            return predictorName;
        }

        public final void setPredictorName(String predictorName) {
            this.predictorName = predictorName;
        }

        @Override
        public final Builder predictorName(String predictorName) {
            this.predictorName = predictorName;
            return this;
        }

        public final String getDatasetGroupArn() {
            return datasetGroupArn;
        }

        public final void setDatasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
        }

        @Override
        public final Builder datasetGroupArn(String datasetGroupArn) {
            this.datasetGroupArn = datasetGroupArn;
            return this;
        }

        public final Boolean getIsAutoPredictor() {
            return isAutoPredictor;
        }

        public final void setIsAutoPredictor(Boolean isAutoPredictor) {
            this.isAutoPredictor = isAutoPredictor;
        }

        @Override
        public final Builder isAutoPredictor(Boolean isAutoPredictor) {
            this.isAutoPredictor = isAutoPredictor;
            return this;
        }

        public final ReferencePredictorSummary.Builder getReferencePredictorSummary() {
            return referencePredictorSummary != null ? referencePredictorSummary.toBuilder() : null;
        }

        public final void setReferencePredictorSummary(ReferencePredictorSummary.BuilderImpl referencePredictorSummary) {
            this.referencePredictorSummary = referencePredictorSummary != null ? referencePredictorSummary.build() : null;
        }

        @Override
        public final Builder referencePredictorSummary(ReferencePredictorSummary referencePredictorSummary) {
            this.referencePredictorSummary = referencePredictorSummary;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public PredictorSummary build() {
            return new PredictorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
