/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The source of the data the monitor used during the evaluation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitorDataSource implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitorDataSource.Builder, MonitorDataSource> {
    private static final SdkField<String> DATASET_IMPORT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetImportJobArn").getter(getter(MonitorDataSource::datasetImportJobArn))
            .setter(setter(Builder::datasetImportJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobArn").build())
            .build();

    private static final SdkField<String> FORECAST_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForecastArn").getter(getter(MonitorDataSource::forecastArn)).setter(setter(Builder::forecastArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForecastArn").build()).build();

    private static final SdkField<String> PREDICTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PredictorArn").getter(getter(MonitorDataSource::predictorArn)).setter(setter(Builder::predictorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_ARN_FIELD,
            FORECAST_ARN_FIELD, PREDICTOR_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String datasetImportJobArn;

    private final String forecastArn;

    private final String predictorArn;

    private MonitorDataSource(BuilderImpl builder) {
        this.datasetImportJobArn = builder.datasetImportJobArn;
        this.forecastArn = builder.forecastArn;
        this.predictorArn = builder.predictorArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset import job used to import the data that initiated the monitor
     * evaluation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset import job used to import the data that initiated the
     *         monitor evaluation.
     */
    public final String datasetImportJobArn() {
        return datasetImportJobArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the forecast the monitor used during the evaluation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the forecast the monitor used during the evaluation.
     */
    public final String forecastArn() {
        return forecastArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the predictor resource you are monitoring.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the predictor resource you are monitoring.
     */
    public final String predictorArn() {
        return predictorArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(forecastArn());
        hashCode = 31 * hashCode + Objects.hashCode(predictorArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitorDataSource)) {
            return false;
        }
        MonitorDataSource other = (MonitorDataSource) obj;
        return Objects.equals(datasetImportJobArn(), other.datasetImportJobArn())
                && Objects.equals(forecastArn(), other.forecastArn()) && Objects.equals(predictorArn(), other.predictorArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitorDataSource").add("DatasetImportJobArn", datasetImportJobArn())
                .add("ForecastArn", forecastArn()).add("PredictorArn", predictorArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetImportJobArn":
            return Optional.ofNullable(clazz.cast(datasetImportJobArn()));
        case "ForecastArn":
            return Optional.ofNullable(clazz.cast(forecastArn()));
        case "PredictorArn":
            return Optional.ofNullable(clazz.cast(predictorArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitorDataSource, T> g) {
        return obj -> g.apply((MonitorDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitorDataSource> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset import job used to import the data that initiated the monitor
         * evaluation.
         * </p>
         * 
         * @param datasetImportJobArn
         *        The Amazon Resource Name (ARN) of the dataset import job used to import the data that initiated the
         *        monitor evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobArn(String datasetImportJobArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the forecast the monitor used during the evaluation.
         * </p>
         * 
         * @param forecastArn
         *        The Amazon Resource Name (ARN) of the forecast the monitor used during the evaluation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastArn(String forecastArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the predictor resource you are monitoring.
         * </p>
         * 
         * @param predictorArn
         *        The Amazon Resource Name (ARN) of the predictor resource you are monitoring.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorArn(String predictorArn);
    }

    static final class BuilderImpl implements Builder {
        private String datasetImportJobArn;

        private String forecastArn;

        private String predictorArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitorDataSource model) {
            datasetImportJobArn(model.datasetImportJobArn);
            forecastArn(model.forecastArn);
            predictorArn(model.predictorArn);
        }

        public final String getDatasetImportJobArn() {
            return datasetImportJobArn;
        }

        public final void setDatasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
        }

        @Override
        public final Builder datasetImportJobArn(String datasetImportJobArn) {
            this.datasetImportJobArn = datasetImportJobArn;
            return this;
        }

        public final String getForecastArn() {
            return forecastArn;
        }

        public final void setForecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
        }

        @Override
        public final Builder forecastArn(String forecastArn) {
            this.forecastArn = forecastArn;
            return this;
        }

        public final String getPredictorArn() {
            return predictorArn;
        }

        public final void setPredictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
        }

        @Override
        public final Builder predictorArn(String predictorArn) {
            this.predictorArn = predictorArn;
            return this;
        }

        @Override
        public MonitorDataSource build() {
            return new MonitorDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
