/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <note>
 * <p>
 * This object belongs to the <a>CreatePredictor</a> operation. If you created your predictor with
 * <a>CreateAutoPredictor</a>, see <a>AdditionalDataset</a>.
 * </p>
 * </note>
 * <p>
 * Describes a supplementary feature of a dataset group. This object is part of the <a>InputDataConfig</a> object.
 * Forecast supports the Weather Index and Holidays built-in featurizations.
 * </p>
 * <p>
 * <b>Weather Index</b>
 * </p>
 * <p>
 * The Amazon Forecast Weather Index is a built-in featurization that incorporates historical and projected weather
 * information into your model. The Weather Index supplements your datasets with over two years of historical weather
 * data and up to 14 days of projected weather data. For more information, see <a
 * href="https://docs.aws.amazon.com/forecast/latest/dg/weather.html">Amazon Forecast Weather Index</a>.
 * </p>
 * <p>
 * <b>Holidays</b>
 * </p>
 * <p>
 * Holidays is a built-in featurization that incorporates a feature-engineered dataset of national holiday information
 * into your model. It provides native support for the holiday calendars of 66 countries. To view the holiday calendars,
 * refer to the <a href="http://jollyday.sourceforge.net/data.html">Jollyday</a> library. For more information, see <a
 * href="https://docs.aws.amazon.com/forecast/latest/dg/holidays.html">Holidays Featurization</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SupplementaryFeature implements SdkPojo, Serializable,
        ToCopyableBuilder<SupplementaryFeature.Builder, SupplementaryFeature> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SupplementaryFeature::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(SupplementaryFeature::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String value;

    private SupplementaryFeature(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the feature. Valid values: <code>"holiday"</code> and <code>"weather"</code>.
     * </p>
     * 
     * @return The name of the feature. Valid values: <code>"holiday"</code> and <code>"weather"</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * <b>Weather Index</b>
     * </p>
     * <p>
     * To enable the Weather Index, set the value to <code>"true"</code>
     * </p>
     * <p>
     * <b>Holidays</b>
     * </p>
     * <p>
     * To enable Holidays, specify a country with one of the following two-letter country codes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * "AL" - ALBANIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "AR" - ARGENTINA
     * </p>
     * </li>
     * <li>
     * <p>
     * "AT" - AUSTRIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "AU" - AUSTRALIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "BA" - BOSNIA HERZEGOVINA
     * </p>
     * </li>
     * <li>
     * <p>
     * "BE" - BELGIUM
     * </p>
     * </li>
     * <li>
     * <p>
     * "BG" - BULGARIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "BO" - BOLIVIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "BR" - BRAZIL
     * </p>
     * </li>
     * <li>
     * <p>
     * "BY" - BELARUS
     * </p>
     * </li>
     * <li>
     * <p>
     * "CA" - CANADA
     * </p>
     * </li>
     * <li>
     * <p>
     * "CL" - CHILE
     * </p>
     * </li>
     * <li>
     * <p>
     * "CO" - COLOMBIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "CR" - COSTA RICA
     * </p>
     * </li>
     * <li>
     * <p>
     * "HR" - CROATIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "CZ" - CZECH REPUBLIC
     * </p>
     * </li>
     * <li>
     * <p>
     * "DK" - DENMARK
     * </p>
     * </li>
     * <li>
     * <p>
     * "EC" - ECUADOR
     * </p>
     * </li>
     * <li>
     * <p>
     * "EE" - ESTONIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "ET" - ETHIOPIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "FI" - FINLAND
     * </p>
     * </li>
     * <li>
     * <p>
     * "FR" - FRANCE
     * </p>
     * </li>
     * <li>
     * <p>
     * "DE" - GERMANY
     * </p>
     * </li>
     * <li>
     * <p>
     * "GR" - GREECE
     * </p>
     * </li>
     * <li>
     * <p>
     * "HU" - HUNGARY
     * </p>
     * </li>
     * <li>
     * <p>
     * "IS" - ICELAND
     * </p>
     * </li>
     * <li>
     * <p>
     * "IN" - INDIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "IE" - IRELAND
     * </p>
     * </li>
     * <li>
     * <p>
     * "IT" - ITALY
     * </p>
     * </li>
     * <li>
     * <p>
     * "JP" - JAPAN
     * </p>
     * </li>
     * <li>
     * <p>
     * "KZ" - KAZAKHSTAN
     * </p>
     * </li>
     * <li>
     * <p>
     * "KR" - KOREA
     * </p>
     * </li>
     * <li>
     * <p>
     * "LV" - LATVIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "LI" - LIECHTENSTEIN
     * </p>
     * </li>
     * <li>
     * <p>
     * "LT" - LITHUANIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "LU" - LUXEMBOURG
     * </p>
     * </li>
     * <li>
     * <p>
     * "MK" - MACEDONIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "MT" - MALTA
     * </p>
     * </li>
     * <li>
     * <p>
     * "MX" - MEXICO
     * </p>
     * </li>
     * <li>
     * <p>
     * "MD" - MOLDOVA
     * </p>
     * </li>
     * <li>
     * <p>
     * "ME" - MONTENEGRO
     * </p>
     * </li>
     * <li>
     * <p>
     * "NL" - NETHERLANDS
     * </p>
     * </li>
     * <li>
     * <p>
     * "NZ" - NEW ZEALAND
     * </p>
     * </li>
     * <li>
     * <p>
     * "NI" - NICARAGUA
     * </p>
     * </li>
     * <li>
     * <p>
     * "NG" - NIGERIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "NO" - NORWAY
     * </p>
     * </li>
     * <li>
     * <p>
     * "PA" - PANAMA
     * </p>
     * </li>
     * <li>
     * <p>
     * "PY" - PARAGUAY
     * </p>
     * </li>
     * <li>
     * <p>
     * "PE" - PERU
     * </p>
     * </li>
     * <li>
     * <p>
     * "PL" - POLAND
     * </p>
     * </li>
     * <li>
     * <p>
     * "PT" - PORTUGAL
     * </p>
     * </li>
     * <li>
     * <p>
     * "RO" - ROMANIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "RU" - RUSSIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "RS" - SERBIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "SK" - SLOVAKIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "SI" - SLOVENIA
     * </p>
     * </li>
     * <li>
     * <p>
     * "ZA" - SOUTH AFRICA
     * </p>
     * </li>
     * <li>
     * <p>
     * "ES" - SPAIN
     * </p>
     * </li>
     * <li>
     * <p>
     * "SE" - SWEDEN
     * </p>
     * </li>
     * <li>
     * <p>
     * "CH" - SWITZERLAND
     * </p>
     * </li>
     * <li>
     * <p>
     * "UA" - UKRAINE
     * </p>
     * </li>
     * <li>
     * <p>
     * "AE" - UNITED ARAB EMIRATES
     * </p>
     * </li>
     * <li>
     * <p>
     * "US" - UNITED STATES
     * </p>
     * </li>
     * <li>
     * <p>
     * "UK" - UNITED KINGDOM
     * </p>
     * </li>
     * <li>
     * <p>
     * "UY" - URUGUAY
     * </p>
     * </li>
     * <li>
     * <p>
     * "VE" - VENEZUELA
     * </p>
     * </li>
     * </ul>
     * 
     * @return <b>Weather Index</b> </p>
     *         <p>
     *         To enable the Weather Index, set the value to <code>"true"</code>
     *         </p>
     *         <p>
     *         <b>Holidays</b>
     *         </p>
     *         <p>
     *         To enable Holidays, specify a country with one of the following two-letter country codes:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         "AL" - ALBANIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "AR" - ARGENTINA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "AT" - AUSTRIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "AU" - AUSTRALIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "BA" - BOSNIA HERZEGOVINA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "BE" - BELGIUM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "BG" - BULGARIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "BO" - BOLIVIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "BR" - BRAZIL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "BY" - BELARUS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "CA" - CANADA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "CL" - CHILE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "CO" - COLOMBIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "CR" - COSTA RICA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "HR" - CROATIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "CZ" - CZECH REPUBLIC
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "DK" - DENMARK
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "EC" - ECUADOR
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "EE" - ESTONIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "ET" - ETHIOPIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "FI" - FINLAND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "FR" - FRANCE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "DE" - GERMANY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "GR" - GREECE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "HU" - HUNGARY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "IS" - ICELAND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "IN" - INDIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "IE" - IRELAND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "IT" - ITALY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "JP" - JAPAN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "KZ" - KAZAKHSTAN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "KR" - KOREA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "LV" - LATVIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "LI" - LIECHTENSTEIN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "LT" - LITHUANIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "LU" - LUXEMBOURG
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "MK" - MACEDONIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "MT" - MALTA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "MX" - MEXICO
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "MD" - MOLDOVA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "ME" - MONTENEGRO
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "NL" - NETHERLANDS
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "NZ" - NEW ZEALAND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "NI" - NICARAGUA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "NG" - NIGERIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "NO" - NORWAY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "PA" - PANAMA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "PY" - PARAGUAY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "PE" - PERU
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "PL" - POLAND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "PT" - PORTUGAL
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "RO" - ROMANIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "RU" - RUSSIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "RS" - SERBIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "SK" - SLOVAKIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "SI" - SLOVENIA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "ZA" - SOUTH AFRICA
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "ES" - SPAIN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "SE" - SWEDEN
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "CH" - SWITZERLAND
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "UA" - UKRAINE
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "AE" - UNITED ARAB EMIRATES
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "US" - UNITED STATES
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "UK" - UNITED KINGDOM
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "UY" - URUGUAY
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "VE" - VENEZUELA
     *         </p>
     *         </li>
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupplementaryFeature)) {
            return false;
        }
        SupplementaryFeature other = (SupplementaryFeature) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SupplementaryFeature").add("Name", name()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SupplementaryFeature, T> g) {
        return obj -> g.apply((SupplementaryFeature) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SupplementaryFeature> {
        /**
         * <p>
         * The name of the feature. Valid values: <code>"holiday"</code> and <code>"weather"</code>.
         * </p>
         * 
         * @param name
         *        The name of the feature. Valid values: <code>"holiday"</code> and <code>"weather"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * <b>Weather Index</b>
         * </p>
         * <p>
         * To enable the Weather Index, set the value to <code>"true"</code>
         * </p>
         * <p>
         * <b>Holidays</b>
         * </p>
         * <p>
         * To enable Holidays, specify a country with one of the following two-letter country codes:
         * </p>
         * <ul>
         * <li>
         * <p>
         * "AL" - ALBANIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "AR" - ARGENTINA
         * </p>
         * </li>
         * <li>
         * <p>
         * "AT" - AUSTRIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "AU" - AUSTRALIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "BA" - BOSNIA HERZEGOVINA
         * </p>
         * </li>
         * <li>
         * <p>
         * "BE" - BELGIUM
         * </p>
         * </li>
         * <li>
         * <p>
         * "BG" - BULGARIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "BO" - BOLIVIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "BR" - BRAZIL
         * </p>
         * </li>
         * <li>
         * <p>
         * "BY" - BELARUS
         * </p>
         * </li>
         * <li>
         * <p>
         * "CA" - CANADA
         * </p>
         * </li>
         * <li>
         * <p>
         * "CL" - CHILE
         * </p>
         * </li>
         * <li>
         * <p>
         * "CO" - COLOMBIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "CR" - COSTA RICA
         * </p>
         * </li>
         * <li>
         * <p>
         * "HR" - CROATIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "CZ" - CZECH REPUBLIC
         * </p>
         * </li>
         * <li>
         * <p>
         * "DK" - DENMARK
         * </p>
         * </li>
         * <li>
         * <p>
         * "EC" - ECUADOR
         * </p>
         * </li>
         * <li>
         * <p>
         * "EE" - ESTONIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "ET" - ETHIOPIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "FI" - FINLAND
         * </p>
         * </li>
         * <li>
         * <p>
         * "FR" - FRANCE
         * </p>
         * </li>
         * <li>
         * <p>
         * "DE" - GERMANY
         * </p>
         * </li>
         * <li>
         * <p>
         * "GR" - GREECE
         * </p>
         * </li>
         * <li>
         * <p>
         * "HU" - HUNGARY
         * </p>
         * </li>
         * <li>
         * <p>
         * "IS" - ICELAND
         * </p>
         * </li>
         * <li>
         * <p>
         * "IN" - INDIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "IE" - IRELAND
         * </p>
         * </li>
         * <li>
         * <p>
         * "IT" - ITALY
         * </p>
         * </li>
         * <li>
         * <p>
         * "JP" - JAPAN
         * </p>
         * </li>
         * <li>
         * <p>
         * "KZ" - KAZAKHSTAN
         * </p>
         * </li>
         * <li>
         * <p>
         * "KR" - KOREA
         * </p>
         * </li>
         * <li>
         * <p>
         * "LV" - LATVIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "LI" - LIECHTENSTEIN
         * </p>
         * </li>
         * <li>
         * <p>
         * "LT" - LITHUANIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "LU" - LUXEMBOURG
         * </p>
         * </li>
         * <li>
         * <p>
         * "MK" - MACEDONIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "MT" - MALTA
         * </p>
         * </li>
         * <li>
         * <p>
         * "MX" - MEXICO
         * </p>
         * </li>
         * <li>
         * <p>
         * "MD" - MOLDOVA
         * </p>
         * </li>
         * <li>
         * <p>
         * "ME" - MONTENEGRO
         * </p>
         * </li>
         * <li>
         * <p>
         * "NL" - NETHERLANDS
         * </p>
         * </li>
         * <li>
         * <p>
         * "NZ" - NEW ZEALAND
         * </p>
         * </li>
         * <li>
         * <p>
         * "NI" - NICARAGUA
         * </p>
         * </li>
         * <li>
         * <p>
         * "NG" - NIGERIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "NO" - NORWAY
         * </p>
         * </li>
         * <li>
         * <p>
         * "PA" - PANAMA
         * </p>
         * </li>
         * <li>
         * <p>
         * "PY" - PARAGUAY
         * </p>
         * </li>
         * <li>
         * <p>
         * "PE" - PERU
         * </p>
         * </li>
         * <li>
         * <p>
         * "PL" - POLAND
         * </p>
         * </li>
         * <li>
         * <p>
         * "PT" - PORTUGAL
         * </p>
         * </li>
         * <li>
         * <p>
         * "RO" - ROMANIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "RU" - RUSSIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "RS" - SERBIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "SK" - SLOVAKIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "SI" - SLOVENIA
         * </p>
         * </li>
         * <li>
         * <p>
         * "ZA" - SOUTH AFRICA
         * </p>
         * </li>
         * <li>
         * <p>
         * "ES" - SPAIN
         * </p>
         * </li>
         * <li>
         * <p>
         * "SE" - SWEDEN
         * </p>
         * </li>
         * <li>
         * <p>
         * "CH" - SWITZERLAND
         * </p>
         * </li>
         * <li>
         * <p>
         * "UA" - UKRAINE
         * </p>
         * </li>
         * <li>
         * <p>
         * "AE" - UNITED ARAB EMIRATES
         * </p>
         * </li>
         * <li>
         * <p>
         * "US" - UNITED STATES
         * </p>
         * </li>
         * <li>
         * <p>
         * "UK" - UNITED KINGDOM
         * </p>
         * </li>
         * <li>
         * <p>
         * "UY" - URUGUAY
         * </p>
         * </li>
         * <li>
         * <p>
         * "VE" - VENEZUELA
         * </p>
         * </li>
         * </ul>
         * 
         * @param value
         *        <b>Weather Index</b> </p>
         *        <p>
         *        To enable the Weather Index, set the value to <code>"true"</code>
         *        </p>
         *        <p>
         *        <b>Holidays</b>
         *        </p>
         *        <p>
         *        To enable Holidays, specify a country with one of the following two-letter country codes:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        "AL" - ALBANIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "AR" - ARGENTINA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "AT" - AUSTRIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "AU" - AUSTRALIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "BA" - BOSNIA HERZEGOVINA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "BE" - BELGIUM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "BG" - BULGARIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "BO" - BOLIVIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "BR" - BRAZIL
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "BY" - BELARUS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "CA" - CANADA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "CL" - CHILE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "CO" - COLOMBIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "CR" - COSTA RICA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "HR" - CROATIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "CZ" - CZECH REPUBLIC
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "DK" - DENMARK
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "EC" - ECUADOR
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "EE" - ESTONIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "ET" - ETHIOPIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "FI" - FINLAND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "FR" - FRANCE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "DE" - GERMANY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "GR" - GREECE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "HU" - HUNGARY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "IS" - ICELAND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "IN" - INDIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "IE" - IRELAND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "IT" - ITALY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "JP" - JAPAN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "KZ" - KAZAKHSTAN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "KR" - KOREA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "LV" - LATVIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "LI" - LIECHTENSTEIN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "LT" - LITHUANIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "LU" - LUXEMBOURG
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "MK" - MACEDONIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "MT" - MALTA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "MX" - MEXICO
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "MD" - MOLDOVA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "ME" - MONTENEGRO
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "NL" - NETHERLANDS
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "NZ" - NEW ZEALAND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "NI" - NICARAGUA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "NG" - NIGERIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "NO" - NORWAY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "PA" - PANAMA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "PY" - PARAGUAY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "PE" - PERU
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "PL" - POLAND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "PT" - PORTUGAL
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "RO" - ROMANIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "RU" - RUSSIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "RS" - SERBIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "SK" - SLOVAKIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "SI" - SLOVENIA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "ZA" - SOUTH AFRICA
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "ES" - SPAIN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "SE" - SWEDEN
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "CH" - SWITZERLAND
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "UA" - UKRAINE
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "AE" - UNITED ARAB EMIRATES
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "US" - UNITED STATES
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "UK" - UNITED KINGDOM
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "UY" - URUGUAY
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "VE" - VENEZUELA
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(SupplementaryFeature model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public SupplementaryFeature build() {
            return new SupplementaryFeature(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
