/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWhatIfForecastRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateWhatIfForecastRequest.Builder, CreateWhatIfForecastRequest> {
    private static final SdkField<String> WHAT_IF_FORECAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfForecastName").getter(getter(CreateWhatIfForecastRequest::whatIfForecastName))
            .setter(setter(Builder::whatIfForecastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfForecastName").build())
            .build();

    private static final SdkField<String> WHAT_IF_ANALYSIS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WhatIfAnalysisArn").getter(getter(CreateWhatIfForecastRequest::whatIfAnalysisArn))
            .setter(setter(Builder::whatIfAnalysisArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhatIfAnalysisArn").build()).build();

    private static final SdkField<List<TimeSeriesTransformation>> TIME_SERIES_TRANSFORMATIONS_FIELD = SdkField
            .<List<TimeSeriesTransformation>> builder(MarshallingType.LIST)
            .memberName("TimeSeriesTransformations")
            .getter(getter(CreateWhatIfForecastRequest::timeSeriesTransformations))
            .setter(setter(Builder::timeSeriesTransformations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesTransformations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeSeriesTransformation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeSeriesTransformation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimeSeriesReplacementsDataSource> TIME_SERIES_REPLACEMENTS_DATA_SOURCE_FIELD = SdkField
            .<TimeSeriesReplacementsDataSource> builder(MarshallingType.SDK_POJO)
            .memberName("TimeSeriesReplacementsDataSource")
            .getter(getter(CreateWhatIfForecastRequest::timeSeriesReplacementsDataSource))
            .setter(setter(Builder::timeSeriesReplacementsDataSource))
            .constructor(TimeSeriesReplacementsDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesReplacementsDataSource")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateWhatIfForecastRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(WHAT_IF_FORECAST_NAME_FIELD, WHAT_IF_ANALYSIS_ARN_FIELD, TIME_SERIES_TRANSFORMATIONS_FIELD,
                    TIME_SERIES_REPLACEMENTS_DATA_SOURCE_FIELD, TAGS_FIELD));

    private final String whatIfForecastName;

    private final String whatIfAnalysisArn;

    private final List<TimeSeriesTransformation> timeSeriesTransformations;

    private final TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource;

    private final List<Tag> tags;

    private CreateWhatIfForecastRequest(BuilderImpl builder) {
        super(builder);
        this.whatIfForecastName = builder.whatIfForecastName;
        this.whatIfAnalysisArn = builder.whatIfAnalysisArn;
        this.timeSeriesTransformations = builder.timeSeriesTransformations;
        this.timeSeriesReplacementsDataSource = builder.timeSeriesReplacementsDataSource;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the what-if forecast. Names must be unique within each what-if analysis.
     * </p>
     * 
     * @return The name of the what-if forecast. Names must be unique within each what-if analysis.
     */
    public final String whatIfForecastName() {
        return whatIfForecastName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the what-if analysis.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the what-if analysis.
     */
    public final String whatIfAnalysisArn() {
        return whatIfAnalysisArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimeSeriesTransformations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTimeSeriesTransformations() {
        return timeSeriesTransformations != null && !(timeSeriesTransformations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The transformations that are applied to the baseline time series. Each transformation contains an action and a
     * set of conditions. An action is applied only when all conditions are met. If no conditions are provided, the
     * action is applied to all items.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimeSeriesTransformations} method.
     * </p>
     * 
     * @return The transformations that are applied to the baseline time series. Each transformation contains an action
     *         and a set of conditions. An action is applied only when all conditions are met. If no conditions are
     *         provided, the action is applied to all items.
     */
    public final List<TimeSeriesTransformation> timeSeriesTransformations() {
        return timeSeriesTransformations;
    }

    /**
     * <p>
     * The replacement time series dataset, which contains the rows that you want to change in the related time series
     * dataset. A replacement time series does not need to contain all rows that are in the baseline related time
     * series. Include only the rows (measure-dimension combinations) that you want to include in the what-if forecast.
     * This dataset is merged with the original time series to create a transformed dataset that is used for the what-if
     * analysis.
     * </p>
     * <p>
     * This dataset should contain the items to modify (such as item_id or workforce_type), any relevant dimensions, the
     * timestamp column, and at least one of the related time series columns. This file should not contain duplicate
     * timestamps for the same time series.
     * </p>
     * <p>
     * Timestamps and item_ids not included in this dataset are not included in the what-if analysis.
     * </p>
     * 
     * @return The replacement time series dataset, which contains the rows that you want to change in the related time
     *         series dataset. A replacement time series does not need to contain all rows that are in the baseline
     *         related time series. Include only the rows (measure-dimension combinations) that you want to include in
     *         the what-if forecast. This dataset is merged with the original time series to create a transformed
     *         dataset that is used for the what-if analysis.</p>
     *         <p>
     *         This dataset should contain the items to modify (such as item_id or workforce_type), any relevant
     *         dimensions, the timestamp column, and at least one of the related time series columns. This file should
     *         not contain duplicate timestamps for the same time series.
     *         </p>
     *         <p>
     *         Timestamps and item_ids not included in this dataset are not included in the what-if analysis.
     */
    public final TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource() {
        return timeSeriesReplacementsDataSource;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to
     * apply to the what if forecast.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of <a
     *         href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to apply
     *         to the what if forecast.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(whatIfForecastName());
        hashCode = 31 * hashCode + Objects.hashCode(whatIfAnalysisArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimeSeriesTransformations() ? timeSeriesTransformations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesReplacementsDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWhatIfForecastRequest)) {
            return false;
        }
        CreateWhatIfForecastRequest other = (CreateWhatIfForecastRequest) obj;
        return Objects.equals(whatIfForecastName(), other.whatIfForecastName())
                && Objects.equals(whatIfAnalysisArn(), other.whatIfAnalysisArn())
                && hasTimeSeriesTransformations() == other.hasTimeSeriesTransformations()
                && Objects.equals(timeSeriesTransformations(), other.timeSeriesTransformations())
                && Objects.equals(timeSeriesReplacementsDataSource(), other.timeSeriesReplacementsDataSource())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWhatIfForecastRequest").add("WhatIfForecastName", whatIfForecastName())
                .add("WhatIfAnalysisArn", whatIfAnalysisArn())
                .add("TimeSeriesTransformations", hasTimeSeriesTransformations() ? timeSeriesTransformations() : null)
                .add("TimeSeriesReplacementsDataSource", timeSeriesReplacementsDataSource())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WhatIfForecastName":
            return Optional.ofNullable(clazz.cast(whatIfForecastName()));
        case "WhatIfAnalysisArn":
            return Optional.ofNullable(clazz.cast(whatIfAnalysisArn()));
        case "TimeSeriesTransformations":
            return Optional.ofNullable(clazz.cast(timeSeriesTransformations()));
        case "TimeSeriesReplacementsDataSource":
            return Optional.ofNullable(clazz.cast(timeSeriesReplacementsDataSource()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWhatIfForecastRequest, T> g) {
        return obj -> g.apply((CreateWhatIfForecastRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWhatIfForecastRequest> {
        /**
         * <p>
         * The name of the what-if forecast. Names must be unique within each what-if analysis.
         * </p>
         * 
         * @param whatIfForecastName
         *        The name of the what-if forecast. Names must be unique within each what-if analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfForecastName(String whatIfForecastName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the what-if analysis.
         * </p>
         * 
         * @param whatIfAnalysisArn
         *        The Amazon Resource Name (ARN) of the what-if analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder whatIfAnalysisArn(String whatIfAnalysisArn);

        /**
         * <p>
         * The transformations that are applied to the baseline time series. Each transformation contains an action and
         * a set of conditions. An action is applied only when all conditions are met. If no conditions are provided,
         * the action is applied to all items.
         * </p>
         * 
         * @param timeSeriesTransformations
         *        The transformations that are applied to the baseline time series. Each transformation contains an
         *        action and a set of conditions. An action is applied only when all conditions are met. If no
         *        conditions are provided, the action is applied to all items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesTransformations(Collection<TimeSeriesTransformation> timeSeriesTransformations);

        /**
         * <p>
         * The transformations that are applied to the baseline time series. Each transformation contains an action and
         * a set of conditions. An action is applied only when all conditions are met. If no conditions are provided,
         * the action is applied to all items.
         * </p>
         * 
         * @param timeSeriesTransformations
         *        The transformations that are applied to the baseline time series. Each transformation contains an
         *        action and a set of conditions. An action is applied only when all conditions are met. If no
         *        conditions are provided, the action is applied to all items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesTransformations(TimeSeriesTransformation... timeSeriesTransformations);

        /**
         * <p>
         * The transformations that are applied to the baseline time series. Each transformation contains an action and
         * a set of conditions. An action is applied only when all conditions are met. If no conditions are provided,
         * the action is applied to all items.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation.Builder#build()} is called
         * immediately and its result is passed to {@link #timeSeriesTransformations(List<TimeSeriesTransformation>)}.
         * 
         * @param timeSeriesTransformations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.TimeSeriesTransformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesTransformations(java.util.Collection<TimeSeriesTransformation>)
         */
        Builder timeSeriesTransformations(Consumer<TimeSeriesTransformation.Builder>... timeSeriesTransformations);

        /**
         * <p>
         * The replacement time series dataset, which contains the rows that you want to change in the related time
         * series dataset. A replacement time series does not need to contain all rows that are in the baseline related
         * time series. Include only the rows (measure-dimension combinations) that you want to include in the what-if
         * forecast. This dataset is merged with the original time series to create a transformed dataset that is used
         * for the what-if analysis.
         * </p>
         * <p>
         * This dataset should contain the items to modify (such as item_id or workforce_type), any relevant dimensions,
         * the timestamp column, and at least one of the related time series columns. This file should not contain
         * duplicate timestamps for the same time series.
         * </p>
         * <p>
         * Timestamps and item_ids not included in this dataset are not included in the what-if analysis.
         * </p>
         * 
         * @param timeSeriesReplacementsDataSource
         *        The replacement time series dataset, which contains the rows that you want to change in the related
         *        time series dataset. A replacement time series does not need to contain all rows that are in the
         *        baseline related time series. Include only the rows (measure-dimension combinations) that you want to
         *        include in the what-if forecast. This dataset is merged with the original time series to create a
         *        transformed dataset that is used for the what-if analysis.</p>
         *        <p>
         *        This dataset should contain the items to modify (such as item_id or workforce_type), any relevant
         *        dimensions, the timestamp column, and at least one of the related time series columns. This file
         *        should not contain duplicate timestamps for the same time series.
         *        </p>
         *        <p>
         *        Timestamps and item_ids not included in this dataset are not included in the what-if analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource);

        /**
         * <p>
         * The replacement time series dataset, which contains the rows that you want to change in the related time
         * series dataset. A replacement time series does not need to contain all rows that are in the baseline related
         * time series. Include only the rows (measure-dimension combinations) that you want to include in the what-if
         * forecast. This dataset is merged with the original time series to create a transformed dataset that is used
         * for the what-if analysis.
         * </p>
         * <p>
         * This dataset should contain the items to modify (such as item_id or workforce_type), any relevant dimensions,
         * the timestamp column, and at least one of the related time series columns. This file should not contain
         * duplicate timestamps for the same time series.
         * </p>
         * <p>
         * Timestamps and item_ids not included in this dataset are not included in the what-if analysis.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeSeriesReplacementsDataSource.Builder}
         * avoiding the need to create one manually via {@link TimeSeriesReplacementsDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeSeriesReplacementsDataSource.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource)}.
         * 
         * @param timeSeriesReplacementsDataSource
         *        a consumer that will call methods on {@link TimeSeriesReplacementsDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource)
         */
        default Builder timeSeriesReplacementsDataSource(
                Consumer<TimeSeriesReplacementsDataSource.Builder> timeSeriesReplacementsDataSource) {
            return timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource.builder()
                    .applyMutation(timeSeriesReplacementsDataSource).build());
        }

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a>
         * to apply to the what if forecast.
         * </p>
         * 
         * @param tags
         *        A list of <a
         *        href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to
         *        apply to the what if forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a>
         * to apply to the what if forecast.
         * </p>
         * 
         * @param tags
         *        A list of <a
         *        href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a> to
         *        apply to the what if forecast.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/forecast/latest/dg/tagging-forecast-resources.html">tags</a>
         * to apply to the what if forecast.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.forecast.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String whatIfForecastName;

        private String whatIfAnalysisArn;

        private List<TimeSeriesTransformation> timeSeriesTransformations = DefaultSdkAutoConstructList.getInstance();

        private TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWhatIfForecastRequest model) {
            super(model);
            whatIfForecastName(model.whatIfForecastName);
            whatIfAnalysisArn(model.whatIfAnalysisArn);
            timeSeriesTransformations(model.timeSeriesTransformations);
            timeSeriesReplacementsDataSource(model.timeSeriesReplacementsDataSource);
            tags(model.tags);
        }

        public final String getWhatIfForecastName() {
            return whatIfForecastName;
        }

        public final void setWhatIfForecastName(String whatIfForecastName) {
            this.whatIfForecastName = whatIfForecastName;
        }

        @Override
        public final Builder whatIfForecastName(String whatIfForecastName) {
            this.whatIfForecastName = whatIfForecastName;
            return this;
        }

        public final String getWhatIfAnalysisArn() {
            return whatIfAnalysisArn;
        }

        public final void setWhatIfAnalysisArn(String whatIfAnalysisArn) {
            this.whatIfAnalysisArn = whatIfAnalysisArn;
        }

        @Override
        public final Builder whatIfAnalysisArn(String whatIfAnalysisArn) {
            this.whatIfAnalysisArn = whatIfAnalysisArn;
            return this;
        }

        public final List<TimeSeriesTransformation.Builder> getTimeSeriesTransformations() {
            List<TimeSeriesTransformation.Builder> result = TimeSeriesTransformationsCopier
                    .copyToBuilder(this.timeSeriesTransformations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesTransformations(Collection<TimeSeriesTransformation.BuilderImpl> timeSeriesTransformations) {
            this.timeSeriesTransformations = TimeSeriesTransformationsCopier.copyFromBuilder(timeSeriesTransformations);
        }

        @Override
        public final Builder timeSeriesTransformations(Collection<TimeSeriesTransformation> timeSeriesTransformations) {
            this.timeSeriesTransformations = TimeSeriesTransformationsCopier.copy(timeSeriesTransformations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesTransformations(TimeSeriesTransformation... timeSeriesTransformations) {
            timeSeriesTransformations(Arrays.asList(timeSeriesTransformations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesTransformations(Consumer<TimeSeriesTransformation.Builder>... timeSeriesTransformations) {
            timeSeriesTransformations(Stream.of(timeSeriesTransformations)
                    .map(c -> TimeSeriesTransformation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimeSeriesReplacementsDataSource.Builder getTimeSeriesReplacementsDataSource() {
            return timeSeriesReplacementsDataSource != null ? timeSeriesReplacementsDataSource.toBuilder() : null;
        }

        public final void setTimeSeriesReplacementsDataSource(
                TimeSeriesReplacementsDataSource.BuilderImpl timeSeriesReplacementsDataSource) {
            this.timeSeriesReplacementsDataSource = timeSeriesReplacementsDataSource != null ? timeSeriesReplacementsDataSource
                    .build() : null;
        }

        @Override
        public final Builder timeSeriesReplacementsDataSource(TimeSeriesReplacementsDataSource timeSeriesReplacementsDataSource) {
            this.timeSeriesReplacementsDataSource = timeSeriesReplacementsDataSource;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWhatIfForecastRequest build() {
            return new CreateWhatIfForecastRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
