/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metrics you can use as a baseline for comparison purposes. Use these metrics when you interpret monitoring results
 * for an auto predictor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictorBaseline implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictorBaseline.Builder, PredictorBaseline> {
    private static final SdkField<List<BaselineMetric>> BASELINE_METRICS_FIELD = SdkField
            .<List<BaselineMetric>> builder(MarshallingType.LIST)
            .memberName("BaselineMetrics")
            .getter(getter(PredictorBaseline::baselineMetrics))
            .setter(setter(Builder::baselineMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BaselineMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(BaselineMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASELINE_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<BaselineMetric> baselineMetrics;

    private PredictorBaseline(BuilderImpl builder) {
        this.baselineMetrics = builder.baselineMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the BaselineMetrics property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBaselineMetrics() {
        return baselineMetrics != null && !(baselineMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for the
     * predictor. Use these metrics as a baseline for comparison purposes as you use your predictor and the metrics
     * change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBaselineMetrics} method.
     * </p>
     * 
     * @return The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a>
     *         for the predictor. Use these metrics as a baseline for comparison purposes as you use your predictor and
     *         the metrics change.
     */
    public final List<BaselineMetric> baselineMetrics() {
        return baselineMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBaselineMetrics() ? baselineMetrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorBaseline)) {
            return false;
        }
        PredictorBaseline other = (PredictorBaseline) obj;
        return hasBaselineMetrics() == other.hasBaselineMetrics() && Objects.equals(baselineMetrics(), other.baselineMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictorBaseline").add("BaselineMetrics", hasBaselineMetrics() ? baselineMetrics() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaselineMetrics":
            return Optional.ofNullable(clazz.cast(baselineMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictorBaseline, T> g) {
        return obj -> g.apply((PredictorBaseline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictorBaseline> {
        /**
         * <p>
         * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for
         * the predictor. Use these metrics as a baseline for comparison purposes as you use your predictor and the
         * metrics change.
         * </p>
         * 
         * @param baselineMetrics
         *        The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a>
         *        for the predictor. Use these metrics as a baseline for comparison purposes as you use your predictor
         *        and the metrics change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineMetrics(Collection<BaselineMetric> baselineMetrics);

        /**
         * <p>
         * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for
         * the predictor. Use these metrics as a baseline for comparison purposes as you use your predictor and the
         * metrics change.
         * </p>
         * 
         * @param baselineMetrics
         *        The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a>
         *        for the predictor. Use these metrics as a baseline for comparison purposes as you use your predictor
         *        and the metrics change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineMetrics(BaselineMetric... baselineMetrics);

        /**
         * <p>
         * The initial <a href="https://docs.aws.amazon.com/forecast/latest/dg/metrics.html">accuracy metrics</a> for
         * the predictor. Use these metrics as a baseline for comparison purposes as you use your predictor and the
         * metrics change.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.forecast.model.BaselineMetric.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.forecast.model.BaselineMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.forecast.model.BaselineMetric.Builder#build()} is called immediately
         * and its result is passed to {@link #baselineMetrics(List<BaselineMetric>)}.
         * 
         * @param baselineMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.forecast.model.BaselineMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baselineMetrics(java.util.Collection<BaselineMetric>)
         */
        Builder baselineMetrics(Consumer<BaselineMetric.Builder>... baselineMetrics);
    }

    static final class BuilderImpl implements Builder {
        private List<BaselineMetric> baselineMetrics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredictorBaseline model) {
            baselineMetrics(model.baselineMetrics);
        }

        public final List<BaselineMetric.Builder> getBaselineMetrics() {
            List<BaselineMetric.Builder> result = BaselineMetricsCopier.copyToBuilder(this.baselineMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBaselineMetrics(Collection<BaselineMetric.BuilderImpl> baselineMetrics) {
            this.baselineMetrics = BaselineMetricsCopier.copyFromBuilder(baselineMetrics);
        }

        @Override
        public final Builder baselineMetrics(Collection<BaselineMetric> baselineMetrics) {
            this.baselineMetrics = BaselineMetricsCopier.copy(baselineMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineMetrics(BaselineMetric... baselineMetrics) {
            baselineMetrics(Arrays.asList(baselineMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder baselineMetrics(Consumer<BaselineMetric.Builder>... baselineMetrics) {
            baselineMetrics(Stream.of(baselineMetrics).map(c -> BaselineMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PredictorBaseline build() {
            return new PredictorBaseline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
