/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.forecast.model.ConfigurationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AdditionalDataset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AdditionalDataset> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AdditionalDataset.getter(AdditionalDataset::name)).setter(AdditionalDataset.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Map<String, List<String>>> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Configuration").getter(AdditionalDataset.getter(AdditionalDataset::configuration)).setter(AdditionalDataset.setter(Builder::configuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Map<String, List<String>> configuration;

    private AdditionalDataset(BuilderImpl builder) {
        this.name = builder.name;
        this.configuration = builder.configuration;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasConfiguration() {
        return this.configuration != null && !(this.configuration instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfiguration() ? this.configuration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdditionalDataset)) {
            return false;
        }
        AdditionalDataset other = (AdditionalDataset)obj;
        return Objects.equals(this.name(), other.name()) && this.hasConfiguration() == other.hasConfiguration() && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"AdditionalDataset").add("Name", (Object)this.name()).add("Configuration", this.hasConfiguration() ? this.configuration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AdditionalDataset, T> g) {
        return obj -> g.apply((AdditionalDataset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Map<String, List<String>> configuration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AdditionalDataset model) {
            this.name(model.name);
            this.configuration(model.configuration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getConfiguration() {
            if (this.configuration instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.configuration;
        }

        public final void setConfiguration(Map<String, ? extends Collection<String>> configuration) {
            this.configuration = ConfigurationCopier.copy(configuration);
        }

        @Override
        @Transient
        public final Builder configuration(Map<String, ? extends Collection<String>> configuration) {
            this.configuration = ConfigurationCopier.copy(configuration);
            return this;
        }

        public AdditionalDataset build() {
            return new AdditionalDataset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AdditionalDataset> {
        public Builder name(String var1);

        public Builder configuration(Map<String, ? extends Collection<String>> var1);
    }
}

