/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details on the backtests performed to evaluate the accuracy of the predictor. The tests are returned in
 * descending order of accuracy, with the most accurate backtest appearing first. You specify the number of backtests to
 * perform when you call the operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredictorExecutionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<PredictorExecutionDetails.Builder, PredictorExecutionDetails> {
    private static final SdkField<List<PredictorExecution>> PREDICTOR_EXECUTIONS_FIELD = SdkField
            .<List<PredictorExecution>> builder(MarshallingType.LIST)
            .memberName("PredictorExecutions")
            .getter(getter(PredictorExecutionDetails::predictorExecutions))
            .setter(setter(Builder::predictorExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictorExecutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PredictorExecution> builder(MarshallingType.SDK_POJO)
                                            .constructor(PredictorExecution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDICTOR_EXECUTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PredictorExecution> predictorExecutions;

    private PredictorExecutionDetails(BuilderImpl builder) {
        this.predictorExecutions = builder.predictorExecutions;
    }

    /**
     * Returns true if the PredictorExecutions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPredictorExecutions() {
        return predictorExecutions != null && !(predictorExecutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of the backtests performed to evaluate the accuracy of the predictor against a particular algorithm. The
     * <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPredictorExecutions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of the backtests performed to evaluate the accuracy of the predictor against a particular
     *         algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in
     *         the array.
     */
    public final List<PredictorExecution> predictorExecutions() {
        return predictorExecutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPredictorExecutions() ? predictorExecutions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictorExecutionDetails)) {
            return false;
        }
        PredictorExecutionDetails other = (PredictorExecutionDetails) obj;
        return hasPredictorExecutions() == other.hasPredictorExecutions()
                && Objects.equals(predictorExecutions(), other.predictorExecutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PredictorExecutionDetails")
                .add("PredictorExecutions", hasPredictorExecutions() ? predictorExecutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredictorExecutions":
            return Optional.ofNullable(clazz.cast(predictorExecutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictorExecutionDetails, T> g) {
        return obj -> g.apply((PredictorExecutionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredictorExecutionDetails> {
        /**
         * <p>
         * An array of the backtests performed to evaluate the accuracy of the predictor against a particular algorithm.
         * The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.
         * </p>
         * 
         * @param predictorExecutions
         *        An array of the backtests performed to evaluate the accuracy of the predictor against a particular
         *        algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows
         *        in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorExecutions(Collection<PredictorExecution> predictorExecutions);

        /**
         * <p>
         * An array of the backtests performed to evaluate the accuracy of the predictor against a particular algorithm.
         * The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.
         * </p>
         * 
         * @param predictorExecutions
         *        An array of the backtests performed to evaluate the accuracy of the predictor against a particular
         *        algorithm. The <code>NumberOfBacktestWindows</code> from the object determines the number of windows
         *        in the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predictorExecutions(PredictorExecution... predictorExecutions);

        /**
         * <p>
         * An array of the backtests performed to evaluate the accuracy of the predictor against a particular algorithm.
         * The <code>NumberOfBacktestWindows</code> from the object determines the number of windows in the array.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PredictorExecution>.Builder} avoiding the
         * need to create one manually via {@link List<PredictorExecution>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PredictorExecution>.Builder#build()} is called immediately
         * and its result is passed to {@link #predictorExecutions(List<PredictorExecution>)}.
         * 
         * @param predictorExecutions
         *        a consumer that will call methods on {@link List<PredictorExecution>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predictorExecutions(List<PredictorExecution>)
         */
        Builder predictorExecutions(Consumer<PredictorExecution.Builder>... predictorExecutions);
    }

    static final class BuilderImpl implements Builder {
        private List<PredictorExecution> predictorExecutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PredictorExecutionDetails model) {
            predictorExecutions(model.predictorExecutions);
        }

        public final List<PredictorExecution.Builder> getPredictorExecutions() {
            List<PredictorExecution.Builder> result = PredictorExecutionsCopier.copyToBuilder(this.predictorExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder predictorExecutions(Collection<PredictorExecution> predictorExecutions) {
            this.predictorExecutions = PredictorExecutionsCopier.copy(predictorExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorExecutions(PredictorExecution... predictorExecutions) {
            predictorExecutions(Arrays.asList(predictorExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predictorExecutions(Consumer<PredictorExecution.Builder>... predictorExecutions) {
            predictorExecutions(Stream.of(predictorExecutions).map(c -> PredictorExecution.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPredictorExecutions(Collection<PredictorExecution.BuilderImpl> predictorExecutions) {
            this.predictorExecutions = PredictorExecutionsCopier.copyFromBuilder(predictorExecutions);
        }

        @Override
        public PredictorExecutionDetails build() {
            return new PredictorExecutionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
