/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDatasetImportJobRequest extends ForecastRequest implements
        ToCopyableBuilder<CreateDatasetImportJobRequest.Builder, CreateDatasetImportJobRequest> {
    private static final SdkField<String> DATASET_IMPORT_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetImportJobName").getter(getter(CreateDatasetImportJobRequest::datasetImportJobName))
            .setter(setter(Builder::datasetImportJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetImportJobName").build())
            .build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(CreateDatasetImportJobRequest::datasetArn))
            .setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<DataSource> DATA_SOURCE_FIELD = SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("DataSource").getter(getter(CreateDatasetImportJobRequest::dataSource))
            .setter(setter(Builder::dataSource)).constructor(DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSource").build()).build();

    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampFormat").getter(getter(CreateDatasetImportJobRequest::timestampFormat))
            .setter(setter(Builder::timestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(CreateDatasetImportJobRequest::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final SdkField<Boolean> USE_GEOLOCATION_FOR_TIME_ZONE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("UseGeolocationForTimeZone")
            .getter(getter(CreateDatasetImportJobRequest::useGeolocationForTimeZone))
            .setter(setter(Builder::useGeolocationForTimeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseGeolocationForTimeZone").build())
            .build();

    private static final SdkField<String> GEOLOCATION_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GeolocationFormat").getter(getter(CreateDatasetImportJobRequest::geolocationFormat))
            .setter(setter(Builder::geolocationFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeolocationFormat").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDatasetImportJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_IMPORT_JOB_NAME_FIELD,
            DATASET_ARN_FIELD, DATA_SOURCE_FIELD, TIMESTAMP_FORMAT_FIELD, TIME_ZONE_FIELD, USE_GEOLOCATION_FOR_TIME_ZONE_FIELD,
            GEOLOCATION_FORMAT_FIELD, TAGS_FIELD));

    private final String datasetImportJobName;

    private final String datasetArn;

    private final DataSource dataSource;

    private final String timestampFormat;

    private final String timeZone;

    private final Boolean useGeolocationForTimeZone;

    private final String geolocationFormat;

    private final List<Tag> tags;

    private CreateDatasetImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.datasetImportJobName = builder.datasetImportJobName;
        this.datasetArn = builder.datasetArn;
        this.dataSource = builder.dataSource;
        this.timestampFormat = builder.timestampFormat;
        this.timeZone = builder.timeZone;
        this.useGeolocationForTimeZone = builder.useGeolocationForTimeZone;
        this.geolocationFormat = builder.geolocationFormat;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name for the dataset import job. We recommend including the current timestamp in the name, for example,
     * <code>20190721DatasetImport</code>. This can help you avoid getting a <code>ResourceAlreadyExistsException</code>
     * exception.
     * </p>
     * 
     * @return The name for the dataset import job. We recommend including the current timestamp in the name, for
     *         example, <code>20190721DatasetImport</code>. This can help you avoid getting a
     *         <code>ResourceAlreadyExistsException</code> exception.
     */
    public final String datasetImportJobName() {
        return datasetImportJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon
     * Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.
     * </p>
     * <p>
     * If encryption is used, <code>DataSource</code> must include an AWS Key Management Service (KMS) key and the IAM
     * role must allow Amazon Forecast permission to access the key. The KMS key and IAM role must match those specified
     * in the <code>EncryptionConfig</code> parameter of the <a>CreateDataset</a> operation.
     * </p>
     * 
     * @return The location of the training data to import and an AWS Identity and Access Management (IAM) role that
     *         Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3
     *         bucket.</p>
     *         <p>
     *         If encryption is used, <code>DataSource</code> must include an AWS Key Management Service (KMS) key and
     *         the IAM role must allow Amazon Forecast permission to access the key. The KMS key and IAM role must match
     *         those specified in the <code>EncryptionConfig</code> parameter of the <a>CreateDataset</a> operation.
     */
    public final DataSource dataSource() {
        return dataSource;
    }

    /**
     * <p>
     * The format of timestamps in the dataset. The format that you specify depends on the <code>DataFrequency</code>
     * specified when the dataset was created. The following formats are supported
     * </p>
     * <ul>
     * <li>
     * <p>
     * "yyyy-MM-dd"
     * </p>
     * <p>
     * For the following data frequencies: Y, M, W, and D
     * </p>
     * </li>
     * <li>
     * <p>
     * "yyyy-MM-dd HH:mm:ss"
     * </p>
     * <p>
     * For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the format isn't specified, Amazon Forecast expects the format to be "yyyy-MM-dd HH:mm:ss".
     * </p>
     * 
     * @return The format of timestamps in the dataset. The format that you specify depends on the
     *         <code>DataFrequency</code> specified when the dataset was created. The following formats are
     *         supported</p>
     *         <ul>
     *         <li>
     *         <p>
     *         "yyyy-MM-dd"
     *         </p>
     *         <p>
     *         For the following data frequencies: Y, M, W, and D
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         "yyyy-MM-dd HH:mm:ss"
     *         </p>
     *         <p>
     *         For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the format isn't specified, Amazon Forecast expects the format to be "yyyy-MM-dd HH:mm:ss".
     */
    public final String timestampFormat() {
        return timestampFormat;
    }

    /**
     * <p>
     * A single time zone for every item in your dataset. This option is ideal for datasets with all timestamps within a
     * single time zone, or if all timestamps are normalized to a single time zone.
     * </p>
     * <p>
     * Refer to the <a href="http://joda-time.sourceforge.net/timezones.html">Joda-Time API</a> for a complete list of
     * valid time zone names.
     * </p>
     * 
     * @return A single time zone for every item in your dataset. This option is ideal for datasets with all timestamps
     *         within a single time zone, or if all timestamps are normalized to a single time zone. </p>
     *         <p>
     *         Refer to the <a href="http://joda-time.sourceforge.net/timezones.html">Joda-Time API</a> for a complete
     *         list of valid time zone names.
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * <p>
     * Automatically derive time zone information from the geolocation attribute. This option is ideal for datasets that
     * contain timestamps in multiple time zones and those timestamps are expressed in local time.
     * </p>
     * 
     * @return Automatically derive time zone information from the geolocation attribute. This option is ideal for
     *         datasets that contain timestamps in multiple time zones and those timestamps are expressed in local time.
     */
    public final Boolean useGeolocationForTimeZone() {
        return useGeolocationForTimeZone;
    }

    /**
     * <p>
     * The format of the geolocation attribute. The geolocation attribute can be formatted in one of two ways:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>LAT_LONG</code> - the latitude and longitude in decimal format (Example: 47.61_-122.33).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CC_POSTALCODE</code> (US Only) - the country code (US), followed by the 5-digit ZIP code (Example:
     * US_98121).
     * </p>
     * </li>
     * </ul>
     * 
     * @return The format of the geolocation attribute. The geolocation attribute can be formatted in one of two
     *         ways:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>LAT_LONG</code> - the latitude and longitude in decimal format (Example: 47.61_-122.33).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CC_POSTALCODE</code> (US Only) - the country code (US), followed by the 5-digit ZIP code (Example:
     *         US_98121).
     *         </p>
     *         </li>
     */
    public final String geolocationFormat() {
        return geolocationFormat;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The optional metadata that you apply to the dataset import job to help you categorize and organize them. Each tag
     * consists of a key and an optional value, both of which you define.
     * </p>
     * <p>
     * The following basic restrictions apply to tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of tags per resource - 50.
     * </p>
     * </li>
     * <li>
     * <p>
     * For each resource, each tag key must be unique, and each tag key can have only one value.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum key length - 128 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * Maximum value length - 256 Unicode characters in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your tagging schema is used across multiple services and resources, remember that other services may have
     * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable
     * in UTF-8, and the following characters: + - = . _ : / @.
     * </p>
     * </li>
     * <li>
     * <p>
     * Tag keys and values are case sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix for
     * keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have this
     * prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers it to be
     * a user tag and will count against the limit of 50 tags. Tags with only the key prefix of <code>aws</code> do not
     * count against your tags per resource limit.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The optional metadata that you apply to the dataset import job to help you categorize and organize them.
     *         Each tag consists of a key and an optional value, both of which you define.</p>
     *         <p>
     *         The following basic restrictions apply to tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Maximum number of tags per resource - 50.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For each resource, each tag key must be unique, and each tag key can have only one value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum key length - 128 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Maximum value length - 256 Unicode characters in UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your tagging schema is used across multiple services and resources, remember that other services may
     *         have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
     *         representable in UTF-8, and the following characters: + - = . _ : / @.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Tag keys and values are case sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
     *         prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix.
     *         Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then
     *         Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with only the
     *         key prefix of <code>aws</code> do not count against your tags per resource limit.
     *         </p>
     *         </li>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetImportJobName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSource());
        hashCode = 31 * hashCode + Objects.hashCode(timestampFormat());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(useGeolocationForTimeZone());
        hashCode = 31 * hashCode + Objects.hashCode(geolocationFormat());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDatasetImportJobRequest)) {
            return false;
        }
        CreateDatasetImportJobRequest other = (CreateDatasetImportJobRequest) obj;
        return Objects.equals(datasetImportJobName(), other.datasetImportJobName())
                && Objects.equals(datasetArn(), other.datasetArn()) && Objects.equals(dataSource(), other.dataSource())
                && Objects.equals(timestampFormat(), other.timestampFormat()) && Objects.equals(timeZone(), other.timeZone())
                && Objects.equals(useGeolocationForTimeZone(), other.useGeolocationForTimeZone())
                && Objects.equals(geolocationFormat(), other.geolocationFormat()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDatasetImportJobRequest").add("DatasetImportJobName", datasetImportJobName())
                .add("DatasetArn", datasetArn()).add("DataSource", dataSource()).add("TimestampFormat", timestampFormat())
                .add("TimeZone", timeZone()).add("UseGeolocationForTimeZone", useGeolocationForTimeZone())
                .add("GeolocationFormat", geolocationFormat()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatasetImportJobName":
            return Optional.ofNullable(clazz.cast(datasetImportJobName()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "DataSource":
            return Optional.ofNullable(clazz.cast(dataSource()));
        case "TimestampFormat":
            return Optional.ofNullable(clazz.cast(timestampFormat()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "UseGeolocationForTimeZone":
            return Optional.ofNullable(clazz.cast(useGeolocationForTimeZone()));
        case "GeolocationFormat":
            return Optional.ofNullable(clazz.cast(geolocationFormat()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDatasetImportJobRequest, T> g) {
        return obj -> g.apply((CreateDatasetImportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ForecastRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDatasetImportJobRequest> {
        /**
         * <p>
         * The name for the dataset import job. We recommend including the current timestamp in the name, for example,
         * <code>20190721DatasetImport</code>. This can help you avoid getting a
         * <code>ResourceAlreadyExistsException</code> exception.
         * </p>
         * 
         * @param datasetImportJobName
         *        The name for the dataset import job. We recommend including the current timestamp in the name, for
         *        example, <code>20190721DatasetImport</code>. This can help you avoid getting a
         *        <code>ResourceAlreadyExistsException</code> exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetImportJobName(String datasetImportJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the Amazon Forecast dataset that you want to import data to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.
         * </p>
         * <p>
         * If encryption is used, <code>DataSource</code> must include an AWS Key Management Service (KMS) key and the
         * IAM role must allow Amazon Forecast permission to access the key. The KMS key and IAM role must match those
         * specified in the <code>EncryptionConfig</code> parameter of the <a>CreateDataset</a> operation.
         * </p>
         * 
         * @param dataSource
         *        The location of the training data to import and an AWS Identity and Access Management (IAM) role that
         *        Amazon Forecast can assume to access the data. The training data must be stored in an Amazon S3
         *        bucket.</p>
         *        <p>
         *        If encryption is used, <code>DataSource</code> must include an AWS Key Management Service (KMS) key
         *        and the IAM role must allow Amazon Forecast permission to access the key. The KMS key and IAM role
         *        must match those specified in the <code>EncryptionConfig</code> parameter of the <a>CreateDataset</a>
         *        operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSource(DataSource dataSource);

        /**
         * <p>
         * The location of the training data to import and an AWS Identity and Access Management (IAM) role that Amazon
         * Forecast can assume to access the data. The training data must be stored in an Amazon S3 bucket.
         * </p>
         * <p>
         * If encryption is used, <code>DataSource</code> must include an AWS Key Management Service (KMS) key and the
         * IAM role must allow Amazon Forecast permission to access the key. The KMS key and IAM role must match those
         * specified in the <code>EncryptionConfig</code> parameter of the <a>CreateDataset</a> operation.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSource.Builder} avoiding the need to create
         * one manually via {@link DataSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSource.Builder#build()} is called immediately and its result
         * is passed to {@link #dataSource(DataSource)}.
         * 
         * @param dataSource
         *        a consumer that will call methods on {@link DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSource(DataSource)
         */
        default Builder dataSource(Consumer<DataSource.Builder> dataSource) {
            return dataSource(DataSource.builder().applyMutation(dataSource).build());
        }

        /**
         * <p>
         * The format of timestamps in the dataset. The format that you specify depends on the
         * <code>DataFrequency</code> specified when the dataset was created. The following formats are supported
         * </p>
         * <ul>
         * <li>
         * <p>
         * "yyyy-MM-dd"
         * </p>
         * <p>
         * For the following data frequencies: Y, M, W, and D
         * </p>
         * </li>
         * <li>
         * <p>
         * "yyyy-MM-dd HH:mm:ss"
         * </p>
         * <p>
         * For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the format isn't specified, Amazon Forecast expects the format to be "yyyy-MM-dd HH:mm:ss".
         * </p>
         * 
         * @param timestampFormat
         *        The format of timestamps in the dataset. The format that you specify depends on the
         *        <code>DataFrequency</code> specified when the dataset was created. The following formats are
         *        supported</p>
         *        <ul>
         *        <li>
         *        <p>
         *        "yyyy-MM-dd"
         *        </p>
         *        <p>
         *        For the following data frequencies: Y, M, W, and D
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        "yyyy-MM-dd HH:mm:ss"
         *        </p>
         *        <p>
         *        For the following data frequencies: H, 30min, 15min, and 1min; and optionally, for: Y, M, W, and D
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the format isn't specified, Amazon Forecast expects the format to be "yyyy-MM-dd HH:mm:ss".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormat(String timestampFormat);

        /**
         * <p>
         * A single time zone for every item in your dataset. This option is ideal for datasets with all timestamps
         * within a single time zone, or if all timestamps are normalized to a single time zone.
         * </p>
         * <p>
         * Refer to the <a href="http://joda-time.sourceforge.net/timezones.html">Joda-Time API</a> for a complete list
         * of valid time zone names.
         * </p>
         * 
         * @param timeZone
         *        A single time zone for every item in your dataset. This option is ideal for datasets with all
         *        timestamps within a single time zone, or if all timestamps are normalized to a single time zone. </p>
         *        <p>
         *        Refer to the <a href="http://joda-time.sourceforge.net/timezones.html">Joda-Time API</a> for a
         *        complete list of valid time zone names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * Automatically derive time zone information from the geolocation attribute. This option is ideal for datasets
         * that contain timestamps in multiple time zones and those timestamps are expressed in local time.
         * </p>
         * 
         * @param useGeolocationForTimeZone
         *        Automatically derive time zone information from the geolocation attribute. This option is ideal for
         *        datasets that contain timestamps in multiple time zones and those timestamps are expressed in local
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useGeolocationForTimeZone(Boolean useGeolocationForTimeZone);

        /**
         * <p>
         * The format of the geolocation attribute. The geolocation attribute can be formatted in one of two ways:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>LAT_LONG</code> - the latitude and longitude in decimal format (Example: 47.61_-122.33).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CC_POSTALCODE</code> (US Only) - the country code (US), followed by the 5-digit ZIP code (Example:
         * US_98121).
         * </p>
         * </li>
         * </ul>
         * 
         * @param geolocationFormat
         *        The format of the geolocation attribute. The geolocation attribute can be formatted in one of two
         *        ways:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>LAT_LONG</code> - the latitude and longitude in decimal format (Example: 47.61_-122.33).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CC_POSTALCODE</code> (US Only) - the country code (US), followed by the 5-digit ZIP code
         *        (Example: US_98121).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geolocationFormat(String geolocationFormat);

        /**
         * <p>
         * The optional metadata that you apply to the dataset import job to help you categorize and organize them. Each
         * tag consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have
         * this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers
         * it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the dataset import job to help you categorize and organize
         *        them. Each tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix.
         *        Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not,
         *        then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with
         *        only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The optional metadata that you apply to the dataset import job to help you categorize and organize them. Each
         * tag consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have
         * this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers
         * it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        The optional metadata that you apply to the dataset import job to help you categorize and organize
         *        them. Each tag consists of a key and an optional value, both of which you define.</p>
         *        <p>
         *        The following basic restrictions apply to tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Maximum number of tags per resource - 50.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For each resource, each tag key must be unique, and each tag key can have only one value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum key length - 128 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Maximum value length - 256 Unicode characters in UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your tagging schema is used across multiple services and resources, remember that other services
         *        may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and
         *        spaces representable in UTF-8, and the following characters: + - = . _ : / @.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Tag keys and values are case sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a
         *        prefix for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix.
         *        Values can have this prefix. If a tag value has <code>aws</code> as its prefix but the key does not,
         *        then Forecast considers it to be a user tag and will count against the limit of 50 tags. Tags with
         *        only the key prefix of <code>aws</code> do not count against your tags per resource limit.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The optional metadata that you apply to the dataset import job to help you categorize and organize them. Each
         * tag consists of a key and an optional value, both of which you define.
         * </p>
         * <p>
         * The following basic restrictions apply to tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Maximum number of tags per resource - 50.
         * </p>
         * </li>
         * <li>
         * <p>
         * For each resource, each tag key must be unique, and each tag key can have only one value.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum key length - 128 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * Maximum value length - 256 Unicode characters in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your tagging schema is used across multiple services and resources, remember that other services may have
         * restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces
         * representable in UTF-8, and the following characters: + - = . _ : / @.
         * </p>
         * </li>
         * <li>
         * <p>
         * Tag keys and values are case sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * Do not use <code>aws:</code>, <code>AWS:</code>, or any upper or lowercase combination of such as a prefix
         * for keys as it is reserved for AWS use. You cannot edit or delete tag keys with this prefix. Values can have
         * this prefix. If a tag value has <code>aws</code> as its prefix but the key does not, then Forecast considers
         * it to be a user tag and will count against the limit of 50 tags. Tags with only the key prefix of
         * <code>aws</code> do not count against your tags per resource limit.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ForecastRequest.BuilderImpl implements Builder {
        private String datasetImportJobName;

        private String datasetArn;

        private DataSource dataSource;

        private String timestampFormat;

        private String timeZone;

        private Boolean useGeolocationForTimeZone;

        private String geolocationFormat;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDatasetImportJobRequest model) {
            super(model);
            datasetImportJobName(model.datasetImportJobName);
            datasetArn(model.datasetArn);
            dataSource(model.dataSource);
            timestampFormat(model.timestampFormat);
            timeZone(model.timeZone);
            useGeolocationForTimeZone(model.useGeolocationForTimeZone);
            geolocationFormat(model.geolocationFormat);
            tags(model.tags);
        }

        public final String getDatasetImportJobName() {
            return datasetImportJobName;
        }

        @Override
        public final Builder datasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
            return this;
        }

        public final void setDatasetImportJobName(String datasetImportJobName) {
            this.datasetImportJobName = datasetImportJobName;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        public final DataSource.Builder getDataSource() {
            return dataSource != null ? dataSource.toBuilder() : null;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final void setDataSource(DataSource.BuilderImpl dataSource) {
            this.dataSource = dataSource != null ? dataSource.build() : null;
        }

        public final String getTimestampFormat() {
            return timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public final Boolean getUseGeolocationForTimeZone() {
            return useGeolocationForTimeZone;
        }

        @Override
        public final Builder useGeolocationForTimeZone(Boolean useGeolocationForTimeZone) {
            this.useGeolocationForTimeZone = useGeolocationForTimeZone;
            return this;
        }

        public final void setUseGeolocationForTimeZone(Boolean useGeolocationForTimeZone) {
            this.useGeolocationForTimeZone = useGeolocationForTimeZone;
        }

        public final String getGeolocationFormat() {
            return geolocationFormat;
        }

        @Override
        public final Builder geolocationFormat(String geolocationFormat) {
            this.geolocationFormat = geolocationFormat;
            return this;
        }

        public final void setGeolocationFormat(String geolocationFormat) {
            this.geolocationFormat = geolocationFormat;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDatasetImportJobRequest build() {
            return new CreateDatasetImportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
