/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.forecast.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides featurization (transformation) information for a dataset field. This object is part of the
 * <a>FeaturizationConfig</a> object.
 * </p>
 * <p>
 * For example:
 * </p>
 * <p>
 * <code>{</code>
 * </p>
 * <p>
 * <code>"AttributeName": "demand",</code>
 * </p>
 * <p>
 * <code>FeaturizationPipeline [ {</code>
 * </p>
 * <p>
 * <code>"FeaturizationMethodName": "filling",</code>
 * </p>
 * <p>
 * <code>"FeaturizationMethodParameters": {"aggregation": "avg", "backfill": "nan"}</code>
 * </p>
 * <p>
 * <code>} ]</code>
 * </p>
 * <p>
 * <code>}</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Featurization implements SdkPojo, Serializable, ToCopyableBuilder<Featurization.Builder, Featurization> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(Featurization::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<List<FeaturizationMethod>> FEATURIZATION_PIPELINE_FIELD = SdkField
            .<List<FeaturizationMethod>> builder(MarshallingType.LIST)
            .memberName("FeaturizationPipeline")
            .getter(getter(Featurization::featurizationPipeline))
            .setter(setter(Builder::featurizationPipeline))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturizationPipeline").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FeaturizationMethod> builder(MarshallingType.SDK_POJO)
                                            .constructor(FeaturizationMethod::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            FEATURIZATION_PIPELINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final List<FeaturizationMethod> featurizationPipeline;

    private Featurization(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.featurizationPipeline = builder.featurizationPipeline;
    }

    /**
     * <p>
     * The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast supports the
     * target field of the <code>TARGET_TIME_SERIES</code> and the <code>RELATED_TIME_SERIES</code> datasets. For
     * example, for the <code>RETAIL</code> domain, the target is <code>demand</code>, and for the <code>CUSTOM</code>
     * domain, the target is <code>target_value</code>. For more information, see <a>howitworks-missing-values</a>.
     * </p>
     * 
     * @return The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast supports
     *         the target field of the <code>TARGET_TIME_SERIES</code> and the <code>RELATED_TIME_SERIES</code>
     *         datasets. For example, for the <code>RETAIL</code> domain, the target is <code>demand</code>, and for the
     *         <code>CUSTOM</code> domain, the target is <code>target_value</code>. For more information, see
     *         <a>howitworks-missing-values</a>.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeaturizationPipeline property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasFeaturizationPipeline() {
        return featurizationPipeline != null && !(featurizationPipeline instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation method.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeaturizationPipeline} method.
     * </p>
     * 
     * @return An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation method.
     */
    public final List<FeaturizationMethod> featurizationPipeline() {
        return featurizationPipeline;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeaturizationPipeline() ? featurizationPipeline() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Featurization)) {
            return false;
        }
        Featurization other = (Featurization) obj;
        return Objects.equals(attributeName(), other.attributeName())
                && hasFeaturizationPipeline() == other.hasFeaturizationPipeline()
                && Objects.equals(featurizationPipeline(), other.featurizationPipeline());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Featurization").add("AttributeName", attributeName())
                .add("FeaturizationPipeline", hasFeaturizationPipeline() ? featurizationPipeline() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "FeaturizationPipeline":
            return Optional.ofNullable(clazz.cast(featurizationPipeline()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Featurization, T> g) {
        return obj -> g.apply((Featurization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Featurization> {
        /**
         * <p>
         * The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast supports the
         * target field of the <code>TARGET_TIME_SERIES</code> and the <code>RELATED_TIME_SERIES</code> datasets. For
         * example, for the <code>RETAIL</code> domain, the target is <code>demand</code>, and for the
         * <code>CUSTOM</code> domain, the target is <code>target_value</code>. For more information, see
         * <a>howitworks-missing-values</a>.
         * </p>
         * 
         * @param attributeName
         *        The name of the schema attribute that specifies the data field to be featurized. Amazon Forecast
         *        supports the target field of the <code>TARGET_TIME_SERIES</code> and the
         *        <code>RELATED_TIME_SERIES</code> datasets. For example, for the <code>RETAIL</code> domain, the target
         *        is <code>demand</code>, and for the <code>CUSTOM</code> domain, the target is
         *        <code>target_value</code>. For more information, see <a>howitworks-missing-values</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation method.
         * </p>
         * 
         * @param featurizationPipeline
         *        An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation
         *        method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featurizationPipeline(Collection<FeaturizationMethod> featurizationPipeline);

        /**
         * <p>
         * An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation method.
         * </p>
         * 
         * @param featurizationPipeline
         *        An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation
         *        method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featurizationPipeline(FeaturizationMethod... featurizationPipeline);

        /**
         * <p>
         * An array of one <code>FeaturizationMethod</code> object that specifies the feature transformation method.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FeaturizationMethod>.Builder} avoiding the
         * need to create one manually via {@link List<FeaturizationMethod>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FeaturizationMethod>.Builder#build()} is called immediately
         * and its result is passed to {@link #featurizationPipeline(List<FeaturizationMethod>)}.
         * 
         * @param featurizationPipeline
         *        a consumer that will call methods on {@link List<FeaturizationMethod>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #featurizationPipeline(List<FeaturizationMethod>)
         */
        Builder featurizationPipeline(Consumer<FeaturizationMethod.Builder>... featurizationPipeline);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private List<FeaturizationMethod> featurizationPipeline = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Featurization model) {
            attributeName(model.attributeName);
            featurizationPipeline(model.featurizationPipeline);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        @Transient
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final List<FeaturizationMethod.Builder> getFeaturizationPipeline() {
            List<FeaturizationMethod.Builder> result = FeaturizationPipelineCopier.copyToBuilder(this.featurizationPipeline);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeaturizationPipeline(Collection<FeaturizationMethod.BuilderImpl> featurizationPipeline) {
            this.featurizationPipeline = FeaturizationPipelineCopier.copyFromBuilder(featurizationPipeline);
        }

        @Override
        @Transient
        public final Builder featurizationPipeline(Collection<FeaturizationMethod> featurizationPipeline) {
            this.featurizationPipeline = FeaturizationPipelineCopier.copy(featurizationPipeline);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder featurizationPipeline(FeaturizationMethod... featurizationPipeline) {
            featurizationPipeline(Arrays.asList(featurizationPipeline));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder featurizationPipeline(Consumer<FeaturizationMethod.Builder>... featurizationPipeline) {
            featurizationPipeline(Stream.of(featurizationPipeline)
                    .map(c -> FeaturizationMethod.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Featurization build() {
            return new Featurization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
